#################################################################################
#
# Makefile for OS/2 Multimedia Pluggable Decompressor Codecs
#
#   Generates a dll:
#         SAMPCODC.DLL        - Sample Compressor/Decompressor.
#
# Copyright (c) IBM Corporation 1993                    All Rights Reserved
#
#################################################################################

.SUFFIXES: .com .sys .exe .obj .mbj .asm .inc .def .lrf .crf .ref \
           .lst .sym .map .c .h .lib .msg .pro .txt

########################################
# Compiler/tools Macros
########################################

ASM=masm
IMPLIB=implib
IPF=ipfc
LIBUTIL=lib
LINK386=link386
MAPSYM=mapsym
RC=rc

########################################
# Definitions for C Set/2 Compiler     #
# NOTE: defaults to /Gd-               #
########################################
CC      = icc
CFLAGS  = /C+ /Gd- /Ge- /Gm+ /Gs- /Re /J+ /Ki- /Ms /Sm /Sn /Ss+
AFLAGS  = -Mx -T -N
LFLAGS  = /batch /map /nod /noe /noi /packcode /packdata /exepack /align:4
LIBS    = DDE4MBS.LIB os2386.lib mmpm2.lib

########################################
# Inference Rules                      #
########################################
.c.obj:
        $(CC)  $(CFLAGS) /Fo$(<R).obj $(<R).c

########################################
# Object lists for 8 bit decoder
########################################
DLLOBJ    = sampmain.obj  \
            sampdeco.obj  \
            sampenco.obj  

#################################
# Target Descriptions
#################################

all: dll codec.mak

#################################
# SAMPCODC.dll Target Descriptions
#################################

dll: sampcodc.dll codec.mak

#################################
# Compile specially as #define
# is passed in from nmake
#################################

sampcodc.dll:  $(DLLOBJ) codec.mak sampcodc.lnk sampcodc.def
        echo linkdebug is $(LNK_DEBUG) end
        $(LINK386) @sampcodc.lnk
        $(MAPSYM) sampcodc


#################################
# Module.def file for sampcodc.DLL
#################################

sampcodc.def: codec.mak
        @echo Creating file <<$(@B).def
LIBRARY sampcodc INITINSTANCE TERMINSTANCE
DESCRIPTION '$(FILEVER)'
SEGMENTS
   PROCESS_SHARED_DATA_SEGMENT CLASS 'DATA' SHARED
DATA MULTIPLE NONSHARED
PROTMODE
HEAPSIZE 0
EXPORTS
   SampleCodecEntry
BASE = 0x1BA00000
<<keep

#################################
# LINKER FILES
#################################

sampcodc.lnk: codec.mak
        @echo Creating file <<$(@B).lnk
$(DLLOBJ)
sampcodc.dll
sampcodc.map $(LFLAGS)
$(LIBS)
sampcodc.def;
<<keep
