#**     makefile for CD Audio Media Component Interface Drivers
#
#
# ***************************************************************************
# *
# *                 Copyright (c) IBM Corporation  1990 - 1993
# *                           All Rights Reserved
# *
# ***************************************************************************

.SUFFIXES:      .asm .c .obj .lst .def .lnk .sys .sym .dll .lib

#################################
# Definitions for C Compiler
# Compiler options (C Set/2 (Toronto))
#    C+  == Perform compile only, no link.
#    Q+  == Supress logo
#    O+  == Optimize code (don't use with Ti)
#    Ti  == Debug information
#    Kp+ == Produce messages about unused function parameters
#    Ss+ == Allow // comments
#    Sm+ == Migration libraries (Microsoft C)
#    Sn+ == Provide DBCS support in runtime string routines
#    Ge- == Build .DLL (default is .exe)
#    Gm+ == Multithreaded libraries
#    Gn+ == Do not generate default libraries in object
#    Gs- == Do not remove stack probes (default)
#    Kb- == Suppress basic diagnostic messages (default)
#    Ki- == Suppress messages about uninitialized variables (default)
#    Ms  == Use "system" calling conventions (as opposed to Mp optlink)
#    Mp  =  Optlink (register passing convention ~10% faster)
#    Fl+ == Produce listing
#    L+  == Produce listing
#    Ls+ == Include source in listing
#    Fa+ == Produce assembler code
#    Le+ == Expand macros
#    La+ == Include offsets in structures in listing
#################################


CC=icc
CFLAGS= /C /Ge- /Gm+ /Gs- /Kb- /Ki- /Ms /Sm /Ss+ /O+ /DINCL_32
DEBUG = /Ti+ /O-

##########################################################
#       Definitions for linker                           #
#                                                        #
#       DDE4MBS is the C Set/2 standard run time Library #
#          for multi-threaded DLLs.                      #
##########################################################

LINK= link386
LFLAGS= /batch /map /nod /noe /noi /map /packcode /packdata /exepack /align:16
LIBS= OS2386.LIB DDE4MBS.LIB

#       Rules for generating object and linker response and definition files

.c.obj:
        $(CC) $(CFLAGS) $*.c

.dll.lib:
        implib $*.lib $*.dll

.sys.sym:
        mapsym $*


#       List of object files required

all: ibmcdrt.dll cdaudiot.dll

ibmcdrt.dll: ibmcdrom.obj ibmcdpro.obj ibmcdmsc.obj cdmccomn.obj cdmcinit.obj \
             hhpheap.obj ibmcdrom.lnk ibmcdrom.def
        $(LINK) $(LFLAGS) @ibmcdrom.lnk

ibmcdrom.def: cdmct.mak
        @echo Creating file <<$(@B).def
LIBRARY IBMCDRT INITINSTANCE TERMINSTANCE
DESCRIPTION 'IBM CD-ROM Toolkit MCI Driver, (c) IBM Corp 1991-1993'
DATA MULTIPLE NONSHARED
HEAPSIZE          44120
STACKSIZE         53000
IMPORTS
  mdm.mdmDriverNotify
EXPORTS
  vsdDriverEntry
<<keep

ibmcdrom.lnk: cdmct.mak
        @echo Creating file <<$(@B).lnk
ibmcdrom ibmcdpro ibmcdmsc cdmccomn cdmcinit hhpheap
ibmcdrt.dll
ibmcdrom.map $(LFLAGS)
$(LIBS)
ibmcdrom.def;
<<keep

cdaudiot.dll:  cdaudio.obj cdaudpro.obj cdaudutl.obj cdmccomn.obj\
               cdmcinit.obj hhpheap.obj cdaudio.lnk cdaudio.def
        $(LINK) $(LFLAGS) @cdaudio.lnk

cdaudio.def: cdmct.mak
        @echo Creating file <<$(@B).def
LIBRARY CDAUDIOT INITINSTANCE TERMINSTANCE
DESCRIPTION 'CD Audio Toolkit MCI Driver, (c) IBM Corp 1991-1993'
DATA MULTIPLE NONSHARED
HEAPSIZE          44120
STACKSIZE         53000
IMPORTS
  mdm.mdmDriverNotify
  mdm.mciSendCommand
  mdm.mciConnection
  mdm.mciQueryConnections
  mdm.mciQueryDefaultConnections
EXPORTS
   mciDriverEntry
<<keep

cdaudio.lnk: cdmct.mak
        @echo Creating file <<$(@B).lnk
cdaudio cdaudpro cdaudutl cdmccomn cdmcinit hhpheap
cdaudiot.dll
cdaudio.map $(LFLAGS)
$(LIBS)
cdaudio.def;
<<keep

