#pragma	title("Test Bed Application  --  Version 1.0  --  (TestWnd.C)")
#pragma	subtitle("   Client Window - Interface Definitions")

#if defined(__IBMC__)

#pragma	info(noext, nopar)

#endif

#define	INCL_DOS		   /* Include OS/2 DOS Kernal		*/
#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

static char *MODID = "@(#)testwnd.c:1.00";

#include <os2.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>

#include <pmcx.h>

#include "appdefs.h"
#include "testbed.h"

/* This	module contains	routine	used to	process	the messages for the	*/
/* applications	client window.						*/

/* Filename:   TestWnd.C						*/

/*  Version:   1.0							*/
/*  Created:   1993-12-21						*/
/*  Revised:   1993-12-21						*/

/* Routines:   MRESULT EXPENTRY	TestWndProc(HWND hWnd, ULONG msg,	*/
/*					    MPARAM mp1,	MPARAM mp2);	*/


/* Copyright  1989-1994  Prominare Inc.  All Rights Reserved.		*/

/* --------------------------------------------------------------------	*/


/* --- Module Prototypes ----------------------------------------------	*/

VOID EXPENTRY LookupSymbol(HWND	hWnd, SHORT idSymbol, SHORT idValue);
BOOL EXPENTRY ValidateSymbol(HWND hWnd,	SHORT idSymbol,	SHORT idValue);
VOID EXPENTRY GetPresParams(HWND hWnd);
BOOL EXPENTRY CUACheck(HWND hWnd, SHORT	idEntryField, INT iCUACompliance);
VOID	      TestStylesDialog(VOID);

/* --- Custom Control Prototypes --------------------------------------	*/

BOOL	EXPENTRY PatternQuery(PUSERINFO	pUserInfo);
MRESULT	EXPENTRY PatternStyles(HWND hWnd, ULONG	msg, MPARAM mp1, MPARAM	mp2);

#pragma	subtitle("   Client Window - Symbol Lookup Procedure")
#pragma	page( )

/* --- LookupSymbol ---------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the Symbol	lookup call back	*/
/*     from the	custom control.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd;    = Dialogue Window Handle				*/
/*     SHORT idSymbol; = Symbol	Entry Field ID				*/
/*     SHORT idValue;  = Symbol	Value Entry Field ID			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     Nothing								*/
/*									*/
/* --------------------------------------------------------------------	*/

VOID EXPENTRY LookupSymbol(HWND	hWnd, SHORT idSymbol, SHORT idValue)

{

WinSetDlgItemText(hWnd,	(ULONG)idSymbol, "ID_TEST");
WinSetDlgItemShort(hWnd, (ULONG)idValue, 1024, FALSE);

}
#pragma	subtitle("   Client Window - Validate Symbol Procedure")
#pragma	page( )

/* --- ValidateSymbol -------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the Symbol	validation call	back	*/
/*     from the	custom control.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND  hWnd;     = Dialogue Window Handle				*/
/*     SHORT idSymbol; = Symbol	Entry Field ID				*/
/*     SHORT idValue;  = Symbol	Value Entry Field ID			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     ValidateSymbol =	 TRUE :	Symbol and ID Validated			*/
/*		      =	FALSE :	Symbol and ID Invalid			*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY ValidateSymbol(HWND hWnd,	SHORT idSymbol,	SHORT idValue)

{

if ( WinMessageBox(HWND_DESKTOP, hWnd, "Press Yes for valid symbol or No for invalid symbol test.",
		   "Test Bed Application", 0UL,
		   MB_ICONASTERISK | MB_YESNO) == MBID_YES )
   return(TRUE);
else
   return(FALSE);
}
#pragma	subtitle("   Client Window - Client Window Procedure")
#pragma	page( )

/* --- GetPresParams --------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the Presentation Parameters	*/
/*     call back from the custom control.				*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND hWnd; = Dialogue Window Handle				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     Nothing								*/
/*									*/
/* --------------------------------------------------------------------	*/

VOID EXPENTRY GetPresParams(HWND hWnd)

{

WinMessageBox(HWND_DESKTOP, hWnd, "Presentation Parameters Callback Test",
	      "Test Bed Application", 0UL, MB_ICONASTERISK | MB_OK);

}
#pragma	subtitle("   Client Window - CUA Check Procedure")
#pragma	page( )

/* --- CUACheck	-------------------------------------------------------	*/
/*									*/
/*     This function is	used to	test the CUA Compliance	call back	*/
/*     from the	custom control.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd;	     = Dialogue	Window Handle			*/
/*     SHORT idEntryField;   = PM Message				*/
/*     INT   iCUACompliance; = Message Parameter 1			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     CUACheck	=  TRUE	: CUA Compliant					*/
/*		= FALSE	: CUA Non-Compliant				*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY CUACheck(HWND hWnd, SHORT	idEntryField, INT iCUACompliance)

{
CHAR *pszMsg;			   /* Message String Pointer		*/

switch ( iCUACompliance	)
   {
   case	CUACHK_MNEMONIC	:
       pszMsg =	"CUA mnemonic check.  Press Yes for CUA compliance or no for non-compliance";
       break;

   case	CUACHK_CAPS :
       pszMsg =	"CUA capitalization check.  Press Yes for CUA compliance or no for non-compliance";
       break;

   case	CUACHK_ELLIPSIS	:
       pszMsg =	"CUA ellipsis check.  Press Yes for CUA compliance or no for non-compliance";
       break;
   }

if ( WinMessageBox(HWND_DESKTOP, hWnd, pszMsg, "Test Bed Application", 0UL,
		   MB_ICONASTERISK | MB_YESNO) == MBID_YES )
   return(TRUE);
else
   return(FALSE);
}
#pragma	subtitle("   Client Window - Style Dialogue Test Procedure")
#pragma	page( )

/* --- TestStylesDialog	-----------------------------------------------	*/
/*									*/
/*     This function is	used to	test the style dialogues that form	*/
/*     part of the custom control.					*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     Nothing								*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     Nothing								*/
/*									*/
/* --------------------------------------------------------------------	*/

VOID TestStylesDialog( )

{
PUSERSTYLE pust;		   /* User Style Pointer		*/
PUSERINFO  pui;			   /* User Information			*/
HMODULE	   hmod;		   /* DLL Module Handle			*/

pui = (PUSERINFO)malloc(sizeof(USERINFO));

DosQueryModuleHandle("Pattern",	&hmod);
PatternQuery(pui);

pust = (PUSERSTYLE  )malloc(sizeof(USERSTYLE) +	pui->utDefined[0].cCtlData);
memset(pust, 0,	sizeof(USERSTYLE) + pui->utDefined[0].cCtlData);

		       /* Copy control data information	to array	*/
		       /* allocated for	the control data in this	*/
		       /* location					*/

if ( pui->utDefined[0].cMaxText	)
   {
   pust->pszText = (PSZ)malloc(pui->utDefined[0].cMaxText);

   pust->cText = 5;
   strcpy(pust->pszText, "Text");
   }
else
   pust->pszText = NULL;

pust->pfnLookupSymbol	= (PFN)(PVOID)&LookupSymbol;
pust->pfnValidateSymbol	= (PFN)(PVOID)&ValidateSymbol;
pust->pfnGetFontClr	= (PFN)(PVOID)&GetPresParams;
pust->pfnCUACheck	= (PFN)(PVOID)&CUACheck;

strcpy(pust->szid, "ID_TESTING");
pust->id = 512;

WinDlgBox(HWND_DESKTOP,	hwndTestBedFrame, (PFNWP)PatternStyles,
	  hmod,	pui->utDefined[0].idDlg, (PVOID)pust);

free(pust->pszText);
free(pust);
free(pui);
}
#pragma	subtitle("   Client Window - Client Window Procedure")
#pragma	page( )

/* --- TestWndProc ----------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages sent to the	*/
/*     applications client window.					*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Window Handle					*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     TestWndProc = Message Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY TestWndProc(HWND hWnd,	ULONG msg, MPARAM mp1, MPARAM mp2)

{
RECTL rcl;			   /* Window Rectangle			*/
HPS   hPS;			   /* Presentation Space Handle		*/

switch ( msg )
   {
			/* Close the application			*/
   case	WM_CLOSE :
       WinPostMsg(hWnd,	WM_QUIT, 0L, 0L);
       break;
			/* Process menu	and button selections		*/
   case	WM_COMMAND :
       switch (	SHORT1FROMMP(mp1) )
	   {
	    case IDM_ABOUT :
		WinDlgBox(HWND_DESKTOP,	hwndTestBedFrame, (PFNWP)AboutDlgProc,
			  (HMODULE)NULL, DLG_ABOUT, NULL);
		break;

	   case	IDM_STYLES :
	       TestStylesDialog( );
	       break;

	   case	IDM_TEST :
	       WinDlgBox(HWND_DESKTOP, hwndTestBedFrame, (PFNWP)TestDlgProc,
			 (HMODULE)NULL,	DLG_TEST, NULL);
	       break;

	   case	IDM_EXIT :
	       WinPostMsg(hWnd,	WM_CLOSE, 0L, 0L);
	       break;

	   }
       break;
			/* Window being	destroyed, perform clean-up	*/
			/* operations					*/
   case	WM_ERASEBACKGROUND :
       WinQueryWindowRect(hWnd,	&rcl);
       WinFillRect((HPS)LONGFROMMP(mp1), &rcl, SYSCLR_WINDOW);
       break;
			/* Paint client	window				*/
   case	WM_PAINT :
       WinFillRect(hPS = WinBeginPaint(hWnd, (HPS)NULL,	&rcl), &rcl, SYSCLR_WINDOW);
       WinEndPaint(hPS);
       break;
			/* Default message processing			*/
   default :
       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
