#pragma	title("Test Bed Application  --  Version 1.0  --  (TestDlg.C)")
#pragma	subtitle("   Test Dialogues - Interface Definitions")

#if defined(__IBMC__)

#pragma	info(noext)

#endif

#define	INCL_WIN		/* Include OS/2	PM Windows Interface	*/

static char *MODID = "@(#)testdlg.c:1.00";

#include <os2.h>
#include <stdio.h>

#include "appdefs.h"
#include "testbed.h"

/* This	module contains	routine	used to	handle the test	dialogues.	*/

/* Filename:   TestDlg.C						*/

/*  Version:   1.0							*/
/*  Created:   1993-12-21						*/
/*  Revised:   1993-12-21						*/

/* Routines:   MRESULT EXPENTRY	TestDlgProc(HWND hWnd, ULONG msg,	*/
/*					    MPARAM mp1,	MPARAM mp2);	*/
/*	       MRESULT EXPENTRY	AboutDlgProc(HWND hWnd,	ULONG msg,	*/
/*					     MPARAM mp1, MPARAM	mp2);	*/


/* Copyright  1989-1994 Prominare Inc.	 All Rights Reserved.		*/

/* --------------------------------------------------------------------	*/

BOOL fState1 = TRUE;

#pragma	subtitle("   Test Dialogues - Test Dialogue Procedure")
#pragma	page( )

/* --- TestDlgProc ----------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the test	*/
/*     dialogue	procedure.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     TestDlgProc = Message Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY TestDlgProc(HWND hWnd,	ULONG msg, MPARAM mp1, MPARAM mp2)

{
SWP swp;			   /* Screen Window Position Holder	*/

switch ( msg )
   {
		       /* Perform dialog initialization			*/
   case	WM_INITDLG :
		       /* Centre dialog	on the screen			*/

       WinQueryWindowPos(hWnd, (PSWP)&swp);
       WinSetWindowPos(hWnd, HWND_TOP,
		       ((WinQuerySysValue(HWND_DESKTOP,	SV_CXSCREEN) - swp.cx) / 2L),
		       ((WinQuerySysValue(HWND_DESKTOP,	SV_CYSCREEN) - swp.cy) / 2L),
		       0L, 0L, SWP_MOVE);

       break;

			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch (SHORT1FROMMP(mp1) )
	    {
	   case	IB_BUTTON1 :
	       WinMessageBox(HWND_DESKTOP, hWnd, "Image Button 1 Pressed.",
			     "Image Button Test", 0UL, MB_OK | MB_ICONASTERISK);
	
	       if ( fState1 )
		   fState1 = FALSE;
	       else
		   fState1 = TRUE;

	       WinEnableWindow(WinWindowFromID(hWnd, IB_BUTTON2), fState1);
	       break;

	   case	IB_BUTTON2 :
	       WinMessageBox(HWND_DESKTOP, hWnd, "Image Button 2 Pressed.",
			     "Image Button Test", 0UL, MB_OK | MB_ICONASTERISK);
	       break;

	   case	IB_BUTTON3 :
	       WinMessageBox(HWND_DESKTOP, hWnd, "Image Button 3 Pressed.",
			     "Image Button Test", 0UL, MB_OK | MB_ICONASTERISK);
	       break;

	   case	IB_BUTTON4 :
	       WinMessageBox(HWND_DESKTOP, hWnd, "Image Button 4 Pressed.",
			     "Image Button Test", 0UL, MB_OK | MB_ICONASTERISK);
	       break;

	    case DID_OK	:
		WinDismissDlg(hWnd, TRUE);
		break;

	    }
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;
			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
#pragma	subtitle("   Test Dialogues - About Box Procedure")
#pragma	page( )

/* --- AboutDlgProc ---------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the About	*/
/*     box procedure.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     USHORT msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     AboutDlgProc = Message Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY AboutDlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
SWP swp;			   /* Screen Window Position Holder	*/

switch ( msg )
   {
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch (SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
		WinDismissDlg(hWnd, TRUE);
		break;

	    }
	break;
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
		       /* Centre dialog	on the screen			*/

       WinQueryWindowPos(hWnd, (PSWP)&swp);
       WinSetWindowPos(hWnd, HWND_TOP,
		       ((WinQuerySysValue(HWND_DESKTOP,	SV_CXSCREEN) - swp.cx) / 2L),
		       ((WinQuerySysValue(HWND_DESKTOP,	SV_CYSCREEN) - swp.cy) / 2L),
		       0L, 0L, SWP_MOVE);
	break;
			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
