#pragma	title("Pattern Control  --  Version 1.0 -- (Pattern.C)")
#pragma	subtitle("  Pattern Control DLL - Interface Definitions")

#pragma	info(noext)

#define	INCL_DOS		   /* Include OS/2 DOS Kernal		*/
#define	INCL_GPI		   /* Include OS/2 PM GPI Interface	*/
#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

static char *MODID = "@(#)pattern.c:1.01";

#include <os2.h>
#include <string.h>

#include <pmcx.h>

#include "pattern.h"

/* This	module contains	an example installable control that can	be used	*/
/* within applications where additional	facilities are provided	that	*/
/* are not found within	the default controls of	OS/2 PM.		*/
/*									*/
/* For complete	details	regarding the PM Control Extensions (PMCX)	*/
/* consult the User's Guide.                                            */
/*									*/
/* The DLL is created using the	following command line invocation:	*/
/*									*/
/*     Icc -G3e- -O+ -Rn -W3 -C	Pattern.C				*/

/* Filename:   Pattern.C						*/

/*  Version:   1.0							*/
/*  Created:   1993-12-21						*/
/*  Revised:   1994-06-26						*/

/* Routines:   BOOL EXPENTRY PatternRegister(HAB hAB);			*/
/*	       BOOL EXPENTRY PatternQuery(PUSERINFO pControlInfo);	*/
/*	       MRESULT EXPENTRY	PatternWndProc(HWND hWnd, ULONG	msg,	*/
/*					       MPARAM mp1, MPARAM mp2);	*/
/*	       MRESULT EXPENTRY	PatternStyles(HWND hWnd, ULONG msg,	*/
/*					      MPARAM mp1, MPARAM mp2);	*/


/* Copyright  1989-1994  Prominare Inc.  All Rights Reserved.		*/

/* --------------------------------------------------------------------	*/

/************************************************************************/
/************************************************************************/
/*		       DISCLAIMER OF WARRANTIES.			*/
/************************************************************************/
/************************************************************************/
/*     The following [enclosed]	code is	library	code created by		*/
/*     Prominare Inc.  This library code is  provided to you solely	*/
/*     for the purpose of assisting you	in the development of your	*/
/*     applications.  The code is provided "AS IS", without		*/
/*     warranty	of any kind.  Prominare	Inc. shall not be liable	*/
/*     for any damages arising out of your use of the library code,	*/
/*     even if they have been advised of the possibility of such	*/
/*     damages.								*/
/************************************************************************/
/************************************************************************/

/* --- Window Information Structures ----------------------------------	*/

typedef	struct _PATTERN		   /* pat */
   {
   RECTL    rcl;		   /* Frame Rectangle			*/
   HPOINTER hptrArrow;		   /* Arrow Pointer			*/
   ULONG    flStyle;		   /* Control Style			*/
   LONG	    aClr[7];		   /* Presentation Colours Array	*/
   } PATTERN ;

typedef	PATTERN	*PPATTERN;

/* --- Module Prototype	Definitions -----------------------------------	*/

BOOL	EXPENTRY PatternRegister(HAB hAB);
BOOL	EXPENTRY PatternQuery(PUSERINFO	pUserInfo);
MRESULT	EXPENTRY PatternWndProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT	EXPENTRY PatternStyles(HWND hWnd, ULONG	msg, MPARAM mp1, MPARAM	mp2);

#pragma	subtitle("   Pattern Control DLL - Control Initialization Function")
#pragma	page ( )

/* --- PatternRegister ------------------------------------------------	*/
/*									*/
/*     This function is	used to	register the installable control class	*/
/*     with OS/2 Presentation Manager.	The registration must use the	*/
/*     USER_CWINDOWWORDS to reserve memory for the control to allow for	*/
/*     proper usage by Resource	Editor and for use by the control	*/
/*     dialog and window procedures.  The information for the control	*/
/*     containing the style, presentation parameters and control data	*/
/*     is pointed to by	a pointer that can be referenced by the		*/
/*     control's dialog and window procedure as required.  The memory   */
/*     for the structure is allocated and controlled through Resource	*/
/*     Editor.	 The control can reserve more memory for its use	*/
/*     by adding the memory required to	that of	the USER_CWINDOWWORDS	*/
/*     constant.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HAB hAB;	= Application Anchor Block Handle			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     PatternRegister =  TRUE : Class Registration Successful		*/
/*		       = FALSE : Class Registration Failed		*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY PatternRegister(HAB hAB)

{
		       /* Register the control class with OS/2		*/
		       /* Presentation Manager and return registration	*/
		       /* result					*/

return(WinRegisterClass(hAB, "Pattern.Control",	(PFNWP)PatternWndProc,
			CS_HITTEST | CS_PARENTCLIP | CS_SYNCPAINT | CS_SIZEREDRAW,
			USER_CWINDOWWORDS));

}
#pragma	subtitle("   Pattern Control DLL - Query Control Information Function")
#pragma	page ( )

/* --- PatternQuery ---------------------------------------------------	*/
/*									*/
/*     This function is	used to	return to the caller information	*/
/*     regarding the installable control and its capabilities.	The	*/
/*     function	should return a	true value otherwise Resource		*/
/*     Editor will not register	the control as being usable.		*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     PUSERINFO pUserInfo; = User Information Pointer			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     PatternQuery =  TRUE : User Information Being Returned		*/
/*		    = FALSE : No User Information Available		*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY PatternQuery(PUSERINFO pUserInfo)

{
POINTL ptl;			   /* Point Holder			*/

		       /* Complete the User Information	structure	*/
		       /* passed to the	function by Resource Editor	*/

		       /* Complete the version and number of control	*/
		       /* types.  In Version 1.00 of CCRS, only	one	*/
		       /* control type is used.				*/
pUserInfo->ulMajor = 3UL;
pUserInfo->ulMinor = 0U;
		       /* Complete the author and control classname	*/

memcpy(pUserInfo->szAuthor,    "Prominare Inc.", 15);
memcpy(pUserInfo->szClassname, "Pattern.Control", 16);
memcpy(pUserInfo->szName,      "Pattern", 8);

		       /* Complete the default size and	style of the	*/
		       /* first	user control type			*/

ptl.x =	ptl.y =	52L;
WinMapDlgPoints(HWND_DESKTOP, &ptl, 1UL, FALSE);
pUserInfo->utDefined[0].cx	     = ptl.x;
pUserInfo->utDefined[0].cy	     = ptl.y;
pUserInfo->utDefined[0].flStyle	     = WS_VISIBLE;

		       /* Set the maximum amount of text control can	*/
		       /* accept including NULL	termination byte	*/

pUserInfo->utDefined[0].cMaxText     = 0UL;

		       /* Save the style's dialogue ID, type, control   */
		       /* data size and	count of style masks		*/

pUserInfo->utDefined[0].idDlg	     = DLG_CTRLUSER;
pUserInfo->utDefined[0].ulType	     = UTYPE_PRIVATE;
pUserInfo->utDefined[0].cCtlData     = 0UL;
pUserInfo->utDefined[0].cMasks	     = 23UL;
pUserInfo->utDefined[0].flStyleType  = STYLETYPE_SEQUENCE;
pUserInfo->utDefined[0].flOptions    = PMCXOPT_REFRESH;

pUserInfo->utDefined[0].stMasks[0].flStyleMask = PATSYM_DEFAULT;
pUserInfo->utDefined[0].stMasks[0].idStyle     = IDS_PATSYM_DEFAULT;
pUserInfo->utDefined[0].stMasks[1].flStyleMask = PATSYM_DENSE1;
pUserInfo->utDefined[0].stMasks[1].idStyle     = IDS_PATSYM_DENSE1;
pUserInfo->utDefined[0].stMasks[2].flStyleMask = PATSYM_DENSE2;
pUserInfo->utDefined[0].stMasks[2].idStyle     = IDS_PATSYM_DENSE2;
pUserInfo->utDefined[0].stMasks[3].flStyleMask = PATSYM_DENSE3;
pUserInfo->utDefined[0].stMasks[3].idStyle     = IDS_PATSYM_DENSE3;
pUserInfo->utDefined[0].stMasks[4].flStyleMask = PATSYM_DENSE4;
pUserInfo->utDefined[0].stMasks[4].idStyle     = IDS_PATSYM_DENSE4;
pUserInfo->utDefined[0].stMasks[5].flStyleMask = PATSYM_DENSE5;
pUserInfo->utDefined[0].stMasks[5].idStyle     = IDS_PATSYM_DENSE5;
pUserInfo->utDefined[0].stMasks[6].flStyleMask = PATSYM_DENSE6;
pUserInfo->utDefined[0].stMasks[6].idStyle     = IDS_PATSYM_DENSE6;
pUserInfo->utDefined[0].stMasks[7].flStyleMask = PATSYM_DENSE7;
pUserInfo->utDefined[0].stMasks[7].idStyle     = IDS_PATSYM_DENSE7;
pUserInfo->utDefined[0].stMasks[8].flStyleMask = PATSYM_DENSE8;
pUserInfo->utDefined[0].stMasks[8].idStyle     = IDS_PATSYM_DENSE8;
pUserInfo->utDefined[0].stMasks[9].flStyleMask = PATSYM_VERT;
pUserInfo->utDefined[0].stMasks[9].idStyle     = IDS_PATSYM_VERT;
pUserInfo->utDefined[0].stMasks[10].flStyleMask	= PATSYM_HORIZ;
pUserInfo->utDefined[0].stMasks[10].idStyle	= IDS_PATSYM_HORIZ;
pUserInfo->utDefined[0].stMasks[11].flStyleMask	= PATSYM_DIAG1;
pUserInfo->utDefined[0].stMasks[11].idStyle	= IDS_PATSYM_DIAG1;
pUserInfo->utDefined[0].stMasks[12].flStyleMask	= PATSYM_DIAG2;
pUserInfo->utDefined[0].stMasks[12].idStyle	= IDS_PATSYM_DIAG2;
pUserInfo->utDefined[0].stMasks[13].flStyleMask	= PATSYM_DIAG3;
pUserInfo->utDefined[0].stMasks[13].idStyle	= IDS_PATSYM_DIAG3;
pUserInfo->utDefined[0].stMasks[14].flStyleMask	= PATSYM_DIAG4;
pUserInfo->utDefined[0].stMasks[14].idStyle	= IDS_PATSYM_DIAG4;
pUserInfo->utDefined[0].stMasks[15].flStyleMask	= PATSYM_NOSHADE;
pUserInfo->utDefined[0].stMasks[15].idStyle	= IDS_PATSYM_NOSHADE;
pUserInfo->utDefined[0].stMasks[16].flStyleMask	= PATSYM_SOLID;
pUserInfo->utDefined[0].stMasks[16].idStyle	= IDS_PATSYM_SOLID;
pUserInfo->utDefined[0].stMasks[17].flStyleMask	= PATSYM_HALFTONE;
pUserInfo->utDefined[0].stMasks[17].idStyle	= IDS_PATSYM_HALFTONE;
pUserInfo->utDefined[0].stMasks[18].flStyleMask	= PATSYM_BLANK;
pUserInfo->utDefined[0].stMasks[18].idStyle	= IDS_PATSYM_BLANK;
pUserInfo->utDefined[0].stMasks[19].flStyleMask	= WS_VISIBLE;
pUserInfo->utDefined[0].stMasks[19].idStyle	= IDS_VISIBLE;
pUserInfo->utDefined[0].stMasks[20].flStyleMask	= WS_GROUP;
pUserInfo->utDefined[0].stMasks[20].idStyle	= IDS_GROUP;
pUserInfo->utDefined[0].stMasks[21].flStyleMask	= WS_DISABLED;
pUserInfo->utDefined[0].stMasks[21].idStyle	= IDS_DISABLED;
pUserInfo->utDefined[0].stMasks[22].flStyleMask	= WS_TABSTOP;
pUserInfo->utDefined[0].stMasks[22].idStyle	= IDS_TABSTOP;

		       /* Save the description of the control		*/

memcpy(pUserInfo->utDefined[0].szDescription, "Pattern Control", 16);

		       /* Return the success flag back to Resource	*/
		       /* Editor					*/
return(TRUE);
}
#pragma	subtitle("   Pattern Control DLL - Control Window Procedure")
#pragma	page( )

/* --- PatternWndProc -------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the image	*/
/*     button control.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Window Handle					*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     PatternWndProc =	Message	Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY PatternWndProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
HPS	      hPS;		   /* Presentation Space Handle		*/
PCREATESTRUCT pcrst;		   /* Create Structure Pointer		*/
POINTL	      ptl;		   /* Drawing Point			*/
PPATTERN      ppat;		   /* Image Button Structure Pointer	*/
PWNDPARAMS    pwprm;		   /* Window Parameters	Pointer		*/
ULONG	      ulID;		   /* ID Holder				*/

switch ( msg )
   {
		       /* Window Create					*/
   case	WM_CREATE :
		       /* Create a heap	for the	control	using a		*/
		       /* segment					*/

       DosAllocMem((PPVOID)(PVOID)&ppat, 4096UL, PAG_READ | PAG_WRITE |	PAG_COMMIT);

		       /* Save the address of the text string pointer	*/
		       /* in the control's reserved memory to allow it  */
		       /* to be	referenced as required by the control	*/

       WinSetWindowPtr(hWnd, QWW_CDATA,	(PVOID)ppat);

		       /* Get the control's creation structure address  */
		       /* to copy the default text of the control to	*/
		       /* the memory in	the heap			*/

       pcrst = (PCREATESTRUCT)PVOIDFROMMP(mp2);

       ppat->hptrArrow = WinQuerySysPointer(HWND_DESKTOP, SPTR_ARROW,
					    FALSE);
       ppat->rcl.xLeft = ppat->rcl.yBottom = 0L;
       ppat->rcl.xRight	= pcrst->cx;
       ppat->rcl.yTop	= pcrst->cy;
       break;
		       /* Process window parameters query		*/

   case	WM_QUERYWINDOWPARAMS :

		       /* Get the address for the windows parameters	*/
		       /* structure					*/

       pwprm = (PWNDPARAMS)PVOIDFROMMP(mp1);

		       /* Determine the	type of	query			*/

       switch (	pwprm->fsStatus	)
	   {
		       /* Query	type:  get text	length			*/

	   case	WPM_CCHTEXT :

		       /* Place	the length the string within the	*/
		       /* structure					*/

	       pwprm->cchText =	0;
	       break;
		       /* Query	type:  get control data	length		*/

	   case	WPM_CBCTLDATA :

		       /* Set the control data length to zero		*/

	       pwprm->cbCtlData	= 0;
	       break;

	   default :
	       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
	   }
       break;

   case	WM_PRESPARAMCHANGED :
       if ( LONGFROMMP(mp1) != PP_FONTNAMESIZE )
	   {
	   ppat	= (PPATTERN)WinQueryWindowPtr(hWnd, QWW_CDATA);
	   WinQueryPresParam(hWnd, (ULONG)LONGFROMMP(mp1), 0L, &ulID, 4UL,
			     (PVOID)&ppat->aClr[(LONGFROMMP(mp1) - 1L) / 2],
			     QPF_NOINHERIT);
	   }
       break;

   case	WM_SIZE	:
       ppat = (PPATTERN)WinQueryWindowPtr(hWnd,	QWW_CDATA);
       WinQueryWindowRect(hWnd,	&ppat->rcl);
       break;
		       /* Erase	background				*/

   case	WM_ERASEBACKGROUND :
       return(MRFROMLONG(TRUE));

   case	WM_HITTEST :
       return(MRFROMLONG(HT_TRANSPARENT));

		       /* Paint	the window				*/
   case	WM_PAINT :
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       ppat = (PPATTERN)WinQueryWindowPtr(hWnd,	QWW_CDATA);

		       /* Get the presentation space for the window	*/
		       /* and draw the grid which the buttons are	*/
		       /* placed					*/

       GpiSetPattern(hPS = WinBeginPaint(hWnd, (HPS)NULL, (PRECTL)NULL),
		     (LONG)(WinQueryWindowULong(hWnd, QWL_STYLE) & 0x5fUL));

       ptl.x = ptl.y = 0L;
       GpiMove(hPS, &ptl);
       ptl.x = ppat->rcl.xRight;
       ptl.y = ppat->rcl.yTop;
       GpiBox(hPS, DRO_FILL, &ptl, 0L, 0L);

		       /* Release the presentation space		*/
       WinEndPaint(hPS);
       break;
		       /* Window being destroyed, perform clean-up	*/
   case	WM_DESTROY :
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       ppat = (PPATTERN)WinQueryWindowPtr(hWnd,	QWW_CDATA);

		       /* Release the heap allocated for use by	the	*/
		       /* control					*/

       DosFreeMem((PVOID)ppat);
       break;
		       /* Virtual key not TAB or Shift+TAB, fall	*/
		       /* through to default window procedure		*/

		       /* Default message processing			*/
   default :
       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
#pragma	subtitle("   Pattern Control DLL - Control Styles Dialogue Procedure")
#pragma	page ( )

/* --- PatternStyles --------------------------------------------------	*/
/*									*/
/*     This function is	used for the custom control's styles dialogue   */
/*     box procedure.							*/
/*									*/
/*     When the	dialogue is invoked from Resource Editor, the	     */
/*     address of the user style information is	contained in message	*/
/*     parameter 2.  The dialogue is responsible for saving the		*/
/*     address.	 The best method to do this is to save the pointer	*/
/*     in the dialogue's reserved memory where it can be retrieved as   */
/*     needed.								*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     PatternStyles = Message Handling	Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY PatternStyles(HWND hWnd, ULONG	msg, MPARAM mp1, MPARAM	mp2)

{
PUSERSTYLE   pust;		   /* User Style Pointer		*/
SWP	     swp;		   /* Screen Window Position Holder	*/
register INT i;			   /* Radio Button Index		*/

switch ( msg )
   {
		       /* Perform dialogue initialization		*/
   case	WM_INITDLG :
		       /* Save the pointer to user style information	*/
		       /* within the dialog's reserved memory           */

       WinSetWindowPtr(hWnd, QWL_USER, (PVOID)mp2);

		       /* Get the pointer to the user style information	*/

       if ( (pust = (PUSERSTYLE)mp2) !=	NULL )
	   {
		       /* Set the text,	ID symbol and value for	the	*/
		       /* control					*/

	   pust->pfnSetSymbolID(hWnd, IDBX_SYMBOLVALUE,	pust);
	   if (	(pust->flStyle & 0x5f) == PATSYM_BLANK )
	       WinSendDlgItemMsg(hWnd, RB_BLANK, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);
	   else
	       WinSendDlgItemMsg(hWnd,
				 (ULONG)(RB_DEFAULT + (pust->flStyle & 0x5f)),
				 BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_VISIBLE )
	       WinSendDlgItemMsg(hWnd, CB_VISIBLE, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_GROUP )
	       WinSendDlgItemMsg(hWnd, CB_GROUP, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_DISABLED )
	       WinSendDlgItemMsg(hWnd, CB_DISABLED, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_TABSTOP )
	       WinSendDlgItemMsg(hWnd, CB_TABSTOP, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);
	   }
		       /* Centre dialog	on the screen			*/

       WinQueryWindowPos(hWnd, (PSWP)&swp);
       WinSetWindowPos(hWnd, HWND_TOP,
		       (WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - swp.cx) /	2L,
		       (WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - swp.cy) /	2L,
		       0L, 0L, SWP_MOVE);
       break;
		       /* Process push button selections		*/
   case	WM_COMMAND :
       switch (	SHORT1FROMMP(mp1) )
	   {
		       /* Enter	pushbutton selected get	the definitions	*/
		       /* for the control				*/
	   case	DID_OK :

		       /* Get the pointer to the user style information	*/

	       if ( (pust = PDATAFROMDLG(hWnd))	!= NULL	)
		   {
		       /* Get the address of the symbol	validation	*/
		       /* function from	the user style information	*/
		       /* structure.  The function will	validate the	*/
		       /* symbol and will check	for duplications of	*/
		       /* values.  A return value of TRUE from the	*/
		       /* validation function indicates	that the symbol	*/
		       /* and value are	acceptable.  Conversely, a	*/
		       /* FALSE	return value indicates that symbol or	*/
		       /* value	was not	acceptable.  In	this case,	*/
		       /* the dialog should not	be exited from and the	*/
		       /* values within	the entry fields should	not be	*/
		       /* saved.					*/

		   if (	!pust->pfnGetSymbolID(hWnd, IDBX_SYMBOLVALUE, pust) )
		       break;
		   else
		       {
		       /* Symbol and value validated, get the text of	*/
		       /* the control and save within the user style	*/
		       /* information structure	for use	by Resource	*/
		       /* Editor					*/

		       pust->cText = 0;

		       pust->flStyle &=	0xffffffa0UL;
		       if ( (i = (INT)SHORT1FROMMR(WinSendDlgItemMsg(hWnd,
								     RB_DEFAULT,
								     BM_QUERYCHECKINDEX,
								     0L, 0L))) ==
			    18 )
			   pust->flStyle |= PATSYM_BLANK;
		       else
			   pust->flStyle |= (ULONG)i;

		       pust->flStyle &=	~(WS_VISIBLE | WS_GROUP	| WS_DISABLED |	WS_TABSTOP);
		       if ( WinSendDlgItemMsg(hWnd, CB_VISIBLE,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_VISIBLE;

		       if ( WinSendDlgItemMsg(hWnd, CB_GROUP,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_GROUP;

		       if ( WinSendDlgItemMsg(hWnd, CB_DISABLED,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_DISABLED;

		       if ( WinSendDlgItemMsg(hWnd, CB_TABSTOP,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_TABSTOP;
		       }
		   }
		       /* Exit the dialogue indicating changes made	*/

	       WinDismissDlg(hWnd, TRUE);
	       break;
		       /* Cancel selected, exit	the dialogue without	*/
		       /* changing anything				*/

	   case	DID_CANCEL :
	       WinDismissDlg(hWnd, FALSE);
	       break;
	   }
       break;
		       /* Close	received, exit dialog			*/
   case	WM_CLOSE :
       WinDismissDlg(hWnd, FALSE);
       break;
		       /* Pass through unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);

}
