#pragma	title("Notebook Example  --  Version 1.0  --  (NoteDlg.C)")
#pragma	subtitle("   Notebook Dialogues - Interface Definitions")

#define	INCL_DOS		   /* Include OS/2 DOS Kernal		*/
#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

#if defined(__IBMC__)

#pragma	info(noext)

#endif

#include <os2.h>
#include <stdio.h>
#include <string.h>

#include "appdefs.h"
#include "notebook.h"

/* This	module contains	routine	used to	notebook dialogues.		*/

/* Filename:   NoteDlg.C						*/

/*  Version:   1.0							*/
/*  Created:   1994-08-22						*/
/*  Revised:   1994-08-22						*/

/* Routines:   MRESULT EXPENTRY	NotebookDlgProc(HWND hWnd, ULONG msg,	*/
/*						MPARAM mp1, MPARAM mp2);*/
/*	       MRESULT EXPENTRY	NotebookPage1DlgProc(HWND hWnd,		*/
/*						     ULONG msg,		*/
/*						     MPARAM mp1,	*/
/*						     MPARAM mp2);	*/
/*	       MRESULT EXPENTRY	NotebookPage2DlgProc(HWND hWnd,		*/
/*						     ULONG msg,		*/
/*						     MPARAM mp1,	*/
/*						     MPARAM mp2);	*/
/*	       MRESULT EXPENTRY	SuperExampleDlgProc(HWND hWnd,		*/
/*						     ULONG msg,		*/
/*						     MPARAM mp1,	*/
/*						     MPARAM mp2);	*/


/* Copyright  1994  Prominare Inc.  All Rights	Reserved.		*/

/* --------------------------------------------------------------------	*/

static HWND hwndPage1;		   /* Page 1 Window Handle		*/
static HWND hwndPage2;		   /* Page 2 Window Handle		*/

#pragma	subtitle("   Notebook Dialogues - Dialog Procedure")
#pragma	page( )

/* --- NotebookDlgProc ------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the dialog	*/
/*     procedure.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     NotebookDlgProc = Message Handling Result			*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY NotebookDlgProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
HPS   hPS;			   /* Temporary	Presentation Space	*/
HWND  hwndNBK;			   /* Notebook Window Handle		*/
PVOID ppb;			   /* Dialogue Template	Pointer		*/
RECTL rcl;			   /* Rectangle	Holder			*/
ULONG ulPageID;			   /* Inserted Page ID			*/

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
       ulPageID	= (ULONG)WinSendMsg(hwndNBK = WinWindowFromID(hWnd, NB_EXAMPLE), BKM_INSERTPAGE, 0L,
				    MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE |	BKA_MAJOR), BKA_LAST));

       WinSendMsg(hwndNBK, BKM_SETSTATUSLINETEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("Page 1 of 2"));

       WinSendMsg(hwndNBK, BKM_SETTABTEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("~First Page"));

       DosGetResource((HMODULE)NULL, RT_DIALOG,	NBP_PAGE1, (PPVOID)&ppb);
       hwndPage1 = WinCreateDlg(HWND_DESKTOP, (HWND)NULL, (PFNWP)NotebookPage1DlgProc,
				(PDLGTEMPLATE)ppb, NULL);
       DosFreeResource((PVOID)ppb);
       WinSendMsg(hwndNBK, BKM_SETPAGEWINDOWHWND,
		  MPFROMLONG(ulPageID),	MPFROMHWND(hwndPage1));

       ulPageID	= (ULONG)WinSendMsg(hwndNBK, BKM_INSERTPAGE, 0L,
				    MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE |	BKA_MAJOR), BKA_LAST));

       WinSendMsg(hwndNBK, BKM_SETSTATUSLINETEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("Page 2 of 2"));

       WinSendMsg(hwndNBK, BKM_SETTABTEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("~Second Page"));

       DosGetResource((HMODULE)NULL, RT_DIALOG,	NBP_PAGE2, (PPVOID)&ppb);
       hwndPage2 = WinCreateDlg(HWND_DESKTOP, (HWND)NULL, (PFNWP)NotebookPage2DlgProc,
			       (PDLGTEMPLATE)ppb, NULL);
       DosFreeResource((PVOID)ppb);
       WinSendMsg(hwndNBK, BKM_SETPAGEWINDOWHWND,
		  MPFROMLONG(ulPageID),	MPFROMHWND(hwndPage2));

       rcl.xLeft = rcl.yBottom = 0L;
       rcl.xRight = rcl.yTop = 400L;

       WinDrawText(hPS = WinGetPS(hWnd), -1, " Second Page ", &rcl, CLR_BLACK, CLR_BLACK,
		   DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT);
       WinReleasePS(hPS);
       WinSendMsg(hwndNBK, BKM_SETDIMENSIONS,
		  MPFROM2SHORT((SHORT)(rcl.xRight - rcl.xLeft),	(SHORT)(fm.lMaxBaselineExt * 2)),
		  MPFROMSHORT(BKA_MAJORTAB));

		       /* Set the dimension of the notebook buttons	*/

       WinSendMsg(hwndNBK, BKM_SETDIMENSIONS, MPFROM2SHORT(21, 21),
		  MPFROMLONG(BKA_PAGEBUTTON));

		       /* Set the background colours to	that of	the	*/
		       /* dialogue					*/

       WinSendMsg(hwndNBK, BKM_SETNOTEBOOKCOLORS, MPFROMLONG(SYSCLR_DIALOGBACKGROUND),
		  MPFROMLONG(BKA_BACKGROUNDPAGECOLORINDEX));
       WinSendMsg(hwndNBK, BKM_SETNOTEBOOKCOLORS, MPFROMLONG(SYSCLR_DIALOGBACKGROUND),
		  MPFROMLONG(BKA_BACKGROUNDMAJORCOLORINDEX));
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
	switch ( SHORT2FROMMP(mp1) )
	    {
	    }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
		WinSendMsg(hwndPage1, WM_COMMAND,
			   MPFROMLONG(DID_OK), MPFROMLONG(CMDSRC_OTHER));
		WinSendMsg(hwndPage2, WM_COMMAND,
			   MPFROMLONG(DID_OK), MPFROMLONG(CMDSRC_OTHER));
		WinDismissDlg(hWnd, TRUE);
		break;
	    }
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
#pragma	subtitle("   Notebook Dialogues - Dialog Procedure")
#pragma	page( )

/* --- NotebookPage1DlgProc -------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the dialog	*/
/*     procedure.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     NotebookPage1DlgProc = Message Handling Result			*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY NotebookPage1DlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
CHAR szBuffer[32];		   /* String Buffer			*/

switch ( msg )
   {
   case	WM_CHAR	:
	break;
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
	WinSetDlgItemText(hWnd,	EF_ENTRYFIELD, "Sample Text");
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
	switch ( SHORT2FROMMP(mp1) )
	    {
	    }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
	       WinQueryDlgItemText(hWnd, EF_ENTRYFIELD,	32L, szBuffer);
	       WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, szBuffer,
			     "Text Retrieved from Notebook Page 1", NBP_PAGE1,
			     MB_OK | MB_ICONEXCLAMATION);
	       break;
	    }
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
#pragma	subtitle("   Notebook Dialogues - Dialog Procedure")
#pragma	page( )

/* --- NotebookPage2DlgProc -------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the dialog	*/
/*     procedure.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     NotebookPage2DlgProc = Message Handling Result			*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY NotebookPage2DlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
CHAR szBuffer[32];		   /* String Buffer			*/
register INT i;			   /* Loop Counter			*/

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
       for ( i = 0; i <	50; i++	)
	   {
	   sprintf(szBuffer, "Item %d",	i + 1);
	   WinSendDlgItemMsg(hWnd, LB_PAGE2, LM_INSERTITEM,
			     MPFROM2SHORT(LIT_END, 0),
			     MPFROMP(szBuffer));
	   }
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
	switch ( SHORT2FROMMP(mp1) )
	    {
	    }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case PB_BUTTON :
	       WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Button Pushed",
			     "Item Selected from Notebook Page 2", NBP_PAGE2,
			     MB_OK | MB_ICONEXCLAMATION);
		break;

	    case DID_OK	:
	       WinQueryDlgItemText(hWnd, EF_ENTRYFIELD,	32L, szBuffer);
	       if ( (i = (INT)WinSendDlgItemMsg(hWnd, LB_PAGE2,
						LM_QUERYSELECTION,
						0L, 0L)) != LIT_NONE )
		   sprintf(szBuffer, "Item %d selected in list box.", i	+ 1);
	       else
		   strcpy(szBuffer, "No items selected in list box");
	       WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, szBuffer,
			     "Item Selected from Notebook Page 2", NBP_PAGE2,
			     MB_OK | MB_ICONEXCLAMATION);
	       break;
	    }
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
#pragma	subtitle("   Notebook Dialogues - Dialog Procedure")
#pragma	page( )

/* --- SuperExampleDlgProc --------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the dialog	*/
/*     procedure.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     SuperExampleDlgProc = Message Handling Result			*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY SuperExampleDlgProc(HWND hWnd,	ULONG msg, MPARAM mp1, MPARAM mp2)

{

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
	switch ( SHORT2FROMMP(mp1) )
	    {
	    }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
		WinDismissDlg(hWnd, TRUE);
		break;
	    }
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
