#pragma	title("Multi Window Example  --  Version 1.0  --  (CapWnd.C)")
#pragma	subtitle("   Captured Child Window - Interface Definitions")

#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

#if defined(__IBMC__)

#pragma	info(noext)

#endif

#include <os2.h>

#include "appdefs.h"
#include "multiwin.h"

/* This	module contains	processing for the captured child window.	*/

/* Filename:   CapWnd.C							*/

/*  Version:   1.0							*/
/*  Created:   1994-08-18						*/
/*  Revised:   1994-08-18						*/

/* Routines:   MRESULT EXPENTRY	CapChildWinProc(HWND hWnd, ULONG msg,	*/
/*						MPARAM mp1, MPARAM mp2);*/


/* Copyright  1994  Prominare Inc.  All Rights	Reserved.		*/

/* --------------------------------------------------------------------	*/

#pragma	subtitle("   Captured Child Window - Client Window Procedure")
#pragma	page( )

/* --- CapChildWinProc ------------------------------------------------- */
/*									*/
/*     This function is	used to	process	the messages sent to the	*/
/*     applications client window.					*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Window Handle					*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     CapChildWinProc = Message Handling Result			*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY CapChildWinProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
RECTL rcl;			    /* Window Rectangle			*/
HPS   hPS;			    /* Presentation Space Handle	*/


switch ( msg )
   {
			/* Process menu	and button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case PB_BUTTON1 :
		break;
	    case PB_BUTTON2 :
		break;
	    }
	break;
			/* Window being	created, perform window		*/
			/* initialization				*/
   case	WM_CREATE :
			/************************************************/
			/* UreGetTemplate is used to allow controls in	*/
			/* windows.  Do	not remove this	function if you	*/
			/* intend to include controls within the window.*/
			/************************************************/

	UreGetTemplate(hWnd, ID_CHILDWIN);
	break;

   case	WM_CHAR	:
	return(UreKeyProc(hWnd,	msg, mp1, mp2));

			/* Window being	destroyed, perform clean-up	*/
			/* operations					*/
   case	WM_DESTROY :
	break;
			/* Erase window	background			*/

   case	WM_ERASEBACKGROUND :
	WinQueryWindowRect(hWnd, &rcl);
	WinFillRect((HPS)LONGFROMMP(mp1), &rcl,	SYSCLR_WINDOW);
	break;
			/* Paint client	window				*/
   case	WM_PAINT :
	hPS = WinBeginPaint(hWnd, (HPS)NULL, &rcl);
	WinFillRect(hPS, &rcl, SYSCLR_WINDOW);
	WinEndPaint(hPS);
	break;

			/* Default message processing			*/
   default :
       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
