#pragma	title("List Box Replacement  --  Version 1.0 -- (EventMgr.C)")
#pragma	subtitle("   Event Manager - Interface Definitions")

#pragma	info(noext)
#pragma	strings(readonly)

#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/

#include <os2.h>

#include "lstbox.h"

/* This	module contains	the routines that handle the event management	*/
/* for the list	box.  All notifications	to the owner window are	handled	*/
/* through these routines.						*/
/*									*/
/* Equivalent command line invocation of each module using the		*/
/* IBM C Set++ Compiler	Version	2.0 is:					*/
/*									*/
/*     Icc -G3e- -O+ -Rn -C -W3	-FoEventMgr EventMgr.C			*/

/* Filename:   EventMgr.C						*/

/*  Version:   1.0							*/
/*  Created:   1993-10-14						*/
/*  Revised:   1993-10-21						*/

/* Routines:   MRESULT mrNotifyOwner(PLISTBOXWIN plbw,			*/
/*				     ULONG ulNotification);		*/

/* --------------------------------------------------------------------	*/

#pragma	subtitle("   Event Manager - Owner Notification Procedure")
#pragma	page( )

/* --- mrNotifyOwner ----------------------------------- [ Public } ---	*/
/*									*/
/*     This function is	used to	send the notification message to the	*/
/*     window owning the list box control.  The	notification message	*/
/*     is one of the defined messages for the control.			*/
/*									*/
/* Standard List Box notification messages				*/
/*									*/
/*     LN_SELECT		  1					*/
/*     LN_SETFOCUS		  2					*/
/*     LN_KILLFOCUS		  3					*/
/*     LN_SCROLL		  4					*/
/*     LN_ENTER			  5					*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     PLISTBOXWIN plbw;	   = List Box Internal Data Pointer	*/
/*     ULONG	   ulNotification; = Notification Value			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     mrNotifyOwner = Notification Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	mrNotifyOwner(PLISTBOXWIN plbw,	ULONG ulNotification)

{

return(WinSendMsg(plbw->hwndOwner, WM_CONTROL,
		  MPFROM2SHORT(plbw->id, (USHORT)ulNotification),
		  MPFROMHWND((plbw->hWnd))));
}
