#pragma	title("Super Combo Box DLL  --  Version 1.0 -- (ComboBox.C)")
#pragma	subtitle("   Resource Editor - Interface Definitions")

#pragma	info(noext)
	
#define	INCL_DOS		   /* Include OS/2 DOS Kernal		*/
#define	INCL_GPI		   /* Include OS/2 PM GPI Interface	*/
#define	INCL_WIN		   /* Include OS/2 PM Windows Interface	*/
#define	INCL_NLS		   /* Include OS/2 PM NLS Support	*/

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pmcx.h>

#include "combobox.h"

/* This	module contains	an example installable control that can	be used	*/
/* within applications where additional	facilities are provided	that	*/
/* are not found within	the default controls of	OS/2 PM.		*/
/*									*/
/* For complete	details	regarding the PM Control Extensions (PMCX)	*/
/* consult the User's Guide.                                            */
/*									*/
/* The DLL is created using the	following command line invocation:	*/
/*									*/
/*     Icc -G3e- -O+ -Rn -W3 -C	ComboBox.C				*/

/* Filename:   ComboBox.C						*/

/*  Version:   1.0							*/
/*  Created:   1993-12-21						*/
/*  Revised:   1994-06-26						*/

/* Routines:   BOOL EXPENTRY ComboBoxRegister(HAB hAB);			*/
/*	       BOOL EXPENTRY ComboBoxQuery(PUSERINFO pUserInfo);	*/
/*	       MRESULT EXPENTRY	ComboBoxWndProc(HWND hWnd, ULONG msg,	*/
/*						MPARAM mp1, MPARAM mp2);*/
/*	       MRESULT EXPENTRY	ComboBoxStyles(HWND hWnd, ULONG	msg,	*/
/*					       MPARAM mp1, MPARAM mp2);	*/


/* Copyright  1989-1994  Prominare Inc.  All Rights Reserved.		*/

/* --------------------------------------------------------------------	*/

/************************************************************************/
/************************************************************************/
/*		       DISCLAIMER OF WARRANTIES.			*/
/************************************************************************/
/************************************************************************/
/*     The following [enclosed]	code is	library	code created by		*/
/*     Prominare Inc.  This library code is  provided to you solely	*/
/*     for the purpose of assisting you	in the development of your	*/
/*     applications.  The code is provided "AS IS", without		*/
/*     warranty	of any kind.  Prominare	Inc. shall not be liable	*/
/*     for any damages arising out of your use of the library code,	*/
/*     even if they have been advised of the possibility of such	*/
/*     damages.								*/
/************************************************************************/
/************************************************************************/
/* --- Combo Box Window	Information Structures ------------------------	*/

typedef	struct _COMBOBOX
   {
   HWND	     hWnd;		   /* Control Window Handle		*/
   ULONG     id;		   /* ID Value				*/
   HWND	     hwndOwner;		   /* Owner Window Handle		*/
   HWND	     hwndParent;	   /* Parent Window Handle		*/
   HWND	     hwndComboBox;	   /* Combo Box	Window Handle		*/
   } COMBOBOX ;

typedef	COMBOBOX *PCOMBOBOX;

/* --- Combo Box Support ----------------------------------------------	*/

typedef	struct _COMBOBOXCDATA
   {
   ULONG    cb;			   /* Structure	Size			*/
   ULONG    cItems;		   /* Items Count			*/
   ULONG    ulSize;		   /* Entry Field			*/
   BYTE	    abList[1];		   /* Array List Start			*/
   } COMBOBOXCDATA ;

typedef	COMBOBOXCDATA *PCOMBOBOXCDATA;

BOOL	EXPENTRY ComboBoxRegister(HAB hAB);
BOOL	EXPENTRY ComboBoxQuery(PUSERINFO pUserInfo);
MRESULT	EXPENTRY ComboBoxStyles(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);

MRESULT	EXPENTRY ComboBoxWndProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);

#pragma	subtitle("   Super Combo Box DLL - Control Initialization Function")
#pragma	page ( )

/* --- ComboBoxRegister	-------------------------------- [ Public ] ---	*/
/*									*/
/*     This function is	used to	register the installable control class	*/
/*     with OS/2 Presentation Manager.	The registration must use the	*/
/*     USER_CWINDOWWORDS to reserve memory for the control to allow for	*/
/*     proper usage by Resource	Editor and for use by the control	*/
/*     dialog and window procedures.  The information for the control	*/
/*     containing the style, presentation parameters and control data	*/
/*     is pointed to by	a pointer that can be referenced by the		*/
/*     control's dialog and window procedure as required.  The memory   */
/*     for the structure is allocated and controlled through Resource	*/
/*     Editor.	 The control can reserve more memory for its use	*/
/*     by adding the memory required to	that of	the USER_CWINDOWWORDS	*/
/*     constant.							*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HAB hAB;	= Application Anchor Block Handle			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     ComboBoxRegister	=  TRUE	: Class	Registration Successful		*/
/*			= FALSE	: Class	Registration Failed		*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY ComboBoxRegister(HAB hAB)

{
		       /* Register the control class with OS/2		*/
		       /* Presentation Manager and return registration	*/
		       /* result					*/

return(WinRegisterClass(hAB, "ComboBox", (PFNWP)ComboBoxWndProc,
			CS_MOVENOTIFY |	CS_PARENTCLIP |	CS_SIZEREDRAW |	CS_SYNCPAINT,
			USER_CWINDOWWORDS));

}
#pragma	subtitle("   Super Combo Box DLL - Query Control Information Function")
#pragma	page ( )

/* --- ComboBoxQuery ----------------------------------- [ Public ] ---	*/
/*									*/
/*     This function is	used to	return to the caller information	*/
/*     regarding the installable control and its capabilities.	The	*/
/*     function	should return a	true value otherwise Resource		*/
/*     Editor will not register	the control as being usable.		*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     PUSERINFO pUserInfo; = User Information Pointer			*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     ComboBoxQuery =	TRUE : User Information	Being Returned		*/
/*		     = FALSE : No User Information Available		*/
/*									*/
/* --------------------------------------------------------------------	*/

BOOL EXPENTRY ComboBoxQuery(PUSERINFO pUserInfo)

{
		       /* Complete the User Information	structure	*/
		       /* passed to the	function by Resource Editor	*/

		       /* Complete the version and number of control	*/
		       /* types.  In Version 1.00 of CCRS, only	one	*/
		       /* control type is used.				*/
pUserInfo->ulMajor = 1UL;
pUserInfo->ulMinor = 0UL;
		       /* Complete the author and control classname	*/

memcpy(pUserInfo->szAuthor,    "Prominare Inc.", 15);
memcpy(pUserInfo->szClassname, "ComboBox", 9);
memcpy(pUserInfo->szName,      "ComboBox", 9);

		       /* Complete the default size and	style of the	*/
		       /* first	user control type			*/

pUserInfo->utDefined[0].cx	     = 48L;
pUserInfo->utDefined[0].cy	     = 32L;
pUserInfo->utDefined[0].flStyle	     = WS_VISIBLE | CBS_DROPDOWNLIST | WS_TABSTOP;

		       /* Set the maximum amount of text control can	*/
		       /* accept including NULL	termination byte	*/

pUserInfo->utDefined[0].cMaxText     = 256UL;

		       /* Save the style's dialogue ID, type, control   */
		       /* data size and	count of style masks		*/

pUserInfo->utDefined[0].idDlg	     = DLG_CTRLUSER;
pUserInfo->utDefined[0].ulType	     = UTYPE_PRIVATE;
pUserInfo->utDefined[0].cCtlData     = sizeof(COMBOBOXCDATA);
pUserInfo->utDefined[0].cMasks	     = 9UL;
pUserInfo->utDefined[0].flOptions    = PMCXOPT_VARICDATA | PMCXOPT_REFRESH;
pUserInfo->utDefined[0].flStyleType  = STYLETYPE_BITFLAGS;
pUserInfo->utDefined[0].stMasks[0].flStyleMask = CBS_SIMPLE;
pUserInfo->utDefined[0].stMasks[0].idStyle     = IDS_CBS_SIMPLE;
pUserInfo->utDefined[0].stMasks[1].flStyleMask = CBS_DROPDOWN;
pUserInfo->utDefined[0].stMasks[1].idStyle     = IDS_CBS_DROPDOWN;
pUserInfo->utDefined[0].stMasks[2].flStyleMask = CBS_DROPDOWNLIST;
pUserInfo->utDefined[0].stMasks[2].idStyle     = IDS_CBS_DROPDOWNLIST;
pUserInfo->utDefined[0].stMasks[3].flStyleMask = ES_AUTOTAB;
pUserInfo->utDefined[0].stMasks[3].idStyle     = IDS_ES_AUTOTAB;
pUserInfo->utDefined[0].stMasks[4].flStyleMask = ES_ANY;
pUserInfo->utDefined[0].stMasks[4].idStyle     = IDS_ES_ANY;
pUserInfo->utDefined[0].stMasks[5].flStyleMask = ES_SBCS;
pUserInfo->utDefined[0].stMasks[5].idStyle     = IDS_ES_SBCS;
pUserInfo->utDefined[0].stMasks[6].flStyleMask = ES_DBCS;
pUserInfo->utDefined[0].stMasks[6].idStyle     = IDS_ES_DBCS;
pUserInfo->utDefined[0].stMasks[7].flStyleMask = ES_MIXED;
pUserInfo->utDefined[0].stMasks[7].idStyle     = IDS_ES_MIXED;
pUserInfo->utDefined[0].stMasks[8].flStyleMask = LS_HORZSCROLL;
pUserInfo->utDefined[0].stMasks[8].idStyle     = IDS_LS_HORZSCROLL;

		       /* Save the description of the control		*/

memcpy(pUserInfo->utDefined[0].szDescription, "Super Combo Box", 16);

		       /* Return the success flag back to Resource	*/
		       /* Editor					*/
return(TRUE);
}
#pragma	subtitle("   Super Combo Box DLL - Control Window Procedure")
#pragma	page( )

/* --- ComboBoxWndProc ------------------------------------------------	*/
/*									*/
/*     This function is	used to	process	the messages for the combo	*/
/*     box control window.						*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Window Handle					*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     ComboBoxWndProc = Message Handling Result			*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY ComboBoxWndProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
PCOMBOBOX      pcb;		   /* Combo Box	Internal Data Pointer	*/
PCOMBOBOXCDATA pcbd;		   /* Combo Box	Data Pointer		*/
PCREATESTRUCT  pcrst;		   /* Create Structure Pointer		*/
PSWP	       pswp;		   /* SWP Structure Pointer		*/
register INT i,	n;		   /* Loop Counters			*/

switch ( msg )
   {

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	1: Control creation coding					*/
/*									*/
/************************************************************************/
/************************************************************************/

   /*********************************************************************/
   /*  Control creation							*/
   /*********************************************************************/

   case	WM_CREATE :
		       /* Allocate memory for internal control data	*/

       DosAllocMem((PPVOID)(PVOID)&pcb,	sizeof(COMBOBOX),
		   PAG_READ | PAG_WRITE	| PAG_COMMIT);

		       /* Save the address of the internal control data	*/
		       /* in the control's reserved memory to allow it  */
		       /* to be	referenced as required by the control	*/

       WinSetWindowPtr(hWnd, QWW_CDATA,	(PVOID)pcb);

		       /* Get the control's creation structure address  */
		       /* to copy the relevant information such	as the	*/
		       /* size,	position and text of the control into	*/
		       /* the internal control data			*/

       pcrst = (PCREATESTRUCT)PVOIDFROMMP(mp2);

		       /* Save the owner and parent of the control so	*/
		       /* notification messages	can be sent back to	*/
		       /* the proper locations within the owning	*/
		       /* application					*/

       pcb->hWnd       = hWnd;
       pcb->hwndOwner  = pcrst->hwndOwner;
       pcb->hwndParent = pcrst->hwndParent;

       if ( !(pcb->hwndComboBox	= WinCreateWindow(hWnd,	WC_COMBOBOX, pcrst->pszText,
						  pcrst->flStyle,
						  0L, 0L, pcrst->cx, pcrst->cy,
						  hWnd,	HWND_TOP, 0x1234UL,
						  (PVOID)NULL, (PVOID)pcrst->pPresParams)) )
	   return(MRFROMLONG(TRUE));

		       /* Get the address of the CTLDATA structure that	*/
		       /* may contain the bitmap information that the	*/
		       /* control can use during its creation instead	*/
		       /* of using messages to set the button images	*/

       if ( (pcbd = (PCOMBOBOXCDATA)PVOIDFROMMP(mp1)) != NULL )
	   {
	   for ( i = n = 0; i <	pcbd->cItems; i++ )
	       {
	       WinSendMsg(pcb->hwndComboBox, LM_INSERTITEM,
			  MPFROM2SHORT(LIT_END,	0),
			  MPFROMP(&pcbd->abList[n]));
	       n += (INT)strlen(&pcbd->abList[n]) + 1;
	       }

	   if (	pcbd->ulSize )
	       WinSendMsg(pcb->hwndComboBox, EM_SETTEXTLIMIT,
			  MPFROMLONG(pcbd->ulSize), 0L);
	   }
       break;

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	2: Control sizing and positioning coding			*/
/*									*/
/************************************************************************/
/************************************************************************/

   /*********************************************************************/
   /*  Control being sized						*/
   /*********************************************************************/

   case	WM_ADJUSTWINDOWPOS :
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       pcb = (PCOMBOBOX)WinQueryWindowPtr(hWnd,	QWW_CDATA);
       pswp = (PSWP)PVOIDFROMMP(mp1);
       if ( pswp->fl & SWP_SIZE	)
	   WinSetWindowPos(pcb->hwndComboBox, HWND_TOP,	0L, 0L,
			   pswp->cx, pswp->cy,
			   SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ACTIVATE);
       break;

   case	WM_SIZE	:
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       pcb = (PCOMBOBOX)WinQueryWindowPtr(hWnd,	QWW_CDATA);
       WinSetWindowPos(pcb->hwndComboBox, HWND_TOP, 0L,	0L,
		       (LONG)SHORT1FROMMP(mp2),	(LONG)SHORT2FROMMP(mp2),
		       SWP_SIZE	| SWP_MOVE | SWP_SHOW |	SWP_ACTIVATE);
       break;

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	3: Control sizing and positioning coding			*/
/*									*/
/************************************************************************/
/************************************************************************/

   /*********************************************************************/
   /*  Control notification messages					*/
   /*********************************************************************/

   case	WM_CONTROL :
       if ( SHORT1FROMMP(mp1) == 0x1234	)
	   {
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

	   pcb = (PCOMBOBOX)WinQueryWindowPtr(hWnd, QWW_CDATA);
	   WinSendMsg(pcb->hwndOwner, msg,
		      MPFROM2SHORT(pcb->id, SHORT2FROMMP(mp1)),	mp2);
	   }
       break;

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	3: Control sizing and positioning coding			*/
/*									*/
/************************************************************************/
/************************************************************************/

   /*********************************************************************/
   /*  Control being sized						*/
   /*********************************************************************/

   case	WM_CONTROLPOINTER :

		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       pcb = (PCOMBOBOX)WinQueryWindowPtr(hWnd,	QWW_CDATA);
       return(WinSendMsg(pcb->hwndOwner, msg, mp1, mp2));

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	4: Control specific messages coding				*/
/*									*/
/************************************************************************/
/************************************************************************/

   /*********************************************************************/
   /*  Control specific	messages are simply passed to the combo	box	*/
   /*********************************************************************/

   case	CBM_HILITE :
   case	CBM_ISLISTSHOWING :
   case	CBM_SHOWLIST :
   case	LM_INSERTITEM :
   case	LM_QUERYITEMCOUNT :
   case	LM_SETTOPINDEX :
   case	LM_QUERYTOPINDEX :
   case	LM_DELETEITEM :
   case	LM_SELECTITEM :
   case	LM_QUERYSELECTION :
   case	LM_SETITEMTEXT :
   case	LM_QUERYITEMTEXT :
   case	LM_QUERYITEMTEXTLENGTH :
   case	LM_SEARCHSTRING	:
   case	LM_DELETEALL :
   case	EM_QUERYFIRSTCHAR :
   case	EM_SETFIRSTCHAR	:
   case	EM_QUERYCHANGED	:
   case	EM_QUERYSEL :
   case	EM_SETSEL :
   case	EM_SETTEXTLIMIT	:
   case	EM_CUT :
   case	EM_PASTE :
   case	EM_COPY	:
   case	EM_CLEAR :
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       pcb = (PCOMBOBOX)WinQueryWindowPtr(hWnd,	QWW_CDATA);
       return(WinSendMsg(pcb->hwndComboBox, msg, mp1, mp2));

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	5: General window messages					*/
/*									*/
/************************************************************************/
/************************************************************************/

   /*********************************************************************/
   /*  General window messages are sent	to the combo box		*/
   /*********************************************************************/

   case	WM_ACTIVATE :
   case	WM_BUTTON1CLICK	:
   case	WM_BUTTON1DBLCLK :
   case	WM_BUTTON1DOWN :
   case	WM_BUTTON1MOTIONEND :
   case	WM_BUTTON1MOTIONSTART :
   case	WM_CHAR	:
   case	WM_ENABLE :
   case	WM_HITTEST :
   case	WM_MOUSEMOVE :
   case	WM_MOVE	:
   case	WM_PRESPARAMCHANGED :
   case	WM_QUERYWINDOWPARAMS :
   case	WM_SETFOCUS :
   case	WM_SETSELECTION	:
   case	WM_SETWINDOWPARAMS :
   case	WM_SHOW	:
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       pcb = (PCOMBOBOX)WinQueryWindowPtr(hWnd,	QWW_CDATA);
       return(WinSendMsg(pcb->hwndComboBox, msg, mp1, mp2));

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	6: Control destruction coding					*/
/*									*/
/************************************************************************/
/************************************************************************/

   /*********************************************************************/
   /*  Control being destroyed,	perform	clean-up			*/
   /*********************************************************************/

   case	WM_DESTROY :
		       /* Get the address of the control info from the	*/
		       /* control's reserved memory                     */

       pcb = (PCOMBOBOX)WinQueryWindowPtr(hWnd,	QWW_CDATA);
       WinDestroyWindow(pcb->hwndComboBox);
       DosFreeMem((PVOID)pcb);
       break;

/************************************************************************/
/************************************************************************/
/*									*/
/* Part	7: Default Processing						*/
/*									*/
/************************************************************************/
/************************************************************************/
		       /* Default message processing			*/
   default :
       return(WinDefWindowProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}
#pragma	subtitle("   Super Combo Box DLL - Control Styles Dialogue Procedure")
#pragma	page ( )

/* --- ComboBoxStyles ---------------------------------- [ Public ] ---	*/
/*									*/
/*     This function is	used for the custom control's styles dialogue   */
/*     box procedure.							*/
/*									*/
/*     When the	dialogue is invoked from Resource Editor, the		*/
/*     address of the user style information is	contained in message	*/
/*     parameter 2.  The dialogue is responsible for saving the		*/
/*     address.	 The best method to do this is to save the pointer	*/
/*     in the dialogue's reserved memory where it can be retrieved as   */
/*     needed.								*/
/*									*/
/*     Upon Entry:							*/
/*									*/
/*     HWND   hWnd; = Dialog Window Handle				*/
/*     ULONG  msg;  = PM Message					*/
/*     MPARAM mp1;  = Message Parameter	1				*/
/*     MPARAM mp2;  = Message Parameter	2				*/
/*									*/
/*     Upon Exit:							*/
/*									*/
/*     ComboBoxStyles =	Message	Handling Result				*/
/*									*/
/* --------------------------------------------------------------------	*/

MRESULT	EXPENTRY ComboBoxStyles(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
CHAR	       szBuffer[256];	   /* Buffer				*/
INT	       cItems;		   /* Items Count			*/
INT	       cLen;		   /* Text Length			*/
INT	       cLines;		   /* Lines Count			*/
INT	       cTextLen;	   /* Text Length			*/
IPT	       iptData;		   /* MLE Data Start Position		*/
PCHAR	       pch;		   /* Character	String Pointer		*/
PCHAR	       pchData;		   /* Data Pointer			*/
PCOMBOBOXCDATA pcbd;		   /* Colour Wheel CTLDATA Pointer	*/
PUSERSTYLE     pust;		   /* User Style Pointer		*/
SWP	       swp;		   /* Screen Window Position Holder	*/
register INT i,	n;		   /* Loop Counter			*/

switch ( msg )
   {
		       /* Perform dialogue initialization		*/
   case	WM_INITDLG :
		       /* Save the pointer to user style information	*/
		       /* within the dialog's reserved memory           */

       WinSetWindowPtr(hWnd, QWL_USER, (PVOID)mp2);

		       /* Get the pointer to the user style information	*/

       if ( (pust = (PUSERSTYLE	 )mp2) != NULL )
	   {
		       /* Set the text,	ID symbol and value for	the	*/
		       /* control					*/

	   pust->pfnSetSymbolID(hWnd, IDBX_SYMBOLVALUE,	pust);
	   pcbd	= (PCOMBOBOXCDATA)pust->pbCtlData;

	   if (	pcbd->ulSize )
	       WinSetDlgItemShort(hWnd,	EF_SIZE, (USHORT)pcbd->ulSize, TRUE);
	   else
	       WinSetDlgItemShort(hWnd,	EF_SIZE, 32, TRUE);

	   if (	pcbd->cItems )
	       {
	       WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_SETTEXTLIMIT,
				 MPFROMLONG(16384L), 0L);
	       WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_DISABLEREFRESH, 0L, 0L);
	       WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_RESETUNDO,	0L, 0L);
	       WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_FORMAT,
				 MPFROMSHORT(MLFIE_NOTRANS), 0L);
	       for ( i = n = 0,	iptData	= 0L; i	< pcbd->cItems;	i++ )
		   {
		   WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_SETIMPORTEXPORT,
				     MPFROMP(szBuffer),
				     MPFROMLONG(cLen = (INT)strlen(strcat(strcpy(szBuffer,
										 &pcbd->abList[n]),
									  "\n"))));
		   WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_IMPORT, MPFROMP(&iptData),
				     MPFROMLONG(cLen));
		   n +=	(INT)strlen(&pcbd->abList[n]) +	1;
		   }
	       WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_ENABLEREFRESH, 0L,	0L);
	       }

	   if (	pust->flStyle &	CBS_SIMPLE )
	       WinSendDlgItemMsg(hWnd, RB_CBS_SIMPLE, BM_SETCHECK, MPFROMSHORT(TRUE), 0L);
	   else
	       if ( pust->flStyle & CBS_DROPDOWN )
		   WinSendDlgItemMsg(hWnd, RB_CBS_DROPDOWN, BM_SETCHECK, MPFROMSHORT(TRUE), 0L);
	       else
		   WinSendDlgItemMsg(hWnd, RB_CBS_DROPLIST, BM_SETCHECK, MPFROMSHORT(TRUE), 0L);

		       /* Set Auto Tab check box if selected		*/

	   if (	pust->flStyle &	ES_AUTOTAB )
	       WinSendDlgItemMsg(hWnd, CB_ES_AUTOTAB, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

		       /* Set Any check	box if selected			*/

	   if (	pust->flStyle &	ES_ANY )
	       WinSendDlgItemMsg(hWnd, CB_ES_ANY, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

		       /* Set SBCS check box if	selected		*/

	   if (	pust->flStyle &	ES_SBCS	)
	       WinSendDlgItemMsg(hWnd, CB_ES_SBCS, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

		       /* Set DBCS check box if	selected		*/

	   if (	pust->flStyle &	ES_DBCS	)
	       WinSendDlgItemMsg(hWnd, CB_ES_DBCS, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

		       /* Set Mixed check box if selected		*/

	   if (	(pust->flStyle & ES_MIXED) == ES_MIXED )
	       WinSendDlgItemMsg(hWnd, CB_ES_MIXED, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

		       /* Set Horizontal Scroll	check box if selected	*/

	   if (	pust->flStyle &	LS_HORZSCROLL )
	       WinSendDlgItemMsg(hWnd, CB_LS_HORZSCROLL, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_VISIBLE )
	       WinSendDlgItemMsg(hWnd, CB_VISIBLE, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_GROUP )
	       WinSendDlgItemMsg(hWnd, CB_GROUP, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_DISABLED )
	       WinSendDlgItemMsg(hWnd, CB_DISABLED, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);

	   if (	pust->flStyle &	WS_TABSTOP )
	       WinSendDlgItemMsg(hWnd, CB_TABSTOP, BM_SETCHECK,
				 MPFROMSHORT(TRUE), 0L);
	   }
		       /* Centre dialog	on the screen			*/

       WinQueryWindowPos(hWnd, (PSWP)&swp);
       WinSetWindowPos(hWnd, HWND_TOP,
		       (WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - swp.cx) /	2L,
		       (WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - swp.cy) /	2L,
		       0L, 0L, SWP_MOVE);
       break;
		       /* Process push button selections		*/
   case	WM_COMMAND :
       switch (	SHORT1FROMMP(mp1) )
	   {
		       /* Presentation push button selected		*/

	   case	DID_FONTCLR :

		       /* Get the pointer to the user style information	*/

	       if ( (pust = PDATAFROMDLG(hWnd))	!= NULL	)

		       /* Get the address of the look up function from	*/
		       /* user style information structure and display	*/
		       /* the dialog.  The value selected within the	*/
		       /* dialog will be automatically placed within	*/
		       /* the required entry fields			*/

		   pust->pfnGetFontClr(hWnd);
	       break;
		       /* Enter	pushbutton selected get	the definitions	*/
		       /* for the control				*/
	   case	DID_OK :

		       /* Get the pointer to the user style information	*/

	       if ( (pust = PDATAFROMDLG(hWnd))	!= NULL	)
		   {
		       /* Get the address of the symbol	validation	*/
		       /* function from	the user style information	*/
		       /* structure.  The function will	validate the	*/
		       /* symbol and will check	for duplications of	*/
		       /* values.  A return value of TRUE from the	*/
		       /* validation function indicates	that the symbol	*/
		       /* and value are	acceptable.  Conversely, a	*/
		       /* FALSE	return value indicates that symbol or	*/
		       /* value	was not	acceptable.  In	this case,	*/
		       /* the dialog should not	be exited from and the	*/
		       /* values within	the entry fields should	not be	*/
		       /* saved.					*/

		   if (	!pust->pfnGetSymbolID(hWnd, IDBX_SYMBOLVALUE, pust) )
		       break;
		   else
		       {
		       pust->cText = 0;

		       cLines =	SHORT1FROMMR(WinSendDlgItemMsg(hWnd, MLE_LIST,
					     MLM_QUERYLINECOUNT, 0L, 0L));

		       DosAllocMem((PPVOID)(PVOID)&pchData, 16384UL, PAG_READ |	PAG_WRITE | PAG_COMMIT);
		       for ( i = n = cItems = 0, iptData = 0L; i < cLines; i++ )
			   if (	(cLen =	(INT)(cTextLen = (LONG)WinSendDlgItemMsg(hWnd, MLE_LIST,
										 MLM_QUERYLINELENGTH,
										 MPFROMLONG(iptData), 0L))) != 0 )
			       {
			       WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_SETIMPORTEXPORT,
						 MPFROMP(szBuffer), MPFROMLONG((IPT)cTextLen));
			       WinSendDlgItemMsg(hWnd, MLE_LIST, MLM_EXPORT,
						 MPFROMP(&iptData), MPFROMP(&cTextLen));

			       szBuffer[cLen] =	0;
			       if ( (pch = strchr(szBuffer, '\r')) != NULL )
				   *pch	= 0;
			       else
				   if (	(pch = strchr(szBuffer,	'\n')) != NULL )
				       *pch = 0;

			       if ( szBuffer[0]	)
				   {
				   strcpy(&pchData[n], szBuffer);
				   n +=	(INT)strlen(szBuffer) +	1;
				   ++cItems;
				   }
			       }

		       if ( !(pust->pbCtlData =	(PBYTE)pust->pfnRealloc(pust->pbCtlData,
									n + sizeof(COMBOBOXCDATA) - 1L)) )
			   {
			   WinMessageBox(HWND_DESKTOP, hWnd,
					 "Memory error on reallocating control data!",
					 "Super Combo Box Control", 0UL, MB_OK | MB_ICONEXCLAMATION);
			   return(0L);
			   }

		       pust->cbCtlData = (ULONG)(sizeof(COMBOBOXCDATA) - 1 + n);

		       pcbd = (PCOMBOBOXCDATA)pust->pbCtlData;
		       pcbd->cb	= (ULONG)(sizeof(COMBOBOXCDATA)	- 1 + n);
		       pcbd->cItems = (ULONG)cItems;
		       memcpy(pcbd->abList, pchData, (UINT)n);
		       DosFreeMem((PVOID)pchData);

		       /* Get the id value of the control and save	*/
		       /* within the user style	information structure	*/
		       /* for use by Resource Editor		     */

		       WinQueryDlgItemShort(hWnd, EF_SIZE,
					    (PSHORT)(PVOID)&pcbd->ulSize, TRUE);

		       /* Get rectangle	type and complete the default	*/
		       /* style						*/

		       switch (	SHORT1FROMMR(WinSendDlgItemMsg(hWnd, RB_CBS_SIMPLE,
							       BM_QUERYCHECKINDEX, 0L, 0L)) +
				 RB_CBS_SIMPLE )
			   {
			   case	RB_CBS_SIMPLE :
			       pust->flStyle = CBS_SIMPLE;
			       break;

			   case	RB_CBS_DROPDOWN	:
			       pust->flStyle = CBS_DROPDOWN;
			       break;

			   case	RB_CBS_DROPLIST	:
			       pust->flStyle = CBS_DROPDOWNLIST;
			       break;
			   }

		       if ( WinSendDlgItemMsg(hWnd, CB_ES_AUTOTAB, BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= ES_AUTOTAB;

		       /* Check	to see if Any desired and if selected	*/
		       /* add style to base selected			*/

		       if ( WinSendDlgItemMsg(hWnd, CB_ES_ANY, BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= ES_ANY;

		       /* Check	to see if SBCS desired and if selected	*/
		       /* add style to base selected			*/

		       if ( WinSendDlgItemMsg(hWnd, CB_ES_SBCS,	BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= ES_SBCS;

		       /* Check	to see if DBCS desired and if selected	*/
		       /* add style to base selected			*/

		       if ( WinSendDlgItemMsg(hWnd, CB_ES_DBCS,	BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= ES_DBCS;

		       /* Check	to see if Mixed	desired	and if selected	*/
		       /* add style to base selected			*/

		       if ( WinSendDlgItemMsg(hWnd, CB_ES_MIXED, BM_QUERYCHECK,	0L, 0L)	)
			   pust->flStyle |= ES_MIXED;

		       /* Check	to see if Horizontal Scroll desired and	*/
		       /* if selected add style	to base	selected	*/

		       if ( WinSendDlgItemMsg(hWnd, CB_LS_HORZSCROLL, BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= LS_HORZSCROLL;

		       if ( WinSendDlgItemMsg(hWnd, CB_VISIBLE,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_VISIBLE;

		       if ( WinSendDlgItemMsg(hWnd, CB_GROUP,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_GROUP;

		       if ( WinSendDlgItemMsg(hWnd, CB_DISABLED,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_DISABLED;

		       if ( WinSendDlgItemMsg(hWnd, CB_TABSTOP,
					      BM_QUERYCHECK, 0L, 0L) )
			   pust->flStyle |= WS_TABSTOP;
		       }
		   }
		       /* Exit the dialogue indicating changes made	*/

	       WinDismissDlg(hWnd, TRUE);
	       break;
		       /* Cancel selected, exit	the dialogue without	*/
		       /* changing anything				*/

	   case	DID_CANCEL :
	       WinDismissDlg(hWnd, FALSE);
	       break;
	   }
       break;
		       /* Close	received, exit dialog			*/
   case	WM_CLOSE :
       WinDismissDlg(hWnd, FALSE);
       break;
		       /* Pass through unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);

}
