#################################################################################
#                                                                               #
# Makefile for OS/2 MMPM/2 TICTAC Application                                   #
#                                                                               #
#   Generates one executable:                                         #
#   TICTAC.EXE                                                                  #
#                                                                               #
# Copyright (c) IBM Corporation  1993                                           #
#################################################################################
.SUFFIXES: .com .sys .exe .obj .mbj .def .lrf .rc .ref \
           .lst .sym .map .c .h .lib .msg .ipf .res

NAMEEXE=TICTAC
NAMEDLL=MDM
#################################
# Target Descriptions
#################################
all: TICTAC.exe

reses: TICTAC.res
###########################################################
# Definitions for C Compiler
# Compiler flags:
#    /C+  Compile only
#    /Gd- Static link run time library
#    /Ge- Build a .DLL file
#    /Gm+ Link with multi-threaded version of library
#    /Gs- Remove stack probes
#    /Re  Generate code for C Set/2 run-time environment
#    /J-  Set unspecified char variables to signed char
#    /Kb- Suppress basic diagnostics messages
#    /Ki- Suppress messages about uninitialized variables
#    /Ms  Use SYSTEM linkage for functions
#    /Sm  Allow migration extensions
#    /Sn  Do not allow DBCS
#    /Ss+ Allow double slash format for comments
#    /D   preprocessor macro name INCL_32
###########################################################

CC=icc
###########################################################################
# Definitions for linker
# LIBS:
#    DDE4MBS.LIB - C Set/2 Multi-threaded Standard Library function calls
#    OS2386.LIB  - OS.2 function calls
#    MMPM2.LIB   - MMPM2 function calls
###########################################################################
!ifdef DEBUG
LINK_DEBUG=/CO /DEBUG
C_DEBUG= /Ti+ /O- /Gh
!endif
LINK= link386
MAP = mapsym
CFLAGS = $(C_DEBUG) /Ss /Ms /Ge+ /Re /Q /G3 /C /Gm+ /Gs-
DLLCFLAGS = $(C_DEBUG) /Ss /Ms /Ge- /Re /Q /G3 /C /Gm+  /DINCL_32 /DINCL_OS2MM
LFLAGS= $(LINK_DEBUG) /nod /noi /map /noe   /PM:PM /packcode /packdata /exepack /align:4
LIBS= DDE4MBS.LIB OS2386.lib

#################################
# Object file lists
#################################

OBJS=tictac.obj

#################################
# Inference Rules
#################################
.ipf.hlp:
    $(IPFC) $*.ipf > $*.err

.c.obj:
    $(CC) $(CFLAGS) $*.C

res: $(O)\$(NAMEEXE).res

###############################
# Resource File
###############################

$(NAMEEXE).res: $(NAMEEXE).rc $(NAMEEXE).dlg $(NAMEEXE).h
   rc -r TICTAC.rc


$(NAMEEXE).HLP: $(NAMEEXE).ipf $(NAMEEXE).h
   ipfc tictac.ipf

##################################
# tictac.exe Target Descriptions
##################################
exe: $(NAMEEXE).exe $(NAMEEXE).h

$(NAMEEXE).exe: $(OBJS) tictac.res tictac.mak  $(NAMEEXE).def
 $(LINK) $(LFLAGS) $(OBJS), $(NAMEEXE).exe, $(NAMEEXE), $(LIBS), $(NAMEEXE).DEF
 rc  tictac.res  tictac.exe
 $(MAP) $(NAMEEXE).map

$(NAMEEXE).def: tictac.mak
        @echo Make $(NAMEEXE).DEF file
        @echo NAME TICTAC WINDOWAPI                        >  $(NAMEEXE).def
        @echo DESCRIPTION 'Tic-Tac-Toe V1.0' >> $(NAMEEXE).def
        @echo STACKSIZE 65536                              >> $(NAMEEXE).def
        @echo PROTMODE                                     >> $(NAMEEXE).def
        @echo IMPORTS                                       >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetInitialize              >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetPackSend                >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetPackRecv                >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetConSend                >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetConRecv                >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetEstablishConnection    >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetQueryNetInfo           >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetOpen                   >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetClose                  >> $(NAMEEXE).def
        @echo        WARPNET.WarpNetBroadcast              >> $(NAMEEXE).def


