/*********************** START OF SPECIFICATIONS *******************************
*
* SOURCE FILE NAME: TICTAC.H
*
* DESCRIPTIVE NAME: TICTAC Dialog Definitions
*
*
* FUNCTION: Component Global Data Structures, and Constant definitions
*
*
* MODIFICATION HISTORY:
*
* DATE      DEVELOPER         CHANGE DESCRIPTION
*********************** END OF SPECIFICATIONS ********************************/
/* TICTAC Internal function prototypes  */

#define  TCP_REGISTER          1
#define  TCP_QUERYPLAYERS      2
#define  TCP_PLAYERMOVE        3
#define  TCP_BEGINPLAY         4

typedef struct _register
  {
    USHORT  usMsg;
    USHORT  usRowPos;
    USHORT  usIndex;
  }REGSTRUCT;

typedef struct _gameCords
  {
    BOOL    fIndexTaken[9];
    POINTL  RoomCords[9];
    BOOL    fOppMoves[9];
    BOOL    fMyMoves[9];
    USHORT  usNumTicks;
  }GAMESTRUCT;

typedef struct _move
  {
    USHORT  usMsg;
    USHORT  usIndex;
  }GAMEMOVE;

VOID  ConnectServer ();                      /* Connect to Server          */
VOID _Optlink SendToServer (PVOID ptemp);
VOID _Optlink RecvFromServer (PVOID ptemp);
FNWP GameWinProc;                            /* Main Window Procedure      */
LONG mprintf(PSZ format, ...) ;              /* Message Box Print Routine  */
MRESULT EXPENTRY MyDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 );

#define WND_FRM                 2000
#define MSG_BOX_ID              2001

#define IDM_OPTIONS             306                    /* Using Help      */
#define IDM_EXIT                307                    /* Help Index      */
#define IDM_START               308                    /* begin game      */
#define PB_OK                   506                    /* OK Button       */

#define ID_DIALOG             100            /* Connect dialog ID          */
#define ID_ENTRY              101            /* IP address entry field     */
#define ID_LOCAL              102            /* Local connection button    */
#define ID_REMOTE             103            /* Remote connection button   */
#define ID_OK                 104            /* OK button id               */
#define ID_START              105            /* Start a new game           */
