/*********************** START OF SPECIFICATIONS **************************
*
* SOURCE FILE NAME: TICTAC.C
*
* DESCRIPTIVE NAME: MultiUser TICTAC Game Client.
*
*              Copyright (c) IBM Corporation   1993
*                        All Rights Reserved
*
*
*********************** END OF SPECIFICATIONS *****************************/

#define INCL_DOS                       /* DosCall Definitions include     */
#define INCL_PM                        /* Presentation Manager include    */
#define INCL_WIN                       /* OS/2 2.x Win  include           */
#define INCL_GPI                       /* OS/2 2.x Win  include           */
#include <os2.h>                       /* OS/2 2.x System include         */
#include <stdio.h>                     /* C Standard library include      */
#include <stdlib.h>                    /* C Standard library include      */
#include <string.h>                    /* C String Functions include      */
#include <stdarg.h>                    /* C Standard Arguments include    */
#include <warpnet.h>                   /* ENTTOOLKIT Header               */
#include "tictac.h"                    /* Component private include       */


CHAR            szMainWin[]="MainWin";   /* Main window class title  */
CHAR            szTitle[]="Tic-Tac-Toe"; /* Application title        */
USHORT          cxChar,cyChar;           /* Character dimensions     */
HWND            hwnd1,hwndc1;            /* Client Window Handles    */
HAB             hab;                     /* Anchor Block Handle      */
HMQ             hmq;                     /* Message Queue Handle     */
QMSG            qmsg;                    /* Q Msg Structure          */
CHAR            buf[1032];               /* data buffer              */
REGSTRUCT       *pRegStr;                /* Data Packet              */
GAMESTRUCT      GameStr;                 /* Data Packet              */
GAMEMOVE        *Gamemove;               /* Data Packet              */
POINTL          Origin;                  /* Origin of the Board      */
USHORT          usDeltaX;                /* X increment              */
USHORT          usDeltaY;                /* Y increment              */
USHORT          usGridX;                 /* Grid X co-ordinate       */
USHORT          usGridY;                 /* Grid Y Co-ordinate       */
USHORT          usMinIndex;              /* Player Move index Range  */
USHORT          usMaxIndex;              /* Player Move index Range  */
USHORT          usIndex;                 /* Player Move index        */
USHORT          usPlayerNum;             /* Player Number            */
HEV             SendEvtSem;              /* Send Semaphore           */
USHORT          cxClient;                /* Client Window X          */
USHORT          cyClient;                /* Client Window Y          */
BOOL            fBegPlay = FALSE;        /* Start Game Flag          */
BOOL            fPlayer1Move = FALSE;    /* My Move Flag             */
BOOL            fGameOver = FALSE;       /* Game is Alive            */

/****************************START OF SPECIFICATIONS *************************
*
* FUNCTION:    main
*
* ARGUMENTS:  argc, argv, envp.
*
* RETURN:     None.
*
* DESCRIPTION: TICTAC Application Main
*
* OS/2 API's USED:
*
*****************************END OF SPECIFICATIONS ***************************/
INT main(LONG argc,PSZ argv[])
{
   static ULONG flCreate;      /* Window Creation Flags        */
   APIRET rc;                  /* Return Code                  */

   /* initialize global variables */


   /* Intialize PM */
   hab = WinInitialize((USHORT) NULL);

   /* Create default size message queue */
   hmq = WinCreateMsgQueue(hab,0);

   WinRegisterClass(hab,szMainWin,
                     (PFNWP) GameWinProc,CS_SIZEREDRAW|CS_CLIPCHILDREN |
                     CS_MOVENOTIFY | CS_PARENTCLIP,
                     0 );
   /* Set main window creation flags */

   flCreate = FCF_SIZEBORDER |  FCF_MINMAX | FCF_MENU |FCF_ICON |
              FCF_SYSMENU | FCF_TITLEBAR | FCF_TASKLIST ;

   /* Create the main window */

   hwnd1 = WinCreateStdWindow( HWND_DESKTOP, WS_VISIBLE, &flCreate,
                                szMainWin, szTitle, 0L, NULLHANDLE,
                                WND_FRM, (PHWND) &hwndc1);

   WinSetWindowPos(hwnd1,
                    HWND_TOP,
                    100, 100, 300, 240,
                    SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW );

   if (!hwnd1)
    {
       mprintf ("Main Window Creation Error");
       DosExit (0,0);
    }

    /* Initialize the System with WarpNet
     */
    if (WarpNetInitialize ())
    {
       mprintf ("Error Initializing with WarpNet\n");
       DosExit (0,0);
    }

    /* Display dialog to get the host name address.
     */
    WinPostMsg ( hwnd1, WM_COMMAND,
                 (PVOID)ID_START, 0 );


   _beginthread(SendToServer,
               (PVOID)NULL,
               (ULONG)16000,
               (PVOID)Gamemove);

   _beginthread(RecvFromServer,
               (PVOID)NULL,
               (ULONG)16000,
               (PVOID)NULL);

    /* Message Loop */
    while ( WinGetMsg(hab,(PQMSG) &qmsg,(HWND) NULL,0,0))
       WinDispatchMsg(hab,(PQMSG) &qmsg );


    WarpNetClose();
    /* Destroy the message queue */
    WinDestroyMsgQueue(hmq );

    /* Terminate and release resources */
    WinTerminate( hab );

    return(0);
}  /* of main */


/****************************START OF SPECIFICATIONS *************************
*
* FUNCTION: GameWinProc()
*
* ARGUMENTS: Standard OS/2 PM Win Proc arguments
*
* RETURN:
*
* DESCRIPTION: This is the main window that interfaces with the user.
* it routes user choices to various internal routines to perform
*
* NOTES:
*
* SIDE EFFECTS:
*
*****************************END OF SPECIFICATIONS ***************************/
MRESULT EXPENTRY GameWinProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   RECTL           rectl,rectl1;      /* Client rectangles       */
   int             i;                 /* loop index              */
   POINTL          pt;                /* GPI static text x,y     */
   POINTL          pt2;               /* GPI static text x,y     */
   POINTL          ptl;               /* GPI static text x,y     */
   static HPS      hps;               /* Presentation Space      */
   HDC             hdc;               /* Device Context handle   */
   char            buffer[24];        /* MLE buffer              */
   USHORT          usIndex = 0;       /* Player Move index       */
   MARKERBUNDLE    mbndle;            /* Marker Bundle           */
   CHARBUNDLE      cbndle;            /* Marker Bundle           */
   ULONG           ulPostCount;       /* Semaphore Count         */
   SIZEF           sizefx;            /* Marker Box Dimensions   */
   SIZEL           sizl = { 0L, 0L }; /* PS Dimensions           */
   FATTRS          fattrs;            /* Vector Font Attributes  */
   ULONG           min;               /* Symbol Set Size         */
   LONG            cFonts, lTemp = 0L;/* Mouse Position approx   */
   PFONTMETRICS    pfm;               /* Font Metrics            */
   LONG            lcid = 1L;         /* Font ID                 */
   CHAR            fontName[25];      /* FontName Buffer         */
   USHORT          codePage;          /* CodePage                */

   switch( msg )
     {
     case WM_CONTROL:
       break;

     case WM_COMMAND:
       switch ( SHORT1FROMMP( mp1 ) )
         {
           case ID_START:
               WinDlgBox ( HWND_DESKTOP, hwndc1,
                           MyDlgProc, (HMODULE)0,
                           ID_DIALOG, 0 );
               break;

           case IDM_EXIT:
             WinPostMsg( hwnd, WM_CLOSE, 0L, 0L );
             break;

           case TCP_REGISTER:
              sprintf (buffer,"%s %d\n","Player:",usPlayerNum);
             if (usPlayerNum ==1)
              {
                 fPlayer1Move = TRUE;
                 sprintf (buffer,"%s %d %s\n","Player:",usPlayerNum,"Your Move First");
              }
             WinSetWindowText (hwnd1, (PSZ)buffer );
             break;

           case TCP_BEGINPLAY:
             fBegPlay = TRUE;
             WinQueryWindowRect ( hwnd, &rectl );
             WinInvalidateRect(hwnd, &rectl, FALSE);      /* Refresh Window */
             break;

           case TCP_PLAYERMOVE:
             if ((USHORT)mp2 >=9)
                break;
             GameStr.fIndexTaken[(USHORT)mp2] = TRUE;
             GameStr.fOppMoves[(USHORT)mp2] = TRUE;
             GameStr.usNumTicks++;

             /* Check to See if the Game is over */

             for (i = 0; i <=2; i++)
               {
                  if ((GameStr.fOppMoves[3*i] == GameStr.fOppMoves[3*i+1])&&
                      (GameStr.fOppMoves[3*i] == GameStr.fOppMoves[3*i+2])&&
                      (GameStr.fOppMoves[3*i] ==TRUE))
                      fGameOver = TRUE;
               }
             for (i = 0; i <=2; i++)
               {
                  if ((GameStr.fOppMoves[i] == GameStr.fOppMoves[i+3])&&
                      (GameStr.fOppMoves[i] == GameStr.fOppMoves[i+6])&&
                      (GameStr.fOppMoves[i] ==TRUE))
                      fGameOver = TRUE;
               }

             if ((GameStr.fOppMoves[0] == GameStr.fOppMoves[4])&&
                 (GameStr.fOppMoves[0] == GameStr.fOppMoves[8])&&
                 (GameStr.fOppMoves[0] ==TRUE))
                 fGameOver = TRUE;

             if ((GameStr.fOppMoves[2] == GameStr.fOppMoves[4])&&
                 (GameStr.fOppMoves[2] == GameStr.fOppMoves[6])&&
                 (GameStr.fOppMoves[2] ==TRUE))
                 fGameOver = TRUE;

             if (fGameOver)
              {
                 mprintf("Game Over.");
                 sprintf (buffer,"%s %d %s\n","Player:",usPlayerNum,"Game Over!");
                 WinSetWindowText (hwnd1, (PSZ)buffer );
                 GpiMarker (hps,&GameStr.RoomCords[(USHORT)mp2]);
                 WinQueryWindowRect ( hwnd, &rectl );
                 WinInvalidateRect(hwnd, &rectl, FALSE);      /* Refresh Window */
                 break;
              }

             if (GameStr.usNumTicks ==9)
                sprintf (buffer,"%s %d %s\n","Player:",usPlayerNum,"Game Over!");
             else
                sprintf (buffer,"%s %d %s\n","Player:",usPlayerNum, "Your Move");

             GpiMarker (hps,&GameStr.RoomCords[(USHORT)mp2]);
             fPlayer1Move = TRUE;
             WinSetWindowText (hwnd1, (PSZ)buffer );
             WinQueryWindowRect ( hwnd, &rectl );
             WinInvalidateRect(hwnd, &rectl, FALSE);      /* Refresh Window */
             break;


         } /* WM_COMMAND */
        break;

     case WM_BUTTON1CLICK:
       ptl.x = SHORT1FROMMP(mp1);
       ptl.y = SHORT2FROMMP(mp1);

       /* If it is not my turn ignore the move */
       if (!fPlayer1Move)
          break;

       /* If Game is Over ignore the move */
       if (fGameOver)
          break;

       /* Check to See if the mouse is on the board */
       if ((ptl.x >= Origin.x ) && (ptl.x <= Origin.x + usGridX) &&
           (ptl.y <= Origin.y ) && (ptl.y >= Origin.y - usGridY))
          {
            /* Map the Row first */
            if ((ptl.y >= (Origin.y - usDeltaY)))
             {
                usMinIndex = 0;
                usMaxIndex = 2;
             }
            else
              if ((ptl.y >= (Origin.y - 2 * usDeltaY)) &&
                  (ptl.y <= (Origin.y -usDeltaY)))
               {
                  usMinIndex = 3;
                  usMaxIndex = 5;
                }
                else
                  {
                     usMinIndex = 6;
                     usMaxIndex = 8;
                  }
            /* Map the Col next */
            if ((ptl.x >= Origin.x) && (ptl.x <= Origin.x + usDeltaX))
                usIndex = usMinIndex;
            else
               if ((ptl.x >= Origin.x +usDeltaX ) && (ptl.x <= Origin.x + 2*usDeltaX))
                  usIndex = usMinIndex +1;
               else
                 usIndex = usMaxIndex;
            if (GameStr.usNumTicks >=9)
               mprintf ("Game Over Dude(ette)");
            if (!GameStr.fIndexTaken[usIndex])
             {
               GameStr.fIndexTaken[usIndex] = TRUE;
               GameStr.fMyMoves[usIndex] = TRUE;
               GameStr.usNumTicks++;
               for (i = 0; i <=2; i++)
                 {
                    if ((GameStr.fMyMoves[3*i] == GameStr.fMyMoves[3*i+1])&&
                        (GameStr.fMyMoves[3*i] == GameStr.fMyMoves[3*i+2])&&
                        (GameStr.fMyMoves[3*i] ==TRUE))
                        fGameOver = TRUE;
                 }
               for (i = 1; i <=3; i++)
                 {
                    if ((GameStr.fMyMoves[i] == GameStr.fMyMoves[i+3])&&
                        (GameStr.fMyMoves[i] == GameStr.fMyMoves[i+6])&&
                        (GameStr.fMyMoves[i] ==TRUE))
                        fGameOver = TRUE;
                 }

               if ((GameStr.fMyMoves[0] == GameStr.fMyMoves[4])&&
                   (GameStr.fMyMoves[0] == GameStr.fMyMoves[8])&&
                   (GameStr.fMyMoves[0] ==TRUE))
                   fGameOver = TRUE;

               if ((GameStr.fMyMoves[2] == GameStr.fMyMoves[4])&&
                   (GameStr.fMyMoves[2] == GameStr.fMyMoves[6])&&
                   (GameStr.fMyMoves[2] ==TRUE))
                   fGameOver = TRUE;
               Gamemove->usMsg = TCP_PLAYERMOVE;
               Gamemove->usIndex = usIndex;
               GpiMarker (hps,&GameStr.RoomCords[usIndex]);
               DosResetEventSem (SendEvtSem, &ulPostCount);
               DosPostEventSem (SendEvtSem);
               fPlayer1Move = FALSE;
               if ((GameStr.usNumTicks ==9) ||fGameOver)
                  sprintf (buffer,"%s %d %s\n","Player:",usPlayerNum,"Game Over!");
               else
                  sprintf (buffer,"%s %d %s\n","Player:",usPlayerNum,"Waiting.......");
               WinSetWindowText (hwnd1, (PSZ)buffer );
               WinQueryWindowRect ( hwnd, &rectl );
               WinInvalidateRect(hwnd, &rectl, FALSE);      /* Refresh Window */

             }
          } /* Mouse Co-ordinates on the Grid */
       break;


     case WM_CLOSE:
       /******************************************************************/
       /* This is the place to put your termination routines             */
       /******************************************************************/
       WinPostMsg( hwnd, WM_QUIT, 0L, 0L );  /* Cause termination        */
       break;

     case WM_CREATE:
         memset (&GameStr,0,sizeof(GAMESTRUCT));
         WinQueryWindowRect (hwnd, &rectl);
         hdc = WinOpenWindowDC(hwnd);
         hps = GpiCreatePS( hab, hdc, &sizl,
                            PU_PELS | GPIF_DEFAULT |
                            GPIT_MICRO | GPIA_ASSOC );
         DosCreateEventSem(NULL,&SendEvtSem,DC_SEM_SHARED,FALSE);
         if ( DosAllocMem ( (PPVOID)&Gamemove, sizeof(GAMEMOVE),
                             (ULONG) PAG_COMMIT | PAG_READ | PAG_WRITE) )
            {
              mprintf ("Error DosAllocMem");
              DosExit (0,0);
            }

        break;

     case WM_SIZE:
       cxClient = SHORT1FROMMP( mp2 );       /* Get new client window size     */
       cyClient = SHORT2FROMMP( mp2 );
       WinQueryWindowRect ( hwnd, &rectl1 );
       usDeltaX = cxClient/4;
       usDeltaY = cyClient/4;
       usGridX  = 3*usDeltaX;
       usGridY  = 3*usDeltaY;

       /* Fix the Grid Origin  */
       Origin.x =  rectl1.xLeft +20;
       Origin.y =  rectl1.yTop - 30;

       GameStr.RoomCords[0].x = Origin.x + usDeltaX / 2;
       GameStr.RoomCords[0].y = Origin.y - usDeltaY / 2;

       GameStr.RoomCords[1].x = Origin.x + usDeltaX + usDeltaX /2 ;
       GameStr.RoomCords[1].y = Origin.y - usDeltaY / 2;

       GameStr.RoomCords[2].x = Origin.x + 2 * usDeltaX + usDeltaX /2 ;
       GameStr.RoomCords[2].y = Origin.y - usDeltaY / 2;

       GameStr.RoomCords[3].x = Origin.x + usDeltaX / 2;
       GameStr.RoomCords[3].y = Origin.y - usDeltaY - usDeltaY / 2;

       GameStr.RoomCords[4].x = Origin.x + usDeltaX + usDeltaX /2 ;
       GameStr.RoomCords[4].y = Origin.y - usDeltaY - usDeltaY / 2;

       GameStr.RoomCords[5].x = Origin.x + 2 * usDeltaX + usDeltaX /2 ;
       GameStr.RoomCords[5].y = Origin.y - usDeltaY - usDeltaY / 2;

       GameStr.RoomCords[6].x = Origin.x + usDeltaX / 2;
       GameStr.RoomCords[6].y = Origin.y - 2 * usDeltaY - usDeltaY / 2;

       GameStr.RoomCords[7].x = Origin.x + usDeltaX + usDeltaX /2 ;
       GameStr.RoomCords[7].y = Origin.y - 2 * usDeltaY - usDeltaY / 2;

       GameStr.RoomCords[8].x = Origin.x + 2 * usDeltaX + usDeltaX /2 ;
       GameStr.RoomCords[8].y = Origin.y - 2 * usDeltaY - usDeltaY / 2;
        break;

     case WM_PAINT:
       hps = WinBeginPaint( hwnd, (HPS) NULL, (PRECTL) &rectl );
       WinFillRect( hps, (PRECTL) &rectl, CLR_WHITE);
       if (fBegPlay)
        {
           WinQueryWindowRect (hwnd, &rectl1);
           strcpy(fontName,"Helvetica Bold");
           codePage = 850;
           cFonts = GpiQueryFonts(hps, QF_PUBLIC, fontName, &lTemp,
               (LONG) sizeof(FONTMETRICS), (PFONTMETRICS)NULL);
           if(cFonts > 0L)
           {
              pfm = malloc(sizeof(FONTMETRICS) * cFonts);
              GpiQueryFonts(hps, QF_PUBLIC, fontName, &cFonts,
                            (LONG) sizeof(FONTMETRICS), pfm);
              fattrs.lMatch          = pfm[0].lMatch;
              strcpy(fattrs.szFacename, pfm[0].szFacename);
           }
           else
           {
              fattrs.lMatch = 0L;
              strcpy(fattrs.szFacename, "");
           }

           fattrs.usRecordLength  = sizeof(FATTRS);
           fattrs.fsSelection     = FATTR_SEL_OUTLINE;
           fattrs.idRegistry      = 0;
           fattrs.usCodePage      = codePage;
           fattrs.lMaxBaselineExt = 0L;
           fattrs.lAveCharWidth   = 0L;
           fattrs.fsType          = 0;
           fattrs.fsFontUse       = FATTR_FONTUSE_OUTLINE;

           GpiCreateLogFont(hps, (PSTR8)NULL, lcid, &fattrs);
           GpiSetCharSet(hps, lcid);

           min = (cxClient<cyClient) ? cxClient : cyClient;
           min /= 4;
           sizefx.cx = MAKEFIXED(min, 0);
           sizefx.cy = MAKEFIXED(min, 0);
           GpiSetMarkerBox (hps,&sizefx);
           memset (&mbndle,0,sizeof(MARKERBUNDLE));
           memset (&cbndle,0,sizeof(CHARBUNDLE));
           /* Set Marker Color  */
           cbndle.lBackColor = CLR_BLUE;
           cbndle.lColor = CLR_BLUE;
           mbndle.lColor = CLR_RED;
           mbndle.usSet = lcid;
           if (usPlayerNum ==2)
              mbndle.usSymbol = 'O';
            else
              mbndle.usSymbol = 'X';
           GpiSetAttrs (hps,PRIM_MARKER,MBB_SYMBOL|MBB_SET|MBB_COLOR,0L,&mbndle);
           GpiSetAttrs (hps,PRIM_CHAR,CBB_COLOR|CBB_BACK_COLOR,0L,&cbndle);
           /* Fix the Grid Origin  */
           pt.x = pt2.x = rectl1.xLeft +20;
           pt.y = pt2.y = rectl1.yTop - 30;

           /* Set color of the text */
           GpiSetColor( hps, CLR_BLUE );

           /* Set line Type  */
           GpiSetLineType( hps, LINETYPE_SOLID);

           GpiMove (hps,&pt);
           pt2.x += usGridX;
           for (i = 0; i <=3; i++)
             {
                GpiLine (hps,&pt2);
                pt.y-=usDeltaY;
                GpiMove (hps,&pt);
                pt2.y -=usDeltaY;
             }
           pt.x = pt2.x = rectl1.xLeft +20;
           pt.y = pt2.y = rectl1.yTop - 30;
           GpiMove (hps,&pt);
           pt2.y-= usGridY;
           for (i = 0; i <=3; i++)
             {
                GpiLine (hps,&pt2);
                pt.x+=usDeltaX;
                GpiMove (hps,&pt);
                pt2.x +=usDeltaX;
             }
           for (i = 0; i <=8; i++)
             {
                if (GameStr.fIndexTaken[i])
                 {
                    memset (&mbndle,0,sizeof(MARKERBUNDLE));
                    /* Set Marker Color  */
                    mbndle.lColor = CLR_RED;
                    mbndle.usSet = lcid;
                    if (usPlayerNum ==2)
                     {
                       if (GameStr.fOppMoves[i])
                           mbndle.usSymbol = 'X';
                       else
                           mbndle.usSymbol = 'O';
                     }
                     else
                      {
                       if (GameStr.fOppMoves[i])
                           mbndle.usSymbol = 'O';
                       else
                           mbndle.usSymbol = 'X';
                      }
                    GpiSetAttrs (hps,PRIM_MARKER,MBB_SYMBOL|MBB_SET|MBB_COLOR,0L,&mbndle);
                    GpiMarker (hps,&GameStr.RoomCords[i]);
                 }
             }

        free (pfm);
        }/* TCP_BEGINPLAY received */
       WinEndPaint( hps );
        break;

     default:
        return(WinDefWindowProc(hwnd,msg,mp1,mp2));
     }
  return(FALSE);
}

/****************************START OF SPECIFICATIONS *************************
*
* FUNCTION:    mprintf
*
* ARGUMENTS:   Error Message String.
*
* RETURN:      None.
*
* DESCRIPTION: Write to Log File for command logging.
*
* OS/2 API's USED:   WinAlarm()
*                    WinMessageBox().
*
* C FUNCTION CALLS:  malloc()
*                     va_start();
*
*
* INTERNAL FUNCTION REFERENCES: None.
*
*****************************END OF SPECIFICATIONS ***************************/

LONG mprintf(PSZ format, ...)
{
   va_list  pArg;
   CHAR     buffer[513];
   LONG     lCount;

   WinAlarm( HWND_DESKTOP, WA_ERROR );

   va_start(pArg, format);

   lCount = vsprintf(buffer, format, pArg);

   WinMessageBox( HWND_DESKTOP,       /* parent window handle    */
                  HWND_DESKTOP,       /* owner window handle     */
                  buffer,             /* pointer to message text */
                  "TIC-TAC-TOE",      /* pointer to title text   */
                  MSG_BOX_ID,         /* message box identifier  */
                  MB_OK | MB_ERROR ); /* message box style       */

   return lCount;
}   /*  end of mprintf()  */

VOID _Optlink SendToServer (PVOID ptemp)
{
    GAMEMOVE         *pmove;         // Game Specific Move Data struct.
    ULONG            ulPostCount;    // Semaphore post count
    ToAddress        GameServer;     // Packet Destination
    WarpNetPacket    *packet;        // WarpNet Packet

    pmove = (GAMEMOVE *)ptemp;
    // Set the Destination Address
    memset (&GameServer,0,sizeof(GameServer));
    GameServer.fDotted = FALSE;
    GameServer.fUsePlayerID = TRUE;

    // This thread loops around blocked on an event semaphore waiting
    // to transmit packets to the remote host. When the local player
    // makes a move, this thread is woken up by the semaphore post
    // The thread then transmits the data.

    while (1)
      {
       DosWaitEventSem (SendEvtSem, SEM_INDEFINITE_WAIT);
       DosResetEventSem (SendEvtSem, &ulPostCount);
       packet = (WarpNetPacket *)buf;
       packet->Message = TCP_PLAYERMOVE;
       packet->DataWord1 = pmove->usIndex;
       packet->fHeaderOnly = TRUE;
       packet->srcPlayerId = usPlayerNum;
       if (usPlayerNum ==1)
       {
        GameServer.PlayerId = packet->tgtPlayerId = 2;
       }
       else
       {
        GameServer.PlayerId = packet->tgtPlayerId = 1;
       }
       // Send it across
       WarpNetPackSend (GameServer,packet);

      }/* While Recv Loop */
}


VOID _Optlink RecvFromServer (PVOID ptemp)
{
    HAB              habt;       // Anchor Block
    HMQ              hmqt;       // Message Queue
    WarpNetPacket    *packet;    // WarpNet Packet

    /* Intialize PM */
    habt = WinInitialize((USHORT) NULL);

    /* Create default size message queue */
    hmqt = WinCreateMsgQueue(habt,0);

    while (1)
      {
        WarpNetPackRecv (buf);

        packet = (WarpNetPacket *)buf;
        switch (packet->Message)
          {
            case WARPNET_REGISTERATION_COMPLETE:

               usPlayerNum = packet->srcPlayerId;
              /* Update Title bar Text to indicate player number */
              WinSendMsg (hwnd1,WM_COMMAND,
                          MPFROM2SHORT (TCP_REGISTER,0),(MPARAM)packet->srcPlayerId) ;

              if (usPlayerNum == 2)
               {
                 packet->Message = TCP_BEGINPLAY;
                 packet->DataSize = 0;
                 packet->pData = NULL;
                 packet->fHeaderOnly = TRUE;
                 WarpNetBroadcast (packet);
               }
              break;

            case TCP_QUERYPLAYERS:
              break;

            case TCP_BEGINPLAY:
              WinSendMsg (hwnd1,WM_COMMAND,
                          MPFROM2SHORT (TCP_BEGINPLAY,0),(MPARAM)0) ;
              break;

            case TCP_PLAYERMOVE:
              WinSendMsg (hwnd1,WM_COMMAND,
                          MPFROM2SHORT (TCP_PLAYERMOVE,0),(MPARAM)packet->DataWord1) ;
              break;
          } /* Server Messages Switch */
      }/* Asynchronous Recv Loop */
}



MRESULT EXPENTRY MyDlgProc ( HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   CHAR             szEntry[100];         /* Entry field text           */
   ToAddress        dest;                 /* Destination Address        */
   WarpNetPacket    Header;               /* WarpNet Packet             */

   switch( msg )
   {
   case WM_COMMAND:
      switch ( SHORT1FROMMP ( mp1 ) )
      {
      case ID_OK:

         /* Get text from entry field
          */
         memset( szEntry, 0, 100 );
         WinQueryWindowText( WinWindowFromID( hwndDlg, ID_ENTRY ),
                             sizeof( szEntry ),
                             szEntry );

         /* Set the Destination Address
          */
         memset (&dest,0,sizeof(dest));
         dest.fDotted = TRUE;
         strcpy (dest.Destination, szEntry);

         /* Open a Session with WarpNet.
          */
         WarpNetOpen (dest, &Header);

         /* Close the dialog box
          */
         WinDismissDlg ( hwndDlg, TRUE );
         break;

      } /* end WM_COMMAND switch */
      break;

   default:
      return ( WinDefDlgProc (hwndDlg, msg, mp1, mp2) );

   } /* end switch */

} /* end MyDlgProc */
