#**************************************************************************
#
# MAKE file for DAUDIO Sample Application
#
# Assumes that the environment is set up for development.  Specifically,
# the compiler, linker, rc and ipfc  should be in the path.  Also, the
# environment variables for the tools must be properly set, e.g. LIB,
# INCLUDE, IPFC. This should all be taken care of automatically by
# installing the OS/2 Toolkit and the MMPM/2 Toolkit.
#
#**************************************************************************

CC          = icc
LINK        = link386
RC          = rc

BASELIBS    = DDE4MBS.LIB OS2386.LIB MMPM2.LIB

DEBUG       = /Ti+ /O-
LDEBUG      = /de

#
# Compilation Switches
#
#     /G3s           : Generate 386 code with no stack checking.
#     /C+            : Compile only one module.
#     /W3            : Warning level.
#     /Gd-           : Link to static C libraries.
#     /Gm+           : Use multithreaded libraries.
#     /DINCL_32      : Use IBM code.
#     /Ti+           : Generate debugging code.
#     /Sm            : Generate debugging code.
#     /O-            : Turn optimization off.
#

COMPILE = /C+ /W3 /Ss+ /Gd- /Ms /Gm+ /DINCL_32

CFLAGS = $(COMPILE)

#
# Link Switches
#
#    /map     : Creates a listing file containing all pulbic symbols.
#    /nod     : Causes all default libraries to be ignored.
#    /noe     : The linker will not search the extended dictionary.
#    /de      : Generate debugging info
#

LFLAGS  = /map /nod /noe

all: daudio.exe

daudio.exe: daudio.obj daudio.def daudio.res
  $(LINK) daudio.obj, daudio.exe, $(LFLAGS) /ST:20000, $(BASELIBS), daudio.def
  $(RC) daudio.res

daudio.obj: daudio.c daudio.h
  $(CC) $(CFLAGS) daudio.c

daudio.res: daudio.rc daudio.h daudio.dlg
  $(RC) -r daudio.rc
