 /**************************************************************************
 *
 * File Name        : WARPNET.H
 *
 * Description      : WARPNET API Definitions.
 *
 *
 * Concepts         :
 *
 * Entry Points     : See Below
 *
 *
 * WarpNet API's       :
 *
 *                     WarpNetInitialize
 *                     WarpNetPackSend
 *                     WarpNetPackRecv
 *                     WarpNetConSend
 *                     WarpNetConRecv
 *                     WarpNetQueryNetInfo
 *                     WarpNetEstablishConnection
 *
 * Copyright        : COPYRIGHT IBM CORPORATION, 1991, 1995
 *
 *        DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
 *        sample code created by IBM Corporation. This sample code is not
 *        part of any standard or IBM product and is provided to you solely
 *        for  the purpose of assisting you in the development of your
 *        applications.  The code is provided "AS IS", without
 *        warranty of any kind.  IBM shall not be liable for any damages
 *        arising out of your use of the sample code, even if they have been
 *        advised of the possibility of such damages.
 *
 ****************************************************************************/

#define  GAME_PORT                                5022
#define  PACKET_SIZE                              512
#define  HEADER_SIZE                              60
#define  DATA_SIZE                                452
#define  MAX_CLIENTS                              10
#define  WARPNETERR_BASE                          5000
#define  WARPNETMSG_BASE                          4000
#define  WARPNET_REGISTER_PLAYER                  (WARPNETMSG_BASE + 1)
#define  WARPNET_REGISTERATION_COMPLETE           (WARPNETMSG_BASE + 2)
#define  WARPNET_DEREGISTER_PLAYER                (WARPNETMSG_BASE + 3)
#define  WARPNET_QUERY_NUMPLAYERS                 (WARPNETMSG_BASE + 4)
#define  WARPNET_QUERY_PROTOCOL                   (WARPNETMSG_BASE + 5)
#define  WARPNET_QUERY_PLAYERLIST                 (WARPNETMSG_BASE + 6)
#define  WARPNET_CURRENT_PLAYERLIST               (WARPNETMSG_BASE + 7)
#define  WARPNET_ERR_INVALID_BUFFER_SIZE          (WARPNETERR_BASE + 1)
#define  WARPNET_ERR_INVALID_DESTINATION          (WARPNETERR_BASE + 2)
#define  WARPNET_ERR_INVALID_BUFFER               (WARPNETERR_BASE + 3)
#define  WARPNET_ERR_MEMORY_EXHAUSTED             (WARPNETERR_BASE + 4)
#define  WARPNET_ERR_INVALID_SOURCEID              (WARPNETERR_BASE + 5)

typedef struct user_pack_header {
   ULONG  Message;                           // WarpNet Message
   ULONG  Node;                              // Packet Destination Node
   ULONG  Channel;                           // Packet Destination channel
   ULONG  srcPlayerId;                       // Packet source PlayerId
   ULONG  tgtPlayerId;                       // Packet destination PlayerID
   BOOL   fHeaderOnly;                       // Send Just The Header and no data
   ULONG  DataWord1;                         // Small Data  for application
   ULONG  DataWord2;                         // Small Data  for application
   ULONG  DataWord3;                         // Small Data  for application
   ULONG  DataWord4;                         // Small Data  for application
   ULONG  DataSize;                          // Packet Data Size
   CHAR   *pData;                            // Packet Data
   ULONG  PackSeq;                           // Fragmented Packet Sequence
   ULONG  chksum;                            // Fragmented Packet Checksum
   ULONG  TimeStamp;                         // Fragmented Packet TimeStamp
   ULONG  PackMarker;                        // Fragmentation/ Assembly Aide
   ULONG  Reserved;                          // For System use
}WarpNetPacket;

typedef struct _WarpNetDest {
   BOOL   fDotted;                           // Dotted decimal address
   CHAR   Destination[255];                  // Destination address
   BOOL   fUsePlayerID;                      // use PlayerID  flag
   ULONG  PlayerId;                          // Use the player Id
}ToAddress;

APIRET APIENTRY WarpNetInitialize ( VOID);

APIRET APIENTRY WarpNetOpen (ToAddress Server,  WarpNetPacket *ppacket);

APIRET APIENTRY WarpNetClose (VOID);

APIRET APIENTRY WarpNetPackRecv (char *bufp) ;

APIRET APIENTRY WarpNetQueryNetInfo (CHAR *bufp, ULONG Msg);

APIRET EXPENTRY WarpNetPackSend (ToAddress Dest , WarpNetPacket *ppacket);

APIRET EXPENTRY WarpNetBroadcast (WarpNetPacket *ppacket);
