/****************************** Module Header ******************************\
*
* Module Name: PMDJP.H
*
* OS/2 Presentation Manager Dynamic Job Properties
*
* Copyright (c) International Business Machines Corporation 1981, 1988-1992
*
* ===========================================================================
*
* The following symbols are used in this file for conditional sections.
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
\***************************************************************************/
/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
   #ifndef __CHKHDR__
      #pragma info( none )
   #endif
   #pragma info( restore )
#endif
#ifdef __cplusplus
      extern "C" {
#endif

#ifndef DJP_INCLUDED
   
   #define DJP_INCLUDED
   /* INC */
   
   /* -----------------------------------------------------------------
   ** Tuple Item used for QUERYSIZE
   */
   typedef struct _djpQueryTuple   /* dqt */
   {
      ULONG       ulProperty;     /* I - Property                      */
      LONG        iType;          /* I - type (DJP_ALL or DJP_CURRENT) */
      /*                                   */
   } QUERYTUPLE, *PQUERYTUPLE;
   
   /* -----------------------------------------------------------------
   ** Query Size Structure for DEVESC_QUERYSIZE
   */
   typedef struct _djpQuerySize   /* dqs */
   {
      ULONG       cb;             /* I - Size of entire structure      */
      ULONG       ulSizeNeeded;   /* O - Size returned;                */
      QUERYTUPLE  aTuples[1];     /* I - Start of tuple list           */
      /*     use DJP_NONE for end of list  */
   } QUERYSIZE, *PQUERYSIZE;
   
   #define QUERYSIZE_HEADER_SIZE  (sizeof (QUERYSIZE) - sizeof (((PQUERYSIZE)NULL)->aTuples))
   
   /* -----------------------------------------------------------------
   ** Dynamic Job Property Item
   */
   typedef struct _djpItem   /* di */
   {
      ULONG       cb;             /* I/O - sizeof DJP_ITEM structure   */
      ULONG       ulProperty;     /* I   - Which property              */
      LONG        iType;          /* I/O - DJP_ALL or DJP_CURRENT.     */
      /*       DJP_ERROR_XXX if error.     */
      ULONG       ulNumReturned;  /* O   - How many elements have been */
      /*       returned                    */
      ULONG       ulValue;        /* O   - Variably sized based on     */
      /*       ulProperty.  The smallest   */
      /*       is a ULONG in size          */
   } DJP_ITEM, *PDJP_ITEM;
   
   #define DJP_HEADER_SIZE        (sizeof (DJP_ITEM) - sizeof (((PDJP_ITEM)NULL)->ulValue))
   #define DJP_NEXT_STRUCTP(p)    ((PDJP_ITEM)((PBYTE)(p) + (p)->cb))
   #define DJP_ELEMENTP(s,t)      ((t*)&((s).ulValue))
   #define DJP_SET_ELEMENT(s,t,e) (*DJP_ELEMENTP (s,t) = (e))
   
   /* -----------------------------------------------------------------
   ** Types of Dynamic Job Properties
   **
   ** To see if the driver is enabled use,
   **     DevEscape      (DEVESC_QUERYESCSUPPORT,
   **                     DEVESC_STARTDOC_WPROP, ...)
   ** and DevQueryDevice (DEVQRY_QUERYSUPPORT,
   **                     DEVESC_QUERYJOBPROPERTIES, ...)
   **
   ** NOTE: the c/s in the defines indicate the complexity or size of
   **       the information.  If it is s, then the size is ULONG sized
   **       and no speical processing for the next element needs to be
   **       done.
   **
   */
   #define DJP_NONE                          0L     /* also End Of List marker */
   #define DJP_S_ORIENTATION                 1L
   #define DJP_C_RESOLUTION                  2L
   #define DJP_S_BITSPERPEL                  3L
   #define DJP_S_COLOR                       4L
   #define DJP_S_PRINTQUALITY                5L
   #define DJP_C_FORM                        6L
   #define DJP_S_PAPERSIZE                   7L
   #define DJP_C_TRAY                        8L
   #define DJP_S_TRAYTYPE                    9L
   #define DJP_S_MEDIA                      10L
   #define DJP_S_MEDIA_COLOR                11L
   #define DJP_S_FONTDOWNLOADING            12L
   #define DJP_S_DUPLEX                     13L
   #define DJP_S_COLLATE                    14L
   #define DJP_S_FEED                       15L
   #define DJP_S_PAPERSOURCE                16L
   #define DJP_S_COPIES                     17L
   #define DJP_S_SCALING                    18L
   #define DJP_S_FORMFEEDCONTROL            19L
   #define DJP_S_N_UP                       20L
   
   /* Types for DEVESC_QUERYJOBPROPERTIES / DEVESC_SETJOBPROPERTIES
   */
   #define DJP_ALL                           1L  /* enumerate the property */
   #define DJP_CURRENT                       2L  /* from job properties    */
   
   /* Errors for DEVESC_QUERYJOBPROPERTIES / DEVESC_SETJOBPROPERTIES
   */
   #define DJP_ERROR_NOT_SUPPORTED          -1L  /* driver doesnt support that property */
   #define DJP_ERROR_OUT_OF_RANGE           -2L  /* not in the valid range              */
   #define DJP_ERROR_NOT_ENUM               -3L  /* not enumerateable                   */
   #define DJP_ERROR_INV_PARMS              -4L  /* field not proper value              */
   
   /* -----------------------------------------------------------------
   ** DJP_S_ORIENTATION
   */
   #define DJP_ORI_PORTRAIT                  1L
   #define DJP_ORI_LANDSCAPE                 2L
   #define DJP_ORI_REV_PORTRAIT              3L
   #define DJP_ORI_REV_LANDSCAPE             4L
   
   typedef ULONG DJPT_ORIENTATION;
   typedef ULONG *PDJPT_ORIENTATION;
   
   /* -----------------------------------------------------------------
   ** DJP_C_RESOLUTION
   */
   typedef struct _djpResolution   /* dr */
   {
      USHORT     usXResolution;    /* X resolution (in dots per inch) */
      USHORT     usYResolution;    /* Y resolution (in dots per inch) */
   } DJPT_RESOLUTION, *PDJPT_RESOLUTION;
   
   /* -----------------------------------------------------------------
   ** DJP_S_BITSPERPEL
   */
   typedef ULONG DJPT_BITSPERPEL;
   typedef ULONG *PDJPT_BITSPERPEL;
   
   /* -----------------------------------------------------------------
   ** DJP_S_COLOR
   */
   #define DJP_CLR_MONOCHROME                1L
   #define DJP_CLR_COLOR                     2L
   
   typedef ULONG DJPT_COLOR;
   typedef ULONG *PDJPT_COLOR;
   
   /* -----------------------------------------------------------------
   ** DJP_S_PRINTQUALITY
   **
   ** Note: DJP_PQL_DRAFT is the worst quality.  In the future, there
   **       may be better qualities (such as DJP_PQL_ULTRA_HIGH) which
   **       will be numerically greater than DJP_PQL_HIGH.
   */
   #define DJP_PQL_DRAFT                     1L
   #define DJP_PQL_LOW                       2L
   #define DJP_PQL_MEDIUM                    3L
   #define DJP_PQL_HIGH                      4L
   
   typedef ULONG DJPT_PRINTQUALITY;
   typedef ULONG *PDJPT_PRINTQUALITY;
   
   /* -----------------------------------------------------------------
   ** DJP_S_PAPERSIZE
   */                                           /*  inches       millimeters */
   #define DJP_PSI_LETTER                    1L /*  8.5  x 11    216 x 279   */
   #define DJP_PSI_LEGAL                     2L /*  8.5  x 14    216 x 356   */
   #define DJP_PSI_WIDE                      3L /* 13.58 x 11    345 x 279   */
   #define DJP_PSI_CSHEET                    4L /* 17    x 22    431 x 558   */
   #define DJP_PSI_DSHEET                    5L /* 22    x 34    558 x 863   */
   #define DJP_PSI_ESHEET                    6L /* 34    x 44    863 x 1117  */
   #define DJP_PSI_LETTERSMALL               7L /*                           */
   #define DJP_PSI_TABLOID                   8L /* 11    x 17    279 x 431   */
   #define DJP_PSI_LEDGER                    9L /* 17    x 11    431 x 279   */
   #define DJP_PSI_STATEMENT                10L /*  5.5  x  8.5  139 x 216   */
   #define DJP_PSI_EXECUTIVE                11L /*  7.25 x 10.5  184 x 266   */
   #define DJP_PSI_A0                       12L /* 33.11 x 46.81 841 x 1189  */
   #define DJP_PSI_A1                       13L /* 23.39 x 33.11 594 x 841   */
   #define DJP_PSI_A2                       14L /* 16.54 x 23.39 420 x 594   */
   #define DJP_PSI_A3                       15L /* 11.7  x 16.54 297 x 420   */
   #define DJP_PSI_A4                       16L /*  8.3  x 11.7  210 x 297   */
   #define DJP_PSI_A5                       17L /*  5.83 x  8.27 148 x 210   */
   #define DJP_PSI_B4                       18L /*  9.84 x 13.94 250 x 354   */
   #define DJP_PSI_B5                       19L /*  7.17 x 10.12 182 x 257   */
   #define DJP_PSI_FOLIO                    20L /*  8.5  x 13    216 x 330   */
   #define DJP_PSI_QUATRO                   21L /*  8.46 x 10.83 215 x 275   */
   #define DJP_PSI_10X14                    22L /* 10    x 14    254 x 355   */
   #define DJP_PSI_11X17                    23L /* 11    x 17    279 x 431   */
   #define DJP_PSI_NOTE                     24L /*                           */
   #define DJP_PSI_ENV_9                    25L /*                           */
   #define DJP_PSI_ENV_10                   26L /*                           */
   #define DJP_PSI_ENV_11                   27L /*                           */
   #define DJP_PSI_ENV_12                   28L /*                           */
   #define DJP_PSI_ENV_14                   29L /*                           */
   #define DJP_PSI_ENV_DL                   30L /*                           */
   #define DJP_PSI_ENV_A2                   31L /*                           */
   #define DJP_PSI_ENV_C3                   32L /*                           */
   #define DJP_PSI_ENV_C4                   33L /*                           */
   #define DJP_PSI_ENV_C5                   34L /*                           */
   #define DJP_PSI_ENV_C6                   35L /*                           */
   #define DJP_PSI_ENV_C65                  36L /*                           */
   #define DJP_PSI_ENV_C9                   37L /*                           */
   #define DJP_PSI_ENV_C10                  38L /*                           */
   #define DJP_PSI_ENV_B4                   39L /*                           */
   #define DJP_PSI_ENV_B5                   40L /*                           */
   #define DJP_PSI_ENV_B6                   41L /*                           */
   #define DJP_PSI_ENV_ITALY                42L /*                           */
   #define DJP_PSI_ENV_MONARCH              43L /*                           */
   #define DJP_PSI_ENV_PERSONAL             44L /*                           */
   #define DJP_PSI_FANFOLD_US               45L /*                           */
   #define DJP_PSI_FANFOLD_STD_GERMAN       46L /*                           */
   #define DJP_PSI_FANFOLD_LGL_GERMAN       47L /*                           */
   #define DJP_PSI_ARCHITECT_BSHEET         48L /*                           */
   #define DJP_PSI_ARCHITECT_CSHEET         49L /*                           */
   #define DJP_PSI_ARCHITECT_DSHEET         50L /*                           */
   #define DJP_PSI_ARCHITECT_ESHEET         51L /*                           */
   #define DJP_PSI_CARD_A6                  52L /*                           */
   #define DJP_PSI_CARD_4X6                 53L /*                           */
   #define DJP_PSI_CARD_5X8                 54L /*                           */
   #define DJP_PSI_CARD_HAGAKI              55L /*                           */
   #define DJP_PSI_LABEL_STANDARD_WHITE     56L /*  1.10 x 3.50   28 x 89    */
   #define DJP_PSI_LABEL_STANDARD_CLEAR     57L /*  1.10 x 3.50   28 x 89    */
   #define DJP_PSI_LABEL_SHIPPING           58L /*  3.98 x 2.13  101 x 54    */
   #define DJP_PSI_LABEL_DISK               59L /*  2.76 x 2.13   70 x 54    */
   #define DJP_PSI_LABEL_EURO               60L /*  3.50 x 1.42   89 x 36    */
   
   typedef ULONG DJPT_PAPERSIZE;
   typedef ULONG *PDJPT_PAPERSIZE;
   
   /* -----------------------------------------------------------------
   ** DJP_C_FORM
   **
   ** Setting can be done two ways:
   **    if djppsFormID >  0 then use the form id
   **    if djppsFormID == 0 then use the szFormname + cx + cy
   **
   ** To create a new user defined form:
   **    if djppsFormID == -1 then create a new form with szFormname as its
   **                              name and cx & cy as its size
   */
   typedef struct _djpForm   /* df */
   {
      DJPT_PAPERSIZE  djppsFormID;           /* Simple form id               */
      /*          -= OR =-            */
      CHAR            szFormname[32];        /* System Form name             */
      LONG            cx;                    /* Form width (in millimeters)  */
      LONG            cy;                    /* Form height (in millimeters) */
      /*   -= Informational only =-   */
      CHAR            szDisplayFormname[64]; /* Display Form name(translated)*/
   }  DJPT_FORM, *PDJPT_FORM;
   
   /* -----------------------------------------------------------------
   ** DJP_S_TRAYTYPE
   */
   #define DJP_TRY_AUTO_SELECT               1L
   #define DJP_TRY_NONE                      2L
   #define DJP_TRY_TRAY                      3L
   #define DJP_TRY_UPPER_TRAY                4L
   #define DJP_TRY_MIDDLE                    5L
   #define DJP_TRY_LOWER_TRAY                6L
   #define DJP_TRY_MULTI_TRAY                7L
   #define DJP_TRY_CASSETTE                  8L
   #define DJP_TRY_UPPER_CASSETTE            9L
   #define DJP_TRY_LOWER_CASSETTE           10L
   #define DJP_TRY_MULTI_CASSETTE           11L
   #define DJP_TRY_MANUAL_FEEDER            12L
   #define DJP_TRY_MANUAL_ENV               13L
   #define DJP_TRY_PAPER_FEEDER             14L
   #define DJP_TRY_ENV_FEEDER               15L
   #define DJP_TRY_CSF                      16L
   #define DJP_TRY_FRONT_CONTINUOUS         17L
   #define DJP_TRY_REAR_CONTINUOUS          18L
   #define DJP_TRY_SINGLE_SHEET             19L
   #define DJP_TRY_SHEET_FEEDER             20L
   #define DJP_TRY_BIN_1                    21L
   #define DJP_TRY_BIN_2                    22L
   #define DJP_TRY_AUTO_FEEDER              23L
   #define DJP_TRY_AUTO_ENV_FEEDER          24L
   #define DJP_TRY_ALTERNATE                25L
   
   typedef ULONG DJPT_TRAYTYPE;
   typedef ULONG *PDJPT_TRAYTYPE;
   
   /* -----------------------------------------------------------------
   ** DJP_C_TRAY
   **
   ** Setting the tray has the side effect of setting the form.  Therefore,
   ** the currently selected form will be returned alongside the tray name.
   **
   */
   typedef struct _djpTray   /* dt */
   {
      CHAR            szTrayname[32];        /* Tray name                    */
      /*   -= Informational only =-   */
      DJPT_PAPERSIZE  djppsFormID;           /* Simple form id (if > 0)      */
      CHAR            szFormname[32];        /* System Form name             */
   }  DJPT_TRAY, *PDJPT_TRAY;
   
   /* -----------------------------------------------------------------
   ** DJP_S_MEDIA
   **
   ** Select the media type.
   */
   #define DJP_MED_PLAIN                     1L
   #define DJP_MED_TRANSPARENCY              2L
   #define DJP_MED_GLOSSY                    3L
   #define DJP_MED_SPECIAL                   4L
   #define DJP_MED_COATED                    5L
   #define DJP_MED_BACKPRINT                 6L
   #define DJP_MED_CLOTH                     7L
   #define DJP_MED_THICK                     8L
   #define DJP_MED_STATIONARY                9L
   #define DJP_MED_ENVELOPE                 10L
   #define DJP_MED_CONTINUOUS_LONG          11L
   #define DJP_MED_CONTINUOUS_SHORT         12L
   #define DJP_MED_TAB_STOCK                13L
   #define DJP_MED_MULTI_PART_FORM          14L
   #define DJP_MED_LABELS                   15L
   
   typedef ULONG DJPT_MEDIA;
   typedef ULONG *PDJPT_MEDIA;
   
   /* -----------------------------------------------------------------
   ** DJP_S_MEDIA_COLOR
   **
   ** Select the media color (from the same media types).
   */
   #define DJP_MDC_BLUE                      1L
   #define DJP_MDC_BLUFF                     2L
   #define DJP_MDC_GOLDENROD                 3L
   #define DJP_MDC_GREEN                     4L
   #define DJP_MDC_PINK                      5L
   #define DJP_MDC_TRANSPARENT               6L
   #define DJP_MDC_WHITE                     7L
   #define DJP_MDC_YELLOW                    8L
   
   typedef ULONG DJPT_MEDIA_COLOR;
   typedef ULONG *PDJPT_MEDIA_COLOR;
   
   /* -----------------------------------------------------------------
   ** DJP_S_FONTDOWNLOADING
   */
   #define DJP_FDL_DOWNLOAD                  1L /* Download fonts to printer          */
   #define DJP_FDL_BITMAP                    2L /* Rasterize fonts                    */
   #define DJP_FDL_SUBSTITUTE                3L /* Substitute device fonts for system */
   
   typedef ULONG DJPT_FONTDOWNLOADING;
   typedef ULONG *PDJPT_FONTDOWNLOADING;
   
   /* -----------------------------------------------------------------
   ** DJP_S_DUPLEX
   */
   #define DJP_DUP_NONE                      1L
   #define DJP_DUP_BOOK                      2L
   #define DJP_DUP_FLIP                      3L
   
   typedef ULONG DJPT_DUPLEX;
   typedef ULONG *PDJPT_DUPLEX;
   
   /* -----------------------------------------------------------------
   ** DJP_S_COLLATE
   */
   #define DJP_COL_OFF                       1L
   #define DJP_COL_ON                        2L
   
   typedef ULONG DJPT_COLLATE;
   typedef ULONG *PDJPT_COLLATE;
   
   /* -----------------------------------------------------------------
   ** DJP_S_FEED
   */
   #define DJP_FED_MANUAL                    1L
   #define DJP_FED_AUTOMATIC                 2L
   
   typedef ULONG DJPT_FEED;
   typedef ULONG *PDJPT_FEED;
   
   /* -----------------------------------------------------------------
   ** DJP_S_PAPERSOURCE
   */
   #define DJP_PSC_NONE                      1L
   
   typedef ULONG DJPT_PAPERSOURCE;
   typedef ULONG *PDJPT_PAPERSOURCE;
   
   /* -----------------------------------------------------------------
   ** DJP_S_COPIES
   **
   ** This is the number of copies on a per page basis.  This is not
   ** enumerateable.
   */
   typedef ULONG DJPT_COPIES;
   typedef ULONG *PDJPT_COPIES;
   
   /* -----------------------------------------------------------------
   ** DJP_S_SCALING
   **
   ** This is a percentage value.  This is not enumerateable.
   */
   typedef LONG DJPT_SCALING;
   typedef LONG *PDJPT_SCALING;
   
   /* -----------------------------------------------------------------
   ** DJP_S_FORMFEEDCONTROL
   **
   ** This is a property that effects raw data jobs (print from the
   ** command line, DOS print jobs, Windows print jobs). This checks
   ** the very last byte of the data stream to see if it is a form
   ** feed control character.
   */
   #define DJP_FFC_NONE                      1L    /* Never add        */
   #define DJP_FFC_CONDITIONAL               2L    /* Add if not seen  */
   #define DJP_FFC_COMPULSORY                3L    /* Always add       */
   
   typedef ULONG DJPT_FORMFEEDCONTROL;
   typedef ULONG *PDJPT_FORMFEEDCONTROL;
   
   /* -----------------------------------------------------------------
   ** DJP_S_N_UP
   **
   ** Number of logical pages per physical page (ex: 2-up, 4-up)
   */
   typedef LONG DJPT_NUP;
   typedef LONG *PDJPT_NUP;
   
   /* NOINC */
#endif

#ifdef __cplusplus
        }
#endif
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
   #ifndef __CHKHDR__
      #pragma info( restore )
   #endif
   #pragma info( restore )
#endif
/* INC */

/**************************** end of file **********************************/
