/* */
 
/*
 
    This is an example REXX program to install a DOS program. It will
    create a Work Place Shell program object, associate an icon, and
    set the DOS setting as appropriate. It also offers the chance
    to run a setup program as part of the installation.
 
    To use, change file names in the SysFileTree functions as appropriate,
    copy all files required to the desired directory, and run.
 
    This example could easily be used to install any type of program.
 
 
    OS/2 REXX must be installed and loaded prior to running this program.
 
    To install REXX:
      1. Open the "OS/2 System" folder.
      2. Open the "System Setup" icon.
      3. Open the "Selective Install" icon.
      4. Select OK on the OS/2 Installation panel.
      5. Select REXX from the list of installable features.
      6. Select INSTALL.
 
*/
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
 
say "*******************************************"
say " "
say "         Raptor installation."
say " "
say "*******************************************"
 
/*
        Params to creat object for the desktop
*/
classname = "WPProgram"
location = "<WP_DESKTOP>"
title = "Raptor"
 
/*
        Verify the correct program exists,
        parse current path,
        set up coreect default settings,
        and create object
*/
rc = SysFileTree("RAP.EXE", fspec, "FO")
if rc=0 then
do
        filename=filespec("Name", fspec.1)
        filepath=filespec("Path", fspec.1)
        filedrive=filespec("Drive", fspec.1)
 
        setup = "OBJECTID=<RAPTOR>;",
                !! "PROGTYPE=VDM;",
                !! "EXENAME="filedrive!!filepath!!filename";",
                !! "STARTUPDIR="filedrive!!filepath!!";",
                !! "ICONFILE="filedrive!!filepath!!"F19A.ICO;",
                !! "SET AUDIO_ADAPTER_SHARING=Required;",
                !! "SET DOS_BACKGROUND_EXECUTION=OFF;",
                !! "SET DOS_HIGH=OFF;",
                !! "SET DOS_UMB=OFF;",
                !! "SET DPMI_MEMORY_LIMIT=8;",
                !! "SET EMS_FRAME_LOCATION=NONE;",
                !! "SET EMS_LOW_OS_MAP_REGION=0;",
                !! "SET EMS_MEMORY_LIMIT=0;",
                !! "SET HW_TIMER=ON;",
                !! "SET IDLE_SENSITIVITY=100;",
                !! "SET INT_DURING_IO=ON;",
                !! "SET KBD_ALTHOME_BYPASS=ON;",
                !! "SET MOUSE_EXCLUSIVE_ACCESS=ON;",
                !! "SET VIDEO_8514A_XGA_IOTRAP=OFF;",
                !! "SET VIDEO_ONDEMAND_MEMORY=OFF;",
                !! "SET VIDEO_RETRACE_EMULATION=OFF;",
                !! "SET VIDEO_ROM_EMULATION=OFF;",
                !! "SET XMS_HANDLES=0;",
                !! "SET XMS_MEMORY_LIMIT=5120"
 
        rc = SysCreateObject(classname, title, location, setup)
        if rc then
        do
                say " "
                say " "
                say " "
                say "Raptor program object created."
                say " "
                say "-----"
                say " "
                say "If you want Raptor to be automatically started at boot"
                say "time, move the program object to the startup folder."
                say " "
                say "-----"
                say " "
                say " Raptor may not run in a DOS Window. Use Alt-Home to"
                say " switch the window to a full screen session to continue."
                say " "
 
                rc = SysFileTree("SETUP.EXE", fspec, "FO")
                if rc=0 then
                do
                        say "----"
                        say " "
                        say "Do you want to run the SETUP program now? (Y/n)"
                        pull answer .
                        if answer = 'Y' then
                             "SETUP"
                end
                say " "
                say " "
                say "*******************************************"
                say " "
                say "     Raptor Installation is complete"
                say " "
                say "*******************************************"
        end
        else
                say "ERROR: program object could not be created."
end
return
 
