/*-
 * Copyright (c) 1991, 1993, 1994
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)unistd.h    8.12 (Berkeley) 4/27/95
 */

#ifndef _UNISTD_H_
#define _UNISTD_H_

#ifdef TCPV40HDRS
#error error: unistd.h is for TCP/IP toolkit 5.0 or later releases only
#else
#include <sys/cdefs.h>
#include <sys/types.h>

__BEGIN_DECLS
int _System soclose __TCPPROTO((int));

#ifndef _POSIX_SOURCE
long _System gethostid __TCPPROTO((void));
int _System gethostname __TCPPROTO((char *, int));
int _System iruserok __TCPPROTO((unsigned long, int, const char *, const char *));
int _System rcmd __TCPPROTO((char **, int, const char *,
                      const char *, const char *, int *));
int _System rresvport __TCPPROTO((int *));
int _System ruserok __TCPPROTO((const char *, int, const char *, const char *));

int _System os2_select __TCPPROTO((int *, int, int, int, long));
int _System select __TCPPROTO((int, fd_set *, fd_set *, fd_set *, struct timeval *));

#endif /* !_POSIX_SOURCE */
__END_DECLS

#endif /* TCPV40HDRS */
#endif /* !_UNISTD_H_ */
