;--------------------------------------------------------------------           
;*                 NETBIOS NCB DATA DECLARATIONS                    *           
;--------------------------------------------------------------------           
                                                                                
NETWORK_CONTROL_BLOCK     STRUC                                                 
;                                                                               
 NCB_COMMAND               DB    ?        ; Netbios command code                
 NCB_RETCODE               DB    ?        ; Return code                         
 NCB_LSN                   DB    ?        ; Local session number                
 NCB_NUM                   DB    ?        ; Number of application name          
 NCB_BUFFER_ADDRESS        DD    ?        ; Address of message buffer           
 NCB_LENGTH                DW    ?        ; length of message buffer            
 NCB_CALLNAME              DB 16 DUP(?)   ; Destination name                    
 NCB_NAME                  DB 16 DUP(?)   ; Source name                         
 NCB_RTO                   DB    ?        ; Receive timeout                     
 NCB_STO                   DB    ?        ; Send timeout                        
 NCB_POST_ADDR_OFFSET      DW    ?        ; Offset of post routine              
 NCB_DD_ID                 DW    ?        ; Device driver ID                    
 NCB_LANA_NUM              DB    ?        ; Adapter number                      
 NCB_CMD_CPLT              DB    ?        ; Command status                      
 NCB_RESERVE               DB 14 DUP(?)   ; Reserved (except RESET)             
;                                                                               
NETWORK_CONTROL_BLOCK     ENDS                                                  
                                                                                
;--------------------------------------------------------------------           
;* THE FIELD LOCATED AT NCB_POST_OFFSET IS USED FOR TWO REASONS.    *           
;* BELOW IS ANOTHER NAME THAT CAN BE USED TO ACCESS THE FIELD       *           
;* FOR VARIOUS COMMANDS.                                            *           
;--------------------------------------------------------------------           
 NCB_POST_ADDRESS         EQU            NCB_POST_ADDR_OFFSET                   
                                                                                
                                                                                
NCB_STATUS_INFORMATION    STRUC                                                 
;                                                                               
 BURNED_IN_ADDRESS         DB  6 DUP(?)   ; Adapter's burned-in addr            
                           DB  2 DUP(0)   ; RESERVED always X'0000'             
 SOFTWARE_LEVEL_NUMBER     DW    ?        ; X'FFnn' - nn is level num           
 REPORTING_PERIOD          DW    ?        ; reporting period (minutes)          
 FRMR_FRAMES_RECEIVED      DW    ?        ; Number of FRMR received             
 FRMR_FRAMES_SENT          DW    ?        ; Number of FRMR sent                 
 BAD_IFRAMES_RECEIVED      DW    ?        ; # bad Iframes received              
 ABORTED_TRANSMISSIONS     DW    ?        ; # aborted transmits                 
 PACKETS_TRANSMITTED       DD    ?        ; # Successfully transmitted          
 PACKETS_RECEIVED          DD    ?        ; # Successfully received             
 BAD_IFRAMES_TRANSMITTED   DW    ?        ; # bad Iframes transmitted           
 LOST_DATA_COUNT           DW    ?        ; Lost SAP buffer data cnt            
 T1_EXPIRATION_COUNT       DW    ?        ; Number of T1 expirations            
 TI_EXPIRATION_COUNT       DW    ?        ; Number of Ti expirations            
 EXTENDED_STATUS_TABLE     DD    ?        ; Address of extended status          
 NUMBER_OF_FREE_NCBS       DW    ?        ; Number of NCBs available            
 MAX_CONFIGURED_NCBS       DW    ?        ; Configured NCB maximum              
 MAX_ALLOWED_NCBS          DW    ?        ; Maximum NCBs (always 255)           
 BUSY_CONDITION_COUNT      DW    ?        ; Local station busy count            
 MAX_DATAGRAM_SIZE         DW    ?        ; Maximum datagram packet             
 PENDING_SESSIONS          DW    ?        ; Number of pending sessions          
 MAX_CONFIGURED_SESSIONS   DW    ?        ; Configured session maximum          
 MAX_ALLOWED_SESSIONS      DW    ?        ; Maximum sessions (254)              
 MAX_DATA_PACKET_SIZE      DW    ?        ; Maximum session packet              
 NUMBER_OF_NAMES_PRESENT   DW    ?        ; Number of names in table            
;                                                                               
NCB_STATUS_INFORMATION    ENDS                                                  
                                                                                
                                                                                
NCB_EXTENDED_STATUS       STRUC                                                 
;                                                                               
                           DB  40 DUP(?)  ; RESERVED                            
 LOCAL_ADAPTER_ADDRESS     DB  6  DUP(0)  ; Adapter local address               
;                                                                               
NCB_EXTENDED_STATUS       ENDS                                                  
                                                                                
                                                                                
NCB_SESSION_STATUS        STRUC                                                 
;                                                                               
 NAME_NUMBER_OF_SESSIONS   DB    ?        ; Name number for sessions            
 SESSIONS_USING_NAME       DB    ?        ; # of sessions using name            
 ACTIVE_RCV_DATAGRAMS      DB    ?        ; # of receive datagrams out          
 ACTIVE_RECEIVE_ANYS       DB    ?        ; # of RECEIVE.ANY cmnds out          
 LOCAL_SESSION_NUMBER      DB    ?        ; Local session number                
 SESSION_STATE             DB    ?        ; State of session                    
 LOCAL_NAME                DB 16 DUP(?)   ; Local name                          
 REMOTE_NAME               DB 16 DUP(?)   ; Remote name                         
 ACTIVE_RECEIVES           DB    ?        ; # of RECEIVE cmnds out              
 ACTIVE_SENDS              DB    ?        ; # of SEND, CHAIN.SEND  out          
;                                                                               
NCB_SESSION_STATUS        ENDS                                                  
                                                                                
                                                                                
NCB_FIND_NAME_INFO        STRUC                                                 
;                                                                               
 NODES_RESPONDING          DW    ?        ; Number of nodes responding          
                           DB    ?        ; RESERVED                            
 NAME_STATUS               DB    ?        ; Unique/Group name flag              
;                                                                               
NCB_FIND_NAME_INFO        ENDS                                                  
                                                                                
                                                                                
NCB_LAN_HEADER_ENTRY      STRUC                                                 
;                                                                               
 LAN_ENTRY_LENGTH          DB    ?        ; Length of entry                     
 LAN_PCF0                  DB    ?        ; Physical control field 0            
 LAN_PCF1                  DB    ?        ; Physical control field 1            
 LAN_DESTINATION_ADDR      DB  6 DUP(?)   ; Destination address                 
 LAN_SOURCE_ADDR           DB  6 DUP(?)   ; Source address                      
 LAN_ROUTING_INFO          DB 18 DUP(?)   ; Routing information                 
;                                                                               
NCB_LAN_HEADER_ENTRY      ENDS                                                  
                                                                                
                                                                                
NCB_CHAIN_SEND            STRUC                                                 
;                                                                               
 NCB_FRONT_CS              DB 10 DUP(?)   ; Front of NCB                        
 BUFFER_TWO_LENGTH_CS      DW    ?        ; Length of second buffer             
 BUFFER_TWO_ADDRESS_CS     DD    ?        ; Address to second buffer            
 NCB_END_CS                DB 48 DUP(?)   ; End of NCB                          
;                                                                               
NCB_CHAIN_SEND            ENDS                                                  
                                                                                
                                                                                
NCB_RESET                 STRUC                                                 
;                                                                               
 NCB_FRONT1_R              DB 4  DUP(?)   ; Front of NCB                        
 DD_NAME_ADDRESS           DD    ?        ; Device driver name address          
 NCB_FRONT2_R              DB 2  DUP(?)   ; Front of NCB                        
 REQ_SESSIONS              DB    ?        ; # of sessions requested             
 REQ_COMMANDS              DB    ?        ; # of commands requested             
 REQ_NAMES                 DB    ?        ; # of names requested                
 REQ_NAME_ONE              DB    ?        ; Name number one request             
                           DB 12 DUP(?)   ; Not used                            
 ACT_SESSIONS              DB    ?        ; # of sessions obtained              
 ACT_COMMANDS              DB    ?        ; # of commands obtained              
 ACT_NAMES                 DB    ?        ; # of names obtained                 
 ACT_NAME_ONE              DB    ?        ; Name number one response            
                           DB  4 DUP(?)   ; RESERVED                            
 LOAD_SESSIONS             DB    ?        ; Number of sessions at load          
 LOAD_COMMANDS             DB    ?        ; Number of commands at load          
 LOAD_NAMES                DB    ?        ; Number of names at load             
 LOAD_STATIONS             DB    ?        ; Number of stations                  
                           DB  2 DUP(?)   ; RESERVED                            
 LOAD_REMOTE_NAMES         DB    ?        ; Number of remote names              
 NCB_END2_R                DB 23 DUP(?)   ; End of NCB                          
;                                                                               
NCB_RESET                 ENDS                                                  
                                                                                
