/**/

/*****************************************************************

 Y2KFORMT

 IBM VisualAge for COBOL Professional
 IBM VisualAge PL/I Professional

 Refomat/report Year 2000 analysis for COBOL and PL/I.
 This batch command file is invoked from DCZMKPU.EXE
 as the final step of analysis processing.
 A default report generator is included with this product,
 DCZY2KR.EXE, but the user can modify this command file to
 substitue an installation specific report generator.

 5693-B92 and 5639-A24
 (C) COPYRIGHT International Business Machines Corp. 1996, 1997

 All Rights Reserved
 Licensed Materials - Property of IBM
 US Government Users Restricted Rights - Use, duplication or
 disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

*****************************************************************/

/**********************************************/
/* no input parameter is a help only request  */
/**********************************************/
parse arg y2kargs
y2kargs = STRIP(y2kargs)
if y2kargs = '' then signal giveHelp

/**********************************************/
/* Loop through the input parameters looking  */
/* for the help parameter                     */
/**********************************************/
looking = y2kargs
do forever
  parse var looking currArg looking
  currArg = STRIP(currArg)
  if currArg = '' then
    leave
  if currArg = '/?' | currArg = '-?' then
    signal giveHelp
end

/**********************************************/
/* All input parameters processed - invoke    */
/* dczy2kr.exe with parameter list.           */
/*                                            */
/* A user supplied report program executable  */
/* can be specified here instead.  All        */
/* parameters are passed through as specified */
/* entered on the command line                */
/**********************************************/
'dczy2kr.exe' y2kargs
returnCode = rc

exit returnCode

giveHelp: ;
  /***********************/
  /* help only requested */
  /***********************/
  say ''
  say 'Y2KFORMT reformats Year 2000 analysis reports for COBOL or PL/I'
  say ''
  say 'Y2KFORMT SYNTAX: (for the default program supplied - DCZY2KR.EXE)'
  say ''
  say '"y2kformt xrlfilename xsdfilename"'
  say ''
  say '  xrlfilename is a required input file,'
  say '  the output file(.XRL) generated by analysis'
  say ''
  say '  xsdfilename is a required input file,'
  say '  the input seed file(.XSD) that was used by analysis'
  say ''
  say ''
  say 'EXAMPLES:'
  say '"y2kformt sample.xrl sample.xsd"'
  say '       reformat the analysis output in the specified file (.XRL)'
  say '       which was produced using the specified seed file (.XSD)'
  say ''
  say '"y2kformt"    or'
  say '"y2kformt /?"'
  say '       will output this help text'
  say ''
  exit
