/* REXX */
/*************************************************************/
/*                                                           */
/*    Licensed Material - Property of IBM                    */
/*                                                           */
/*    5639-B92 (C) Copyright IBM Corp., 1995, 1998           */
/*    All rights reserved                                    */
/*                                                           */
/*    US Government Users Restricted Rights - Use,           */
/*    duplication or disclosure restricted by GSA ADP        */
/*    Schedule Contract with IBM Corp.                       */
/*                                                           */
/*************************************************************/

/*************************************************************/
/* Name: IWZZCDL.CMD                                         */
/*                                                           */
/* Function: This REXX procedure is invoked as an exit when  */
/*           the component containing the sample projects    */
/*           is deleted.  This procedure does the following: */
/*                                                           */
/*           1) Delete the files that were created if the    */
/*              sample projects were built, plus some        */
/*              other miscellaneous files.                   */
/*                                                           */
/*           2) Attempt to delete the sample project         */
/*              directories up to, but not including, the    */
/*              SAMPLES directory.                           */
/*                                                           */
/*           3) Attempt to delete the projects themselves,   */
/*              except for projects 4 and 5 that are         */
/*              handled directly by software installer.      */
/*                                                           */
/*************************************************************/

/*************************************************************/
/*                                                           */
/* Last Update: 01/31/98                                     */
/*                                                           */
/* Change Activity:                                          */
/*                                                           */
/*   Defect                  Change Made                     */
/*   ------   ---------------------------------------------- */
/*     16     - Initial version of this file.                */
/*                                                           */
/*     xx     - Add new samples: elookup2, minivb, etc. */
/*                                                           */
/*************************************************************/

signal on novalue;

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
CALL SysLoadFuncs;

/* */
call erase "elookup1\*.* /n";
call erase "elookup1\copy\*.* /n";
call erase "elookup1\dbclss\*.* /n";
call erase "elookup1\helpdir\*.* /n";
call rd "elookup1\copy";
call rd "elookup1\helpdir";
call rd "elookup1\dbclss";
call rd "elookup1";
/* */
call erase "elookup2\*.* /n";
call erase "elookup2\*.c* /n";
call erase "elookup2\*.a* /n";
call erase "elookup2\*.d* /n";
call erase "elookup2\*.r* /n";
call erase "elookup2\*.l* /n";
call erase "elookup2\*.p* /n";
call erase "elookup2\*.m* /n";
call erase "elookup2\*.$* /n";
call erase "elookup2\copy\*.* /n";
call erase "elookup2\dbclss\*.* /n";
call erase "elookup2\helpdir\*.* /n";
call rd "elookup2\copy";
call rd "elookup2\helpdir";
call rd "elookup2\dbclss";
call rd "elookup2";
/* */
call erase "cicssmp\clidir\*.* /n";
call erase "cicssmp\clidir\helpdir\*.* /n";
call erase "cicssmp\srvdir\*.* /n";
call rd "cicssmp\clidir\helpdir";
call rd "cicssmp\clidir";
call rd "cicssmp\srvdir";
call rd "cicssmp";
/* */
call erase "minivb\asnum\*.* /n";
call erase "minivb\con1\*.* /n";
call erase "minivb\con2\*.* /n";
call erase "minivb\msgbox\*.* /n";
call erase "minivb\listbx\*.* /n";
call erase "minivb\graphics\*.* /n";
call rd "minivb\asnum";
call rd "minivb\con1";
call rd "minivb\con2";
call rd "minivb\msgbox";
call rd "minivb\listbx";
call rd "minivb\graphics";
call rd "minivb";
/* */
call erase "helloapp\*.* /n";
call rd "helloapp";
/* */
call erase "dde\*.* /n";
call erase "dde\ddeserv\*.* /n";
call rd "dde\ddeserv";
call rd "dde";
/* */
call erase "loan\*.* /n";
call erase "loan\helpdir\*.* /n";
call rd "loan\helpdir";
call rd "loan";
/* */
call erase "editor\*.* /n";
call rd "editor";
/* */
call erase "hostdata\h*.* /n";
call erase "hostdata\m*.* /n";
call rd "hostdata";
/* */
call erase "todolist\helpdir\vb*.* /n";
call erase "todolist\t*.lst /n";
call erase "todolist\t*.mak /n";
call erase "todolist\t*.$mm /n";
call erase "todolist\t*.cbl /n";
call erase "todolist\t*.lib /n";
call erase "todolist\t*.r*  /n";
call erase "todolist\t*.opt /n";
call erase "todolist\t*.lib /n";
call erase "todolist\c*.cmd /n";
call rd "todolist\helpdir";
call rd "todolist";
/* */
call erase "winestr\*.* /n";
call rd "winestr";
/* */
call erase "\mtexe\mtdll\*.* /n";
call erase "mtexe\*.* /n";
call rd "mtexe\mtdll";
call rd "mtexe";
/* */
exit 0;

/* erase: Erase file routine */
erase:
parse arg filename;
"ERASE %COBOLMAIN%\SAMPLES\"filename;
 return;

/* rd: Remove directory routine */
rd:
parse arg dirname;
"RD %COBOLMAIN%\SAMPLES\"dirname;
rd_rc = rc;
return;
/* 4A65737369636120224A657373696522204D7972746C65205370616E6F */
