/* REXX */
/*****************************************************************************/
/*                                                                           */
/*    Licensed Material - Property of IBM                                    */
/*    5622-793 (C) Copyright IBM Corp., 1996                                 */
/*    All rights reserved                                                    */
/*    US Government Users Restricted Rights - Use, duplication or disclosure */
/*    restricted by GSA ADP Schedule Contract with IBM Corp.                 */
/*                                                                           */
/*****************************************************************************/

/*************************************************************/
/* Name: IWZVMTX.CMD                                         */
/*                                                           */
/* Function: This REXX procedure is invoked as an exit when  */
/*           the component containing the multiple targets   */
/*           sample project is deleted.                      */
/*           This procedure does the following:              */
/*                                                           */
/*           1) Delete the files that were created if the    */
/*              sample projects were built.                  */
/*                                                           */
/*           2) Attempt to delete the sample project         */
/*              directories up to, but not including, the    */
/*              SAMPLES directory.                           */
/*                                                           */
/* Last Update: 05/15/95                                     */
/*************************************************************/

/*************************************************************/
/*                                                           */
/* Change Activity:                                          */
/*                                                           */
/*   Defect                  Change Made                     */
/*   ------   ---------------------------------------------- */
/*     00     - Initial version of this file.                */
/*                                                           */
/*************************************************************/

signal on novalue;

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
CALL SysLoadFuncs;

/* */
call erase "MTEXE\DYNAMIC_";
call erase "MTEXE\MTARGET.*";
call rd    "MTEXE";
/* */
call erase "MTDLL\DYNDLL?.*";
call erase "MTDLL\cbltmake.*";
call rd    "MTDLL";
/* */

sysrc = SysDestroyObject("<IWZVMTX>");

exit 0;

/* erase: Erase file routine */
erase:
parse arg filename;
"ERASE %ICOBDIR%\SAMPLES\"filename;
 return;

/* rd: Remove directory routine */
rd:
parse arg dirname;
"RD %ICOBDIR%\SAMPLES\"dirname;
rd_rc = rc;
return;
/* 4A65737369636120224A657373696522204D7972746C65205370616E6F */
