/*** IWZVGDEF.CMD                                                                     */
/**************************************************************************************/
/***  Licensed Material - Property of IBM                                             */
/***  5622-793 (C) Copyright IBM Corp., 1996                                          */
/***  All rights reserved                                                             */
/***  US Government Users Restricted Rights - Use, duplication or disclosure          */
/***  restricted by GSA ADP Schedule Contract with IBM Corp.                          */
/**************************************************************************************/
'@ECHO OFF'
trace 0

parse arg objfiles

/* set variables to be used if link is requested */

deflocation = ""
maxgoodrc = 4
returncode = 0

environ  = 'OS2ENVIRONMENT'

defTemplate = 'iwzvmod.def'

if stream( defTemplate, 'c', 'query exists')  <> '' then
   do
      say defTemplate 'is in current directory'
      deflocation = "CurrentDir"
   end
else     /* check for .def template in COBOL bin directory  */
   do
      defaultdefFile = value('ICOBFDIR', , environ) || '\bin\' || defTemplate
      if stream(defaultdefFile, 'c', 'query exists')  <> '' then
         do
            say 'iwzvmod.def is in COBOL BIN directory'
            deflocation = "COBOLBIN"
         end
   end

objfiles = strip(objfiles)
do  while objfiles <> ""
   if pos('"',objfiles) <> 1 then                        /* no quotes  */
      parse var objfiles objfile objfiles
   else /* hpfs file in quotes */
      do
         endpos = pos('"',objfiles,2) /* look for closing quote */
         if endpos = 0 then
            do
               say 'Error: No closing quote found'
               exit maxgoodrc+4
            end
         objfile = substr(objfiles,2,endpos-2)
         objfiles = strip(substr(objfiles,endpos+1))
      end

   parse value filespec('name',objfile) with objname '.' objext

   /* check if file.def exists in current directory  */
   deffile = objname || '.def'
   if stream(deffile, 'c', 'query exists')  <> '' then     /* deffile exists  */
         say "Module definition file:" deffile "exists and will not be overwritten."

   else          /* Check if template exists   */
      select
         when deflocation = "CurrentDir"
            then call createdeffile deffile objname translate(objname) defTemplate
         when deflocation = "COBOLBIN"
            then call createdeffile deffile objname translate(objname) defaultdefFile
         otherwise
            call writedeffile deffile objname translate(objname)
      end  /* select */

exit returncode


createdeffile: procedure
   Arg deffile filename exportname defTemplate

   defLineIn = linein(defTemplate,1,0)
   Do While lines(defTemplate) > 0
      defLineIn = linein(defTemplate)
      defLineOut = ''
      do while defLineIn <> ''
         parse var defLineIn parmIn defLineIn
         select
            when parmIn == 'filename' then
               defLineOut = defLineOut filename

            when parmIn == 'exportname' then
               defLineOut = defLineOut exportname

            otherwise
               defLineOut = defLineOut parmIn

         end   /* select */
      end /* do */
      call lineout deffile, substr(defLineOut,2)
   end   /* while */
   call lineout deffile
Return makedefrc

/* This procedure only gets called if the module definition template */
/* (iwzvmod.def) doesn't exist in the current or default directories */
writedeffile: procedure
   Arg deffile filename exportname
   /* only create file if it doesn't exist  */
   if stream(fn, 'C', 'QUERY EXISTS') == '' then
      do
         call lineout deffile, ''
         call lineout deffile, 'LIBRARY' filename 'INITINSTANCE TERMINSTANCE'
         call lineout deffile, 'PROTMODE'
         call lineout deffile, 'DATA MULTIPLE NONSHARED READWRITE LOADONCALL'
         call lineout deffile, 'CODE LOADONCALL'
         call lineout deffile, 'EXPORTS'
         call lineout deffile, exportname
         call lineout deffile
      end
Return makedefrc
