/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
msgtype = 'error';
inmon = 'yes';
parse upper arg xx '++' request sysout;
if request <> '' then
  do;
  if substr(request,1,1) = '!' then
    do;
    inmon = 'no';
    request = substr(request,2);
    end;
  end;
usedrive = '';
if tempdata <> '' then
  do;
  if numdrive > 0 then
    do;
    do ii = 1 to numdrive;
      if tempdata = drive.ii & trans.ii = 'text,crlf' then
        do;
        usedrive = drive.ii;
        temphqual = highqual.ii;
        leave;
        end;
      end;
    end;
  if usedrive = '' then
    do;
    call message 01;
    call traceit 1 'Error exit';
    exit 16;
    end;
  end;
else
  do;
  if numdrive > 0 then
    do;
    do ii = 1 to numdrive;
      if highqual.ii = userid & trans.ii = 'text,crlf' then
        do;
        usedrive = drive.ii;
        leave;
        end;
      end;
    end;
  if usedrive = '' then
    do;
    call message 02;
    call traceit 1 'Error exit';
    exit 16;
    end;
  end;
mvslog = value('TMP',,env)'\MVSJOB.LOG';
if tempdata <> '' then
  do;
  if pos('.',temphqual) > 0 then
    dsname = temphqual||'.OUTLIST';
  else
    dsname = temphqual||'.IWZ.OUTLIST';
  end;
else
  dsname = userid||'.IWZ.OUTLIST';
foundmsg = 'NO JOBS FOUND+';
searchmsg = 'SYSTEM QUEUES WERE SEARCHED FOR JOBNAMES EQUAL TO YOUR USERID PLUS ONE CHARACTER';
if request <> '' then
  do;
  if request <> 'LIST' & request <> 'LIST100' & request <> 'SAVE' &,
    request <> 'SAVENUM' & request <> 'DELETE' then
    do;
    call message 03 request;
    call traceit 1 'Error exit';
    exit 16;
    end;
  if sysout = '' then
    call message 04;
    do;
    end;
  tm = time();
  dt = date('U');
  outline = strip(sysout,'B');
  call traceit 2 'Before call to process';
  call process;
  call traceit 2 'After call to process';
  if inmon = 'yes' then
    do;
    if request = 'LIST' | request = 'LIST100' then
      do;
      godoccmd = 'GODOC FIND' outfile '!';
      if opsys = 'OS/2' then
        call iwzmlxp.cmd '"M:\MVS Job Status Monitor" /NOLOGO /CM MULT !MACRO iwzmSYA.LX CLEAN!'godoccmd;
      else
        '@iwzmlxp "M:\MVS Job Status Monitor" /NOLOGO /CM MULT !MACRO iwzmSYA.LX CLEAN!'godoccmd;
      end;
    else
      do;
      if opsys = 'OS/2' then
        call iwzmlxp.cmd '"M:\MVS Job Status Monitor" /NOLOGO /CM MACRO iwzmSYA.LX REFRESH';
      else
        '@iwzmlxp "M:\MVS Job Status Monitor" /NOLOGO /CM MACRO iwzmSYA.LX REFRESH';
      end;
    end;
  call traceit 1 'Normal exit';
  exit 0;
  end;
/* The following is used internally and is not displayed to the user. */
/* It should not be translated for NLS purposes.                      */
call sayit;
call sayit '---------------- MVS Job Status Monitor ----------------';
if mvscomm = 'YES' then
  call iwzmvws.cmd 'STATUS >'tempout;
else
  call iwzmtso.cmd '!!??'tempout'??STATUS';
call traceit 2 'Before call to showout';
call showout;
call traceit 2 'After call to showout';
if opsys = 'OS/2' then
  call iwzmlxp.cmd '"M:\MVS Job Status Monitor" /NOLOGO /CM MACRO iwzmMN.LX HIGHLIGHT';
else
  '@iwzmlxp "M:\MVS Job Status Monitor" /NOLOGO /CM MACRO iwzmMN.LX HIGHLIGHT';
call traceit 1 'Normal exit';
exit 0;
/* */
showout:
read_stem.0 = 0;
xx = linein(tempout,1,0);
do forever;
  if lines(tempout) = 0 then
    leave;
  read_stem.0 = read_stem.0 + 1;
  nn = read_stem.0;
  read_stem.nn = linein(tempout);
  if substr(read_stem.nn,1,2) = '??' then
    read_stem.nn = substr(read_stem.nn,3);
  end;
xx = stream(tempout,'C','CLOSE');
'@erase' tempout;
tm = time();
dt = date('U');
call sayit;
if read_stem.0 > 0 then
  do;
  do mm = 1 to read_stem.0;
    outline = strip(read_stem.mm,'T');
    call traceit 2 'Before call to process';
    call process;
    call traceit 2 'After call to process';
    end;
  end;
return;
/* */
process:
if outline <> ' ' then
  do;
  select;
    when pos(foundmsg,outline) > 0 then
      do;
      len = pos('+',outline) - 1;
      outline = substr(outline,1,len);
      call sayit dt tm outline;
      end;
    when pos(searchmsg,outline) > 0 then
      nop;
    otherwise
      do;
      if request = '' then
        call sayit dt tm outline;
      end;
    end;
  end;
if request <> '' then
  do;
  if pos('ON OUTPUT QUEUE',outline) > 0 then
    do;
    parse var outline dummy 'JOB ' jobname rest;
    if pos('(',jobname) <> 0 & pos(')',jobname) <> 0 then
      do;
      parse var jobname job '(' jobnum ')' rest;
      if request = 'SAVE' then
        outlist = "'"dsname"("job")'";
      else
        outlist = "'"dsname"("jobnum")'";
      if request = 'SAVE' | request = 'SAVENUM' then
        do;
        if mvscomm = 'YES' then
          call iwzmvws.cmd,
            " OUTPUT" jobname "PRINT("outlist") >"tempout;
        else
          callit "iwzmtso.cmd !!",
            " OUTPUT" jobname "PRINT("outlist") >"tempout;
        end;
      else
        do;
        if request = 'LIST' | request = 'LIST100' then
          do;
          call traceit 2 'Before call to showterm';
          call showterm;
          call traceit 2 'After call to showterm';
          return;
          end;
        else
          do;
          if mvscomm = 'YES' then
            call iwzmvws.cmd,
              " OUTPUT" jobname "DELETE >"tempout;
          else
            callit "iwzmtso.cmd !!",
               " OUTPUT" jobname "DELETE >"tempout;
          call traceit 2 'Before call to log';
          call log dt tm 'DEL' jobname;
          call traceit 2 'After call to log';
          end;
        end;
      read_stem2.0 = 0;
      xx = linein(tempout,1,0);
      do forever;
        if lines(tempout) = 0 then
          leave;
        read_stem2.0 = read_stem2.0 + 1;
        nn = read_stem2.0;
        read_stem2.nn = linein(tempout);
        end;
      xx = stream(tempout,'C','CLOSE');
      '@erase' tempout;
      outok = 'yes';
      do nn = 1 to read_stem2.0;
        outline = strip(read_stem2.nn,'T');
        if outline <> '' then
          do;
          outok = 'no';
          call lpexemsg outline;
          leave;
          end;
        end;
      if outok = 'yes' then
        do;
        if request = 'SAVE' | request = 'SAVENUM' then
          do;
          call message 05 dt tm'\\'jobname'\\'outlist;
          call traceit 2 'Before call to log';
          call log dt tm 'SAV' jobname outlist;
          call traceit 2 'After call to log';
          end;
        end;
      end;
    end;
  end;
return;
/* */
showterm:
doshow = 'yes';
parse var jobname jobnm '(' jobnum ')' rest;
if tempdata <> '' then
  do;
  if pos('.',temphqual) > 0 then
    do;
    outdsn = "'"temphqual"."jobnm"."jobnum".OUTLIST'";
    outfile = usedrive'\'jobnm'.'jobnum'.OUTLIST';
    end;
  else
    do;
    outdsn = "'"temphqual".IWZ."jobnm"."jobnum".OUTLIST'";
    outfile = usedrive'\IWZ.'jobnm'.'jobnum'.OUTLIST';
    end;
  end;
else
  do;
  outdsn = "'"userid".IWZ."jobnm"."jobnum".OUTLIST'";
  outfile = usedrive'\IWZ.'jobnm'.'jobnum'.OUTLIST';
  end;
outcmd = 'OUTPUT' jobname 'PRINT('outdsn') HOLD KEEP';
lpexcmds = '/CM MULT !SET READONLY ON!SET NOSAVE ON!';
lpexcmds = lpexcmds'SET SYNONYM.QQUIT macro iwzmqt.lx qquit' outdsn;
if mvscomm = 'YES' then
  call iwzmvws.cmd outcmd '>'tempout;
else
  call iwzmtso.cmd '!!??'tempout'??'outcmd;
read_stem.0 = 0;
xx = linein(tempout,1,0);
do forever;
  if lines(tempout) = 0 then
    leave;
  read_stem.0 = read_stem.0 + 1;
  nn = read_stem.0;
  read_stem.nn = linein(tempout);
  if substr(read_stem.nn,1,2) = '??' then
    read_stem.nn = substr(read_stem.nn,3);
  end;
xx = stream(tempout,'C','CLOSE');
'@erase' tempout;
  if read_stem.0 > 0 then
    output = read_stem.1;
  else
    output = '';
if output <> '' then
  do;
  call lpexemsg output;
  doshow = 'no';
  end;
doctype = '/DOCTYPE OUT';
if doshow = 'yes' then
  do;
  do ii = 1 to 2;
    xx = SysFileTree(outfile,'tree_stem.','F');
    if xx <> 0 then
      do;
      call message 06 xx;
      doshow = 'no';
      leave;
      end;
    if tree_stem.0 > 0 then
      leave;
    if ii > 1 then
      do;
      call message 07;
      doshow = 'no';
      leave;
      end;
    call message 08;
    xx = SysSleep(31);
    end;
  if doshow = 'yes' then
    do;
    if opsys = 'OS/2' then
      call iwzmlxp.cmd outfile '/NOLOGO' lpexcmds doctype;
    else
      '@iwzmlxp' outfile '/NOLOGO' lpexcmds doctype;
    end;
  end;
return;
/* */
log:
if joblog <> 'YES' then
  return;
parse arg logdata;
do ll = 1 to 5;
  '@echo' logdata '>>'mvslog;
  echo_rc = rc;
  if echo_rc = 0 then
    return;
  xx = SysSleep(1);
  end;
call message 09 mvslog;
return;
/* */
lpexemsg:
parse arg themsg;
if inmon = 'yes' then
  do;
  if msgtype = 'error' then
    doalarm = 'ALARM!';
  else
    doalarm = '';
  call traceit 2 'Before call to LXPM for message:' themsg;
  if opsys = 'OS/2' then
    call iwzmlxp.cmd '"M:\MVS Job Status Monitor" /NOLOGO /CM MULT !MSG "'themsg'" !'doalarm;
  else
    '@iwzmlxp "M:\MVS Job Status Monitor" /NOLOGO /CM MULT !MSG "'themsg'" !'doalarm;
  xx = SysSleep(3);
  call traceit 2 'After call to LXPM for message:' themsg;
  end;
else
  call sayit themsg;
return;
/* */
lpexmsg:
parse arg themsg;
msgtype = 'info';
call lpexemsg themsg;
msgtype = 'error';
return;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call lpexemsg 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call lpexemsg 'Cannot find drive with userid as high level qualifier';
end;
 
when iwz_message_num = 3 then do;
call lpexemsg 'Invalid SYSOUT request:' iwz_message_arg1;
end;
 
when iwz_message_num = 4 then do;
call lpexemsg 'Sysout specification missing for request';
end;
 
when iwz_message_num = 5 then do;
call lpexmsg iwz_message_arg1 'Output for' iwz_message_arg2 'saved to' iwz_message_arg3;
end;
 
when iwz_message_num = 6 then do;
call lpexemsg 'Internal error from SySFileTree , RC =' iwz_message_arg1;
end;
 
when iwz_message_num = 7 then do;
call lpexemsg 'Cannot access saved SYSOUT, reconnect to MVS';
end;
 
when iwz_message_num = 8 then do;
call lpexemsg 'Waiting 30 seconds for file system cache to refresh';
end;
 
when iwz_message_num = 9 then do;
call lpexemsg 'Cannot write to log' iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call lpexemsg 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call lpexemsg 'Cannot find drive with userid as high level qualifier';
end;
 
when iwz_message_num = 3 then do;
call lpexemsg 'Invalid SYSOUT request:' iwz_message_arg1;
end;
 
when iwz_message_num = 4 then do;
call lpexemsg 'Sysout specification missing for request';
end;
 
when iwz_message_num = 5 then do;
call lpexmsg iwz_message_arg1 'Output for' iwz_message_arg2 'saved to' iwz_message_arg3;
end;
 
when iwz_message_num = 6 then do;
call lpexemsg 'Internal error from SySFileTree , RC =' iwz_message_arg1;
end;
 
when iwz_message_num = 7 then do;
call lpexemsg 'Cannot access saved SYSOUT, reconnect to MVS';
end;
 
when iwz_message_num = 8 then do;
call lpexemsg 'Waiting 30 seconds for file system cache to refresh';
end;
 
when iwz_message_num = 9 then do;
call lpexemsg 'Cannot write to log' iwz_message_arg1;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
