/* ***************************************************************** */
/*               IBM VisualAge for COBOL for OS/2                    */
/* ***************************************************************** */
/*                     OCO Source Materials                          */
/*                                                                   */
/*                       IBM Confidential                            */
/*       (IBM Confidential-Restricted when combined with the         */
/*         aggregated OCO source modules for this program)           */
/*                                                                   */
/*                             5639-B92                              */
/*             (C) Copyright IBM Corporation 1996, 1997              */
/*                       All Rights Reserved                         */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. copyright office.                         */
/*                                                                   */
/* ***************************************************************** */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */
/* 5639-B92 (C) Copyright IBM Corp., 1996, 1997                      */
/* All rights reserved                                               */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/* ***************************************************************** */
/**************************************************************/
/*  Emulates ISPF service call VPUT/VGET/VDELETE.             */
/*                                         wsv3 8/95 psw      */
/*  ISPEXEC "VPUT (v1,v2,...) SHARED"  for ISPF               */
/*  "ISPEXEC fcn,v1[,vv1],v2[,vv2],..."  for OS/2 command.    */
/*  The SHARED pool is a flat file SHARED.ABJ with records    */
/*    of the form: "v1=vv1;"                                  */
/*  vdelete returns nothing, requires no value vars.          */
/*  vget returns "vv1=value1;vv2=value2;..."                  */
/*    the calling pgm must do interpret on what's returned.   */
/*  vput returns 0 if sucessful else returns null.            */
/**************************************************************/
/*  11/15/97  jph  Add full path, (replace GetEnv)            */
/**************************************************************/
/*  parse argument  */
ct = arg()
function = arg(1)
vname. = ""
vval. = ""
if function == "VDELETE" then
   do i = 2 to ct
      ip = i-1
      vname.ip = arg(i)
   end /* Do */
else do
   ip = 0  /* pair count */
   do i = 1 to ct-1 by 2
      /* vval.i = var name that will hold path info. */
      ip = ip + 1
      vname.ip = arg(i+1)
      vval.ip = arg(i+2)
  end /* Do */
end  /* Do */

ECFCWORK = value("ECFWORK",,"OS2ENVIRONMENT")
/* GetEnv by calling C DLL                       */
/* envvar = "ECFWORK"
   call ECFGTENV envvar
   ECFCWORK = result */
/* end GetEnv        */
sharedp = ECFCWORK||"\SHARED.ABJ"
sharedt = ECFCWORK||"\SHARED.TMP"
select
   when function == "VDELETE" then call ISPVDEL
   when function == "VGET" then call ISPVGET
   when function == "VPUT" then call ISPVPUT
otherwise
   say "oops!  Should not be here."
end  /* select */
exit result

ISPVDEL:
   call deletercd
   "erase " sharedp  /* file becomes smaller */
   "rename " sharedt " SHARED.ABJ"
   return

ISPVGET:
   call findvals
   return result

ISPVPUT:
   call insert
   return

/*-----< deletercd >-------------------------------------------*/
/*  deletes matching record and creates a tmp shared pool file */
/*    because the file is usually smaller.                     */
/*-------------------------------------------------------------*/
deletercd:

   foundv = 0  /* counts number of vars found */
   rc = stream(sharedt, "c", "open write")
   rc = stream(sharedp, "c", "open read")
   if rc == "READY:" then do forever
      call read_shared
      if vn.0 = "" then leave
      /* find first match */
      match = 0
      do ig = 1 to ip until match = 1
         if vname.ig == vn.0 then do
            foundv = foundv + 1
            match = 1
         end  /* Do */
      end /* Do while */
      if match = 0 then call lineout sharedt, readline
   end  /* Do eof */
   rc = stream(sharedp, "c", "close")
   rc = stream(sharedt, "c", "close")
   return

/*-----< findvals >--------------------------------------------*/
/*  finds and returns a interpretable string that sets values  */
/*-------------------------------------------------------------*/
findvals:
   foundv = 0  /* counts number of vars found */
   retval = ""
   rc = stream(sharedp, "c", "open read")
   if rc == "READY:" then do
      do while vn.0 \= "" & foundv < ip
         call read_shared
         /* find first match */
         do ig=1 to ip
            if vname.ig == vn.0 then do
               retval = retval||vval.ig||"='"||vv.0||"';"
               foundv = foundv + 1
               leave
            end  /* if */
         end /* Do */
      end  /* Do while */
   end  /* Do */
   rc = stream(sharedp, "c", "close")
   return retval

/*-----< insert >----------------------------------------------*/
/*  modifies record if vname found else insert a new record    */
/*      the file is either the same size or larger             */
/*-------------------------------------------------------------*/
insert:
   vn. = ""
   vv. = ""
   do j = 1 to ip  /* for all input vars */
      rc = stream(sharedp, "c", "query exists")
      if rc \== "" then do
         rc = stream(sharedp, "c", "open")
         k = 0
         inserted = 0
         /* do until eof_shared */
         do forever
            /* read shared_file to vn.0 and vv.0 */
            call read_shared
            if vn.0 == "" then leave
            k = k+1
            select
               when vname.j << vn.0 then do
                  if inserted = 0 then do
                     vn.k = vname.j; vv.k = vval.j
                     inserted = 1
                     k = k + 1
                  end  /* Do */
                  vn.k = vn.0; vv.k = vv.0
               end  /* Do */
               when vname.j >> vn.0 then do
                  vn.k = vn.0; vv.k = vv.0
               end  /* Do */
            otherwise /* change the variable value */
               vn.k = vname.j; vv.k = vval.j
               inserted = 1
            end  /* select */
         end /* do until eof */
         if inserted = 0 then do  /* new name > all in file */
            k = k + 1
            vn.k = vname.j; vv.k = vval.j
         end  /* Do */
         rc = stream(sharedp, "c", "close")
         rc = stream(sharedp, "c", "open")   /* for non-append write */
         do iw = 1 to k
            /* write shared_file from vn.iw and vv.iw */
            aline = vn.iw||"="vv.iw
            call lineout sharedp, aline
         end /* do write-back */
      end  /* Do shardp exists */
      else do
         /* write shared_file from vname.j and vval.j */
         aline = vname.j||"="||vval.j
         call lineout sharedp, aline
      end  /* Do shardp not exists */
      rc = stream(sharedp, "c", "close")
   end /* do for all input vars */
Return
/*-----< read_shared >-----------------------------------------*/
/*  read shared pool and return name and value of current var. */
/*-------------------------------------------------------------*/
read_shared:
   vn.0 = ""
   vv.0 = ""
   readline = ""
   readline = linein(sharedp)
   parse upper var readline vn.0"="vv.0
Return
