/* ***************************************************************** */
/*               IBM VisualAge for COBOL for OS/2                    */
/* ***************************************************************** */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */
/* 5639-B92 (C) Copyright IBM Corp., 1996, 1997                      */
/* All rights reserved                                               */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/* ***************************************************************** */
/*--< Start of Specifications >--------------------------------------*/
/*                                                                   */
/* Program Name: ECFSCPC                                             */
/*                                                                   */
/* Descriptive Name:  COBOL/SF - Toolcap for the                     */
/*                    COBOL and CICS/VS Command Level Conversion Aid */
/*                    (CCCA)                                         */
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/* Input:                                                            */
/*                                                                   */
/*   Symbolic Name: project                                          */
/*   Description:                                                    */
/*                                                                   */
/*   Symbolic Name: group                                            */
/*   Description:                                                    */
/*                                                                   */
/*   Symbolic Name: type                                             */
/*   Description:                                                    */
/*                                                                   */
/*   Symbolic Name: member                                           */
/*   Description:                                                    */
/*                                                                   */
/*                                                                   */
/* Output:                                                           */
/*                                                                   */
/*   Symbolic Name: RC                                               */
/*   Description:   Return code.                                     */
/*                                                                   */
/* Normal Exit Conditions:                                           */
/*   RC=0                                                            */
/*            Processing completed successfully.                     */
/*                                                                   */
/* Error Exit Conditions:                                            */
/*                                                                   */
/* Messages:                                                         */
/*                                                                   */
/* External References:                                              */
/*                                                                   */
/*   Routines:                                                       */
/*                                                                   */
/*   Services:                                                       */
/*                                                                   */
/* Environment Variables:                                            */
/*                                                                   */
/*   ECFCPATH - Directory where fixed files are located.             */
/*   ECFCWORK - Directory where modifiable files are located.        */
/*                                                                   */
/*--< End of Specifications >----------------------------------------*/
/*                                                                   */
/*--< Pseudocode >---------------------------------------------------*/
/*                                                                   */
/*   Parse the input parameters                                      */
/*                                                                   */
/*   ALLOCATE CCCA's datasets                                        */
/*                                                                   */
/*   Call CCCA                                                       */
/*                                                                   */
/*   FREE CCCA's dataset                                             */
/*                                                                   */
/*   Exit                                                            */
/*                                                                   */
/*                                                                   */
/* Change Activity                                                   */
/*                                                                   */
/*   09/15/92 NN   Add the integration.                              */
/*   03/15/93 NN   Add code to generate 6 CCCA's reports             */
/*   03/07/94 NN   Update code to integrate with CCCA v1r7           */
/*   05/08/95 psw  Adapted for Workstation Version of CCCA           */
/*   03/26/96 psw  Fix CheckCICS problems                            */
/*   05/24/96 psw  Allow process to be cancelled from interface      */
/*   05/30/96 psw  Delete .CRS file at start of process.             */
/*   12/20/96 jph  Update CCCA to match with Australia               */
/*   01/16/97 psw  Fix write .CRS file problem.                      */
/*   02/10/97 jph  Fix Copylibs in CICS problems.                    */
/*   02/11/97 psw  Fix lost print copy member parm.                  */
/*   02/19/97 psw  Fix no sysxxxx file problem.                      */
/*   03/14/97 jph  Copyright statement for release 4/97.             */
/*   03/19/97 psw  Fix lost critical msgs problem for rel.4/97       */
/*   10/15/97 jph  Incorporate VSE, (replace GetEnv), add full path  */
/*                                                                   */
/*--< End of specifications >----------------------------------------*/
/*********************************************************************/
/*   M A I N L I N E                                                 */
/*********************************************************************/
Signal On NoValue
testflag = 0  /*  set to 1 if console trace during conversion is needed */
/* set testflag to Y if console trace is desired (PASS3)                */
/* set trace_flag to 1 if this .cmd needs trace to file: ECFSCPC.TCE    */
trace_flag = 1
/* trace ?i */
ECFCPATH = value("ECFFILE",,"OS2ENVIRONMENT")
ECFCWORK = value("ECFWORK",,"OS2ENVIRONMENT")
ECFLOCAL = value("ECFLOCAL",,"OS2ENVIRONMENT") /* for share install */
if ECFLOCAL = "NULL" then share_flag = 0
else share_flag = 1        
/* GetEnv by calling C DLL  */
/* envvar = "ECFFILE"
   call ECFGTENV envvar
   ECFCPATH = result
   envvar = "ECFWORK"
   call ECFGTENV envvar
   ECFCWORK = result        */
/* end GetEnv               */
if ECFCWORK = "" then exit 1111
mvs_vse = "MVS"                             /* 03/98 incorporate VSE     */
ECFVSE = value("ECFVSE",,"OS2ENVIRONMENT")  /*       by setting ECFVSE=1 */
if ECFVSE = "1" then  mvs_vse = "VSE"       /*       in config.sys       */
sysout  = ECFCWORK||"\SYSOUT.ABJ"  /* error message receptor */
sysprt1 = ECFCWORK||"\SYSPRT1.ABJ"
sysprt2 = ECFCWORK||"\SYSPRT2.ABJ"
sysprt3 = ECFCWORK||"\SYSPRT3.ABJ"
"erase "||ECFCWORK||"\db2prein.*"
"erase "||ECFCWORK||"\COPYBOOK.ABJ"
"erase "||ECFCWORK||"\COPYBOUT.ABJ"
"erase "||ECFCWORK||"\COPYLINE.ABJ"
"erase " sysout
"erase " sysprt1
"erase " sysprt2
"erase " sysprt3
if trace_flag = 1 then do
   tracef = ECFCWORK||"\ECFSCPC.TCE"
   "erase " tracef
   call lineout tracef, "ECFCPATH and ECFCWORK : "||ECFCPATH "; " ECFCWORK
end  /* Do */
/* process cancellation 5/96 psw */
cancf = ECFCWORK||"\ECFQUIT.DAT"
"erase " cancf
call lineout cancf, "Processing"
rc = stream(cancf,"c","close")
pif = ECFCWORK||"\ECFSTA.STA"
Call SetConst
Call ParseOptions
if trace_flag = 1 then call lineout tracef, "ParseOptions completed."
/* Set file names and qualifiers. write options into VSAM file.   */
/*     preprocess CICS and DB2 commands in LINKAGE SECTION.       */
Call SetMiscOS2
Call CheckSource  /* check source file  9/97 window   */
Call WriteOptions
if trace_flag = 1 then call lineout tracef, "WriteOptions completed."
Call CheckCICS
if trace_flag = 1 then call lineout tracef, "CheckCICS completed."
/*  Convert the program and dispatch reports                      */
Call ConvertPgm
if trace_flag = 1 then call lineout tracef, "ConvertPgm  completed "||retcd

If retcd = ok then do
   retfile = "NOFILE"
End
call lineout tracef, "Calling WriteCRSFile"
Call WriteCRSFile
/* Add convert log to correct WorkFrame Working directory */
call lineout tracef, "Adding files to WorkFrame"
/* "ECF2WFC" retcd srcfspec              ==> 3/98 exec full path */
pgmexe = ECFCPATH||"\ECF2WFC.EXE"
pgmexe retcd srcfspec
/*  end ECF2WFC */
call lineout tracef, "return from adding files, rc = "||rc
/* Parse the ABx files into TMx files */
/* call lineout tracef, "Parsing the ABx files." */
call ECFPARCC
call lineout tracef, "Return from parsing ABx files.  status is "||result

call DeleteClibs  /* deletes all copylib vars from shared pool */
/*****>  DO MORE TEMP FILE DELETING HERE LATER  <*****/
"erase "||ECFCWORK||"\db2prein.*"
call lineout tracef, "exit normally from ECFSCPC, rc = "||retcd
exit retcd
/*********************************************************************/
/*     E N D  M A I N L I N E                                        */
/*********************************************************************/


/*-< SetConst >------------------------------------------------------*/
/*  Setup required constants and initial values of control vars.     */
/*-------------------------------------------------------------------*/
SetConst:

   con_char    = "xx"   /* control char padded to string that pass to*/
                        /* cobol module the read & write option VSAM */
   delm        = "#$"   /* delimiter separate the options            */
   blank       = ""
   yes         = "Y"
   apost_str   = "*APOST"
   quote_str   = "*QUOTE"
   apost       = "A"
   ok          = 0        /* used for checking allocation status     */
   retcd       = ok       /* Initialize return code                  */
   clibct      = 0        /* initialize copylib count to 0           */
   allocerr    = 468      /* Set when ECFABJ.OPT not found           */
   rerroptf    = 469      /* Set when ECFABJ.OPT read error occurred */
   srcerr      = 404      /* Input source file has lenght > 80       */
   allocrpterr = 1128     /* Set when can't allocate report data set */
   /* pdserr      = 1122     Only partitioned dataset allowed in fore*/
                          /* ground. Use batch for sequential dataset*/
   noverr      = 1122     /* REXX trap condition NOVALUE occurred    */
   /* ispexerr = 1123     Set when can't run ISPEXEC                 */
   /* vgeterr     = 1124     Set when can't do "VGET"                */
   /* error in accessing VSAM CONTROL file by using COBOL prog       */
   /* ECFOPT2 and return code get back from this COBOL prog          */
   openerr     = 1125     /* can't open the option VSAM file         */
   /* LCP0090 */
   rwerr       = 1126     /* can't read or write to option VSAM file */
   /* LCP0025 */
   keyerr      = 1127     /* using invalid key to access VSAM file   */
   openrc      = 1        /* return code if read & write to option   */
   rwrc        = 2        /* return code if read & write to option   */
                          /* file happened                           */
   keyrc       = 3        /* return code if key error happened       */
   lnk1errb    = 1500     /* base value for create dummy pgm error   */
   lnk2errb    = 1600     /* base value for bll length calc error    */
   comperrb    = 2000     /* base value for compiler errors          */
   db2perrb    = 3000     /* base value for DB2 preprocessor errors  */
return



/*-< ParseOptions >--------------------------------------------------*/
/*  Parse the options file ECFABJ.OPT.                               */
/*-------------------------------------------------------------------*/
ParseOptions:

  optctmp = ECFCWORK||"\ECFABJ.OPT"
  rc = stream(optctmp, "c", "query exists")
  if rc == "" then do  /* file not found */
     retcd = allocerr
     retfile = optctmp
  end  /* Do */
  /* Say "Initializing" */
  if trace_flag = 1 then call lineout tracef, "initializing."
  If retcd = ok Then do
     optstr = ParseOptFile()
     /* Delete .CRS file   5/96 psw */
     crsfname = FILESPEC("name", source)
     Parse Var crsfname crsfname"."gar
     crsf = ECFCWORK || "\" || crsfname || ".CRS"
     "erase " crsf
  End
  Else do
     Call Abend
  End
return



/*-< ParseOptFile >--------------------------------------------------*/
/*                                                                   */
/*-------------------------------------------------------------------*/
ParseOptFile:

/*      Procedure Expose ,
              opsys source target targetlib ABJCONV1 LOPTION ,
              Q L1 A W DAT X XY SX F G M H I J L K RPT
              cics_comp cics_opt sql_opt,
              O1 O2 O3 O4 O5 O6 O7 O8 O9 O10 O11 O12 O13 O14 O15,
              ddclib1 clib1 ddclib2 clib2 ddclib3 clib3,
              ddclib4 clib4 ddclib5 clib5 ddclib6 clib6,
              apost apost_str quote_str delm opt_string              */
   signal on NOTREADY NAME opt_EOF
   line.51 = ""
   do i = 1 to 51
      line.i = linein(optctmp)
   end /* do */
   opt_EOF:
      signal off NOTREADY
      if i < 51 then do
         retcd = rerroptf
         retfile = optctmp
         call Abend
      end  /* Do */
      rc = stream(optctmp, "c", "close")
      /* say  optctmp " closed; rc = " rc */
  if trace_flag = 1 then call lineout tracef, optctmp||" file closed; rc = "||rc
      /* Options needed for every Converted file */
      /* input dataset */
      Parse Value line.1  with . "'" source    "'" .
      /* output dataset */
      Parse Value line.2  with . "'" target    "'" .
      /* output copy lib */
      Parse Value line.3  with . "'" targetlib "'" .
      /* type of conversion OSVS or DOSVS */
      Parse Value line.4  with . "'" ABJCONV1  "'" .
      /* copy libraries */
      Parse Upper Value line.5  with . "'" ddclib1  "'" .
      Parse Upper Value line.6  with . "'" clib1    "'" .
      Parse Upper Value line.7  with . "'" ddclib2  "'" .
      Parse Upper Value line.8  with . "'" clib2    "'" .
      Parse Upper Value line.9  with . "'" ddclib3  "'" .
      Parse Upper Value line.10 with . "'" clib3    "'" .
      Parse Upper Value line.11 with . "'" ddclib4  "'" .
      Parse Upper Value line.12 with . "'" clib4    "'" .
      Parse Upper Value line.13 with . "'" ddclib5  "'" .
      Parse Upper Value line.14 with . "'" clib5    "'" .
      Parse Upper Value line.15 with . "'" ddclib6  "'" .
      Parse Upper Value line.16 with . "'" clib6    "'" .

      /* Options that specialized for each converted file */
      /* literal delimiter: don't need anymore */
      Parse Value line.17 with . "'" Q  "'" .
      /* input language level */
      Parse Value line.18 with . "'" L1 "'" .
      /* output language level */
      Parse Value line.19 with . "'" A "'" .
      /* line count */
      Parse Value line.20 with . "'" W  "'" .
      /* date format */
      Parse Value line.21 with . "'"DAT "'" .
      /* resequencing */
      Parse Value line.22 with . "'" X  "'" .
      /* Increment */
      Parse Value line.23 with . "'" XY "'" .
      /* reserved word suffix */
      Parse Value line.24 with . "'" SX "'" .
      /* generate new program */
      Parse Value line.25 with . "'" F  "'" .
      /* generate new copy */
      Parse Value line.26 with . "'" G  "'" .
      /* replace like-named copy mbr */
      Parse Value line.27 with . "'" M  "'" .
      /* print reference source line */
      Parse Value line.28 with . "'" H  "'" .
      /* print copy module  psw 2-11-97 */
      /* Parse Value line.29 with . "'" ICPY "'" .   */
      Parse Value line.29 with . "'" ICPY "'" .
      /* level diagnostic */
      Parse Value line.30 with . "'" J  "'" .
      /* Heading */
      Parse Value line.31 with . "'" L  "'" .
      /* debug mode */
      Parse Value line.32 with . "'" K "'" .
      /* option 1 */
      Parse Value line.33 with . "'" O1 "'" .
      /* option 2 */
      Parse Value line.34 with . "'" O2 "'" .
      /* option 3 */
      Parse Value line.35 with . "'" O3 "'" .
      /* option 4 */
      Parse Value line.36 with . "'" O4 "'" .
      /* option 5 */
      Parse Value line.37 with . "'" O5 "'" .
      /* option 6 */
      Parse Value line.38 with . "'" O6 "'" .
      O6 = 'N'   /* should set this to N foreground conversion */
      /* option 7 */
      Parse Value line.39 with . "'" O7 "'" .
      /* option 8 */
      Parse Value line.40 with . "'" O8 "'" .
      /* option 9 */
      Parse Value line.41 with . "'" O9 "'" .
      /* option 10*/
      Parse Value line.42 with . "'" O10"'" .
      /* option 11*/
      Parse Value line.43 with . "'" O11"'" .
      /* option 12*/
      Parse Value line.44 with . "'" O12"'" .
      /* option 13*/
      Parse Value line.45 with . "'" O13"'" .
      /* option 14*/
      Parse Value line.46 with . "'" O14"'" .
      /* option 15*/
      Parse Value line.47 with . "'" O15"'" .
      /* Generate 6 reports */
      Parse Value line.48 with . "'"RPT "'" .
      /* CICS compiler given */
      Parse Value line.49 with . "'" cics_comp "'" .
      /* CICS options thats used for CICS given */
      Parse Value line.50 with . "'" cics_opt "'" .
      /* SQL options thats used for having DB2 cmds */
      Parse Value line.51 with . "'" sql_opt "'" .

      srcfspec = Strip(source)
      tgtfspec = Strip(target)
      ABJCONV1 = Strip(ABJCONV1)
      ddclib.1  = Strip(ddclib1)
      clib.1    = Strip(clib1)
      ddclib.2  = Strip(ddclib2)
      clib.2    = Strip(clib2)
      ddclib.3  = Strip(ddclib3)
      clib.3    = Strip(clib3)
      ddclib.4  = Strip(ddclib4)
      clib.4    = Strip(clib4)
      ddclib.5  = Strip(ddclib5)
      clib.5    = Strip(clib5)
      ddclib.6  = Strip(ddclib6)
      clib.6    = Strip(clib6)

      call SaveCopyPaths

      Q   = Strip(Q);   L1  = Strip(L1);  A   = Strip(A)
      W   = Strip(W);   DAT = Strip(DAT); X   = Strip(X)
      XY  = Strip(XY);  SX  = Strip(SX);  F   = Strip(F)
      G   = Strip(G);   M   = Strip(M);   H   = Strip(H)
      /*I   = Strip(I);   J   = Strip(J);   L   = Strip(L) */
      ICPY= Strip(ICPY); J   = Strip(J);  L   = Strip(L) /*  psw 2-11-97 */
      K   = Strip(K);   O1  = Strip(O1);  O2  = Strip(O2)
      O3  = Strip(O3);  O4  = Strip(O4);  O5  = Strip(O5)
      O6  = Strip(O6);  O7  = Strip(O7);  O8  = Strip(O8)
      O9  = Strip(O9);  O10 = Strip(O10); O11 = Strip(O11)
      O12 = Strip(O12); O13 = Strip(O13); O14 = Strip(O14)
      O15 = Strip(O15); RPT = Strip(RPT)

      cics_comp = Strip(cics_comp)  /* 1,OSVS | 2, COBII | 3,CB370 | 4,NOCIC */
      cics_opt  = Strip(cics_opt)   /* value is Y,O,N  note D value is PTFd */
      sql_opt = Strip(sql_opt)    /* value is Y,N */
      /* If options file does not have sql_opt (PTF) */
      if cics_opt == "D" then sql_opt = "Y"
      else if sql_opt == "" then sql_opt = "N"

      LOPTION = L1 /* based on panel ABJDRIS2 or ABJDRISL */

      Call InterpretOption
      /* parm list changed to sync  12/20/96 jph */
      /* parm_string = "0,"||LOPTION||","||cics_opt||","||sql_opt||","||"MVS,"||"0,0,0,0,"||testflag */
      /*  03/98  incorporate VSE */

      parm_string = "0,"||LOPTION||","||cics_opt||","||sql_opt||","||mvs_vse||","||"0,0,0,"||testflag


               /*    H||delm||I||delm||J||delm||L||delm||K||delm||,   */
      opt_string = Q||delm||lang_in||delm||ansy_in||delm||ansy_out||delm||,
                   W||delm||DAT||delm||,
                   X||delm||XY||delm||SX||delm||F||delm||G||delm||M||delm||,
                   H||delm||ICPY||delm||J||delm||L||delm||K||delm||,
                   O1||delm||O2||delm||O3||delm||O4||delm||O5||delm||,
                   O6||delm||O7||delm||O8||delm||O9||delm||O10||delm||,
                   O11||delm||O12||delm||O13||delm||O14||delm||O15||delm
                   /* psw 2-11-97 */
Return parm_string


/*-----< SaveCopyPaths >--------------------------------*/
/*  save ddname=clibpath to shared pool                 */
/*------------------------------------------------------*/
SaveCopyPaths:
   if ddclib.1 == "" | clib.1 == "" then return 20
   clibct = clibct + 1
   ddclibr.1 = ddclib.1
   clibr.1 = clib.1
   do i = 2 to 6
      ddc = ddclib.i
      cl = clib.i
      if cl = ""  then leave
      else
         if ddc == "" then  clibr.clibct = clibr.clibct || ";" || cl
         else do
            dup_index = dup_ddn(i)  /* dup_index sets to ddname(dup), else 0 */				
            if dup_index <> 0 then clibr.dup_index = clibr.dup_index || ";" || cl
            else do
               clibct = clibct + 1
               ddclibr.clibct = ddc
               clibr.clibct = cl
            end /* do */
         end /* do */
   end /* do */
   do i = 1 to clibct
      call ispexec "VPUT", ddclibr.i, clibr.i
   end /* do */
   return


/*-----< dup_ddn >--------------------------------------*/
/* Find the index of the ddname that is already defined */
/*------------------------------------------------------*/
dup_ddn:
   do idx = 1 to clibct  /* find first duplicate ddname */
     if ddc == ddclibr.idx then return idx
   end /* do */
   return 0 /* dup not found */


/*-----< DeleteClibs >----------------------------------*/
/*  delete ddname=clibpaths records from shared pool    */
/*------------------------------------------------------*/
DeleteClibs:
   if clibct = 0 then return
   del_call = "ispexec('VDELETE'"
   do i = 1 to clibct
      del_call = del_call || ", " || "ddclibr." || i
   end /* do */
   del_call = del_call||");"
   /* interpret "del_call" */
   interpret "rc = "del_call
   return

/*-< InterpretOption >-----------------------------------------------*/
/*                                                                   */
/*-------------------------------------------------------------------*/
InterpretOption:

   /* input language level */
   /* Determin lang_in and ansy_in value is based on L1 */
   /* determine ansy_in and lang_in based on COBOL program ABJOPT1 */
   /* determine ABJCONV1 and ABJCONV based on panel ABJCVOP1 */
   Select
   When L1 = "1" then
      Do
         ansy_in  = "ANS68"
         lang_in  = "DOS/VS"
         ABJCONV1 = "DOSVS"
         ABJCONV  = "DOS/VS"
      End
   When L1 = "2" then
      Do
         ansy_in  = "ANS68"
         lang_in  = "OS/VS "
         ABJCONV1 = "OSVS"
         ABJCONV  = "OS/VS"
      End
   When L1 = "3" then
      Do
         ansy_in  = "ANS74"
         lang_in  = "OS/VS "
         ABJCONV1 = "OSVS"
         ABJCONV  = "OS/VS"
      End
   When L1 = "4" then
      Do
         ansy_in  = "COBII"
         lang_in  = "COBII "
         ABJCONV1 = "COBII"
         ABJCONV  = "COBII"
      End
   When L1 = "5" then
      Do
         ansy_in  = "COBII"
         lang_in  = "COBII3"
         ABJCONV1 = "COBII3"
         ABJCONV  = "COBII3"
      End
   When L1 = "6" then
      Do
         ansy_in  = "ANS85"
         lang_in  = "COBII3"
         ABJCONV1 = "COBII3"
         ABJCONV  = "COBII3"
      End
   Otherwise
      Do
         ansy_in  = "ANS85"
         lang_in  = "COBII3"
         ABJCONV1 = "COBII3"
         ABJCONV  = "COBII3"
      End
   End /* select */
/*****>>   Address ISPEXEC "VPUT (ABJCONV,ABJCONV1) PROFILE"
   Address ISPEXEC "VPUT (ABJCONV,ABJCONV1) SHARED"      <<*****/
   call ispexec "VPUT", "ABJCONV", ABJCONV,  "ABJCONV1", ABJCONV1
   /* output language level */
   /* 3/98 incoporate VSE, output language level = 3 if VSE  */
   If mvs_vse = "VSE" then A = "3"      /* for VSE           */
   If A = "1" then do
      ansy_out = "COBII"
   End
   Else do
      ansy_out = "CB370"
   End

   /* cics options  */ /* VS COBOL II */
   If LOPTION > "3" then do
      cics_opt = "N"
   End

   /* cics compiler */
   if cics_comp \= 0 then
      ABJCOB = "WSCOB"
   else
      ABJCOB = "NOCIC"

   /* Option 6: Post Conversion Compile */
   /* We don't need this option in foreground conversion */
   /*------ ABJOPT6 = O6
   If ABJOPT6 = "" then
      ABJOPT6 = "Y"
      Address ISPEXEC "VPUT (ABJOPT6) PROFILE"
      Address ISPEXEC "VPUT (ABJOPT6) SHARED"
   -------*/

   /* set ABJBUG to default value */
   ABJBUG = "NODEBUG"
/*****>>
   Address ISPEXEC "VPUT (ABJBUG) PROFILE"
   Address ISPEXEC "VPUT (ABJBUG) SHARED"
<<*****/
   call ispexec "VPUT", "ABJBUG", ABJBUG

Return



/*-< SetMiscOS2 >----------------------------------------------------*/
/*   Set environ variables for conversion.                           */
/*-------------------------------------------------------------------*/
SetMiscOS2:

   parse value filespec("name", srcfspec) with member "." ext

   /* "ABJNVPR" qualifier changed to "ECFCWORK" */
   /* linklist = ECFCWORK||"\LINKLIST.ABJ"<<---find out who uses this */
   /* flid     = ECFCWORK||"\"||member||".LST" <<---find out who uses this */
   flidb1   = ECFCWORK||"\DEBUG1.DAT"
   flidb2   = ECFCWORK||"\DEBUG2.DAT"
   "SET SOURCE="||srcfspec
   "SET TMPSRC="||ECFCWORK||"\TMPSRC.DAT"
   "SET POINTER="||ECFCWORK||"\POINTER.DAT"
   "SET NEWSRC="||tgtfspec
   "SET NEWCPYP="||targetlib
   "SET CELLOUT="||ECFCWORK||"\CELLOUT.DAT"
   "SET RECDD="||ECFCWORK||"\CELLOUT.DAT"
   "SET BLLDD="||ECFCWORK||"\BLLOUT.DAT"
   "SET COPYBOOK="||ECFCWORK||"\COPYBOOK.ABJ"
   "SET NEWCPYBK="||ECFCWORK||"\COPYBOUT.ABJ"
   "SET SYSPRT1="||sysprt1
   "SET SYSPRT2="||sysprt2
   "SET SYSPRT3="||sysprt3
   "SET LITDELIM="||ECFCWORK||"\CBLCARD.ABJ" /* ABJPASS1 uses this */

   /* "ABJNSPR" qualifier changed to "ECFCWORK" */
   "SET CHANGE="||ECFCWORK||"\CHANGE.ABJ"
   "SET WORK="||ECFCWORK||"\DRWORK.ABJ"
   /* "SET MESSAGE="||ECFCWORK||"\ABJMSG.VSM" <<---find out who uses this */
   "SET TOKEN="||ECFCWORK||"\TOKEN.ABJ"

   /* "ABJVSSH" qualifier changed to "ECFCPATH" */
   if share_flag = 0 then do
      "SET TABLE="||ECFCPATH||"\ABJRTBL.VSM"
      "SET MESSAG="||ECFCPATH||"\ABJMSG.VSM"
      "SET DRIVEN="||ECFCPATH||"\ABJDRVN.VSM"   
   end
   else do 
     "SET TABLE="||ECFLOCAL||"\ABJRTBL.VSM"
     "SET MESSAG="||ECFLOCAL||"\ABJMSG.VSM"
     "SET DRIVEN="||ECFLOCAL||"\ABJDRVN.VSM"
   end 
   /*  03/98 incorporate VSE */
   if mvs_vse = "VSE" then do
     if share_flag = 0 then do 
       "SET MESSAG="||ECFCPATH||"\ABJXMSG.VSM"  
     end
     else do 
       "SET MESSAG="||ECFLOCAL||"\ABJXMSG.VSM"
     end
   end


Return


/*-< WriteOptions >--------------------------------------------------*/
/*                                                                   */
/*-------------------------------------------------------------------*/
WriteOptions:
   RC = 0
   "SET CONTROL="||ECFCWORK||"\ABJCNTL.VSM"
   opt_string = con_char || opt_string
   /* Write the user option to VSAM dataset CONTROL.KSDS */
   /* Say "Writing options into CONTROL VSAM dataset:"   */
   /*   Address ISPEXEC "SELECT PGM(ECFOPT2) PARM("opt_string")"  */
   /* "ECFOPT2 " opt_string                 ==> 3/98 exec full path */
   pgmexe = ECFCPATH||"\ECFOPT2.EXE"
   pgmexe opt_string
   /*  end ECFOPT2 */
   RC2 = RC
   /* SAY result rc RC    */
   if trace_flag = 1 then call lineout tracef, "ECFOPT2(rc) = "RC2
   if RC2 <> ok then do
      retfile = "ECFOPT2"
      If RC2 = openrc then do
         retcd = openerr
         End
      Else do
         If RC2 = keyrc then do
            retcd = keyerr
            End
         Else do
            retcd = rwerr
            End
      End
      call Abend
   End /* if rc not ok */
Return


/*-< CheckCICS  >----------------------------------------------------*/
/*  Invoke ABJLINKs when CICS Conversion option set to Y or D        */
/*-------------------------------------------------------------------*/
CheckCICS:
   RC = 0
   RC2 = 0
   If cics_opt = 'Y'| cics_opt = 'D' then do
      call SetStatus(pif "1")
   /*   "SET SYSOUT="||sysout  1/16/97 psw delete to fix write .CRS prt */
      "SET SYSOUT="||sysout  /* 3/19/97 psw to fix lost critical msgs */
      "SET IEBCALEN="||ECFCWORK||"\IEBCALEN.ABJ"
      "SET LINKAGE="||ECFCWORK||"\DB2PREIN.CBL"
      "SET CBLCARD="||ECFCWORK||"\CBLCARD.ABJ"
      /* execute ABJLINK1.EXE - process the linkage section */
      /* "ABJLINK1 " || LOPTION || "," || ABJCOB || ",0\ "  ==> full path */
      pgmexe = ECFCPATH||"\ABJLINK1.EXE"
      pgmexe LOPTION || "," || ABJCOB || ",0\ "
      /*  end ABJLINK1 */

      RC2 = RC
      if trace_flag = 1 then call lineout tracef, " ABJLINK1(rc) = " RC2
      If RC2 > 4 then do
         retcd = RC2 + lnk1errb
         retfile = "ABJLINK1"
         Call Abend
         /* error return */
      End
      Call CheckDB2
      /* invoke IBMCOB compiler */
      curdir = directory()     /* save current directory */
      Call directory ECFCWORK  /* point to TMP directory */
      cob_opts = "S LIB MAP NOLIST NOTEST NOVBREF NOXREF NOSEQ NOADATA NOTERM"
      sysin    = ECFCWORK||"\DB2PREIN.CBL"
      /* "COB2 -q"""||cob_opts||""" -c "||sysin  */
      copy_opts = " "
      do i = 1 to 6          /*    2/07/97 jph test copylibs in cics  */
          tlib = clib.i
          if tlib = "" then leave
          else do
            tmp_opts = "-i"||clib.i
            tmp_opts = " "||tmp_opts
            copy_opts = copy_opts||tmp_opts
          end
      end  /*   do */
      /* "COB2 -q"""||cob_opts||""""||copy_opts||" -c "||sysin    */
      /*  3/18/97 jph  set comprc_ok instead of using default     */
        "COB2 -comprc_ok=2 -q"""||cob_opts||""""||copy_opts||" -c "||sysin

          RC2 = RC
      if trace_flag = 1 then call lineout tracef, " IGYCCOB2(rc) = " RC2
      Call directory curdir
      If RC2 > 4 then do
         retcd = RC2 + comperrb
         retfile = "IBMCOBOL"
         Call Abend  /* may need to issue ERROR06 */
         /* error return */
      End

      /* set up the call to ABJLINK2 - process BLL-Cells */
      cellout = ECFCWORK||"\CELLOUT.DAT"
      "SET MAP="||ECFCWORK||"\DB2PREIN.LST"
      "SET BLLOUT="||ECFCWORK||"\BLLOUT.DAT"
      "SET CELLOUT="||cellout

      /* set up for calling ABJPASS0 - CCCA engine later */
      "SET RECDD="||cellout

      /* Address ISPEXEC "SELECT PGM(ABJLINK2) PARM(&ABJCOB 0)"  */
      /* "ABJLINK2 " || ABJCOB || ",0\"    ==> 03/98 exec full path */
      pgmexe = ECFCPATH||"\ABJLINK2.EXE"
      pgmexe ABJCOB || ",0\"
      /*  end ABJLINK2 */
      RC2 = RC
      if trace_flag = 1 then call lineout tracef, " ABJLINK2(rc) = " RC2
      If RC2 > 4 then do
         retcd = RC2 + lnk2errb
         retfile = "ABJLINK2"
         Call Abend  /* issue ERROR05 */
         /* error return */
      End
   End
   "set SYSOUT="  /* 3/19/97 psw to fix lost critical msgs */
Return RC2  /*  RC2 not greater than 4  */


/*-< CheckDB2   >----------------------------------------------------*/
/*  Invoke DB2 preprocessor for programs that contain DB2 SQL cmds.  */
/*-------------------------------------------------------------------*/
CheckDB2:

   RC = 0
   RC2 = 0
   if sql_opt = "Y" then do
      "REN "||ECFWORK||"\DB2PREIN.CBL *.SQB"
      sysin = ECFWORK||"\DB2PREIN.SQB"
      dbrmlib = "DBRMLIB.DAT"  /* ??? */
      /* MERGE LITDELIM with DB2PREIN as sysin */
      Call Merge_infiles  /*****  to do  *****/
      /* Invoke DB2 preprocessor */
      /* Address ISPEXEC "SELECT PGM() ",
            "PARM("LOPTION" "ABJCOB" SIZE(MAX) BUF(004K)\)" */
      "DB2 'CONNECT TO your_DB_name'"   /* ??? */
      RC2 = RC
      If RC2 > 4 then do
         retcd = RC2 + db2perrb
         retfile = "DB2PREPROC"
         Call Abend
         /* error return */
      End
      "DB2 'PREP " sysin "MESSAGES "sysout "TARGET IBMCOB'"  /* ??? */
      /* Output should be DB2PREIN.CBL */
      RC2 = RC
      If RC2 > 4 then do
         retcd = RC2 + db2perrb
         retfile = "DB2PREPROC"
         Call Abend
         /* error return */
      End
   end  /* Do */
Return RC2



/*-< Merge_Infiles >----------------------------------------------*/
/*  Merge the input files LITDELM.ABJ and DB2PREIN.CBL into       */
/*  DB2PREIN.SQB to allow correct preprocessing.                  */
/*----------------------------------------------------------------*/
Merge_Infiles:

   /* say "Need to do this once DB2 preprocessing is understood !" */
Return


/*-< ConvertPgm >-------------------------------------------------*/
/*    Convert the program and                                     */
/*    Generate reports as requested AND exist.                    */
/*----------------------------------------------------------------*/
ConvertPgm:

   RC = 0
   "erase " sysout            /*  1/16/97 psw fix write .CRS  */
   /* Now let us invoke the CCCA Facility */
   /* Say "Invoking CCCA engine:" */
   optstr = member || ',' || optstr
   if trace_flag = 1 then call lineout tracef, "Invoking CCCA engine; parms= "||optstr
   retfile = "ABJPASS0"
   /* Address ISPEXEC "SELECT PGM(ABJPASS0) PARM("optstr")" */
   /*    "idbug ABJPASS0 " || optstr                              */
   /* " ABJPASS0 " || optstr             ==> 03/98 exec full path */
   pgmexe = ECFCPATH||"\ABJPASS0.EXE"
   pgmexe optstr
   /*  end ABJPASS0 */                                     retcd = RC
   if trace_flag = 1 then call lineout tracef, " ABJPASS0(rc) = " RC
   /* Say 'CCCA return code was ' RC */
   if (0 <= retcd) & (retcd <= 8) then do
      if (RPT = yes) then do
         /* Say 'Generating reports' */
         if trace_flag = 1 then call lineout tracef, " Gen reports started."
         "SET CONTROL="||ECFCWORK||"\ABJCNTL.VSM"
         "SET CONTRLB="||ECFCWORK||"\ABJCNTL.VSM"
         do i = 1 to 6
            "erase "||ECFCWORK||"\ECFCCCA.AB"||i
         end /* do */
         /* Generate Program/File Report */
         /* Call AllocPDSReport 'LISTP' ABJNVPR'.PROGREP.LIST' '133' qsysattr */
         "SET LISTP="||ECFCWORK||"\ECFCCCA.AB1"
         /* Address ISPEXEC "SELECT PGM(ABJLISTP)" */
         /* "ABJLISTP"                         ==> 03/98 exec full path */
         ECFCPATH||"\ABJLISTP.EXE"
         /* Generate File/Program Report */
         /* Call AllocPDSReport "LISTF" ABJNVPR".FILEREP.LIST" '121' dbg1attr */
         "SET LISTF="||ECFCWORK||"\ECFCCCA.AB2"
         /* Address ISPEXEC "SELECT PGM(ABJLISTF)" */
         /* "ABJLISTF"                         ==> 03/98 exec full path */
         ECFCPATH||"\ABJLISTF.EXE"
         /* Generate Copy/Program Report */
         /* Call AllocPDSReport "LISTC" ABJNVPR".COPYRP1.LIST" '121' dbg1attr */
         /* Address ISPEXEC "SELECT PGM(ABJLISTC)" */
         "SET LISTC="||ECFCWORK||"\ECFCCCA.AB3"
   if trace_flag = 1 then call lineout tracef, " files reporting finished, status will be set to 6 "
         call SetStatus(pif "6")
         /* "ABJLISTC"                         ==> 03/98 exec full path */
         ECFCPATH||"\ABJLISTC.EXE"
         /* Generate Program/Copy Report */
         /* Call AllocPDSReport "LSTPC" ABJNVPR".COPYRP2.LIST" '121' dbg1attr */
         /* Address ISPEXEC "SELECT PGM(ABJLSTPC)" */
         "SET LSTPC="||ECFCWORK||"\ECFCCCA.AB4"
         /* "ABJLSTPC"                         ==> 03/98 exec full path */
         ECFCPATH||"\ABJLSTPC.EXE"
         /* Generate Call/Program Report */
         /* Call AllocPDSReport "LISTCA" ABJNVPR".CALLRP1.LIST" '121' dbg1attr */
         /* Address ISPEXEC "SELECT PGM(ABJLSTCA)" */
         "SET LISTCA="||ECFCWORK||"\ECFCCCA.AB5"
   if trace_flag = 1 then call lineout tracef, " copy members reporting finished, status will be set to 7 "
         call SetStatus(pif "7")
         /* "ABJLSTCA"                         ==> 03/98 exec full path */
         ECFCPATH||"\ABJLSTCA.EXE"
         /* Generate Program/Call Report */
         /* Call AllocPDSReport "LISTCA" ABJNVPR".CALLRP2.LIST" '121' dbg1attr */
         /* Address ISPEXEC "SELECT PGM(ABJLSTCB)" */
         "SET LISTCB="||ECFCWORK||"\ECFCCCA.AB6"
         /* "ABJLSTCB"                         ==> 03/98 exec full path */
         ECFCPATH||"\ABJLSTCB.EXE"

      end /* do */
   end  /* IF */
   /* display the sysprt3.abj file prior to issuing success message */
   if trace_flag = 1 then call lineout tracef, " all reporting finished, status will be set to 8"
   call SetStatus(pif "8")
Return

/*-< WriteCRSFile >--------------------------------------------------*/
/*                                                                   */
/* Copy the SYSPRTx.ABJ file to the member.CRS file                  */
/*-------------------------------------------------------------------*/
WriteCRSFile:
/* say "I should be creating file " ECFCWORK||"\"||member||".CRS" */
call lineout tracef, "I should be creating file " ECFCWORK||"\"||member||".CRS"
/* Check which SYSPRTx.ABJ file was created */
crsfile = ECFCWORK || "\" || member || ".CRS"
rc = stream(crsfile, "c", "query exists")
if rc \== "" then do
   say "Erasing old " crsfile
   "erase " crsfile
end  /* Do */
/* ONLY ONE OF THE FOLLOWING FOUR SHOULD EXIST */
copyfrom = ""  /*  psw 02/19/97  */
rc = stream(sysprt1, "c", "query exists")
/* if rc \== "" then do   jph 03/18/97   */
if rc \== "" & copyfrom = "" then do
   say "Creating " crsfile "from " sysprt1
   copyfrom = sysprt1
end  /* Do */
rc = stream(sysprt2, "c", "query exists")
if rc \== "" & copyfrom = "" then do            /* only if copyfrom is not exist */
   say "Creating " crsfile "from " sysprt2
   copyfrom = sysprt2
end  /* Do */
rc = stream(sysprt3, "c", "query exists")
if rc \== "" & copyfrom = "" then do            /* only if copyfrom is not exist */
   say "Creating " crsfile "from " sysprt3
   copyfrom = sysprt3
end  /* Do */
rc = stream(sysout, "c", "query exists")
if rc \== "" & copyfrom = "" then do            /* only if copyfrom is not exist */
   say "Creating " crsfile "from " sysout
   copyfrom = sysout
end  /* Do */
if copyfrom == "" then return        /*  psw 02/19/97  */
rc = stream(copyfrom, "c", "close")  /* close file first */
copyto = crsfile
aline = ""
signal on NOTREADY NAME abj_EOF
do forever
  aline = linein(copyfrom)
  call lineout copyto, aline
end /* do forever */
abj_EOF:
rc = stream(copyfrom, "c", "close")  /* close after reading */
rc = stream(copyto, "c", "close")

Return


/*-< Abend >---------------------------------------------------------*/
/*  Abend error exits:                                               */
/*        Abend is due to user/environment error while converting.   */
/*        NOVALUE is usually due to corrupted ECFSCPC command file.  */
/*-------------------------------------------------------------------*/
Abend:

  /* say 'Allocation error - exit.'
     Say "End of CICS/VS Command Level Conversion Aid Processing" */
  rc = "RETCD="retcd" "retfile       /* message for workstation */
  if trace_flag = 1 then call lineout tracef, " Abnormal error occurred - "||rc
  "set SYSOUT="  /* 3/19/97 psw to fix lost critical msgs */
  if retcd > lnk1errb then do
     select
        when (retcd < lnk2errb) & (retcd > lnk1errb) then do
           rc = retcd - lnk1errb
           insert = "Error occurred creating dummy BLL calculation program, rc = "
        end  /* Do */
        when (retcd < comperrb) & (retcd > lnk2errb) then do
           rc = retcd - lnk2errb
           insert = "Error occurred in BLL calculation program, rc = "
        end  /* Do */
        when (retcd < db2perrb) & (retcd > comperrb) then do
           rc = retcd - comperrb
           insert = "Error occurred compiling dummy BLL calculation program, rc = "
        end  /* Do */
        when retcd > db2perrb then do
           rc = retcd - db2errb
           insert = "Error occurred preprocessing dummy BLL calculation program, rc = "
        end  /* Do */
     end  /* select */

     call lineout sysout, insert rc
     call SetStatus(pif "8")
     /* display error output file until dismissed */
     call lineout tracef, "Calling WriteCRSFile"
     Call WriteCRSFile
     exit retcd
  end  /* Do */
  rc = stream(pif, "c", "query exists")
  if rc <> "" then "erase "pif
  call lineout tracef, "Calling WriteCRSFile"
  Call WriteCRSFile
  exit retcd

NOVALUE:
  if trace_flag = 1 then call lineout tracef, "NOVALUE: "||RC
  /*  exit SIGL  */
  rc = stream(pif, "c", "query exists")
  if rc <> "" then "erase "pif
  call lineout tracef, "Calling WriteCRSFile"
  Call WriteCRSFile
  exit noverr

SetStatus: procedure expose cancf
   arg pif status
   /* Process cancellation 5/96 psw */
   rc = stream(cancf, "c", "query exists")
   if rc == "" then do  /* user cancelled process */
      "erase " pif
      exit 999
   end /* do */
   do until rc2 == "READY:"
      rc2 = stream(pif, "c", "open")
      /* if rc2 <> "READY:" then "ecfdelay"   */ 
      if rc2 <> "READY:" then ECFCPATH||"\ecfdelay.exe" 
      else do
         call lineout pif, strip(status)
         rc = stream(pif, "c", "close")
      end  /* Do */
   end /* do */
return


/*  Check input source file which should have record */
/*  less than 80 char                                */
CheckSource:

   signal on NOTREADY NAME source_EOF
   sourcefile = srcfspec
   sline = ""

  do forever
    anytext = ""
    sline = linein(sourcefile)
    anytext = substr(sline,81)
    if anytext \= " " then do
       insert = "Error occurred reading source file, line length exceeds column 80, rc = "
       call lineout sysout, insert srcerr
       rc = stream(sysout, "c", "close")
       signal off NOTREADY
       retcd = srcerr
       retfile = srcfspec
       call Abend
    end
 end /* do forever */

 source_EOF:
      signal off NOTREADY
      rc = stream(sourcefile, "c", "close")
      rc = stream(srcfspec, "c", "close")

return

