/*-------------------------------------------------------*/
/* ARDSETUP.CMD                                          */
/* REXX file to setup ARD database                       */
/* 2/27 S.Shafazand updated the copyright year           */
/*-------------------------------------------------------*/

/*********************************************************
* IBM Application Understanding      Version 1 Release 2 *
**********************************************************
*                                                        *
* Licensed Materials - Property of IBM                   *
* 5639-B92                                               *
* (C) Copyright IBM Corp. 1996, 1997, 1998               *
*                                                        *
**********************************************************/
'@ECHO OFF'
arg migrate recreate create bind sample ipdrive rest;

if migrate = 'Y' then migrate = 'y';
if recreate = 'Y' then recreate = 'y';
if create = 'Y' then create = 'y';
if bind = 'Y' then bind = 'y';
if sample = 'Y' then sample = 'y';

/*------- Translate the following 15 lines  (between '  ')      */
line1 = ' ******************************************************'
line2 = ' ******************************************************'
line3 = ' ************       ERROR       ************           '
line4 = '                                                       '
line5 = '  Unable to start DB2/2.                               '
line6 = '  Application Understanding requires DB2/2 Version 2.1.'
line7 = '  You must have DB2/2 installed before you run         '
line8 = '  Application Understanding.                           '
line9 = '                                                       '
line10 ='  Application Understanding Setup can not be run until '
line11 ='  DB2/2 is installed.                                  '
line12 =' ******************************************************/'
line13 ='                                                       '
line14 ='  Press enter to exit setup.                             '
line15 ='Application Understanding directory is  '

aureturncode = 'OS2ENVIRONMENT'
xx = value('ARDSETUP', 0, aureturncode)

redeveloper = 'OS2ENVIRONMENT'
bindir = VALUE('CMWPATH',,redeveloper)

installPath = bindir || "\BIN;";
aulibpath = 'OS2ENVIRONMENT'
xxx = value('BEGINLIBPATH',installPath,aulibpath);
say line15 || installPath

db2installpath = 'OS2ENVIRONMENT'
db2path = value('DB2PATH', ,db2installpath)

/***************************/
/* Can DB2/2 be started ?  */
/***************************/
if db2path = ""  then saverc = 12;
else do;
  call ardcmd2
  saverc = value('ARDSETUP',  , aureturncode)
end;

if saverc = 0;
 /******************************************/
 /*  DB2 is installed - proceed            */
 /******************************************/
 then do
  ardimain migrate recreate create bind sample ipdrive rest;
 end;
 else do;
   say line1
   say line2
   say line3
   say line4
   say line5
   say line6
   say line7
   say line8
   say line9
   say line10
   say line11
   say line12
   say line13
   say line14
   Pull first;
 end;

address cmd "exit"
exit;
