/*--< Start of Specifications >--------------------------------------*/
/*                                                                   */
/* Program Name: ABJCREAT                                            */
/*                                                                   */
/* Descriptive Name:  CONVERSION AID VSAM file creation command      */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */
/*                                                                   */
/* 5639-B92 (C) Copyright IBM Corp. 1996, 1997                       */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/* See Copyright Instructions.                                       */
/*                                                                   */
/* Status = Version 1 Release 1 Level 0                              */
/*                                                                   */
/* Function:                                                         */
/* CREATES AND COPIES COVERSION REQUIRED .VSM FILES TO \BIN AND \TMP */
/*                                                                   */
/* Input:                                                            */
/*                                                                   */
/*   Description: none                                               */
/*                                                                   */
/* Output:                                                           */
/*                                                                   */
/*   Description: none                                               */
/*                                                                   */
/* Normal Exit Conditions:                                           */
/*                                                                   */
/* Error Exit Conditions:                                            */
/*                                                                   */
/* Messages:                                                         */
/*                                                                   */
/* External References:                                              */
/*                                                                   */
/*   Routines: ABJCRCTL, ABJCRDRV, ABJCRMSG, ABJCRTBL                */
/*                                                                   */
/*   Services:                                                       */
/*                                                                   */
/* Environment Variables:  CONTROL, SOURCE, SYSIN, OUTFILE           */
/*                         MESSAG, DRIVEN, TABLE                     */
/*                                                                   */
/*--< End of Specifications >----------------------------------------*/
/*                                                                   */
/* Change Activity                                                   */
/*                                                                   */
/*   03/14/97 jph  Copyright statement for release 4/97.             */
/*   10/15/97 jph  Incorporate VSE.                                  */
/*                                                                   */
/*--< End of specifications >----------------------------------------*/

/* localbin is for shared install.
   If a user is doing a full install, localbin and binpath will be
   same. */

arg localbin binpath tmppath dllpath garbage
"erase "||localbin||"\*.vsm"

/* CREATE A NEW CONTROL FILES */
"set CONTROL="||localbin||"\ABJCNTL.VSM"
"set SOURCE="||localbin||"\ABJRPCTL.SAM"
"set SYSIN="||localbin||"\ABJCRCTL.EDT"
"set BEGINLIBPATH="||dllpath
binpath||"\abjcrctl"
"erase "||localbin||"\ABJCRCTL.EDT"
"copy "||localbin||"\*abjcntl.vsm " ||tmppath

/* CREATE MESSAGE VSAM FILES */
"set MESSAG="||localbin||"\ABJMSG.VSM"
"set SOURCE="||localbin||"\ABJRPMSG.SAM"
"set OUTFILE="||localbin||"\ABJRPMSG.EDT"
binpath||"\abjcrmsg"
"erase "||localbin||"\abjrpmsg.edt"

/* CREATE DRIVEN VSAM FILES */
"set DRIVEN="||localbin||"\ABJDRVN.VSM"
"set SOURCE="||localbin||"\ABJRPDRV.SAM"
"set OUTFILE="||localbin||"\ABJRPDRV.EDT"
binpath||"\abjcrdrv"
"erase "||localbin||"\abjrpdrv.edt"

/* CREATE TABLE VSAM FILES */
"set TABLE="||localbin||"\ABJRTBL.VSM"
"set SOURCE="||localbin||"\ABJRPTBL.SAM"
"set OUTFILE="||localbin||"\ABJRTBL.EDT"
binpath||"\abjcrtbl"
"erase "||localbin||"\abjrtbl.edt"

/* CREATE MESSAGE VSAM FILES FOR "VSE" */
"set MESSAG="||localbin||"\ABJXMSG.VSM"
"set SOURCE="||localbin||"\ABJRXMSG.SAM"
"set OUTFILE="||localbin||"\ABJRXMSG.EDT"
binpath||"\abjcrmsg"
"erase "||localbin||"\abjrxmsg.edt"
