/*
 * This file communicates w/ SAMPLEDD.SYS to get at the BIOS data area that
 * contains the number of columns for the screen.
 *
 */

#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <conio.h>

#define SAMPLE_IOCTL_CATEGORY  0xE0
#define SAMPLE_IOCTL_FUNC_INIT 0xF0

char devName[] = "$SAMPDD";
short* columnCountPtr;

VOID int3( VOID );

  int
main( )
{
  HFILE dev;
  ULONG actionTaken, nBytes, devArgList;

  #define ESC 27
  int promptChar = 0;

  /* Open the device driver */
  if( DosOpen(devName, &dev, &actionTaken,
                   0,                    /* new file size */
                   0,                    /* new file attribute */
                   OPEN_ACTION_OPEN_IF_EXISTS,
                   OPEN_SHARE_DENYNONE + OPEN_FLAGS_NOINHERIT,
                   NULL)                 /* ext.attrib buffer NULL */

      )
      return( 1 );

  for( ; ; ) {
    printf( "\nType any char to DevIOCTL sampledd.sys.  Type ESC to quit.\n" );
    promptChar = getch( );
    if( promptChar == ESC )
      break;

    /* Get the address of the BIOS column count from the device */
    nBytes = sizeof(devArgList);
    if( DosDevIOCtl(dev, SAMPLE_IOCTL_CATEGORY, SAMPLE_IOCTL_FUNC_INIT,
                   (PVOID) &devArgList, nBytes, &nBytes, NULL, 0L, NULL)
      )
      return( 1 );


    /* Convert the returned 16:16 address to a 0:32 address */
    columnCountPtr = (VOID*)(
                     ((devArgList >> 19) << 16) | (devArgList & 0xFFFF) );
    printf( "\nDereference of returned ptr = %d", *columnCountPtr );
  }
  printf( "\n" );

  return( 0 );
}
