      PROCESS LIB                                                       CAL00010
      *************************************************************     CAL00020
      *                                                           *     CAL00030
      *    Licensed Material - Property of IBM                    *     CAL00040
      *                                                           *     CAL00050
      *    83H9095 (C) Copyright IBM Corp., 1996                  *     CAL00060
      *    All rights reserved                                    *     CAL00070
      *                                                           *     CAL00080
      *    US Government Users Restricted Rights - Use,           *     CAL00090
      *    duplication or disclosure restricted by GSA ADP        *     CAL00100
      *    Schedule Contract with IBM Corp.                       *     CAL00110
      *                                                           *     CAL00120
      *************************************************************     CAL00130
      * File CALCPRG  COBOL                                             CAL00140
       IDENTIFICATION DIVISION.                                         CAL00150
         PROGRAM-ID.    CALCPRG.                                        CAL00160
       ENVIRONMENT DIVISION.                                            CAL00170
       CONFIGURATION SECTION.                                           CAL00180
         SPECIAL-NAMES.                                                 CAL00190
            C01 IS NEW-PAGE.                                            CAL00200
       INPUT-OUTPUT SECTION.                                            CAL00210
         FILE-CONTROL.                                                  CAL00220
           SELECT INDATA-FILE                                           CAL00230
             ASSIGN TO INDATA.                                          CAL00240
           SELECT OUTDATA-FILE                                          CAL00250
             ASSIGN TO OUTDATA.                                         CAL00260
       DATA DIVISION.                                                   CAL00270
       FILE SECTION.                                                    CAL00280
       FD  INDATA-FILE                                                  CAL00290
           RECORDING MODE IS F                                          CAL00300
           BLOCK CONTAINS 0 RECORDS                                     CAL00310
           RECORD CONTAINS 196 CHARACTERS                               CAL00320
           LABEL RECORD IS STANDARD.                                    CAL00330
       01  INDATA-REC                        PIC X(196).                CAL00340
                                                                        CAL00350
       FD  OUTDATA-FILE                                                 CAL00360
           RECORDING MODE IS F                                          CAL00370
           BLOCK CONTAINS 0 RECORDS                                     CAL00380
           RECORD CONTAINS 196 CHARACTERS                               CAL00390
           LABEL RECORD IS STANDARD.                                    CAL00400
       01  OUTDATA-REC                        PIC X(196).               CAL00410
                                                                        CAL00420
       WORKING-STORAGE SECTION.                                         CAL00430
         01  FLAGS.                                                     CAL00440
             05 INDATA-EOF-FLAG               PIC X VALUE SPACES.       CAL00450
                88 INDATA-EOF VALUE 'Y'.                                CAL00460
                                                                        CAL00470
         COPY RECIN.                                                    CAL00480
         COPY RECOUT.                                                   CAL00490
                                                                        CAL00500
       LINKAGE SECTION.                                                 CAL00510
         COPY COMNDATA.                                                 CAL00520
                                                                        CAL00530
       PROCEDURE DIVISION USING COMNDATA.                               CAL00540
                                                                        CAL00550
                 DISPLAY 'CALCPRG MODULE BEGINS'.                       CAL00560
                 ACCEPT RUNDATE FROM DATE.                              CAL00570
                                                                        CAL00580
                 PERFORM 1000-INIT-PARA                                 CAL00590
                    THRU 1000-IP-EXIT.                                  CAL00600
                                                                        CAL00610
                 PERFORM 2000-PROCESS-PARA                              CAL00620
                    THRU 2000-PP-EXIT                                   CAL00630
                         WITH TEST BEFORE                               CAL00640
                              UNTIL INDATA-EOF.                         CAL00650
                                                                        CAL00660
                 PERFORM 3000-END-PARA                                  CAL00670
                    THRU 3000-EP-EXIT.                                  CAL00680
                                                                        CAL00690
                 DISPLAY 'CALCPRG MODULE ENDS. OLDONE = ' OLDONE.       CAL00700
                                                                        CAL00710
                 STOP RUN.                                              CAL00720
                                                                        CAL00730
       1000-INIT-PARA.                                                  CAL00740
                                                                        CAL00750
                 INITIALIZE FLAGS                                       CAL00760
                            COMNDATA                                    CAL00770
                            INBUFVARDS                                  CAL00780
                            OUTBUFVARDS.                                CAL00790
                                                                        CAL00800
                 PERFORM 1100-OPEN-FILES                                CAL00810
                    THRU 1100-OF-EXIT.                                  CAL00820
                                                                        CAL00830
                 PERFORM 7000-READ-INDATA                               CAL00840
                    THRU 7000-RI-EXIT.                                  CAL00850
                                                                        CAL00860
                 IF INDATA-EOF                                          CAL00870
                    CALL 'ERROUT'                                       CAL00880
                    DISPLAY 'INDATA FILE IS EMPTY - PGM ENDING'         CAL00890
                    GO TO 1000-IP-EXIT                                  CAL00900
                 END-IF.                                                CAL00910
                                                                        CAL00920
                 IF DB-SELECTION = 1  THEN                              CAL00930
                    CALL 'DB1DOPRG' USING BY REFERENCE INBUFVARDS       CAL00940
                 ELSE                                                   CAL00950
                    CALL 'DB2DOPRG' USING BY REFERENCE INBUFVARDS       CAL00960
                 END-IF.                                                CAL00970
                                                                        CAL00980
       1000-IP-EXIT.                                                    CAL00990
            EXIT.                                                       CAL01000
                                                                        CAL01010
       1100-OPEN-FILES.                                                 CAL01020
                                                                        CAL01030
            OPEN INPUT INDATA-FILE.                                     CAL01040
                                                                        CAL01050
            OPEN OUTPUT OUTDATA-FILE.                                   CAL01060
                                                                        CAL01070
       1100-OF-EXIT.                                                    CAL01080
            EXIT.                                                       CAL01090
                                                                        CAL01100
       2000-PROCESS-PARA.                                               CAL01110
                                                                        CAL01120
            MOVE CORRESPONDING INBUFVARDS TO OUTBUFVARDS.               CAL01130
                                                                        CAL01140
            CALL 'INIT1PRG' USING BY REFERENCE OUTBUFVARDS, COMNDATA.   CAL01150
                                                                        CAL01160
            EVALUATE TRUE                                               CAL01170
                WHEN RATEVAR = 1                                        CAL01180
                     CALL 'ADDPRG' USING BY REFERENCE OUTBUFVARDS       CAL01190
                WHEN RATEVAR = 2                                        CAL01200
                     CALL 'SUBPRG' USING BY REFERENCE OUTBUFVARDS       CAL01210
                WHEN RATEVAR = 3                                        CAL01220
                     CALL 'MULTPRG' USING BY REFERENCE OUTBUFVARDS      CAL01230
                WHEN RATEVAR > 3                                        CAL01240
                     CALL 'DIVPRG' USING BY REFERENCE OUTBUFVARDS       CAL01250
            END-EVALUATE                                                CAL01260
                                                                        CAL01270
            PERFORM 2100-WRITE-OUTDATA                                  CAL01280
               THRU 2100-WO-EXIT.                                       CAL01290
                                                                        CAL01300
            PERFORM 7000-READ-INDATA                                    CAL01310
               THRU 7000-RI-EXIT.                                       CAL01320
                                                                        CAL01330
       2000-PP-EXIT.                                                    CAL01340
            EXIT.                                                       CAL01350
                                                                        CAL01360
       2100-WRITE-OUTDATA.                                              CAL01370
            IF NOT ACCOUNT-UPDT-DDMMYY OF OUTBUFVARDS = RUNDATE         CAL01380
               THEN IF ACCOUNT-OPEN-DDMMYY OF INBUFVARDS < OLDONE       CAL01390
                     MOVE ACCOUNT-OPEN-DDMMYY OF INBUFVARDS TO OLDONE.  CAL01400
                                                                        CAL01410
            WRITE OUTDATA-REC FROM OUTBUFVARDS.                         CAL01420
                                                                        CAL01430
       2100-WO-EXIT.                                                    CAL01440
            EXIT.                                                       CAL01450
                                                                        CAL01460
       3000-END-PARA.                                                   CAL01470
                                                                        CAL01480
            CLOSE INDATA-FILE                                           CAL01490
                  OUTDATA-FILE.                                         CAL01500
                                                                        CAL01510
       3000-EP-EXIT.                                                    CAL01520
            EXIT.                                                       CAL01530
                                                                        CAL01540
       7000-READ-INDATA.                                                CAL01550
                                                                        CAL01560
            READ INDATA-FILE INTO INBUFVARDS                            CAL01570
                 AT END                                                 CAL01580
                    MOVE 'Y' TO INDATA-EOF-FLAG.                        CAL01590
                                                                        CAL01600
       7000-RI-EXIT.                                                    CAL01610
            EXIT.                                                       CAL01620
