      ******************************************************************
      * ODBCPROC.CPY                                                   *
      *----------------------------------------------------------------*
      *  Sample ODBC initialization, clean-up and error handling       *
      *    procedures                                                  *
      ******************************************************************
      *** Initialization functions SECTION *****************************
       ODBC-Initialization SECTION.
      *
        SQLAllocEnv-Function.
           CALL "SQLAllocEnv" USING BY REFERENCE Henv
                              RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
             MOVE "SQLAllocEnv" TO SQL-stmt
             PERFORM SQLError-Function
           END-IF.
      *
        SQLAllocConnect-Function.
           CALL "SQLAllocConnect" USING BY VALUE     Henv
                                        BY REFERENCE Hdbc
                                  RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
               MOVE "SQLAllocConnect" to SQL-stmt
               PERFORM SQLError-Function
           END-IF.

      *** SQL-SetLicInfo SECTION **************************************
       SQL-SetLicInfo-Function SECTION.
        SQL-SetLicInfo.
           CALL "iwzODBCLicInfo" USING BY VALUE Hdbc.

      *** SQLAllocStmt function SECTION *******************************
       SQLAllocStmt-Function SECTION.
        SQLAllocStmt.
           CALL "SQLAllocStmt" USING BY VALUE     Hdbc
                                     BY REFERENCE Hstmt
                               RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
               MOVE "SQLAllocStmt" TO SQL-stmt
               PERFORM SQLError-Function
           END-IF.

      *** Cleanup Functions SECTION ***********************************
       ODBC-Clean-Up SECTION.
      *
        SQLFreeStmt-Function.
           CALL "SQLFreeStmt" USING BY VALUE Hstmt
                                             SQL-DROP
                              RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
               MOVE "SQLFreeStmt" TO SQL-stmt
               PERFORM SQLError-Function
           END-IF.
      *
        SQLDisconnect-Function.
           CALL "SQLDisconnect" USING BY VALUE Hdbc
                                RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
               MOVE "SQLDisconnect" TO SQL-stmt
               PERFORM SQLError-Function
           END-IF.
      *
        SQLFreeConnect-Function.
           CALL "SQLFreeConnect" USING BY VALUE Hdbc
                                 RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
               MOVE "SQLFreeConnect" TO SQL-stmt
               PERFORM SQLError-Function
           END-IF.
      *
        SQLFreeEnv-Function.
           CALL "SQLFreeEnv" USING BY VALUE Henv
                             RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
               MOVE "SQLFreeEnv" TO SQL-stmt
               PERFORM SQLError-Function
           END-IF.

      *** SQLError function SECTION ************************************
       SQLError-Function SECTION.
        SQLError.
           MOVE SQL-RC TO SAVED-SQL-RC
           DISPLAY "Return Value = " SQL-RC
           PERFORM WITH TEST AFTER UNTIL SQL-RC =  SQL-SUCCESS
                                                OR SQL-NO-DATA-FOUND
                                                OR SQL-INVALID-HANDLE

             IF SQL-RC = SQL-SUCCESS-WITH-INFO
               THEN
                  DISPLAY SQL-stmt " successful with information"
               ELSE
                  DISPLAY SQL-stmt " failed"
             END-IF

             CALL "SQLError" USING BY VALUE     Henv
                                                Hdbc
                                                Hstmt
                                   BY REFERENCE szSqlState
                                                fNativeError
                                                szErrorMsg
                                   BY VALUE     cbErrorMsgMax
                                   BY REFERENCE cbErrorMsg
                             RETURNING SQL-RC
             IF SQL-RC = SQL-SUCCESS OR SQL-SUCCESS-WITH-INFO
               THEN
                 DISPLAY "SQL-State = " szSQLState-Chars
                 INSPECT szErrorMsg TALLYING char-count
                                    FOR CHARACTERS BEFORE X"00"
                 DISPLAY "Message = " szErrorMsg (1:char-count)
                 MOVE 0 TO char-count
               ELSE
                 DISPLAY "Return value = " SQL-RC
             END-IF
                 MOVE "SQLError" TO SQL-stmt
           END-PERFORM

           IF Saved-SQL-RC NOT = SQL-SUCCESS-WITH-INFO
             DISPLAY "Application being terminated"
      *       you might do <CALL "SQLTransact" USING BY VALUE ...
      *       SQL-Rollback> or some other processing here.
             STOP RUN
           END-IF.
      ***********************
      * End of ODBCPROC.CPY *
      ***********************
