      CBL PGMNAME(MIXED)
      ******************************************************************
      * ODBC2EG.CBL                                                    *
      *----------------------------------------------------------------*
      * Sample program using ODBC2, ODBC2D and ODBC2P COPY books       *
      ******************************************************************
       IDENTIFICATION DIVISION.
       PROGRAM-ID. "ODBC2EG".
       DATA DIVISION.

       WORKING-STORAGE SECTION.
      *  copy ODBC API constant definitions
           COPY "odbc2.cpy" SUPPRESS.

      *  copy additional definitions used by ODBCPROC procedure
           COPY "odbc2d.cpy".

      *  arguments used for SQLConnect
       01  szDSN                     PIC X(10) VALUE Z"myDSN".
       01  szUID                     PIC X(10) VALUE Z"userid".
       01  szAuthStr                 PIC X(10) VALUE Z"password".

       PROCEDURE DIVISION.
       Do-ODBC SECTION.
        Start-ODBC.
           DISPLAY "Sample ODBC 2 program starts"

      *  allocate henv & hdbc
           PERFORM ODBC-Initialization

      *  connect to data source
           CALL "SQLConnect" USING BY VALUE     Hdbc
                                   BY REFERENCE szDSN
                                   BY VALUE     SQL-NTS
                                   BY REFERENCE szUID
                                   BY VALUE     SQL-NTS
                                   BY REFERENCE szAuthStr
                                   BY VALUE     SQL-NTS
                             RETURNING SQL-RC
           IF SQL-RC NOT = SQL-SUCCESS
             DISPLAY "SQLConnect failed"
             PERFORM SQLError-Function
           END-IF

      *  set licensing informationm
           PERFORM SQL-SetLicInfo-Function

      *  allocate hstmt
           PERFORM SQLAllocStmt-Function.

      *****************************************
      *  add application specific logic here  *
      *****************************************

      *  clean-up environment
           PERFORM ODBC-Clean-Up.

      *  End of sample program execution
           GOBACK.

      *  copy predefined COBOL ODBC calls which are performed
           COPY "odbc2p.cpy".
      *********************************************
      * End of ODBC2EG.CBL:   ODBC-Sample program *
      *********************************************
