
      *************************************************************
      *                                                           *
      *    Licensed Materials - Property of IBM                   *
      *                                                           *
      *    28H2177  (C) Copyright IBM Corp. 1995, 1998            *
      *    All rights reserved                                    *
      *                                                           *
      *    US Government Users Restricted Rights - Use,           *
      *    duplication, or disclosure restricted by GSA ADP       *
      *    Schedule Contract with IBM Corp.                       *
      *                                                           *
      *************************************************************

      *************************************************************
       IDENTIFICATION DIVISION.
      *************************************************************
       PROGRAM-ID.    SERVC.
       AUTHOR.        Programmer.

      *************************************************************
      *                                                           *
      *NAME.........SERVC                                         *
      *LANGUAGE.....COBOL                                         *
      *FUNCTION.....Service Length calculation subroutine         *
      *             This subroutine accepts a date (format:       *
      *             yyyymmdd), calculates and returns the service *
      *             length (number of years from today's date.)   *
      *COPY MEMBER..Servsc                                        *
      *PARAMETERS...Hire date      (value set by calling program) *
      *             Service length (value set by this program)    *
      *                                                           *
      *************************************************************

      *************************************************************
       ENVIRONMENT DIVISION.
      *************************************************************
       CONFIGURATION SECTION.
      *************************************************************
       DATA DIVISION.
      *************************************************************
       WORKING-STORAGE SECTION.
       01  WORK-FIELDS.
           05  WK-TODAYS-DATE.
               10  WK-TODAYS-YEAR         PIC 9(04).
               10  WK-TODAYS-MONTH        PIC 9(02).
               10  WK-TODAYS-DAY          PIC 9(02).
           05  WK-SERVICE-LENGTH          PIC 9(02).
           05 WK-SC-HIRE-YEAR-FOUR        PIC 9(04).
           05 WK-HUNDRED-YEAR-WINDOW-START PIC 9(04).

      *************************************************************
      *  Linkage Section                                          *
      *************************************************************
       LINKAGE SECTION.
       01  SC-COMMAREA.
           Copy SERVSC.

      *************************************************************
       PROCEDURE DIVISION USING SC-COMMAREA.
      *************************************************************

      *************************************************************
      *0000-MAIN.                                                 *
      *  Initialize the service length fields.                    *
      *  Retrieve today's date and then calculcate number of      *
      *    years of service.                                      *
      *  Move calculcated service length to return parameter.     *
      *************************************************************

       0000-MAIN.

            INITIALIZE SC-SERVICE-LENGTH
                       WK-SERVICE-LENGTH.

      *     Retrieve today's date
            MOVE FUNCTION CURRENT-DATE(1:8) TO WK-TODAYS-DATE

      * Convert the hire year from two digit to four digit.
      * Assume a floating 100 year window from 80 years prior to
      * current year to 20 years from current year.  This algorithm
      * assumes all years are of the form 19xx or 20xx.

      *     Calculate service length
            SUBTRACT SC-HIRE-YEAR FROM WK-TODAYS-YEAR
                GIVING WK-SERVICE-LENGTH

            IF WK-TODAYS-MONTH < SC-HIRE-MONTH AND
               WK-SERVICE-LENGTH > 0
                SUBTRACT 1 FROM WK-SERVICE-LENGTH
                    GIVING WK-SERVICE-LENGTH
            ELSE
                IF WK-TODAYS-MONTH = SC-HIRE-MONTH AND
                   SC-HIRE-DAY > WK-TODAYS-DAY AND
                   WK-SERVICE-LENGTH > 0
                    SUBTRACT 1 FROM WK-SERVICE-LENGTH
                        GIVING WK-SERVICE-LENGTH
                END-IF
            END-IF.

            Move WK-SERVICE-LENGTH To SC-SERVICE-LENGTH.
            Move  0  To sc-return-code.

       0000-MAIN-EXIT.
            GOBACK.
