CBL LIB,APOST
      ****************************************************
      *                                                  *
      *  Licensed Materials - Property of IBM.           *
      *                                                  *
      *  IBM VisualAge for COBOL: 5639-B92               *
      *  (C) Copyright IBM Corp. 1983, 1997              *
      *  All rights reserved                             *
      *                                                  *
      *  US Government Users Restricted Rights - Use,    *
      *  duplication or disclosure restricted by GSA     *
      *  ADP Schedule Contract with IBM Corp.            *
      *                                                  *
      ****************************************************
      **                                                **
      ** Function: CEEDATM - convert seconds to         **
      **                     character timestamp        **
      **                                                **
      ** In this example, a call is made to CEEDATM     **
      ** to convert a date represented in Lilian        **
      ** seconds (the number of seconds since           **
      ** 00:00:00 14 October 1582) to a character       **
      ** format (such as 06/02/88 10:23:45). The        **
      ** result is displayed.                           **
      **                                                **
      ****************************************************
       IDENTIFICATION DIVISION.
       PROGRAM-ID. CBLDATM.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01  DEST          PIC S9(9) BINARY VALUE 2.
       01  SECONDS                 COMP-2.
       01  IN-DATE.
           02  Vstring-length      PIC S9(4) BINARY.
           02  Vstring-text.
               03  Vstring-char    PIC X
                           OCCURS 0 TO 256 TIMES
                           DEPENDING ON Vstring-length
                               of IN-DATE.
       01  PICSTR.
           02  Vstring-length      PIC S9(4) BINARY.
           02  Vstring-text.
               03  Vstring-char    PIC X
                           OCCURS 0 TO 256 TIMES
                           DEPENDING ON Vstring-length
                              of PICSTR.
       01  TIMESTP                 PIC X(80).
       01  FC.
           02  Condition-Token-Value.
           COPY  CEEIGZCT.
               03  Case-1-Condition-ID.
                   04  Severity    PIC S9(4) COMP-5.
                   04  Msg-No      PIC S9(4) COMP-5.
               03  Case-2-Condition-ID
                         REDEFINES Case-1-Condition-ID.
                   04  Class-Code  PIC S9(4) COMP-5.
                   04  Cause-Code  PIC S9(4) COMP-5.
               03  Case-Sev-Ctl    PIC X.
               03  Facility-ID     PIC XXX.
           02  I-S-Info            PIC S9(9) COMP-5.

       PROCEDURE DIVISION.
       PARA-CBLDATM.
      *************************************************
      ** Call CEESECS to convert timestamp of 6/2/88 **
      **     at 10:23:45 AM to Lilian representation **
      *************************************************
           MOVE 20 TO Vstring-length of IN-DATE.
           MOVE '06/02/88 10:23:45 AM'
               TO Vstring-text of IN-DATE.
           MOVE 20 TO Vstring-length of PICSTR.
           MOVE 'MM/DD/YY HH:MI:SS AP'
               TO Vstring-text of PICSTR.
           CALL 'CEESECS' USING IN-DATE, PICSTR,
                                SECONDS, FC.

      *************************************************
      ** If CEESECS runs successfully, display result**
      *************************************************
           IF  CEE000 of FC  THEN
               DISPLAY Vstring-text of IN-DATE
                   ' is Lilian second:  ' SECONDS
           ELSE
               DISPLAY 'CEESECS failed with msg '
                   Msg-No of FC UPON CONSOLE
               STOP RUN
           END-IF.


      *************************************************
      ** Specify desired format of the output.       **
      *************************************************
           MOVE 35 TO Vstring-length OF PICSTR.
           MOVE 'ZD Mmmmmmmmmmmmmmz YYYY at HH:MI:SS'
                   TO Vstring-text OF PICSTR.

      *************************************************
      ** Call CEEDATM to convert Lilian seconds to   **
      **     a character timestamp                   **
      *************************************************
           CALL 'CEEDATM' USING SECONDS, PICSTR,
                                TIMESTP, FC.

      *************************************************
      ** If CEEDATM runs successfully, display result**
      *************************************************
           IF CEE000 of FC  THEN
               DISPLAY 'Input seconds of ' SECONDS
                   ' corresponds to: ' TIMESTP
           ELSE
               DISPLAY 'CEEDATM failed with msg '
                   Msg-No of FC UPON CONSOLE
               STOP RUN
           END-IF.

           GOBACK.
