#*******************************************************************************
# FILE NAME: iwzbdll.mak                                             V2R2      *
#                                                                              *
# DESCRIPTION:                                                                 *
#   Make file to create OS/2 dll for class: $(CVBNAME)                         *
#                                                                              *
# COPYRIGHT:                                                                   *
#   IBM(R) VisualAge(TM) for COBOL                                             *
#   (C) Copyright International Business Machines Corporation 1998             *
#   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
#   US Government Users Restricted Rights - Use, duplication, or disclosure    *
#   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
#                                                                              *
# ---------------------------------------------------------------------------- *
# Notes: $(CVBNAME).obj $(CVBNAME).lib iwzbtemp.lib iwzbtemp.obj are temps     *
#   The environment variables CVBNAME, CVBDEBUG, PARTCOMPFLAGS, APPCOMPFLAGS,  *
#   PARTLINKFLAGS, APPLINKFLAGS can be used to override the default values     *
#*******************************************************************************
PARTCOMPFLAGS=-qFLAG(E) $(PARTCOMPFLAGS) 
!ifdef CVBDEBUG
PARTCOMPFLAGS=$(PARTCOMPFLAGS) -qTEST
!endif

PARTLINKFLAGS=/free /pmtype:pm /nologo /dll $(PARTLINKFLAGS)
!ifdef CVBDEBUG
PARTLINKFLAGS=$(PARTLINKFLAGS) /de
!endif

DLLDEPENDS=$(LIBLIST) $(DLLDEPENDS)
DLLLIBS=$(LIBLIST) $(FILESIN) $(DLLLIBS)

.SUFFIXES:

.SUFFIXES: .cbl 

$(CVBNAME).dll:  $(CVBNAME).lib $(DLLDEPENDS)
  @echo ... creating $(CVBNAME).dll ...
          @copy  $(CVBNAME).cbj $(CVBNAME).obj > nul
          iwzolnk1 $(PARTLINKFLAGS) $(CVBNAME).obj \
             iwzbcprt.lib iwzbcobs.lib iwzbapix.lib \
             iwzbodx.lib iwzblang.obj iwzbrtr1.lib $(CVBNAME).def \
             $(DLLLIBS) $(IWZVPA) 
          implib /nol $(CVBNAME).imp $(CVBNAME).def

.cbl.lib:
  @echo ... compiling %s ...
          @if exist iwzbtemp.obj del iwzbtemp.obj
          @if exist %|dpfF.obj ren %|dpfF.obj iwzbtemp.obj
          @if exist %|dpfF.cbj del %|dpfF.cbj
          @set SYSLIB=$(SYSLIB);$(INCLUDE)
      -7  igyccob2 $(PARTCOMPFLAGS) %s
          @if exist %|dpfF.obj ren %|dpfF.obj %|dpfF.cbj
          @if exist iwzbtemp.obj ren iwzbtemp.obj %|dpfF.obj 


clean:
  @if exist $(CVBNAME).dll del $(CVBNAME).dll
  @if exist $(CVBNAME).lib del $(CVBNAME).lib
  @if exist $(CVBNAME).cbj del $(CVBNAME).cbj
  @if exist $(CVBNAME).lst del $(CVBNAME).lst
  @if exist $(CVBNAME).adt del $(CVBNAME).adt
  @if exist $(CVBNAME).obj del $(CVBNAME).obj

