/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*  Type    Date     Userid   Description of problem                         */
/*                                                                           */
/*  A1    2/02/99  dewittsc   PQ23998 - Add ODBC data format error           */
/*                                                                           */
/*****************************************************************************/
#ifndef  FCWXOCIB_H
#define  FCWXOCIB_H

// -----------------------------------------------------------------
//   Unit Of Work connection options
// -----------------------------------------------------------------
static char*  XOCONCT_RUOW     = "R";
static char*  XOCONCT_D1A      = "D1A";
static char*  XOCONCT_D1C      = "D1C";
static char*  XOCONCT_D1E      = "D1E";
static char*  XOCONCT_D2A      = "D2A";
static char*  XOCONCT_D2C      = "D2C";
static char*  XOCONCT_D2E      = "D2E";

static char*  XOCONCT_DISC     = "DISC";
static char*  XOCONCT_DCURRENT = "DCURRENT";
static char*  XOCONCT_DALL     = "DALL";
static char*  XOCONCT_SET      = "SET";
static char*  XOCONCT_QUERYDB  = "QUERYDB";


// -----------------------------------------------------------------
//    EZECONCT connection reason and option values
// -----------------------------------------------------------------
// enum ConnReason { dft_connection = 1, eze_connection };
// enum ConnOption { xoRUOW=1, xoD1A, xoD1C, xoD1E, xoD2A, xoD2C, xoD2E, xoDISC, xoDCURRENT, xoDALL, xoSET, xoERROR };
enum ConnOption { RUOW=1, D1A, D1C, D1E, D2A, D2C, D2E, DISC, DCURRENT, DALL, SET, QUERYDB,  ERROPT };
enum ConnType   { type_1 = 1, type_2, undefined };
enum RCodeType { from_SQL = 1, from_CPP };
enum ConnState { connected, not_connected };

enum StmtState { unprepared = 0, prepared,  executed };


// -----------------------------------------------------------------
//    Non SQL error codes ( when RCodeType == from_CPP )
// -----------------------------------------------------------------
const   short int  XO_UOW_OPTION_ERROR       =  -1;
const   short int  XO_RESOURCE_ERROR         =  -2;
const   short int  XO_NO_CONNECTION_ERROR    =  -3;
const   short int  XO_NO_OPEN_CURSOR_ERROR   =  -4;
const   short int  XO_DATA_FORMAT_ERROR      =  -5;                            /*@A1*/

// ------------------------------------------------------------------
//   Misc. macro constants ...
// ------------------------------------------------------------------
const  int   SQLMSG_MAX_LEN                  =   1024;
const  int   SQLSTATE_MAX_LEN                =   5;

const  int   DBM_TYPE_DB2                    = 1;
const  int   DBM_TYPE_ODBC                   = 2;

const  int   CURSOR_NAME_LENGTH              = 19;
const  int   SQLSTATE_LENGTH                 = 6;
const  int   MSG_BUFFER_LENGTH               = 1032;

enum   ConvType { ct_dft = 0, ct_char = 1, ct_pack = 2 };
enum   FsOption { fs_close = 1, fs_drop = 2 };

// -----------------------------------------------------------------
//    Interface Parameter Block for ITF/C++ to ODBC driver.
//    It contains both input and output parameter for interface.
// -----------------------------------------------------------------
struct FCWXOCIB
{
    int            connID;

    void*          henv;                // environment handle
    void*          hdbc;                // connection handle
    void*          hstmt;               // statement handle

    void*          pConnObj;            // connection object
    void*          pStmtObj;            // statement object

    void*          pSQLCA;              // ptr to sqlca

                                        //       Connect()
    long           hCsoConn;            // CSO connection handle
    char*          pDSN;                // connection data source name
    short          dsnLength;
    char*          pUSR;                // connection user id
    short          usrLength;
    char*          pPSW;                // connection authorization string
    short          pswLength;

    void*          pUOW;                // unit of work connection option
    void*          pProduct;            // DBMS identification
    void*          pRelease;            // DBMS version

    long           connReason;          // Connection reason
    ConnOption     connOption;          // Connection option

                                        //      GetStmtObj()
    char*          pAppName;            // appl name or EZEVGITF
    char*          pRcdName;            // name of SQL row
    int            stmtID;              // statement handle id
    short          numIParm;            // no. of input parm for stmt
    short          numOParm;            // no. of output parm for stmt

    char*          pStmtStr;            // SQL statement string
    int            stmtStrLength;       // length of SQL statement string
    short          execOption;          // stmt exec option

                                        //      GetCurrentCursor()
    int            prcOption;           // process option
    unsigned char  cursorName[CURSOR_NAME_LENGTH];      // cursor name

                                        //    SetParm() or BindCol()
    unsigned short parmNum;             // parameter number, left to right
    short int      parmType;            // parameter type: I, I/O or O
    short int      cType;               // C type
    short int      sqlType;             // SQL data type
    unsigned long int  colDef;          // column precision
    short int      colScale;            // scale of column
    void*          rgbValue;            // ptr to buffer
    signed long int  cbValueMax;        // length of rbgValue buffer
    signed long int *pcbValue;          // ptr to pcbValue
    signed long int  cbValue;           // content of pcbValue
    void*            pNull;             // ptr to SQL NULL indicator
    void*            pRetLen;           // ptr to SQL returned length (short*)
    ConvType       convType;            // SQL and C data type conversion

                                        //    GetResultCols() / GetColDesc()
    short int      nResultCols;         // number of columns in a result set
    unsigned char  *colName;
    short int      maxColNameLen;
    short int      colNameLen;
    short int      nullIndicator;
                                        //    Close()  (SQLFreeStmt())
    FsOption       fsOption;            // either CLOSE or DROP

                                        //        ERROR
    RCodeType      retType;             // error due to SQL or non-SQL
    long           retCode;             // return code from call
    long           errLoc;              // where error is detected ...
    unsigned short ioStatus;            // VG I/O status mask: EOF, NRF ...
    char           sqlState[SQLSTATE_LENGTH];        // SQL state
    long int       nativeErrorCode;     // Native error code
    CMCOMP         cmComp;              // cso error struct
    short int      lengthMsgText;       // length of text in msgBuffer
    char           msgBuffer[MSG_BUFFER_LENGTH];     // buffer for msg text
};

typedef struct FCWXOCIB  FCWXOCIB;

// -----------------------------------------------------------------
//  Function:  Interface to ODBC <database object, connection and
//             statement handles> for C++ and ITF
// -----------------------------------------------------------------
class FCWXOITF
{
   public:
      virtual int EZEConnect( FCWXOCIB* pCIB ) = 0;
      virtual int Commit( FCWXOCIB* pCIB ) = 0;
      virtual int RollBack( FCWXOCIB* pCIB ) = 0;

      virtual int SetParm( FCWXOCIB* pCIB ) = 0;
      virtual int BindCol( FCWXOCIB* pCIB ) = 0;

      virtual int Prepare( FCWXOCIB* pCIB ) = 0;
      virtual int Execute( FCWXOCIB* pCIB ) = 0;
      virtual int ExecDirect( FCWXOCIB* pCIB ) = 0;
      virtual int Fetch( FCWXOCIB* pCIB ) = 0;
      virtual int Close( FCWXOCIB* pCIB ) = 0;

      virtual void* GetStmtObj( FCWXOCIB* pCIB ) = 0;
      virtual void  SetCbValue( FCWXOCIB* pCIB ) = 0;
      virtual char* GetCharBuffer( FCWXOCIB* pCIB ) = 0;
      //virtual void  FixupBindCol( FCWXOCIB* pCIB ) = 0;                     /*@A1*/
      virtual int   FixupBindCol( FCWXOCIB* pCIB ) = 0;                       /*@A1*/
      virtual signed long int* GetPcbValue( FCWXOCIB* pCIB ) = 0;
      virtual int   StmtNeedPrepare( FCWXOCIB* pCIB ) = 0;

      virtual short int  MapItemTypeToC( ItemType  itmType ) = 0;
      virtual short int  MapItemTypeToODBC( ItemType  itmType ) = 0;  // ????
      virtual short int  MapDB2CodeToODBC( int db2Code ) = 0;

      virtual int   SetCurrentCursor( FCWXOCIB* pCIB ) = 0;
      virtual int   GetCurrentCursorName( FCWXOCIB* pCIB ) = 0;
      virtual int   GetCurrentCursorStmt( FCWXOCIB* pCIB ) = 0;
      virtual int   CloseCurrentCursor( FCWXOCIB* pCIB ) = 0;

                                                          // ITF requirements
      virtual int   InitStmtOParm( FCWXOCIB* pCIB ) = 0;
      virtual int   InitStmtIParm( FCWXOCIB* pCIB ) = 0;
      virtual int   GetResultCols( FCWXOCIB* pCIB ) = 0;
      virtual int   GetColDesc( FCWXOCIB* pCIB ) = 0;
      virtual int   SetCursorName( FCWXOCIB* pCIB ) = 0;

};



typedef FCWXOITF* (*PFXOITF) ();



// ---------------------------------------------------------
//   Abstract interface class for database object
// ---------------------------------------------------------

enum SFDBValue  { sql_DB = 1,  file_DB = 2 };             // PQ01395

class FCWDBOBJ
{
  public:
   virtual int   EZEConnect( char* id, char* psw, char* dbname, char* product,
                             char* release, char* uow, void* pCA ) = 0;
   virtual int   Commit( int option ) = 0;
   virtual int   RollBack( int option ) = 0;
   virtual int   Close( char opt ) = 0;
   virtual void* Register( void* p) = 0;
   virtual int   DeRegister( void* p ) = 0;
   virtual void  SetIO( Bool f ) = 0;
   virtual Bool  IOPending() = 0;
   virtual void  SaveOpenCursor( char* App, char* Rec, short CursorID, Bool bWithHold ) = 0;
   virtual void  GetOpenCursor( char* App, char* Rec, short& cursor, Bool& bWithHold ) = 0;

   virtual InitValue DbmType() = 0;
   virtual int   SwitchSFDB( SFDBValue ) = 0;
   virtual Bool FileSystemIsManagedByDB2() = 0;            // PQ01395
   virtual void SetDBNameForNextSQLIO( char* n ) = 0;

   virtual Bool DriverExists() = 0;                        // PQ19733
};



// ---------------------------------------------------------
//   Interface to FCWXOCMN library via GetDbDrv()
// ---------------------------------------------------------

const int from_CSO  =   1;
const int from_WGS  =   2;

struct GDD_WGS {
   void*    xoItf;
};

// typedef int  (*PFXOItf) ( void *p, int k );
typedef int (* SYSCALL PFXOItf) ( void *p, int k );

#endif
