/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*   VisualAge Generator Server for OS/2, AIX, HP-UX, SUN, and Windows NT    */
/*                          Version 4.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1999                      */
/*                                                                           */
/*****************************************************************************/
/*    Date     Userid          Description of problem                        */
/*  08/17/99   Lui        D11871  -  Unicode Support                         */
/*  12/07/99   mheitz     D12562  -  PutData writes past end of buffer       */
/*  06/12/00   mheitz     D13176  -  UI state not updated after call         */
/*  07/07/00   mheitz     D13994  -  Add constructor w/ quadnum to UIRItems  */
/*****************************************************************************/

#ifndef FCWUIREC_H
#define FCWUIREC_H

#include <fcwexpu.h>

/*-------------------------------------------------------------------------*/
/*  Misc definitions for UIRecords                                         */
/*-------------------------------------------------------------------------*/

const char UIRC[4] = {'\xAA','\xAA','\xAA','\xAA'};
const char FERR[4] = {'\xBB','\xBB','\xBB','\xBB'};

#define UIBUF_SIZE  32500  /* D12562 */

#define UIRC_HDRSIZE  28
typedef struct
{
   char  id[4];                        /* id = UIRC                        */
   char  bean[18];                     /* record / bean name               */
   char  fill1[2];                     /* filler for alignment             */
   long  segment_count;                /* number of record segments        */
   char  segments[1];                  /* string of UIR segments           */
}  UIRECORD;


#define UIRS_HDRSIZE  8
typedef struct
{
   long  segment_offset;               /* offset of segment in record      */
   long  segment_length;               /* number of bytes of segment data  */
   char  segment_data[1];              /* segment data                     */
}  UIRSEGMENT;


#define FERR_HDRSIZE  32
typedef struct
{
   char  id[4];                        /* id = FERR                        */
   char  bean[18];                     /* record / bean name               */
   char  fill1[2];                     /* filler for alignment             */
   long  field_offset;                 /* offset of field in error         */
   long  text_len;                     /* total text length                */
   char  text[1];                      /* null terminated text             */
}  UIFIELDERR;

/*-------------------------------------------------------------------------*/
/*  Class definition for User Interface Record (UIRecord)                  */
/*-------------------------------------------------------------------------*/
class UIRItem;

class UIRecord : public Record
{
  friend class UIRDriver;

  private:
    void*           pData;
    Bool            bInitial;
    Bool            bBypassSegmentIn;
    char            recName[18];
    Bool            recInError;
    FCWApp*         pAppl;
    LIST(UIRItem*)  LUIRItems;
    long            hashCode;

  protected:
                    UIRecord (char* n, long l);
    virtual         ~UIRecord();

    UIRSEGMENT*     BuildUIRC( UIRECORD* );
    long            BuildUIRSegments( UIRSEGMENT*, long* );
    Bool            BypassSegmentIn();
    void            SetUIRItemModified( long offSet );
    long            GetData( void* );
    Bool            IsInitial();
    FCWApp*         pApp();
    void            ResetInitial();
    void            ResetModified();
    void            ResetSelected();
    void            SetBypassSegmentIn( Bool bp );
    virtual void    StatementGroupEdits() {};
    void            UpdateItems( UIRECORD* );
    void            ValidateGWS( void* );

  public:
    void            AddUIRItem( UIRItem* );
    void            Converse();
    UIRItem*        GetUIRItem( int );
    Bool            IsAnyModified();
    Bool            IsError();
    char*           Name();
    void            PutData( void* );
    void            ResetError();
    void            SetClear();
    void            SetError();
    void            SetSelected();   /* D13176 */
    virtual long    GetHashCode() = 0;
    void            VerifyAndRetrieveFirstUI();

};

/*-------------------------------------------------------------------------*/
/*  Declare forward references                                             */
/*-------------------------------------------------------------------------*/

class MAPDBCS;
class TBLDBCS;

/*-------------------------------------------------------------------------*/
/*  Class definition for User Interface Record Item                        */
/*-------------------------------------------------------------------------*/

class UIRItem
{
   public:

     Bool         IsAnyModified();
     Bool         IsModified();
     Bool         IsModified(int);
     void         ResetModified();
     void         SetModified();
     void         SetModified( int );
     Bool         TestModified();

     void         ClearSelected();
     Bool         IsSelected();
     Bool         IsSelected( int );
     void         SetSelected();
     void         SetSelected( int );

   protected:
                  UIRItem();
                  UIRItem( int );
                  UIRItem( const UIRItem&, int );
                  ~UIRItem();

   private:

     Bool         bAllocated;         /* This obj allocated the other flags*/
     Bool*        bModified;           /* item was changed by the user     */
     Bool*        bSelected;           /* item was changed by the program  */
                                       /*  or user                         */
     int          occurs;

};


/*-------------------------------------------------------------------------*/
/*  Class definition for UIRBIN2 Item                                      */
/*-------------------------------------------------------------------------*/

class UIRBIN2 : public BIN2, public UIRItem
{

  public:

    UIRBIN2 (UIRecord&, Level, int, int, int, int, int=0);
    UIRBIN2 (const UIRBIN2&, int);
    UIRBIN2 (const UIRBIN2&, quadnum); /* D13994 */
    virtual ~UIRBIN2();

    void    operator = (const UIRBIN2&);
    void    operator = (const quadnum& v);
    UIRBIN2 operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRBIN4 Item                                      */
/*-------------------------------------------------------------------------*/

class UIRBIN4 : public BIN4, public UIRItem
{

  public:

    UIRBIN4 (UIRecord&, Level, int, int, int, int, int=0);
    UIRBIN4 (const UIRBIN4&, int);
    UIRBIN4 (const UIRBIN4&, quadnum); /* D13994 */
    virtual ~UIRBIN4();

    void    operator = (const UIRBIN4&);
    void    operator = (const quadnum& v);
    UIRBIN4 operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRBIN8 Item                                      */
/*-------------------------------------------------------------------------*/

class UIRBIN8 : public BIN8, public UIRItem
{

  public:

    UIRBIN8 (UIRecord&, Level, int, int, int, int, int=0);
    UIRBIN8 (const UIRBIN8&, int);
    UIRBIN8 (const UIRBIN8&, quadnum); /* D13994 */
    virtual ~UIRBIN8();

    void    operator = (const UIRBIN8&);
    void    operator = (const quadnum& v);
    UIRBIN8 operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRCHA Item                                       */
/*-------------------------------------------------------------------------*/

class UIRCHA : public CHA, public UIRItem
{

  public:

    UIRCHA (UIRecord&, Level, int, int, int, int);
    UIRCHA (const UIRCHA&, int);
    UIRCHA (const UIRCHA&, quadnum); /* D13994 */
    virtual ~UIRCHA();

    void SetEmpty() const;

    void   operator = (const CHA& v);
    void   operator = (const UIRCHA& v);
    void   operator = (const HEX& v);
    void   operator = (const MIX& v);
    void   operator = (const NUM& v);
    void   operator = (const char *v);
    void   operator = (const quadnum& v );
    void   operator = (const int v );
    UIRCHA operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRMIX Item                                       */
/*-------------------------------------------------------------------------*/

class UIRMIX : public MIX, public UIRItem
{

  public:

    UIRMIX (UIRecord&, Level, int, int, int, int);
    UIRMIX (const UIRMIX&, int);
    UIRMIX (const UIRMIX&, quadnum); /* D13994 */
    virtual ~UIRMIX();

    void    operator = (const CHA& v);
    void    operator = (const MIX& v);
    void    operator = (const UIRCHA& v);
    void    operator = (const UIRMIX& v);
    void    operator = (const char *v);
    UIRMIX  operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRDBCS Item                                      */
/*-------------------------------------------------------------------------*/

class UIRDBCS : public DBCS, public UIRItem
{

  public:

    UIRDBCS (UIRecord&, Level, int, int, int, int);
    UIRDBCS (const UIRDBCS&, int);
    UIRDBCS (const UIRDBCS&, quadnum); /* D13994 */
    virtual ~UIRDBCS();

    void    operator = (const DBCS& v);
    void    operator = (const UIRDBCS& v);
    void    operator = (const char *v);
    UIRDBCS operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRUNICODE Item                      @11871       */
/*-------------------------------------------------------------------------*/

class UIRUNICODE : public UNICODE, public UIRItem
{

  public:

    UIRUNICODE (UIRecord&, Level, int, int, int, int);
    UIRUNICODE (const UIRUNICODE&, int);
    UIRUNICODE (const UIRUNICODE&, quadnum); /* D13994 */
    virtual ~UIRUNICODE();

    void    operator = (const UNICODE& v);
    void    operator = (const UIRUNICODE& v);
    UIRUNICODE operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRHEX Item                                       */
/*-------------------------------------------------------------------------*/

class UIRHEX : public HEX, public UIRItem
{

  public:

    UIRHEX (UIRecord&, Level, int, int, int, int);
    UIRHEX (const UIRHEX&, int);
    UIRHEX (const UIRHEX&, quadnum); /* D13994 */
    virtual ~UIRHEX();

    void   operator = (const HEX& v);
    void   operator = (const CHA& v);
    void   operator = (const UIRHEX& v);
    void   operator = (const char* v);
    UIRHEX operator [] (quadnum) const;

  private:
    void*    pData;
};


/*-------------------------------------------------------------------------*/
/*  Class definition for UIRNUM Item                                       */
/*-------------------------------------------------------------------------*/

class UIRNUM : public NUM, public UIRItem
{

  public:

    UIRNUM (UIRecord&, Level, int, int, int, int, int=0);
    UIRNUM (const UIRNUM&, int);
    UIRNUM (const UIRNUM&, quadnum); /* D13994 */
    virtual ~UIRNUM();

    void   operator = (const CHA&);
    void   operator = (const NUM&);
    void   operator = (const UIRCHA& v);
    void   operator = (const UIRNUM& v);
    void   operator = (const quadnum& v);
    UIRNUM operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRNUMC Item                                      */
/*-------------------------------------------------------------------------*/

class UIRNUMC : public NUMC, public UIRItem
{

  public:

    UIRNUMC (UIRecord&, Level, int, int, int, int, int=0);
    UIRNUMC (const UIRNUMC&, int);
    UIRNUMC (const UIRNUMC&, quadnum); /* D13994 */
    virtual ~UIRNUMC();

    void    operator = (const NUMC&);
    void    operator = (const UIRNUMC& v);
    void    operator = (const quadnum& v);
    UIRNUMC operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRPACK Item                                      */
/*-------------------------------------------------------------------------*/

class UIRPACK : public PACK, public UIRItem
{

  public:

    UIRPACK (UIRecord&, Level, int, int, int, int, int=0);
    UIRPACK (const UIRPACK&, int);
    UIRPACK (const UIRPACK&, quadnum); /* D13994 */
    virtual ~UIRPACK();

    void    operator = (const PACK&);
    void    operator = (const UIRPACK& v);
    void    operator = (const quadnum& v);
    UIRPACK operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for UIRPACF Item                                      */
/*-------------------------------------------------------------------------*/

class UIRPACF : public PACF, public UIRItem
{

  public:

    UIRPACF (UIRecord&, Level, int, int, int, int, int=0);
    UIRPACF (const UIRPACF&, int);
    UIRPACF (const UIRPACF&, quadnum); /* D13994 */
    virtual ~UIRPACF();

    void    operator = (const PACF&);
    void    operator = (const UIRPACF& v);
    void    operator = (const quadnum& v);
    UIRPACF operator [] (quadnum) const;

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for CSOUIERR record                                   */
/*-------------------------------------------------------------------------*/

struct rcdCSOERRORUIR_ : public UIRecord
{
        UIRCHA      PGMNAME_ ;
        UIRCHA      ERRDATE_ ;
        UIRCHA      ERRTIME_ ;
        UIRBIN4     MSGCOUNT_ ;
        UIRCHA      ERRMSG_ ;

rcdCSOERRORUIR_ () : UIRecord ( "CSOERRORUIR" , 10077 ) ,
        PGMNAME_       ( *this , Leaf , 1, 0, 0, 50 ) ,
        ERRDATE_       ( *this , Leaf , 1, 0, 50, 15 ) ,
        ERRTIME_       ( *this , Leaf , 1, 0, 65, 8 ) ,
        MSGCOUNT_      ( *this , Leaf , 1, 0, 73, 9 , 0 ) ,
        ERRMSG_        ( *this , Leaf , 40, 250, 77, 250 )
        {};
        long GetHashCode()  { return 0x00000687; }
};

#endif
