/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*   VisualAge Generator Server for OS/2, AIX, HP-UX, SUN, Windows NT, and   */
/*                      SCO OpenServer  -  Version 4.1                       */
/*                    (C) COPYRIGHT IBM CORP. 1994, 2000                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWRECD_H
#define FCWRECD_H

class Item;
class NumItem;
class RPCParm;

/*-------------------------------------------------------------------------*/
/* Parent of item's (ie. base of record and table strutures)               */
/*-------------------------------------------------------------------------*/
class Parent
{
   friend class Item;
   private:
       LIST(Item*) LItems;
       char*       dataPtr;
       Bool        bAllocated;
       long        size;
       void*       pData;

   protected:
                   Parent(long);
      virtual      ~Parent();
      void         SetOccurs(int);
      void         Add(Item*);
      void         SetupRpc(LIST(RPCParm*)&, int&, int, Item*, Item*);

   public:
      void         Setup (void* b=NULL);
      void         SetEmpty();
      void         SetClear();

      char*        Data();
      void         SetData(void*);
      long         Size();
      void         SetSize(long);
      void         ConvertData( char, FILE* );
      Item*        GetItem(int);
      long         GetNumItems();
};


/*-------------------------------------------------------------------------*/
/*  Record class definition -- base class for all record types             */
/*-------------------------------------------------------------------------*/
class Record : public Parameter, public Parent
{
  private:
    int            numberOfRPCEntries;
    LIST(RPCParm*) LRPCParm;                           /* List of RPC Parms*/
    void*          pData;

  protected:
    Record (long l);
    virtual ~Record ();

  public:
    void           Setup (void* b=NULL);

    long           ParmSize();
    char*          ParmData();

    int&           fNumberOfRPCEntries();
    LIST(RPCParm*)& RPCList();

    virtual void   SetupRpc();
    virtual Item*  getRLI();
    virtual Item*  getNOI();
    virtual ItemType itemType() const { return tRECORD; };
};

/*-------------------------------------------------------------------------*/
/*  FileRecord class - base class for all file  records                    */
/*-------------------------------------------------------------------------*/
class File;
class FileRecord : public Record
{
  protected:
    FileRecord(long l, char* n);
    FileRecord(long l, char* n, char* ft, char* rn);

    void      CalcRecordLength();    /* Calculate length of var length recs*/
    void      SetRecOrg(char ro);
    void      SetRecFormat(char rf);

    File&     file();
    void      setRLI( NumItem* );
    Bool      hasRLI();
    NumItem&  RLI();
    void      setNOI( NumItem* );
    void      setFixedLength( long );
    void      setOccursItemLength( long );
    Bool      hasNOI() { return ( pNOI != NULL ); };

    File*     pfile;                   /* Pointer to associated file object*/

  private:

    FCWString fileName;
    FCWString fileType;              /* File type (vsam, seq, tempmain, ..)*/
    FCWString resName;                 /* Resource name                    */
    char      recOrg;                 /* Record organization (serial, etc.)*/
    char      recFormat;               /* Record format (fixed, variable)  */

    NumItem*  pRLI;                                   /* Record Length Item*/
    NumItem*  pNOI;                                /* Number of Occurs Item*/
    long      fixedLength;             /* Length of fixed-part of record   */
    long      occursItemLength;        /* Length of the Occurs Item        */
    void*     pData;

  public:
    virtual   ~FileRecord();
    void      Setup();

                                       /* General error checks             */
    int Err();
    int Hrd();

                                       /* Soft errors                      */
    int Eof();
    int Nrf();
    int Lok();
    int Dup();
    int Unq();

                                       /* Hard errors                      */
    int Ful();
    int Fmt();
    int Fnf();
    int Fna();

                                       /* Compatibility  V2x               */
    int Ded();

                                       /* operations                       */
    void Close();
    void ChkStatus(char* operation);

    void  EZEDEST(char* n);
    void  EZEDEST( FCWString s );
    char* EZEDEST();

    FCWString& Name()        ;
    FCWString& Type()        ;
    FCWString& ResourceName();
    char    GetRecOrg()      ;
    char   GetRecFormat()    ;

    Item*  getRLI();
    Item*  getNOI();

    virtual Bool  isFileRecord() { return True; };
    int           GetStatus();
    void          SetStatus( int );
};

/*-------------------------------------------------------------------------*/
/*  SerialRecord class                                                     */
/*-------------------------------------------------------------------------*/
class SerialRecord : public FileRecord
{
  protected:
    SerialRecord(long l, char* n);
    SerialRecord(long l, char* n, char* ft, char* rn);
    SerialRecord(long l, char* n, char* ft, char* rn, int replace);
    virtual ~SerialRecord();

  public:

    void Add();
    void Scan();
    void Setup();
    void Setup(void* r);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  VarLenSerialRecord class                                               */
/*-------------------------------------------------------------------------*/
class VarLenSerialRecord : public SerialRecord
{
  protected:
    VarLenSerialRecord(long l, char* n);
    VarLenSerialRecord(long l, char* n, char* ft, char* rn);
    virtual ~VarLenSerialRecord();

  public:
    void Add();
    void Scan();
    void Setup(void* r);
    void Setup(NumItem*, NumItem*, long, long);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  IndexedRecord class                                                    */
/*-------------------------------------------------------------------------*/
class IndexedRecord : public FileRecord
{
  protected:
    IndexedRecord(long l, char* n, long ko, long kl);
    IndexedRecord(long l, char* n, long ko, long kl, char* ft, char* rn);
    virtual ~IndexedRecord();

    long keyLength;
    long keyOffSet;

  public:

    void Add();
    void Delete();
    void Inquiry();
    void Replace();
    void Scan();
    void ScanBack();
    void SetScan();
    void Update();
    void Setup();
    void Setup(void* r);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  VarLenIndexedRecord class                                              */
/*-------------------------------------------------------------------------*/
class VarLenIndexedRecord : public IndexedRecord
{
  protected:
    VarLenIndexedRecord(long l, char* n, long ko, long kl);
    VarLenIndexedRecord(long l, char* n, long ko, long kl, char* ft, char* rn);
    virtual ~VarLenIndexedRecord();

  public:
    void Add();
    void Inquiry();
    void Replace();
    void Scan();
    void ScanBack();
    void Update();

    void Setup(void* r);
    void Setup(NumItem*, NumItem*, long, long);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  RelativeRecord class                                                   */
/*-------------------------------------------------------------------------*/
class RelativeRecord : public FileRecord
{
  protected:
    RelativeRecord(long l, char* n);
    RelativeRecord(long l, char* n, char* ft, char* rn);
    virtual ~RelativeRecord();

    NumItem* pRII;                  /* Record Id Item (relative record num)*/
    long relRecNum;

  public:

    void Add();
    void Delete();
    void Inquiry();
    void Replace();
    void Scan();
    void Update();
    void Setup(void* r);
    void Setup(NumItem*);

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  MsgRecord class                                                        */
/*-------------------------------------------------------------------------*/

#define OPT_INCMSG    0x00000001
#define OPT_OPENEXC   0x00000002

class MsgRecord : public FileRecord
{
  protected:
    MsgRecord( long l, char* n );
    MsgRecord( long l, char* n, char* ft, char* rn );
    virtual ~MsgRecord();

  public:

    void    Add();
    void    Scan();

    void    BuildDescriptor();
    void    EZEDEST(char*);
    void    EZEDEST( FCWString s );
    char*   EZEDEST();
    char*   GetDescriptor()   { return pDescriptor; };
    char*   GetConTableAddr() { return pConTable; };
    Record* GetMQODAddr()     { return pMQOD; };
    Record* GetMQOPTAddr()    { return pMQOPT; };
    Record* GetMQMDAddr()     { return pMQMD; };
    Record* GetMQGMOAddr()    { return pMQGMO; };
    Record* GetMQPMOAddr()    { return pMQPMO; };
    long    GetMQOpts()       { return options; };

    void    SetConTableAddr(char* pCT)   { pConTable = pCT; };
    void    SetMQODAddr(Record* pMQod)   { pMQOD = pMQod; };
    void    SetMQOPTAddr(Record* pMQopt) { pMQOPT = pMQopt; };
    void    SetMQMDAddr(Record* pMQmd)   { pMQMD = pMQmd; };
    void    SetMQGMOAddr(Record* pMQgmo) { pMQGMO = pMQgmo; };
    void    SetMQPMOAddr(Record* pMQpmo) { pMQPMO = pMQpmo; };
    void    SetMQOpts(long opts)         { options = opts; };

    void    Setup();
    void    Setup( void* r );
    void    Setup( Record* pMQod, Record* pMQopt, Record* pMQmd, Record* pMQgmo,
                Record* pMQpmo, long options );
    void    Setup( Record* pMQod, Record* pMQopt, Record* pMQmd, Record* pMQgmo,
                Record* pMQpmo, char* pCT ,long options );

  private:
    long     options;
    Record*  pMQOPT;
    Record*  pMQOD;
    Record*  pMQMD;
    Record*  pMQGMO;
    Record*  pMQPMO;
    char*    pConTable;

    CMDESC*  pDescriptor;
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  VarLenMsgRecord class                                                  */
/*-------------------------------------------------------------------------*/
class VarLenMsgRecord : public MsgRecord
{
  protected:
    VarLenMsgRecord(long l, char* n);
    VarLenMsgRecord(long l, char* n, char* ft, char* rn);
    virtual ~VarLenMsgRecord();

  public:
    void Add();
    void Scan();

    void Setup(void* r);
    void Setup(NumItem* pRLI, NumItem* pNOI, long fl, long oil,
                Record* pMQod, Record* pMQopt, Record* pMQmd, Record* pMQgmo,
                Record* pMQpmo, long options );
    void Setup(NumItem* pRLI, NumItem* pNOI, long fl, long oil,
                Record* pMQod, Record* pMQopt, Record* pMQmd, Record* pMQgmo,
                Record* pMQpmo, char* pConTable, long options );


  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Working Storage record class                                           */
/*-------------------------------------------------------------------------*/
class WSRecord : public Record
{
  protected:
    WSRecord (long l);
    virtual ~WSRecord();

  public:
    void LocalSetup();
    void Retrieve();

  private:
    void*    pData;
};


/*-------------------------------------------------------------------------*/
/*  Redefined Record class                                                 */
/*-------------------------------------------------------------------------*/
class RedefinedRecord : public WSRecord
{
  protected:
    RedefinedRecord (long l);
    virtual ~RedefinedRecord();

  public:
    void Setup( Record& );
    void Setup( void* );

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for application and SQL EZEwords                      */
/*-------------------------------------------------------------------------*/
struct recEZEWORDS : public WSRecord
{
  public:
    recEZEWORDS(int);
    virtual ~recEZEWORDS();

  private:
    void*    pData;
};

struct  recEZESQL : public WSRecord
{
  public:
    recEZESQL(int);
    virtual ~recEZESQL();

  private:
    void*    pData;
};

/*-------------------------------------------------------------------------*/
/*  Class definition for application and SQL EZEwords                      */
/*-------------------------------------------------------------------------*/
#define LENGTH_EZEDLPSB_NAME      8
#define LENGTH_EZEDLPSB_ADDRESS   4
#define LENGTH_EZEDLPSB_RECORD   LENGTH_EZEDLPSB_NAME + LENGTH_EZEDLPSB_ADDRESS

class  recEZEDLPSB : public WSRecord
{
  public:
     recEZEDLPSB(long l);
     virtual ~recEZEDLPSB();
     void Setup( void* p = NULL );
     void SetupRpc();
     virtual ItemType  itemType() const { return tEZEDLPSB; };

  private:
    void*    pData;
};

#endif
