/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWQLONG_H
#define FCWQLONG_H

#include <iostream.h>
#include <memory.h>

/*-------------------------------------------------------------------------*/
/* 8-byte integer value                                                    */
/*-------------------------------------------------------------------------*/
class dbllong
{
public:

  dbllong( const int = 0 );
  dbllong( const int[] );
  dbllong( const dbllong & );
  virtual ~dbllong();

  dbllong & operator = ( const dbllong & );
  dbllong & operator = ( const int );

  int getData( const int ) const;

private:

  int _data[2];
  void* pData;
};

/*-------------------------------------------------------------------------*/
/* 16-byte integer value                                                   */
/*-------------------------------------------------------------------------*/
class quadlong
{
public:

  quadlong();
  quadlong( const int );
  quadlong( const int,
            const int );
  quadlong( const char* );
  quadlong( const FCWString & );
  quadlong( const char*,
            const int );
  quadlong( const dbllong & );
  quadlong( const long );
  quadlong( const quadlong & );
  virtual ~quadlong();

  int asInt() const;
  long asLong() const;
  short asShort() const;
  dbllong asDbllong() const;

  FCWString asString() const;

  int isZero() const;
  int isNegative() const;
  int isPositive() const;
  int isShortValueOverFlow() const;
  int isLongValueOverFlow() const;
  int isDblLongValueOverFlow() const;
  int checkMax() const;

  quadlong & operator = ( const quadlong & );
  quadlong & operator = ( const int );
  quadlong & operator = ( const dbllong & );

  const quadlong & operator + () const;
  quadlong operator - () const;

  quadlong & operator += ( const quadlong & );
  quadlong & operator -= ( const quadlong & );
  quadlong & operator *= ( const quadlong & );
  quadlong & operator /= ( const quadlong & );
  quadlong & operator %= ( const quadlong & );

  quadlong operator + ( const quadlong & ) const;
  quadlong operator - ( const quadlong & ) const;
  quadlong operator * ( const quadlong & ) const;
  quadlong operator / ( const quadlong & ) const;
  quadlong operator % ( const quadlong & ) const;

  int operator == ( const quadlong & ) const;
  int operator != ( const quadlong & ) const;
  int operator < ( const quadlong & ) const;
  int operator <= ( const quadlong & ) const;
  int operator > ( const quadlong & ) const;
  int operator >= ( const quadlong & ) const;

  quadlong & negate();
  quadlong & mul10();
  quadlong & absolute();

  quadlong divide( const quadlong & );

  char lastDigit();

  friend ostream & operator << ( ostream &,
                                 const quadlong & );
  static void initConstants();

private:

  int   _data[4];
  void* pData;

  void divide (quadlong, quadlong&, quadlong&) const;
  void shiftLeft ();
  void shiftRight ();
};

extern quadlong quadlong_0;
extern quadlong quadlong_10;
extern quadlong adj_tbl[];


#endif
