/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*****************************************************************************/
#ifndef  FCWOSQR_H
#define  FCWOSQR_H

class Item;

class FCWOSQR : public Record
{
  public:
           FCWOSQR( char*, long l );
          ~FCWOSQR();

     void Setup( void* = 0 );

     int  BeginAdd( short stmtID, short opt, short ida, short oda );
     int  EndAdd( char* stmt );

     int  BeginISU( short opr, short stmtID, short opt, short ida, short oda );
     int  EndSetIU( short opr, char* stmt );

     int  BeginInq( short stmtID, short opt, short ida, short oda )
          { return BeginISU( INQUIRY_OPR, stmtID, opt, ida, oda ); };
     int  EndInq( char* stmt );
     int  BeginUpd( short stmtID,  short opt, short ida, short oda )
          { return BeginISU( UPDATE_OPR, stmtID, opt, ida, oda ); };
     int  EndUpd( char* stmt );

     int  BegRpDl ( short opr, short stmtID,  short opt, short ida, short oda );
     int  EndRpDl ( char* stmt, short opr );
     int  BeginRep( short stmtID, short opt, short ida, short oda )
          { return BegRpDl( REPLACE_OPR, stmtID, opt, ida, oda ); };
     int  EndRep( char* stmt )
          { return EndRpDl( stmt, REPLACE_OPR ); };
     int  BeginDel( short stmtID, short opt, short ida, short oda )
          { return BegRpDl( DELETE_OPR, stmtID, opt, ida, oda ); };
     int  EndDel( char* stmt )
          { return EndRpDl( stmt, DELETE_OPR ); };

     int  BeginSetUpd( short stmtID, short opt, short ida, short oda )
          { return BeginISU( SETUPD_OPR, stmtID, opt, ida, oda ); };
     int  EndSetUpd( char* stmt )
          { return EndSetIU( SETUPD_OPR, stmt ); };
     int  BeginSetInq( short stmtID, short opt, short ida, short oda )
          { return BeginISU( SETINQ_OPR, stmtID, opt, ida, oda ); };
     int  EndSetInq( char* stmt )
          { return EndSetIU( SETINQ_OPR, stmt ); };

     int  BeginScan();
     int  EndScan();
     int  Close();

     int  BeginSQLExec( short stmtID, short opt, short ida, short oda );
     int  EndSQLExec( char* stmt );

     int  SetParm( unsigned short parmNum,
                   Item&  dte,
                   short int sqlType );

     int  BindCol( unsigned short parmNum,
                   Item&  dte,
                   short int sqlType );

     short GetCursorID();
     void  EndAppOnInvalidCursorID();

     int  Err();
     int  Hrd();
     int  Nrf();
     int  Dup();
     int  Ded();
     int  Unq();

     int  Lok();                             // followings not supported by SQL:
     int  Eof();                             //     always return False!!!
     int  Ful();
     int  Fmt();
     int  Fnf();
     int  Fna();

     char*  Name() { return recName;} ;      // return name of SQL row  @0001

   private:
     char*           pAppName;               // application Name
     FCWString       recName;                // name of SQL row
     void*           pSQLCA;                 // ptr to appl SQLCA
     void*           pStmtObj;               // statement handle
     char*           pSqlStmt;               // SQL statement for Prep/Exec
     unsigned short  ioStatus;               // database I/O status
     int             currStmtID;             // current statement id

     void*           pImpData;               // filler space
     FCWXOITF*       pDbDrv;

     void  IOErrorHandling( FCWXOCIB *pCIB, int msgno );

};


// -------------------------------------------------------------------
//  Function:  Dummy SQL row for SQLEXEC process option without
//             a process object
// -------------------------------------------------------------------
struct rcdEZEOSQR : public FCWOSQR
{
   rcdEZEOSQR() : FCWOSQR( "EZEOSQR", 0 ) {};
};


class FCWODBO : public FCWDBOBJ
{
  public:
    FCWODBO();
   ~FCWODBO();

    int   EZEConnect( char* id, char* psw, char* dbname, char* product,
                      char* release, char* uow, void* pCA );
    int   Commit( int option );
    int   RollBack( int option );
    int   Close( char opt );
    void* Register( void* p);
    int   DeRegister( void* p );
    void  SetIO( Bool f );
    Bool  IOPending();
    void  SaveOpenCursor( char* App, char* Rec, short CursorID, Bool bWithHold );
    void  GetOpenCursor( char* App, char* Rec, short& cursor, Bool& bWithHold );
    InitValue  DbmType();
    int   DftDBConnect( void* pCA );   // connect to database

    FCWXOITF* GetDrv();
    int  SwitchSFDB ( SFDBValue newDB );                          // PQ01395
    Bool FileSystemIsManagedByDB2();                              // PQ01395
    void SetDBNameForNextSQLIO( char* n );

    Bool DriverExists();                                          // PQ19733

  private:
    FCWXOITF* pDbDrv;
};

#endif
