/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*  Type    Date     Userid   Description of problem                         */
/*  ----  --------  --------  ---------------------------------------------  */
/*  A1    08/07/99  Lui       Feature 11712: Unicode Support                 */
/*  A2    08/02/00  mheitz    D14190: Missing standalone Unicode constructor */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWEXPU_H
#define FCWEXPU_H

#include <fcwexp.h>

// ************************************************************************
//                        Unicode data type                        @A1
// ************************************************************************

class UNICODE : public ChaItem
{
  public:

    UNICODE (Parent&, Level, int, int, int, int);
    UNICODE (const UNICODE&, int);
    UNICODE (const UNICODE&, quadnum);
    UNICODE (int, int);                                /*@A2*/
    virtual ~UNICODE();

    UNICODE operator [] (quadnum) const;

    void SetEmpty () const;
    Bool IsBlank();
    virtual FCWString StringForm();

    // Interactions with other UNICODE objects
    void operator =  (const UNICODE& v);
    int  operator == (const UNICODE& v) const;
    int  operator != (const UNICODE& v) const;
    int  operator >  (const UNICODE& v) const;
    int  operator <  (const UNICODE& v) const;
    int  operator >= (const UNICODE& v) const;
    int  operator <= (const UNICODE& v) const;

    int Contains( const UNICODE& v, const quadnum i );
    int CompareUcsUcs( const char* s1, const char* s2, int l1, int l2 ) const;
    char* getUCBlank() const;

    virtual int LengthWOTBlanks();

  private:
    void*    pData;
};



// *********************************************************************
// Stream overloads
// *********************************************************************

ostream& operator << (ostream&, const UNICODE&);               /*@A1*/

// *********************************************************************
// Trace overloads
// *********************************************************************

TraceFile& operator << (TraceFile&, const UNICODE&);          /*@A1*/


#endif
