/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/* ID  REF#     USER       DATE       DESCRIPTION                            */
/* ------------------------------------------------------------------------- */
/* A1  PQ22777  dewittsc   01/20/1999 Added SQLMapError and constants        */
/*                                                                           */
/*****************************************************************************/

#ifndef  FCWCSQL_H
#define  FCWCSQL_H

#include <fcwcmndb.h>
#include <fcwcmn.h>

#define   AHVPTR     void**

enum { opt_blank=1, opt_reset=2, opt_server=3 };     // SQL connect option

/* VG Common Error Codes */                       /*@A1*/

#define SQL_OK                          0         /*@A1*/
#define SQL_CURSOR_ALREADY_OPEN_ERR     1         /*@A1*/
#define SQL_CONNECTION_EXISTS_ERR       2         /*@A1*/
#define SQL_UNKNOWN_ERR                 -1        /*@A1*/

// ------------------------------------------------------------------
//              System dependent calls
// ------------------------------------------------------------------
class CmnSQLItf {

  public:
    int   virtual SQLStart() = 0;
    int   virtual SQLConnect( short opt, unsigned char* dbname, void* pCA ) = 0;

    int   virtual SQLMapError( int ) = 0;         /*@A1*/
    int   virtual SQLSetDBIOStatus( void *, unsigned short * ) = 0;
    void  virtual SQLGetDBMessage( void *, char*, int ) = 0;

    void  virtual SQLCopyRsCAToApp( void*, void* ) = 0;
    void  virtual SQLBackupCA( void**, void* ) = 0;
    void  virtual SQLRestoreCA( void*, void* ) = 0;
    int   virtual SQLTransact( char ) = 0;
    int   virtual SQLBind( unsigned char* plan, unsigned char* dbname, void* pCA ) = 0;

    FCWString virtual SQLGetProduct( void* pCA ) = 0;
    FCWString virtual SQLGetRelease( void* pCA ) = 0;
    Bool  virtual SQLTypeIsVarLenChar( short ) = 0;
};

typedef CmnSQLItf* (*PFItf)();
typedef CmnSQLItf*   HSQLDRV;

#endif
