/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vgj.uibean;

import com.ibm.hpt.gateway.GatewayException;
import com.ibm.vgj.uibean.VGJDataItemFormat;
import com.ibm.vgj.wgs.VGJBigNumber;
import com.ibm.vgj.wgs.VGJDataItem;
import com.ibm.vgj.wgs.VGJException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class VGJLinkItemFormat
extends VGJDataItemFormat {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private String _programName = null;
    private String _firstUIRecord = null;
    private Hashtable _linkParms = new Hashtable();
    private boolean _newWindow = false;

    public VGJLinkItemFormat(VGJDataItem vGJDataItem) {
        super(vGJDataItem);
    }

    public VGJLinkItemFormat(VGJDataItem vGJDataItem, Locale locale) {
        super(vGJDataItem, locale);
    }

    public String getGatewayURL() throws VGJException, GatewayException {
        return this.getGatewayURL(0);
    }

    public String getGatewayURL(int n) throws VGJException, GatewayException {
        StringBuffer stringBuffer = new StringBuffer(this.getBean().getGatewayURL(this._programName));
        if (this._programName != null) {
            stringBuffer.append("?");
            stringBuffer.append(this.getProgramParm());
            stringBuffer.append("&hptExec=Y");
            stringBuffer.append(this.getRecordParm());
            if (this.getUIType() == 16) {
                stringBuffer.append(this.getLinkParms(n));
            }
        }
        return stringBuffer.toString();
    }

    private String getLinkParms() throws VGJException, GatewayException {
        return this.getLinkParms(0);
    }

    private String getLinkParms(int n) throws VGJException, GatewayException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this._linkParms.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this._linkParms.get(string);
            String string2 = null;
            if (v instanceof String) {
                string2 = (String)v;
            } else if (v instanceof VGJBigNumber) {
                string2 = ((VGJBigNumber)v).toString();
            } else {
                VGJDataItemFormat vGJDataItemFormat = this.getBean().formatFromItem((VGJDataItem)v);
                if (vGJDataItemFormat.getOccurs() > 1 && n < vGJDataItemFormat.getOccurs()) {
                    string2 = vGJDataItemFormat.getFormattedText(n).trim();
                } else if (vGJDataItemFormat.getOccurs() == 1) {
                    string2 = vGJDataItemFormat.getFormattedText().trim();
                } else {
                    this.trace("getLinkParms - Index, " + n + ", is out of range for item, " + ((VGJDataItem)v).getName() + " - returning empty value");
                    string2 = new String();
                }
            }
            stringBuffer.append("&" + URLEncoder.encode(string) + "=" + URLEncoder.encode(string2));
        }
        return stringBuffer.toString();
    }

    private String getProgramParm() {
        if (this._programName == null || this._programName.length() == 0) {
            return new String();
        }
        return "hptAppId=" + URLEncoder.encode(this._programName);
    }

    private String getRecordParm() {
        if (this._firstUIRecord == null || this._firstUIRecord.length() == 0) {
            return new String();
        }
        return "&hptRecord=" + URLEncoder.encode(this._firstUIRecord);
    }

    public String getSecureGatewayURL() throws VGJException, GatewayException {
        return this.getSecureGatewayURL(0);
    }

    public String getSecureGatewayURL(int n) throws VGJException, GatewayException {
        String string = this.getGatewayURL(n);
        if (string.startsWith("http") && !string.startsWith("https:")) {
            string = "https" + string.substring(4);
        }
        return string;
    }

    public void setFirstUIRecord(String string) {
        this._firstUIRecord = string;
    }

    public void setLinkParameter(String string, VGJBigNumber vGJBigNumber) {
        this._linkParms.put(string, vGJBigNumber);
    }

    public void setLinkParameter(String string, VGJDataItem vGJDataItem) {
        this._linkParms.put(string, vGJDataItem);
    }

    public void setLinkParameter(String string, String string2) {
        this._linkParms.put(string, string2);
    }

    public void setNewWindow(boolean bl) {
        this._newWindow = bl;
    }

    public void setProgramName(String string) {
        this._programName = string;
    }
}

