/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vgj.uibean;

import com.ibm.hpt.gateway.GatewayException;
import com.ibm.vgj.uibean.VGJDataItemFormat;
import com.ibm.vgj.uibean.VGJInvalidInputException;
import com.ibm.vgj.wgs.VGJ4GLPart;
import com.ibm.vgj.wgs.VGJChaItem;
import com.ibm.vgj.wgs.VGJDataItem;
import com.ibm.vgj.wgs.VGJException;
import com.ibm.vgj.wgs.VGJUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class VGJDateItemFormat
extends VGJDataItemFormat {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private static final String DEFAULT_DATE_MASK = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_MASK = "HH:mm:ss";
    DateFormat _inDateFormatter = null;
    DateFormat _exDateFormatter = null;
    boolean _dateEdit = false;
    int _dateFormat = -1;
    String _dateMask = null;
    String _timeMask = null;
    boolean _timeEdit = false;
    boolean _isGregorianDateMask = false;
    boolean _isLongDateMask = false;
    int _timeFormat = -1;
    String _stimeFormat = "HH:mm:ss";

    public VGJDateItemFormat(VGJDataItem vGJDataItem) {
        super(vGJDataItem);
    }

    public VGJDateItemFormat(VGJDataItem vGJDataItem, Locale locale) {
        super(vGJDataItem, locale);
    }

    private String dateToString(Date date) throws ParseException {
        int n;
        int n2;
        int n3;
        if (this._item instanceof VGJChaItem) {
            return this.getInternalDateFormatter().format(date);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.isGregorianDateMask()) {
            n3 = calendar.get(1);
            n2 = calendar.get(2) + 1;
            int n4 = calendar.get(5);
            n = this.isLongDateMask() ? n3 * 10000 + n2 * 100 + n4 : n3 % 100 * 10000 + n2 * 100 + n4;
        } else {
            n3 = calendar.get(1);
            n2 = calendar.get(6);
            n = this.isLongDateMask() ? n3 * 1000 + n2 : n3 % 100 * 1000 + n2;
        }
        String string = String.valueOf(n);
        while (string.length() != this._item.getLength()) {
            string = "0" + string;
        }
        return string;
    }

    protected String formatData(int n) throws VGJException, GatewayException {
        String string = this.getItem().toString(n);
        try {
            int n2;
            if (this._item instanceof VGJChaItem ? string.trim().length() == 0 : (n2 = Integer.parseInt(string)) == 0) {
                return new String();
            }
            return this.getExternalDateFormatter().format(this.stringToDate(string));
        }
        catch (ParseException parseException) {
            throw new GatewayException(parseException);
        }
    }

    private String getDateMask() {
        if (this._dateMask == null) {
            this._dateMask = this.getBean().getDateMask();
            if (this._dateMask != null) {
                boolean bl;
                boolean bl2 = this._isGregorianDateMask = VGJUtil.isGregorianDateMask((String)this._dateMask.toUpperCase(), (boolean)true) || VGJUtil.isGregorianDateMask((String)this._dateMask.toUpperCase(), (boolean)false);
                if (this._isGregorianDateMask) {
                    this._isLongDateMask = VGJUtil.isGregorianDateMask((String)this._dateMask.toUpperCase(), (boolean)false);
                }
                boolean bl3 = bl = VGJUtil.isJulianDateMask((String)this._dateMask.toUpperCase(), (boolean)true) || VGJUtil.isJulianDateMask((String)this._dateMask.toUpperCase(), (boolean)false);
                if (!this._isGregorianDateMask && !bl) {
                    this.trace("Specified date mask, \"" + this._dateMask + "\", is invalid, use default, \"" + DEFAULT_DATE_MASK + "\"");
                    this._dateMask = null;
                }
            }
            if (this._dateMask == null) {
                this._dateMask = DEFAULT_DATE_MASK;
                this._isGregorianDateMask = true;
                this._isLongDateMask = true;
            }
            char[] cArray = this._dateMask.toLowerCase().toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (this._isGregorianDateMask) {
                    if (cArray[n] == 'm') {
                        cArray[n] = 77;
                    }
                } else if (cArray[n] == 'd') {
                    cArray[n] = 68;
                }
                ++n;
            }
            this._dateMask = new String(cArray);
        }
        return this._dateMask;
    }

    private DateFormat getDefaultExternalDateFormatter() {
        DateFormat dateFormat = null;
        if (this._dateEdit && !this._timeEdit) {
            dateFormat = DateFormat.getDateInstance(3, this.getBean().getLocale());
        } else if (!this._dateEdit && this._timeEdit) {
            dateFormat = new SimpleDateFormat(DEFAULT_TIME_MASK, this.getBean().getLocale());
            this.trace("time format:" + dateFormat.toString() + " " + dateFormat.getClass().toString());
        } else {
            dateFormat = this._dateEdit && this._timeEdit ? DateFormat.getDateTimeInstance(3, 3, this.getBean().getLocale()) : DateFormat.getDateTimeInstance(3, 3, this.getBean().getLocale());
        }
        if (dateFormat instanceof SimpleDateFormat) {
            String string = ((SimpleDateFormat)dateFormat).toPattern();
            int n = string.indexOf("yy");
            int n2 = string.indexOf("yyyy");
            if (n != -1 && n2 == -1) {
                string = String.valueOf(string.substring(0, n)) + "yyyy" + string.substring(n + 2, string.length());
            }
            ((SimpleDateFormat)dateFormat).applyPattern(string);
        }
        return dateFormat;
    }

    private DateFormat getExternalDateFormatter() {
        if (this._exDateFormatter == null) {
            this._exDateFormatter = this.getDefaultExternalDateFormatter();
            this._exDateFormatter.setLenient(false);
        }
        return this._exDateFormatter;
    }

    private DateFormat getInternalDateFormatter() {
        if (this._inDateFormatter == null) {
            if (this._dateEdit && !this._timeEdit) {
                this.trace("Internal Date Mask: \"" + this.getDateMask() + "\"");
                this._inDateFormatter = new SimpleDateFormat(this.getDateMask(), this.getLocale());
            } else if (!this._dateEdit && this._timeEdit) {
                this.trace("Internal Time Mask: \"" + this.getTimeMask() + "\"");
                this._inDateFormatter = new SimpleDateFormat(this.getTimeMask(), this.getLocale());
            } else if (this._dateEdit && this._timeEdit) {
                this.trace("Internal Date Mask: \"" + this.getDateMask() + "\"");
                this.trace("Internal Time Mask: \"" + this.getTimeMask() + "\"");
                this._inDateFormatter = new SimpleDateFormat(String.valueOf(this.getDateMask()) + " " + this.getTimeMask(), this.getLocale());
            } else {
                this._inDateFormatter = DateFormat.getDateTimeInstance();
            }
        }
        return this._inDateFormatter;
    }

    private String getTimeMask() {
        if (this._timeMask == null) {
            this._timeMask = DEFAULT_TIME_MASK;
        }
        return this._timeMask;
    }

    private boolean isGregorianDateMask() {
        this.getDateMask();
        return this._isGregorianDateMask;
    }

    private boolean isLongDateMask() {
        this.getDateMask();
        return this._isLongDateMask;
    }

    String performEdits(int n) throws VGJInvalidInputException {
        try {
            ParsePosition parsePosition = new ParsePosition(0);
            Date date = this.getExternalDateFormatter().parse(this.getInputString(n), parsePosition);
            if (parsePosition.getIndex() != this.getInputString(n).length() || date == null) {
                throw new ParseException(this.getItem().getName(), parsePosition.getIndex());
            }
            String string = this.dateToString(date);
            return string;
        }
        catch (ParseException parseException) {
            Object[] objectArray = new Object[]{String.valueOf(this.getItem().getName()) + "[" + String.valueOf(n + 1) + "]", ((SimpleDateFormat)this.getExternalDateFormatter()).toPattern()};
            throw new VGJInvalidInputException((VGJ4GLPart)this.getItem(), "VGJ0508E", objectArray);
        }
    }

    public void setDateEdit(boolean bl) {
        this._dateEdit = bl;
    }

    void setDateTimeFormat(DateFormat dateFormat) {
        this._exDateFormatter = dateFormat;
    }

    public void setTimeEdit(boolean bl) {
        this._timeEdit = bl;
    }

    private Date stringToDate(String string) throws ParseException {
        if (this._item instanceof VGJChaItem) {
            return this.getInternalDateFormatter().parse(string);
        }
        int n = Integer.parseInt(string);
        Calendar calendar = Calendar.getInstance();
        if (this.isGregorianDateMask()) {
            int n2 = n / 10000;
            int n3 = n / 100 % 100;
            int n4 = n % 100;
            if (n2 < 100) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy");
                String string2 = simpleDateFormat.format(new Date());
                int n5 = string2.lastIndexOf("/");
                if (n5 == -1) {
                    n5 = string2.length();
                }
                String string3 = new String("00" + n2);
                string2 = String.valueOf(string2.substring(0, n5 + 1)) + string3.substring(string3.length() - 2);
                calendar.setTime(simpleDateFormat.parse(string2));
                n2 = calendar.get(1);
            }
            calendar.set(5, n4);
            calendar.set(2, n3 - 1);
            calendar.set(1, n2);
        } else {
            int n6 = n / 1000;
            int n7 = n % 1000;
            if (n6 < 100) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy");
                String string4 = simpleDateFormat.format(new Date());
                int n8 = string4.lastIndexOf("/");
                if (n8 == -1) {
                    n8 = string4.length();
                }
                String string5 = new String("00" + n6);
                string4 = String.valueOf(string4.substring(0, n8 + 1)) + string5.substring(string5.length() - 2);
                calendar.setTime(simpleDateFormat.parse(string4));
                n6 = calendar.get(1);
            }
            calendar.set(6, n7);
            calendar.set(1, n6);
        }
        return calendar.getTime();
    }
}

