/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vgj.uibean;

import com.ibm.hpt.gateway.GatewayException;
import com.ibm.vgj.uibean.VGJDataItemFormat;
import com.ibm.vgj.wgs.VGJException;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class VGDataElement {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private VGJDataItemFormat _format = null;
    private int _index = 0;

    public VGDataElement(VGJDataItemFormat vGJDataItemFormat) {
        this(vGJDataItemFormat, 0);
    }

    public VGDataElement(VGJDataItemFormat vGJDataItemFormat, int n) {
        this._format = vGJDataItemFormat;
        this._index = n;
    }

    private void checkIndex(int n) throws GatewayException {
        try {
            this._format.checkIndex(n);
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public Enumeration getEditTableValues() {
        return this._format.getEditTableValues();
    }

    public String getErrorMessage() throws GatewayException {
        return this.getErrorMessage(this._index);
    }

    public String getErrorMessage(int n) throws GatewayException {
        this.checkIndex(n);
        return this._format.getErrorMsg(n);
    }

    public String getGatewayURL() throws GatewayException {
        return this.getGatewayURL(this._index);
    }

    public String getGatewayURL(int n) throws GatewayException {
        this.checkIndex(n);
        try {
            return this._format.getGatewayURL(n);
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public String getHelpText() {
        return this._format.getHelpText();
    }

    public int getIndex() {
        return this._index;
    }

    public String getLabel() throws GatewayException {
        return this.getLabel(this._index);
    }

    public String getLabel(int n) throws GatewayException {
        this.checkIndex(n);
        try {
            return this._format.getLabel(n);
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public String getSecureGatewayURL() throws GatewayException {
        return this.getSecureGatewayURL(this._index);
    }

    public String getSecureGatewayURL(int n) throws GatewayException {
        this.checkIndex(n);
        try {
            return this._format.getSecureGatewayURL();
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public String getTextValue() throws GatewayException {
        return this.getTextValue(this._index);
    }

    public String getTextValue(int n) throws GatewayException {
        this.checkIndex(n);
        try {
            return this._format.getFormattedText(n);
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public Object getTextValuesTable() throws GatewayException {
        return this.getTextValuesTable(this._index);
    }

    public Object getTextValuesTable(int n) throws GatewayException {
        this.checkIndex(n);
        try {
            return this._format.getFormattedTextTable(n);
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public boolean hasInputError() throws GatewayException {
        return this.hasInputError(this._index);
    }

    public boolean hasInputError(int n) throws GatewayException {
        this.checkIndex(n);
        return this._format.hasInputError(n);
    }

    public boolean hasLabel() throws GatewayException {
        return this.hasLabel(this._index);
    }

    public boolean hasLabel(int n) throws GatewayException {
        this.checkIndex(n);
        try {
            return this._format.hasLabel(n);
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public boolean isAnyModified() {
        return this._format.isAnyModified();
    }

    public boolean isDisplayable() throws GatewayException {
        return this.isDisplayable(this._index);
    }

    public boolean isDisplayable(int n) throws GatewayException {
        this.checkIndex(n);
        try {
            return this._format.isDisplayable(n);
        }
        catch (VGJException vGJException) {
            this.trace(vGJException);
            throw new GatewayException(vGJException);
        }
    }

    public boolean isEmpty() {
        return this._format.isEmpty();
    }

    public boolean isSelected() throws GatewayException {
        return this.isSelected(this._index);
    }

    public boolean isSelected(int n) throws GatewayException {
        this.checkIndex(n);
        return this._format.isSelected(n);
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public Enumeration occurrences() {
        Vector<VGDataElement> vector = new Vector<VGDataElement>();
        int n = 0;
        while (n < this._format.getOccurs()) {
            vector.addElement(new VGDataElement(this._format, n));
            ++n;
        }
        return vector.elements();
    }

    public void setDateTimeFormat(DateFormat dateFormat) {
        this._format.setDateTimeFormat(dateFormat);
    }

    public void setErrorMsg(int n, String string) throws GatewayException {
        this.checkIndex(n);
        this._format.setErrorMsg(n, string);
    }

    public void setErrorMsg(String string) throws GatewayException {
        this.setErrorMsg(this._index, string);
    }

    public Enumeration subElements() throws GatewayException {
        return this.subElements(this._index);
    }

    public Enumeration subElements(int n) throws GatewayException {
        this.checkIndex(n);
        return this._format.getSubElements(n).elements();
    }

    public void trace(String string) {
        this._format.trace(string);
    }

    public void trace(Throwable throwable) {
        this._format.trace(throwable);
    }
}

