/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vgj.uibean;

import com.ibm.vgj.cso.CSOIntConverter;

public class UIRecordSegment {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private int segmentOffset;
    private int segmentLength;
    private byte[] segmentData;

    public UIRecordSegment() {
    }

    public UIRecordSegment(byte[] byArray, int n, int n2) {
        this.fromBytes(byArray, n, n2);
    }

    public void fromBytes(byte[] byArray, int n, int n2) {
        this.segmentOffset = CSOIntConverter.intFrom4Bytes((byte[])byArray, (int)n, (int)n2);
        this.segmentLength = CSOIntConverter.intFrom4Bytes((byte[])byArray, (int)(n + 4), (int)n2);
        this.segmentData = new byte[this.segmentLength];
        System.arraycopy(byArray, n + 8, this.segmentData, 0, this.segmentLength);
    }

    public byte[] getData() {
        return this.segmentData;
    }

    public int getLength() {
        return this.segmentLength;
    }

    public int getOffset() {
        return this.segmentOffset;
    }

    public void setData(byte[] byArray) {
        this.segmentData = byArray;
    }

    public void setLength(int n) {
        this.segmentLength = n;
    }

    public void setOffset(int n) {
        this.segmentOffset = n;
    }

    public byte[] toBytes(int n) {
        byte[] byArray = new byte[this.segmentLength + 8];
        System.arraycopy(CSOIntConverter.get4Bytes((int)this.segmentOffset, (int)n), 0, byArray, 0, 4);
        System.arraycopy(CSOIntConverter.get4Bytes((int)this.segmentLength, (int)n), 0, byArray, 4, 4);
        System.arraycopy(this.segmentData, 0, byArray, 8, this.segmentLength);
        return byArray;
    }
}

