/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hpt.gateway;

import com.ibm.hpt.gateway.SessionIDManagerI;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;

public class SessionIDManager
extends UnicastRemoteObject
implements SessionIDManagerI {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private String _prefix = "CUIR";
    private int _maxSessionIDs = 10000;
    private int _nextID = 0;
    private String[] _usedIDs = null;
    static final int MINPREFIXLENGTH = 4;
    static final int MAXPREFIXLENGTH = 7;
    static final int MAXIDLENGTH = 8;

    public SessionIDManager() throws RemoteException, MalformedURLException, UnknownHostException {
        this((String)null);
    }

    public SessionIDManager(String string) throws RemoteException, MalformedURLException, UnknownHostException {
        if (string != null && string.length() > 0) {
            this._prefix = string.trim();
            if (this._prefix.length() >= 8) {
                this._prefix = this._prefix.substring(0, 7);
            }
            if (this._prefix.length() < 4) {
                this._prefix = String.valueOf(this._prefix) + new String("0000").substring(0, 4 - this._prefix.length());
            }
            this._maxSessionIDs = new Integer(new String("99999999").substring(0, 8 - this._prefix.length())) + 1;
            if (this._maxSessionIDs == 0) {
                this._maxSessionIDs = 1;
            }
        }
        this._usedIDs = new String[this._maxSessionIDs];
        this.setLocalHostAddress();
        try {
            Naming.rebind("hptSessionIDManager", this);
            System.err.println("Server started, bound to Java RMI Registry.");
        }
        catch (ConnectIOException connectIOException) {
            try {
                System.err.println("Java RMI Registry not found...creating one");
                Registry registry = LocateRegistry.createRegistry(1099);
                registry.rebind("hptSessionIDManager", this);
                System.err.println("Server started, bound to Java RMI Registry.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Unable to start registry. Use local ID manager");
            }
        }
        catch (ConnectException connectException) {
            try {
                System.err.println("Java RMI Registry not found...creating one");
                Registry registry = LocateRegistry.createRegistry(1099);
                registry.rebind("hptSessionIDManager", this);
                System.err.println("Server started, bound to Java RMI Registry.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Unable to start registry. Use local ID manager");
            }
        }
    }

    public String getSessionID() throws RemoteException {
        String[] stringArray = this._usedIDs;
        synchronized (this._usedIDs) {
            String string = null;
            int n = 0;
            while (n < this._maxSessionIDs) {
                if (this._usedIDs[n] == null) {
                    String string2 = Integer.toString(n);
                    string2 = String.valueOf(new String("00000000").substring(this._prefix.length() + string2.length())) + Integer.toString(n);
                    this._usedIDs[n] = string = String.valueOf(this._prefix) + string2;
                    break;
                }
                ++n;
            }
            System.out.println(String.valueOf(new Date().toString()) + " - Session, " + string + ", created");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }

    public String getSessionID_rr() throws RemoteException {
        String[] stringArray = this._usedIDs;
        synchronized (this._usedIDs) {
            String string = null;
            int n = this._nextID;
            do {
                if (this._usedIDs[n] != null) continue;
                String string2 = Integer.toString(n);
                string2 = String.valueOf(new String("00000000").substring(this._prefix.length() + string2.length())) + Integer.toString(n);
                this._usedIDs[n] = string = String.valueOf(this._prefix) + string2;
            } while ((n = (n + 1) % this._maxSessionIDs) != this._nextID && string == null);
            this._nextID = n;
            System.out.println("Session, " + string + ", created");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                new SessionIDManager();
            } else {
                new SessionIDManager(stringArray[0]);
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to create a SessionIDManager");
            exception.printStackTrace();
        }
    }

    public void releaseSessionID(String string) throws RemoteException {
        String[] stringArray = this._usedIDs;
        synchronized (this._usedIDs) {
            if (string == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int n = Integer.valueOf(string.substring(this._prefix.length()));
            if (this._usedIDs[n] != null && this._usedIDs[n].equals(string)) {
                this._usedIDs[n] = null;
                System.out.println(String.valueOf(new Date().toString()) + " - Session, " + string + ", released");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setLocalHostAddress() {
        String string = "java.rmi.server.hostname";
        Properties properties = System.getProperties();
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostAddress();
                ((Hashtable)properties).put(string, string2);
                System.setProperties(properties);
            }
            catch (IOException iOException) {}
        }
    }
}

