/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hpt.gateway;

import com.ibm.hpt.gateway.CSOServerCommunications;
import com.ibm.hpt.gateway.GatewayException;
import com.ibm.hpt.gateway.GatewayRequestHandler;
import com.ibm.hpt.gateway.GatewayServlet;
import com.ibm.hpt.gateway.SessionIDManagerI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class GatewaySessionData
implements Serializable,
HttpSessionBindingListener {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private boolean _hasLogin = false;
    private boolean _hasServedLogin = false;
    private String _userid = null;
    private String _password = null;
    private String _remoteUser = null;
    private String _idManagerHost = null;
    private String _ezeusr = null;
    private String _logFileName = null;
    private String _serverErrorPackage = null;
    private String _dateMask = null;
    private Hashtable _handlersBySessionID = new Hashtable();
    private Hashtable _handlersByInitialApp = new Hashtable();
    private Hashtable _handlersByURL = new Hashtable();
    private boolean _bProcessingEntryApp = false;
    private transient CSOServerCommunications _server = new CSOServerCommunications(this);
    private transient SessionIDManagerI _idManager = null;
    private transient GatewayServlet _servlet = null;

    public void addHandler(GatewayRequestHandler gatewayRequestHandler) throws GatewayException {
        if (gatewayRequestHandler == null) {
            return;
        }
        gatewayRequestHandler.setSessionData(this);
        gatewayRequestHandler.setSessionID(this.getSessionID());
        this.addHandlersByInitialApp(gatewayRequestHandler);
        this.addHandlersBySessionID(gatewayRequestHandler);
        this.addHandlersByURL(gatewayRequestHandler);
        this.trace("Handler added for application: \"" + gatewayRequestHandler.getProgramName() + "\", app id.....: \"" + gatewayRequestHandler.getSessionID() + "\", url........: \"" + gatewayRequestHandler.getURL() + "\"");
    }

    private void addHandlersByInitialApp(GatewayRequestHandler gatewayRequestHandler) {
        String string = gatewayRequestHandler.getInitialProgramName();
        Vector<GatewayRequestHandler> vector = this.handlersFromInitialApp(string);
        if (vector == null) {
            vector = new Vector<GatewayRequestHandler>();
            this._handlersByInitialApp.put(string, vector);
        }
        vector.addElement(gatewayRequestHandler);
    }

    private void addHandlersBySessionID(GatewayRequestHandler gatewayRequestHandler) {
        this._handlersBySessionID.put(gatewayRequestHandler.getSessionID(), gatewayRequestHandler);
    }

    private void addHandlersByURL(GatewayRequestHandler gatewayRequestHandler) {
        String string = gatewayRequestHandler.getURL();
        Vector<GatewayRequestHandler> vector = this.handlersFromURL(string);
        if (vector == null) {
            vector = new Vector<GatewayRequestHandler>();
            this._handlersByURL.put(string, vector);
        }
        vector.addElement(gatewayRequestHandler);
    }

    protected void finalize() {
        this.unbind();
        this.releaseEzeusr();
    }

    public String getDateMask() {
        return this._dateMask;
    }

    public String getEzeusr() throws GatewayException {
        if (this._ezeusr == null) {
            try {
                this._ezeusr = this.getIDManager().getSessionID();
            }
            catch (Exception exception) {
                GatewayException gatewayException = new GatewayException("VGJ0611E", new Object[0]);
                System.err.println(((Throwable)((Object)gatewayException)).getMessage());
                this.trace(((Throwable)((Object)gatewayException)).getMessage(), false);
                throw gatewayException;
            }
        }
        return this._ezeusr;
    }

    public boolean getHasLogin() {
        return this._hasLogin;
    }

    public SessionIDManagerI getIDManager() throws GatewayException {
        this.setup();
        return this._idManager;
    }

    public String getIDManagerHost() {
        if (this._idManagerHost == null) {
            try {
                this._idManagerHost = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable throwable) {}
        }
        return this._idManagerHost;
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public String getPassword() {
        if (this._password == null) {
            this._password = new String();
        }
        return this._password;
    }

    public String getRemoteUser() {
        if (this._remoteUser == null) {
            this._remoteUser = new String();
        }
        return this._remoteUser;
    }

    public CSOServerCommunications getServer() {
        return this._server;
    }

    public String getServerErrorPackage() {
        return this._serverErrorPackage;
    }

    public GatewayServlet getServlet() {
        return this._servlet;
    }

    private String getSessionID() throws GatewayException {
        try {
            return this.getIDManager().getSessionID();
        }
        catch (Exception exception) {
            GatewayException gatewayException = new GatewayException("VGJ0611E", new Object[0]);
            System.err.println(((Throwable)((Object)gatewayException)).getMessage());
            this.trace(((Throwable)((Object)gatewayException)).getMessage());
            throw gatewayException;
        }
    }

    public String getUserid() {
        if (this._userid == null) {
            this._userid = new String();
        }
        return this._userid;
    }

    private GatewayRequestHandler handlerFromSessionID(String string) {
        return (GatewayRequestHandler)this._handlersBySessionID.get(string);
    }

    public GatewayRequestHandler handlerFromSessionIDAndApp(String string, String string2) {
        GatewayRequestHandler gatewayRequestHandler = this.handlerFromSessionID(string);
        if (gatewayRequestHandler != null && gatewayRequestHandler.getProgramName().equals(string2)) {
            return gatewayRequestHandler;
        }
        if (gatewayRequestHandler != null) {
            this.trace("handler for app, " + gatewayRequestHandler.getProgramName());
        }
        return null;
    }

    public GatewayRequestHandler handlerFromURLAndApp(String string, String string2) {
        this.trace("Find handler from url, \"" + string + "\", and app, \"" + string2 + "\"");
        Vector vector = this.handlersFromURL(string);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                GatewayRequestHandler gatewayRequestHandler = (GatewayRequestHandler)enumeration.nextElement();
                if (!gatewayRequestHandler.getInitialProgramName().equals(string2)) continue;
                return gatewayRequestHandler;
            }
        }
        return null;
    }

    private Vector handlersFromInitialApp(String string) {
        return (Vector)this._handlersByInitialApp.get(string);
    }

    private Vector handlersFromURL(String string) {
        return (Vector)this._handlersByURL.get(string);
    }

    public boolean hasServedLogin() {
        return this._hasServedLogin;
    }

    public boolean isProcessingEntryApp() {
        return this._bProcessingEntryApp;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.println("--> GatewaySessionData.readObject");
        objectInputStream.defaultReadObject();
        System.out.println("GatewaySessionData.readObject - initialize transients");
        this._server = new CSOServerCommunications(this);
        this._servlet = null;
        try {
            this.getIDManager();
        }
        catch (GatewayException gatewayException) {
            this._idManager = null;
        }
        Enumeration enumeration = this._handlersBySessionID.elements();
        while (enumeration.hasMoreElements()) {
            GatewayRequestHandler gatewayRequestHandler = (GatewayRequestHandler)enumeration.nextElement();
            gatewayRequestHandler.setSessionData(this);
        }
        System.out.println("<-- GatewaySessionData.readObject");
    }

    synchronized void releaseEzeusr() {
        this.releaseSessionID(this._ezeusr);
        this._ezeusr = null;
    }

    private void releaseSessionID(String string) {
        if (string == null) {
            return;
        }
        try {
            this.getIDManager().releaseSessionID(string);
        }
        catch (Exception exception) {}
    }

    public void removeHandler(GatewayRequestHandler gatewayRequestHandler) {
        if (gatewayRequestHandler == null) {
            return;
        }
        gatewayRequestHandler.setSessionData(null);
        this.removeHandlersByInitialApp(gatewayRequestHandler);
        this.removeHandlersBySessionID(gatewayRequestHandler);
        this.removeHandlersByURL(gatewayRequestHandler);
        this.releaseSessionID(gatewayRequestHandler.getSessionID());
        this.trace("Handler removed for application: \"" + gatewayRequestHandler.getProgramName() + "\", app id.....: \"" + gatewayRequestHandler.getSessionID() + "\", url........: \"" + gatewayRequestHandler.getURL() + "\"");
    }

    private void removeHandlersByInitialApp(GatewayRequestHandler gatewayRequestHandler) {
        Vector vector = this.handlersFromInitialApp(gatewayRequestHandler.getInitialProgramName());
        if (vector != null) {
            vector.removeElement(gatewayRequestHandler);
            if (vector.size() == 0) {
                this._handlersByInitialApp.remove(gatewayRequestHandler.getInitialProgramName());
            }
        }
    }

    private void removeHandlersBySessionID(GatewayRequestHandler gatewayRequestHandler) {
        this._handlersBySessionID.remove(gatewayRequestHandler.getSessionID());
    }

    private void removeHandlersByURL(GatewayRequestHandler gatewayRequestHandler) {
        Vector vector = this.handlersFromURL(gatewayRequestHandler.getURL());
        if (vector != null) {
            vector.removeElement(gatewayRequestHandler);
            if (vector.size() == 0) {
                this._handlersByURL.remove(gatewayRequestHandler.getURL());
            }
        }
    }

    void reset() {
        this._userid = null;
        this._password = null;
        this._hasLogin = false;
        this._hasServedLogin = false;
        this.unbind();
    }

    public void setDateMask(String string) {
        this._dateMask = string;
    }

    public void setHasLogin(boolean bl) {
        this._hasLogin = bl;
    }

    public void setHasServedLogin(boolean bl) {
        this._hasServedLogin = bl;
    }

    public void setIDManagerHost(String string) {
        this._idManagerHost = string;
    }

    public void setLogFileName(String string) {
        this._logFileName = string;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public void setProcessingEntryApp(boolean bl) {
        this._bProcessingEntryApp = bl;
    }

    public void setRemoteUser(String string) {
        this._remoteUser = string;
    }

    public void setServerErrorPackage(String string) {
        this._serverErrorPackage = string;
    }

    void setServlet(GatewayServlet gatewayServlet) {
        this._servlet = gatewayServlet;
    }

    public void setup() throws GatewayException {
        if (this._idManager == null) {
            try {
                String string = "hptSessionIDManager";
                String string2 = this.getIDManagerHost();
                if (string2 != null) {
                    string = "//" + string2 + "/" + string;
                }
                this._idManager = (SessionIDManagerI)Naming.lookup(string);
                Object[] objectArray = new Object[]{this.getRemoteUser()};
                System.out.println(GatewayException.buildErrorMessage("VGJ0612I", objectArray));
            }
            catch (Exception exception) {
                GatewayException gatewayException = new GatewayException("VGJ0611E", new Object[0]);
                System.err.println(((Throwable)((Object)gatewayException)).getMessage());
                this.trace(((Throwable)((Object)gatewayException)).getMessage());
                throw gatewayException;
            }
        }
    }

    public void setUserid(String string) {
        this._userid = string;
    }

    public void trace(String string) {
        this.trace(string, true);
    }

    public void trace(String string, boolean bl) {
        String string2 = null;
        if (bl) {
            try {
                string2 = String.valueOf(this.getEzeusr()) + " - ";
            }
            catch (Exception exception) {
                string2 = new String();
            }
        } else {
            string2 = new String();
        }
        if (this.getServlet() == null) {
            System.out.println(String.valueOf(new Date().toString()) + " - " + string2 + string);
        } else {
            this.getServlet().trace(String.valueOf(new Date().toString()) + " - " + string2 + string);
        }
    }

    public void trace(Throwable throwable) {
        this.getServlet().trace(throwable);
    }

    synchronized void unbind() {
        if (this._idManager != null) {
            Enumeration enumeration = this._handlersBySessionID.elements();
            while (enumeration.hasMoreElements()) {
                GatewayRequestHandler gatewayRequestHandler = (GatewayRequestHandler)enumeration.nextElement();
                this.releaseSessionID(gatewayRequestHandler.getSessionID());
            }
        }
        this._handlersBySessionID = new Hashtable();
        this._handlersByInitialApp = new Hashtable();
        this._handlersByURL = new Hashtable();
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        Object[] objectArray = new String[1];
        try {
            objectArray[0] = this.getEzeusr();
        }
        catch (Exception exception) {
            objectArray[0] = new String();
        }
        String string = GatewayException.buildErrorMessage("VGJ0609I", objectArray);
        System.out.println(string);
        this.trace(string);
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        Object[] objectArray = new String[1];
        try {
            objectArray[0] = this.getEzeusr();
        }
        catch (Exception exception) {
            objectArray[0] = new String();
        }
        String string = GatewayException.buildErrorMessage("VGJ0610I", objectArray);
        System.out.println(string);
        this.trace(string);
        this.unbind();
        this.releaseEzeusr();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector;
        System.out.println("--> GatewaySessionData.writeObject");
        System.out.println("GatewaySessionData.writeObject - preparing for writing");
        System.out.println("handers By sessionid is empty? " + this._handlersBySessionID.isEmpty());
        System.out.println("handers By initial App is empty? " + this._handlersByInitialApp.isEmpty());
        Enumeration enumeration = this._handlersByInitialApp.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            System.out.println("How many handlers? " + vector.size());
        }
        System.out.println("handers By URL is empty? " + this._handlersByURL.isEmpty());
        enumeration = this._handlersByURL.elements();
        while (enumeration.hasMoreElements()) {
            vector = (Vector)enumeration.nextElement();
            System.out.println("How many handlers? " + vector.size());
        }
        objectOutputStream.defaultWriteObject();
        System.out.println("<-- GatewaySessionData.writeObject");
    }
}

