/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hpt.gateway;

import com.ibm.hpt.gateway.ApplicationLinkage;
import com.ibm.hpt.gateway.CSOERRORUIRBean;
import com.ibm.hpt.gateway.DefaultGatewayModifier;
import com.ibm.hpt.gateway.GatewayException;
import com.ibm.hpt.gateway.GatewayModifier;
import com.ibm.hpt.gateway.GatewayRequestHandler;
import com.ibm.hpt.gateway.GatewaySessionData;
import com.ibm.hpt.gateway.RequestTermination;
import com.ibm.hpt.gateway.ServerConfiguration;
import com.ibm.hpt.gateway.ServerRequest;
import com.ibm.hpt.gateway.ServletSupport;
import com.ibm.hpt.gateway.ServletSupport20;
import com.ibm.hpt.gateway.ServletSupport21;
import com.ibm.hpt.gateway.VGUirCSOERRORUIR;
import com.ibm.vgj.cso.CSOException;
import com.ibm.vgj.uibean.VGJUIRecordBean;
import com.ibm.vgj.wgs.VGJBigNumber;
import com.ibm.vgj.wgs.VGJException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class GatewayServlet
extends HttpServlet
implements Serializable {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private static final String _version = "FP VZ-1.0";
    private boolean _initProcessed = false;
    private ServerConfiguration _servConfig = null;
    private Random _generator = new Random();
    private boolean _dontExpirePage = false;
    private static ServletSupport _servletSupport = null;
    private Hashtable _validApps = null;
    private String _serverErrorPackage = null;
    private GatewayModifier _modifier = null;
    private static final String LOGON_PAGE_PARM = "hptLogonPage";
    private static final String ENTRY_PAGE_PARM = "hptEntryPage";
    private static final String ENTRY_APP_PARM = "hptEntryApp";
    private static final String ERROR_LOG_PARM = "hptErrorLog";
    private static final String LINKAGE_TABLE_PARM = "hptLinkageProperties";
    private static final String RUNTIME_PROPERTIES_PARM = "hptRuntimeProperties";
    private static final String ID_MANAGER_HOST_PARM = "hptIDManagerHost";
    private static final String PROPERTIES_PARM = "hptGatewayProperties";
    private static final String DONT_EXPIRE_PARM = "hptDontExpire";
    private static final String DATE_MASK_PARM = "hptDateMask";
    private static final String SERVLET_VERSION_PARM = "hptServletVersion";
    private static final String VALID_APPS_PARM = "hptValidApps";
    private static final String MODIFIER_CLASS_PARM = "hptGatewayModifierClass";
    private static final int LOGON_PAGE = 0;
    private static final int ENTRY_PAGE = 1;
    private static final int ENTRY_APP = 2;
    private static final int ERROR_LOG = 3;
    private static final int LINKAGE_TABLE = 4;
    private static final int RUNTIME_PROPERTIES = 5;
    private static final int ID_MANAGER_HOST = 6;
    private static final int PROPERTIES = 7;
    private static final int DATE_MASK = 8;
    private static final int SERVLET_VERSION = 9;
    private static final int VALID_APPS = 10;
    private static final int MODIFIER_CLASS = 11;
    private String[] _propertyValues = new String[12];
    private static final String[] _propertyNames = new String[]{"hptLogonPage", "hptEntryPage", "hptEntryApp", "hptErrorLog", "hptLinkageProperties", "hptRuntimeProperties", "hptIDManagerHost", "hptGatewayProperties", "hptDateMask", "hptServletVersion", "hptValidApps", "hptGatewayModifierClass"};
    private static final String GATEWAY_PARM = "hptGatewayObject";
    private static final String SESSION_DATA_PARM = "hptGatewaySessionData";
    private static final String USERID_PARM = "hptUserid";
    private static final String PASSWORD_PARM = "hptPassword";
    private static final String SESSION_ID_PARM = "hptSessionId";
    public static final String CHECK_DIGIT_PARM = "hptPageId";
    public static final String PROGRAM_PARM = "hptAppId";
    public static final String EXEC_PARM = "hptExec";
    public static final String RECORD_PARM = "hptRecord";
    public static final String ERROR_DATA = "hptErrorData";
    public static final String LOGIN = "hptLogin";
    public static final String LOGOUT = "hptLogout";
    public static final String GATEWAY_URL = "hptGatewayURL";
    public static final String GATEWAY_SECURE_URL = "hptSecureGatewayURL";
    public static final String DEFAULT_ERROR_PACKAGE = "com.ibm.hpt.gateway";
    private static final String SERVLET_INFO = "VisualAge Generator Gateway Servlet";

    private void callPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws GatewayException {
        try {
            this.getServletSupport().callPage(this.getServletContext(), string, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string, exception.toString(), exception.getMessage()};
            throw new GatewayException("VGJ0602E", objectArray);
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.performTask(httpServletRequest, httpServletResponse);
    }

    public synchronized void doInit(ServletConfig servletConfig) throws ServletException {
        String string;
        Object object;
        Object[] objectArray;
        Object object2;
        super.init(servletConfig);
        if (this._initProcessed) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            object2 = servletConfig.getInitParameter(string2);
            hashtable.put(string2.toLowerCase(), (String)object2);
        }
        if (hashtable.get(DONT_EXPIRE_PARM.toLowerCase()) != null) {
            this._dontExpirePage = true;
        }
        int n = 0;
        while (n < _propertyNames.length) {
            this._propertyValues[n] = (String)hashtable.get(_propertyNames[n].toLowerCase());
            ++n;
        }
        String string3 = this.getProperty(7);
        if (string3 != null && string3.trim().length() != 0) {
            try {
                String string4;
                object2 = new Properties();
                objectArray = new FileInputStream(string3);
                ((Properties)object2).load((InputStream)objectArray);
                objectArray.close();
                object = new Properties();
                Enumeration<?> enumeration2 = ((Properties)object2).propertyNames();
                while (enumeration2.hasMoreElements()) {
                    String string5 = (String)enumeration2.nextElement();
                    string4 = (String)((Hashtable)object2).get(string5);
                    ((Hashtable)object).put(string5.toLowerCase(), string4);
                }
                int n2 = 0;
                while (n2 < _propertyNames.length) {
                    string4 = (String)((Hashtable)object).get(_propertyNames[n2].toLowerCase());
                    if (string4 != null) {
                        this._propertyValues[n2] = string4;
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        this.setValidApps(this.getProperty(10));
        System.out.println("*******************************************************");
        System.out.println("IBM VisualAge Generator 4.5 GatewayServlet: FP VZ-1.0");
        System.out.println(COPYRIGHT);
        System.out.println("*******************************************************");
        int n3 = 0;
        while (n3 < 10) {
            System.out.println(String.valueOf(_propertyNames[n3]) + "=\"" + this._propertyValues[n3] + "\"");
            ++n3;
        }
        System.out.println("*******************************************************");
        System.out.println("CLASSPATH:" + System.getProperty("java.class.path"));
        System.out.println("*******************************************************");
        if (this._serverErrorPackage == null || this._serverErrorPackage.trim().length() == 0) {
            this._serverErrorPackage = DEFAULT_ERROR_PACKAGE;
        }
        if ((string = this.getProperty(4)) == null || string.trim().length() == 0) {
            objectArray = new Object[]{LINKAGE_TABLE_PARM};
            object = new GatewayException("VGJ0614E", objectArray);
            System.out.println(((Throwable)object).getMessage());
            throw object;
        }
        try {
            this._servConfig = new ServerConfiguration(string);
        }
        catch (CSOException cSOException) {
            throw new GatewayException(cSOException);
        }
        this._initProcessed = true;
    }

    public synchronized void doInit(ServletConfig servletConfig, HttpSession httpSession) throws ServletException {
        String string;
        Object object;
        Object[] objectArray;
        Object object2;
        if (this._initProcessed) {
            return;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            object2 = servletConfig.getInitParameter(string2);
            hashtable.put(string2.toLowerCase(), (String)object2);
        }
        if (hashtable.get(DONT_EXPIRE_PARM.toLowerCase()) != null) {
            this._dontExpirePage = true;
        }
        int n = 0;
        while (n < _propertyNames.length) {
            this._propertyValues[n] = (String)hashtable.get(_propertyNames[n].toLowerCase());
            ++n;
        }
        String string3 = this.getProperty(7);
        if (string3 != null && string3.trim().length() != 0) {
            try {
                String string4;
                object2 = new Properties();
                objectArray = new FileInputStream(string3);
                ((Properties)object2).load((InputStream)objectArray);
                objectArray.close();
                object = new Properties();
                Enumeration<?> enumeration2 = ((Properties)object2).propertyNames();
                while (enumeration2.hasMoreElements()) {
                    String string5 = (String)enumeration2.nextElement();
                    string4 = (String)((Hashtable)object2).get(string5);
                    ((Hashtable)object).put(string5.toLowerCase(), string4);
                }
                int n2 = 0;
                while (n2 < _propertyNames.length) {
                    string4 = (String)((Hashtable)object).get(_propertyNames[n2].toLowerCase());
                    if (string4 != null) {
                        this._propertyValues[n2] = string4;
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        this.setValidApps(this.getProperty(10));
        System.out.println("*******************************************************");
        System.out.println("IBM VisualAge Generator 4.5 GatewayServlet: FP VZ-1.0");
        System.out.println(COPYRIGHT);
        System.out.println("*******************************************************");
        int n3 = 0;
        while (n3 < 10) {
            System.out.println(String.valueOf(_propertyNames[n3]) + "=\"" + this._propertyValues[n3] + "\"");
            ++n3;
        }
        System.out.println("*******************************************************");
        System.out.println("CLASSPATH:" + System.getProperty("java.class.path"));
        System.out.println("*******************************************************");
        if (this._serverErrorPackage == null || this._serverErrorPackage.trim().length() == 0) {
            this._serverErrorPackage = DEFAULT_ERROR_PACKAGE;
        }
        if ((string = this.getProperty(4)) == null || string.trim().length() == 0) {
            objectArray = new Object[]{LINKAGE_TABLE_PARM};
            object = new GatewayException("VGJ0614E", objectArray);
            System.out.println(((Throwable)object).getMessage());
            throw object;
        }
        try {
            this._servConfig = new ServerConfiguration(string);
        }
        catch (CSOException cSOException) {
            throw new GatewayException(cSOException);
        }
        this._initProcessed = true;
        this.validateParms();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.performTask(httpServletRequest, httpServletResponse);
    }

    void dumpParameters(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            if (stringArray.length > 1) {
                System.out.println(String.valueOf(string) + "=" + stringArray[0]);
                continue;
            }
            int n = 0;
            while (n < stringArray.length) {
                System.out.println(String.valueOf(string) + "[" + n + "]=" + stringArray[n]);
                ++n;
            }
        }
    }

    private String getFullURL(HttpServletRequest httpServletRequest) {
        String string = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
        String string2 = httpServletRequest.getQueryString();
        if (string2 != null) {
            string = String.valueOf(string) + "?" + this.getMergedQueryString(httpServletRequest);
        }
        return string;
    }

    GatewayModifier getGatewayModifier() throws GatewayException {
        if (this._modifier != null) {
            return this._modifier;
        }
        String string = this.getProperty(11);
        if (string == null) {
            return new DefaultGatewayModifier();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GatewayException(classNotFoundException, "The hptGatewayModifierClass gateway parameter, " + string + ", does not specify a valid class.");
        }
        if (clazz == null) {
            throw new GatewayException("The hptGatewayModifierClass gateway parameter, " + string + ", does not specify a valid class.");
        }
        try {
            this._modifier = (GatewayModifier)clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new GatewayException(throwable, "Unable to instantiate the hptGatewayModifierClass gateway parameter, " + string + ".");
        }
        if (this._modifier == null) {
            throw new GatewayException("Unable to instantiate the hptGatewayModifierClass gateway parameter, " + string + ".");
        }
        return this._modifier;
    }

    public ApplicationLinkage getLinkage(String string) throws GatewayException {
        ApplicationLinkage applicationLinkage = null;
        try {
            applicationLinkage = this._servConfig.getLinkageManager().getLinkage(string);
        }
        catch (CSOException cSOException) {
            this.trace(String.valueOf(new Date().toString()) + " - " + " - " + cSOException.getMessage());
        }
        if (applicationLinkage == null) {
            Object[] objectArray = new Object[]{string};
            throw new GatewayException("VGJ0600E", objectArray);
        }
        return applicationLinkage;
    }

    public String getLogFileName() {
        return this.getProperty(3);
    }

    private String getMergedQueryString(HttpServletRequest httpServletRequest) {
        String string;
        Hashtable hashtable = this.queryStringAsHashtable(httpServletRequest);
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, httpServletRequest.getParameterValues(string)[0]);
        }
        string = this.hashToString(hashtable);
        return string;
    }

    private GatewayRequestHandler getNewHandler(GatewaySessionData gatewaySessionData, String string, String string2) throws ServletException {
        if (!this.isValidApp(string)) {
            (new Object[1])[0] = string;
            throw new GatewayException("Web transaction, " + string + ", is not allowed to run on this instance of the Visualage Generator Gateway Servlet.");
        }
        GatewayRequestHandler gatewayRequestHandler = new GatewayRequestHandler();
        gatewayRequestHandler.setLinkage(this.getLinkage(string));
        gatewayRequestHandler.setProgramName(string);
        gatewayRequestHandler.setURL(string2);
        gatewayRequestHandler.setUserid(gatewaySessionData.getUserid());
        gatewayRequestHandler.setPassword(gatewaySessionData.getPassword());
        gatewayRequestHandler.setDontExpire(this._dontExpirePage);
        gatewaySessionData.addHandler(gatewayRequestHandler);
        return gatewayRequestHandler;
    }

    public String getProperty(int n) {
        return this._propertyValues[n];
    }

    private String getSecureGatewayURL(HttpServletRequest httpServletRequest) {
        String string = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
        if (string.startsWith("http") && !string.startsWith("https:")) {
            string = "https" + string.substring(4);
        }
        return string;
    }

    public String getServletInfo() {
        return SERVLET_INFO;
    }

    ServletSupport getServletSupport() {
        if (_servletSupport == null) {
            String string = this.getProperty(9);
            _servletSupport = string != null ? (string.equals("20") || string.equals("2.0") ? new ServletSupport20() : (string.equals("21") || string.equals("2.1") ? new ServletSupport21() : new ServletSupport21())) : new ServletSupport21();
        }
        return _servletSupport;
    }

    public static String getSessionDataString() {
        return SESSION_DATA_PARM;
    }

    private String getValidApps() {
        if (this._validApps == null || this._validApps.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this._validApps.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String getValue(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        String[] stringArray = httpServletRequest.getParameterValues(string);
        if (stringArray != null) {
            string2 = stringArray[0];
        }
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            string2 = this.getValueFromQueryString(httpServletRequest, string);
        }
        return string2;
    }

    public String getValueFromQueryString(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        Hashtable hashtable = this.queryStringAsHashtable(httpServletRequest);
        string2 = (String)hashtable.get(string);
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private void handleException(GatewayRequestHandler gatewayRequestHandler, Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GatewaySessionData gatewaySessionData, HttpSession httpSession) throws ServletException {
        gatewaySessionData.removeHandler(gatewayRequestHandler);
        try {
            this.handleException(gatewayRequestHandler != null ? gatewayRequestHandler.getProgramName() : new String(), throwable, httpServletRequest, httpServletResponse, gatewaySessionData, httpSession);
        }
        catch (Exception exception) {
            gatewaySessionData.trace(exception);
            httpSession.invalidate();
            try {
                httpServletResponse.sendError(500);
            }
            catch (Exception exception2) {
                gatewaySessionData.trace(exception2);
            }
        }
    }

    private void handleException(String string, Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GatewaySessionData gatewaySessionData, HttpSession httpSession) throws VGJException, GatewayException {
        Throwable throwable2 = throwable;
        GatewayException gatewayException = null;
        if (throwable instanceof GatewayException) {
            gatewayException = (GatewayException)((Object)throwable);
            if (((GatewayException)((Object)throwable)).getRootCause() != null) {
                throwable2 = ((GatewayException)((Object)throwable)).getRootCause();
            }
        } else {
            httpSession.invalidate();
        }
        if (gatewayException != null && gatewayException != throwable2 && ((Throwable)((Object)gatewayException)).getMessage() != null) {
            gatewaySessionData.trace(((Throwable)((Object)gatewayException)).getMessage());
        }
        gatewaySessionData.trace(throwable2.getMessage());
        gatewaySessionData.trace(throwable2);
        CSOERRORUIRBean cSOERRORUIRBean = new CSOERRORUIRBean();
        cSOERRORUIRBean.setSessionData(gatewaySessionData);
        cSOERRORUIRBean.setGateway(this);
        cSOERRORUIRBean.setException(throwable2);
        cSOERRORUIRBean.setGatewayURL(this.getServletSupport().encodeURL(httpServletResponse, HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString()));
        VGUirCSOERRORUIR vGUirCSOERRORUIR = (VGUirCSOERRORUIR)cSOERRORUIRBean.getRecord();
        vGUirCSOERRORUIR.PGMERROR.assign(0, string);
        Date date = new Date();
        vGUirCSOERRORUIR.DATEERROR.assign(0, DateFormat.getDateInstance(2).format(date));
        vGUirCSOERRORUIR.TIMEERROR.assign(0, DateFormat.getTimeInstance(2).format(date));
        int n = 0;
        if (gatewayException != null && gatewayException != throwable2 && ((Throwable)((Object)gatewayException)).getMessage() != null && !((Throwable)((Object)gatewayException)).getMessage().equals(throwable2.getMessage())) {
            vGUirCSOERRORUIR.MSGERROR.assign(n++, ((Throwable)((Object)gatewayException)).getMessage());
        }
        if (throwable2.getMessage() != null && throwable2.getMessage().length() != 0) {
            vGUirCSOERRORUIR.MSGERROR.assign(n++, throwable2.getMessage());
        } else {
            vGUirCSOERRORUIR.MSGERROR.assign(n++, throwable2.toString());
        }
        vGUirCSOERRORUIR.MSGCOUNT.assign(0, new VGJBigNumber((long)n));
        this.setAttribute(httpServletRequest, cSOERRORUIRBean.getName(), cSOERRORUIRBean);
        this.callPage(cSOERRORUIRBean.getTemplateName(), httpServletRequest, httpServletResponse);
    }

    public static void handleJspException(String string, VGJUIRecordBean vGJUIRecordBean, Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        GatewayServlet gatewayServlet = null;
        GatewaySessionData gatewaySessionData = null;
        HttpSession httpSession = httpServletRequest.getSession(true);
        if (vGJUIRecordBean != null) {
            gatewaySessionData = vGJUIRecordBean.getSessionData();
            gatewayServlet = gatewaySessionData.getServlet();
            gatewaySessionData.removeHandler(vGJUIRecordBean.getHandler());
        }
        if (gatewayServlet != null && !string.equals("CSOERRORUIR")) {
            try {
                gatewayServlet.handleException(string, throwable, httpServletRequest, httpServletResponse, gatewaySessionData, httpSession);
            }
            catch (VGJException vGJException) {
                if (gatewaySessionData != null) {
                    gatewaySessionData.trace("Error trying to display CSOERRORUIR bean");
                    gatewaySessionData.trace(vGJException);
                    gatewaySessionData.trace("Original error");
                    gatewaySessionData.trace(throwable);
                }
                GatewayServlet.serveErrorPage(httpServletRequest, httpServletResponse, string, throwable);
            }
        } else {
            if (gatewaySessionData != null) {
                gatewaySessionData.trace("No gateway for JSP, \"" + string + "\", or error in CSOERRORUIR bean");
                gatewaySessionData.trace(throwable);
            }
            GatewayServlet.serveErrorPage(httpServletRequest, httpServletResponse, string, throwable);
        }
    }

    private String hashToString(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = hashtable.toString();
        if (string == null) {
            string = null;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            if (stringBuffer.length() != 0) {
                stringBuffer.append("&");
            }
            stringBuffer.append(string2);
            stringBuffer.append("=");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
        }
        catch (Throwable throwable) {
            System.out.println("Throwable in init");
            throwable.printStackTrace();
        }
    }

    private boolean isValidApp(String string) {
        if (this._validApps == null || this._validApps.isEmpty()) {
            return true;
        }
        String string2 = string;
        int n = string.length() + 1;
        while (n >= 0) {
            String string3 = (String)this._validApps.get(string2);
            if (string3 != null) {
                return true;
            }
            string2 = String.valueOf(string.substring(0, n == 0 ? n : n - 1)) + "*";
            --n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties parseParms(String string) {
        Properties properties = new Properties();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(38, 38);
        streamTokenizer.whitespaceChars(61, 61);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.quoteChar(39);
        streamTokenizer.quoteChar(34);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(60, 60);
        streamTokenizer.wordChars(62, 62);
        streamTokenizer.wordChars(37, 37);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(47, 47);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(63, 63);
        streamTokenizer.wordChars(33, 33);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(35, 35);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(92, 92);
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            block8: while (true) {
                int n = streamTokenizer.nextToken();
                switch (n) {
                    case -1: {
                        return properties;
                    }
                    case 10: {
                        continue block8;
                    }
                    case -2: {
                        if (!bl2) {
                            bl = true;
                            return properties;
                        }
                        ((Hashtable)properties).put(string2, String.valueOf(streamTokenizer.nval));
                        bl2 = false;
                        continue block8;
                    }
                    case -3: 
                    case 34: {
                        if (bl2) {
                            ((Hashtable)properties).put(string2, streamTokenizer.sval);
                            bl2 = false;
                            continue block8;
                        }
                        string2 = streamTokenizer.sval;
                        bl2 = true;
                        continue block8;
                    }
                }
                break;
            }
            bl = true;
            return properties;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return properties;
    }

    public void performTask(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        HttpSession httpSession = httpServletRequest.getSession(true);
        GatewaySessionData gatewaySessionData = (GatewaySessionData)httpSession.getValue("hptGatewaySessionData:" + HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest));
        try {
            if (gatewaySessionData == null) {
                gatewaySessionData = new GatewaySessionData();
                gatewaySessionData.setServlet(this);
                this.doInit(this.getServletConfig(), httpSession);
                gatewaySessionData.setRemoteUser(httpServletRequest.getRemoteUser());
                gatewaySessionData.setIDManagerHost(this.getProperty(6));
                gatewaySessionData.setLogFileName(this.getProperty(3));
                gatewaySessionData.setServerErrorPackage(this._serverErrorPackage);
                gatewaySessionData.setDateMask(this.getProperty(8));
                try {
                    gatewaySessionData.setup();
                }
                catch (GatewayException gatewayException) {
                    httpSession.invalidate();
                    throw gatewayException;
                }
                httpSession.putValue("hptGatewaySessionData:" + HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest), (Object)gatewaySessionData);
            } else {
                gatewaySessionData.setServlet(this);
                this.doInit(this.getServletConfig(), httpSession);
            }
            if (!gatewaySessionData.getHasLogin() && !gatewaySessionData.hasServedLogin()) {
                this.serveLoginPage(httpServletRequest, httpServletResponse, gatewaySessionData);
                return;
            }
            if (httpServletRequest.getParameterValues(LOGIN) != null) {
                this.processLogin(httpServletRequest, httpServletResponse, gatewaySessionData);
                return;
            }
            if (httpServletRequest.getParameterValues(LOGOUT) != null) {
                gatewaySessionData.reset();
                this.serveLoginPage(httpServletRequest, httpServletResponse, gatewaySessionData);
                return;
            }
            if (!gatewaySessionData.getHasLogin()) {
                this.serveLoginPage(httpServletRequest, httpServletResponse, gatewaySessionData);
                return;
            }
            String string = this.getValue(httpServletRequest, PROGRAM_PARM);
            gatewaySessionData.setProcessingEntryApp(this.getProperty(2) != null && this.getProperty(2).equals(string));
            this.serveApplicationPage(httpServletRequest, httpServletResponse, gatewaySessionData);
        }
        catch (Exception exception) {
            this.handleException((GatewayRequestHandler)null, (Throwable)exception, httpServletRequest, httpServletResponse, gatewaySessionData, httpSession);
        }
    }

    public void processLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GatewaySessionData gatewaySessionData) throws ServletException {
        boolean bl;
        String string;
        String string2;
        ServerRequest serverRequest = new ServerRequest();
        String[] stringArray = httpServletRequest.getParameterValues(USERID_PARM);
        String string3 = string2 = stringArray != null ? stringArray[0] : null;
        if (string2 == null) {
            string2 = (String)httpServletRequest.getAttribute(USERID_PARM);
        }
        serverRequest.setUserid(string2);
        String[] stringArray2 = httpServletRequest.getParameterValues(PASSWORD_PARM);
        String string4 = string = stringArray2 != null ? stringArray2[0] : null;
        if (string == null) {
            string = (String)httpServletRequest.getAttribute(PASSWORD_PARM);
        }
        serverRequest.setPassword(string);
        if (string2 != null) {
            gatewaySessionData.trace("Userid:\"" + string2 + "\"");
        }
        if (string != null) {
            String string5 = "*****************************";
            gatewaySessionData.trace("Password:\"" + string5.substring(0, string.length()) + "\"");
        }
        if (bl = gatewaySessionData.getServer().validateUser(serverRequest)) {
            gatewaySessionData.setUserid(string2);
            gatewaySessionData.setPassword(string);
            gatewaySessionData.setHasLogin(true);
            this.serveEntrypointPage(httpServletRequest, httpServletResponse, gatewaySessionData, true);
        } else {
            this.serveLoginPage(httpServletRequest, httpServletResponse, gatewaySessionData);
        }
    }

    public Hashtable queryStringAsHashtable(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            return new Hashtable();
        }
        return this.parseParms(string);
    }

    private GatewaySessionData readData() {
        try {
            FileInputStream fileInputStream = new FileInputStream("d:/vagen/t.tmp");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            GatewaySessionData gatewaySessionData = (GatewaySessionData)objectInputStream.readObject();
            fileInputStream.close();
            return gatewaySessionData;
        }
        catch (Exception exception) {
            System.out.println("Exception trying to read the file");
            exception.printStackTrace();
            return null;
        }
    }

    public void serveApplicationPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GatewaySessionData gatewaySessionData) throws ServletException {
        String string = this.getValue(httpServletRequest, PROGRAM_PARM);
        String string2 = this.getValue(httpServletRequest, SESSION_ID_PARM);
        String string3 = this.getValue(httpServletRequest, EXEC_PARM);
        gatewaySessionData.trace("App: \"" + string + "\", sessionID: \"" + string2 + "\", exec: \"" + string3 + "\"");
        if (string == null || string2 == null && string3 == null) {
            gatewaySessionData.trace("Serve Entry point page");
            this.serveEntrypointPage(httpServletRequest, httpServletResponse, gatewaySessionData, false);
            return;
        }
        GatewayRequestHandler gatewayRequestHandler = null;
        try {
            if (string3 != null) {
                gatewayRequestHandler = gatewaySessionData.handlerFromURLAndApp(this.getServletSupport().encodeURL(httpServletResponse, this.getFullURL(httpServletRequest)), string);
                if (gatewayRequestHandler != null) {
                    gatewaySessionData.trace("   Found");
                    gatewayRequestHandler.setReshow(true);
                } else {
                    gatewaySessionData.trace("   Create a new one");
                    gatewayRequestHandler = this.getNewHandler(gatewaySessionData, string, this.getServletSupport().encodeURL(httpServletResponse, this.getFullURL(httpServletRequest)));
                }
            } else {
                gatewaySessionData.trace("Find handler from session id and app");
                gatewayRequestHandler = gatewaySessionData.handlerFromSessionIDAndApp(string2, string);
            }
            if (gatewayRequestHandler == null) {
                gatewaySessionData.trace("No handler found...serve entry point page");
                this.serveEntrypointPage(httpServletRequest, httpServletResponse, gatewaySessionData, false);
                return;
            }
            try {
                gatewayRequestHandler.performTask(httpServletRequest, httpServletResponse);
            }
            catch (RequestTermination requestTermination) {
                gatewaySessionData.removeHandler(gatewayRequestHandler);
                gatewayRequestHandler = null;
                this.serveEntrypointPage(httpServletRequest, httpServletResponse, gatewaySessionData, false);
                return;
            }
        }
        catch (Exception exception) {
            this.handleException(gatewayRequestHandler, (Throwable)exception, httpServletRequest, httpServletResponse, gatewaySessionData, httpServletRequest.getSession(true));
        }
    }

    public void serveEntrypointPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GatewaySessionData gatewaySessionData, boolean bl) throws ServletException {
        String string = this.getValue(httpServletRequest, PROGRAM_PARM);
        String string2 = this.getValue(httpServletRequest, EXEC_PARM);
        if (bl && string != null && string2 != null) {
            gatewaySessionData.trace("Running application, " + string + ", instead of entrypoint page");
            this.serveApplicationPage(httpServletRequest, httpServletResponse, gatewaySessionData);
        } else if (this.getProperty(1) != null) {
            this.trace("Serving entrypoint page, " + this.getProperty(1));
            this.servePage(this.getProperty(1), httpServletRequest, httpServletResponse, gatewaySessionData);
        } else {
            try {
                this.trace("Running hptEntryApp, " + this.getProperty(2));
                httpServletResponse.sendRedirect(String.valueOf(this.getServletSupport().encodeRedirectURL(httpServletResponse, this.getFullURL(httpServletRequest))) + "?" + PROGRAM_PARM + "=" + this.getProperty(2) + "&" + EXEC_PARM + "=Y");
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{this.getProperty(2), exception.toString(), exception.getMessage()};
                GatewayException gatewayException = new GatewayException("VGJ0601E", objectArray);
                throw new ServletException(((Throwable)((Object)gatewayException)).getMessage());
            }
        }
    }

    public static void serveErrorPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable) throws ServletException {
        try {
            httpServletResponse.setContentType("text/html");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<HTML>");
            printWriter.println("<HEAD>");
            printWriter.println("<TITLE>VisualAge Generator System Error</TITLE>");
            printWriter.println("</HEAD>");
            printWriter.println("<BODY>");
            printWriter.println("</FONT><b>Reported Error:</b><BR>");
            printWriter.println("<b>Bean In Error: </b>" + string + "<BR>");
            printWriter.println("<BR><FONT COLOR=\"#FF0000\">");
            printWriter.println(throwable.toString());
            printWriter.println("</FONT>");
            printWriter.println("<BR>");
            throwable.printStackTrace(printWriter);
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{"Error", exception.toString(), exception.getMessage()};
            throw new GatewayException("VGJ0602E", objectArray);
        }
    }

    public void serveLoginPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GatewaySessionData gatewaySessionData) throws ServletException {
        if (this.getProperty(0) != null) {
            gatewaySessionData.setHasServedLogin(true);
            this.servePage(this.getProperty(0), httpServletRequest, httpServletResponse, gatewaySessionData);
        } else {
            this.processLogin(httpServletRequest, httpServletResponse, gatewaySessionData);
        }
    }

    public void servePage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, GatewaySessionData gatewaySessionData) throws GatewayException {
        int n = string.toLowerCase().indexOf(".jsp");
        if (n != -1) {
            String string2 = string.substring(string.lastIndexOf(47) + 1, n);
            try {
                VGJUIRecordBean vGJUIRecordBean = new VGJUIRecordBean(string2);
                vGJUIRecordBean.setSessionData(gatewaySessionData);
                vGJUIRecordBean.setGateway(this);
                this.setAttribute(httpServletRequest, string2, vGJUIRecordBean);
            }
            catch (VGJException vGJException) {}
        }
        this.setAttribute(httpServletRequest, GATEWAY_URL, this.getServletSupport().encodeURL(httpServletResponse, HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString()));
        this.setAttribute(httpServletRequest, GATEWAY_SECURE_URL, this.getServletSupport().encodeURL(httpServletResponse, this.getSecureGatewayURL(httpServletRequest)));
        this.callPage(string, httpServletRequest, httpServletResponse);
    }

    private void setAttribute(HttpServletRequest httpServletRequest, String string, Object object) {
        this.getServletSupport().setAttribute(httpServletRequest, string, object);
    }

    private void setValidApps(String string) {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).charAt(0) == '\"') {
            string = string.substring(1);
        }
        if (string.charAt(string.length() - 1) == '\"') {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        this._validApps = new Hashtable();
        while (string.length() != 0) {
            String string2;
            int n = string.indexOf(",");
            if (n == -1) {
                string2 = string.trim();
                string = new String();
            } else {
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1);
            }
            if (string2.length() == 0) continue;
            this._validApps.put(string2, string2);
        }
    }

    public synchronized void trace(String string) {
        if (this.getLogFileName() == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.getLogFileName(), true), true);
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Exception, " + exception.toString() + ", trying to trace, " + string);
        }
    }

    public synchronized void trace(Throwable throwable) {
        if (this.getLogFileName() == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.getLogFileName(), true), true);
            throwable.printStackTrace(printWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            this.trace("Exception, " + exception.toString() + ", trying to print exception, " + throwable.toString());
        }
    }

    private void validateParms() throws GatewayException {
        if (!(this.getProperty(1) != null && this.getProperty(1).trim().length() != 0 || this.getProperty(2) != null && this.getProperty(2).trim().length() != 0)) {
            Object[] objectArray = new Object[]{"hptEntryPage or hptEntryApp"};
            throw new GatewayException("VGJ0614E", objectArray);
        }
    }

    private void writeData(GatewaySessionData gatewaySessionData) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("d:/vagen/t.tmp");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(gatewaySessionData);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception trying to write the file");
            exception.printStackTrace();
        }
    }
}

