/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hpt.gateway;

import com.ibm.hpt.gateway.ApplicationLinkage;
import com.ibm.hpt.gateway.DefaultGatewayModifier;
import com.ibm.hpt.gateway.GatewayException;
import com.ibm.hpt.gateway.GatewayModifier;
import com.ibm.hpt.gateway.GatewayServlet;
import com.ibm.hpt.gateway.GatewaySessionData;
import com.ibm.hpt.gateway.RequestTermination;
import com.ibm.hpt.gateway.ServerRequest;
import com.ibm.hpt.gateway.ServletSupport;
import com.ibm.vgj.cso.CSOException;
import com.ibm.vgj.cso.CSOIntConverter;
import com.ibm.vgj.cso.CSOStrConverter;
import com.ibm.vgj.uibean.UIRecordSegment;
import com.ibm.vgj.uibean.VGJDataItemFormat;
import com.ibm.vgj.uibean.VGJUIRecordBean;
import com.ibm.vgj.wgs.VGJException;
import com.ibm.vgj.wgs.VGJUiRecordItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class GatewayRequestHandler
implements Serializable {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private String _currentBeanName = null;
    private String _language = null;
    private String _currentSum = null;
    private String _currentPage = null;
    private String _pgmName = null;
    private String _initialPgmName = null;
    private String _sessionID = null;
    private String _requestURL = null;
    private String _userid = null;
    private String _password = null;
    private String _linkageName = null;
    private String _serverid = null;
    private boolean _reshow = false;
    private String _initialURL = null;
    private boolean _dontExpirePage = false;
    private boolean _hasMadeCall = false;
    private byte[] _beanData = null;
    private int _byteOrder = 0;
    private ServerRequest _serverRequest = null;
    private static final int UIRecord_ID = -1431655766;
    private static final int UIFieldErr_ID = -1145324613;
    private static final String CSOERRORUIR = "CSOERRORUIR";
    private transient VGJUIRecordBean _currentBean = null;
    private transient ApplicationLinkage _linkage = null;
    private transient GatewaySessionData _sessionData = null;
    private transient ServletContext _servletContext = null;
    private transient ServletSupport _servletSupport = null;
    private transient GatewayModifier _gatewayModifier = null;
    private transient Class[] _parmClasses = null;
    private transient Random _generator = new Random();

    private void addParameterValue(Hashtable hashtable, String string, String[] stringArray) throws GatewayException {
        boolean bl = false;
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if (this.isNumber(string4)) {
                int n2 = new Integer(string4) - 1;
                string2 = string3;
                String[] stringArray2 = (String[])hashtable.get(string2);
                if (stringArray2 == null) {
                    stringArray2 = new String[]{};
                }
                if (n2 >= stringArray2.length) {
                    String[] stringArray3 = new String[n2 + 1];
                    int n3 = 0;
                    n3 = 0;
                    while (n3 < stringArray2.length) {
                        stringArray3[n3] = stringArray2[n3];
                        ++n3;
                    }
                    while (n3 < stringArray3.length) {
                        stringArray3[n3] = null;
                        ++n3;
                    }
                    stringArray2 = stringArray3;
                }
                stringArray2[n2] = stringArray[0];
                stringArray = stringArray2;
            } else {
                Object object;
                n = string3.indexOf(46);
                int n4 = 0;
                if (n != -1) {
                    object = string3.substring(n + 1);
                    string3 = string3.substring(0, n);
                    string2 = String.valueOf(string3) + string4.toUpperCase() + "." + (String)object;
                    this.addParameterValue(hashtable, string2, stringArray);
                    if (this.isNumber((String)object)) {
                        n4 = new Integer((String)object) - 1;
                    }
                    bl = true;
                } else {
                    string2 = String.valueOf(string3) + string4.toUpperCase();
                }
                object = this.getCurrentBean();
                VGJDataItemFormat vGJDataItemFormat = ((VGJUIRecordBean)object).getFormatNamed(string3);
                if (vGJDataItemFormat != null && (vGJDataItemFormat.isSubmitField() || vGJDataItemFormat.isSubmitBypassField()) && hashtable.get(string3) == null) {
                    try {
                        String[] stringArray4 = new String[]{vGJDataItemFormat.getFormattedText(n4)};
                        this.addParameterValue(hashtable, string3, stringArray4);
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    return;
                }
            }
        }
        hashtable.put(string2, stringArray);
    }

    private void callPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws GatewayException {
        try {
            this.getServletSupport().callPage(this.getServletContext(), string, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string, exception.toString(), exception.getMessage()};
            throw new GatewayException("VGJ0602E", objectArray);
        }
    }

    private void dumpParameters(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = (String[])hashtable.get(string);
            int n = 0;
            while (n < stringArray.length) {
                this.trace(String.valueOf(string) + "[" + n + "] = \"" + stringArray[n] + "\"");
                ++n;
            }
        }
    }

    boolean expirePage() {
        return !this.getDontExpire();
    }

    private String getBeanNameFor(String string) throws GatewayException {
        String string2 = String.valueOf(string) + "Bean";
        string2 = string.equals(CSOERRORUIR) ? String.valueOf(this.getGatewayPackage()) + string2 : String.valueOf(this.getBeanPackage()) + string2;
        return this.getGatewayModifier().beanName(string2);
    }

    public String getBeanPackage() throws GatewayException {
        String string = this.getLinkage().getJavaPackage();
        if (string != null) {
            if (string.length() != 0 && string.charAt(string.length() - 1) != '.') {
                string = String.valueOf(string) + ".";
            }
        } else {
            string = new String();
        }
        return string;
    }

    private Class[] getBeanParmClasses() throws ClassNotFoundException {
        if (this._parmClasses == null) {
            this._parmClasses = new Class[3];
            this._parmClasses[0] = Class.forName("com.ibm.vgj.uibean.VGJUIRecordBean");
            this._parmClasses[1] = Class.forName("java.lang.String");
            this._parmClasses[2] = Class.forName("java.lang.Integer");
        }
        return this._parmClasses;
    }

    public VGJUIRecordBean getCurrentBean() throws GatewayException {
        if (this._currentBean == null && this._beanData != null) {
            try {
                this._currentBean = this.getNewBean(this._currentBeanName);
                this._currentBean.setLanguage(this._language);
                this._currentBean.setBytes(this._beanData, this._byteOrder);
            }
            catch (VGJException vGJException) {
                throw new GatewayException(vGJException);
            }
        }
        return this._currentBean;
    }

    public String getCurrentPage() {
        return this._currentPage;
    }

    public String getCurrentSum() {
        return this._currentSum;
    }

    public String getDateMask() {
        return this.getSessionData().getDateMask();
    }

    boolean getDontExpire() {
        return this._dontExpirePage;
    }

    public GatewayModifier getGatewayModifier() {
        if (this._gatewayModifier == null) {
            try {
                this._gatewayModifier = this.getServlet().getGatewayModifier();
            }
            catch (GatewayException gatewayException) {
                this.trace((Throwable)((Object)gatewayException));
                this._gatewayModifier = new DefaultGatewayModifier();
            }
        }
        return this._gatewayModifier;
    }

    public String getGatewayPackage() {
        String string = this.getSessionData().getServerErrorPackage();
        if (string != null) {
            if (string.length() != 0 && string.charAt(string.length() - 1) != '.') {
                string = String.valueOf(string) + ".";
            }
        } else {
            string = new String();
        }
        return string;
    }

    public String getInitialProgramName() {
        return this._initialPgmName;
    }

    private String getJSPName(String string) {
        int n;
        String string2 = this.getJspPath();
        if (string2 != null && (n = string.lastIndexOf("/")) != -1) {
            string = String.valueOf(n == 0 ? "" : string.substring(0, n)) + string2 + string.substring(n);
        }
        return this.getGatewayModifier().jspName(string);
    }

    private String getJspPath() {
        String string = this.getGatewayModifier().jspPath();
        if (string == null || string.trim().length() == 0 || string.trim().equals("/")) {
            return null;
        }
        string = string.trim();
        while (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        while (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string.trim().length() == 0) {
            return null;
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        return string;
    }

    public ApplicationLinkage getLinkage() throws GatewayException {
        if (this._linkage == null) {
            this._linkage = this.getServlet().getLinkage(this.getLinkageName());
            this._linkage.setServerid(this._serverid);
        }
        return this._linkage;
    }

    public String getLinkageName() {
        return this._linkageName;
    }

    public VGJUIRecordBean getNewBean(String string) throws GatewayException {
        try {
            VGJUIRecordBean vGJUIRecordBean = this.instantiateBean(string);
            if (vGJUIRecordBean == null) {
                String string2 = this.getBeanNameFor(GatewayRequestHandler.mangleName(string));
                Object[] objectArray = new Object[]{string2};
                throw new GatewayException("VGJ0603E", objectArray);
            }
            vGJUIRecordBean.setHandler(this);
            vGJUIRecordBean.setSessionData(this.getSessionData());
            vGJUIRecordBean.setGateway(this.getServlet());
            this.setCurrentBean(vGJUIRecordBean);
            this.setCurrentBeanName(string);
            return vGJUIRecordBean;
        }
        catch (GatewayException gatewayException) {
            throw gatewayException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.getSessionData().trace(throwable);
            String string3 = this.getBeanNameFor(GatewayRequestHandler.mangleName(string));
            Object[] objectArray = new Object[]{string3, throwable.toString(), throwable.getMessage()};
            throw new GatewayException("VGJ0604E", objectArray);
        }
        catch (Exception exception) {
            String string4 = this.getBeanNameFor(GatewayRequestHandler.mangleName(string));
            Object[] objectArray = new Object[]{string4, exception.toString(), exception.getMessage()};
            throw new GatewayException("VGJ0604E", objectArray);
        }
    }

    public String getProgramName() {
        return this._pgmName;
    }

    public ServerRequest getServerRequest() throws GatewayException {
        if (this._serverRequest == null) {
            this._serverRequest = new ServerRequest(this._userid, this._password, this.getSessionID());
            this._serverRequest.setLinkage(this.getLinkage());
            this._serverRequest.setEzeusr(this.getSessionData().getEzeusr());
        } else if (this._serverRequest.getLinkage() == null) {
            System.out.println("Had a server request object without a linage");
            this._serverRequest.setLinkage(this.getLinkage());
        }
        return this._serverRequest;
    }

    public GatewayServlet getServlet() {
        return this.getSessionData().getServlet();
    }

    ServletContext getServletContext() {
        if (this._servletContext == null) {
            this._servletContext = this.getServlet().getServletContext();
        }
        return this._servletContext;
    }

    private ServletSupport getServletSupport() {
        if (this._servletSupport == null) {
            this._servletSupport = this.getServlet().getServletSupport();
        }
        return this._servletSupport;
    }

    public GatewaySessionData getSessionData() {
        return this._sessionData;
    }

    public String getSessionID() {
        if (this._sessionID == null) {
            return new String("");
        }
        return this._sessionID;
    }

    public String getURL() {
        if (this._initialURL == null) {
            return new String("");
        }
        return this._initialURL;
    }

    public String getValue(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        String[] stringArray = httpServletRequest.getParameterValues(string);
        if (stringArray != null) {
            string2 = stringArray[0];
        }
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        if (string2 == null) {
            string2 = this.getValueFromQueryString(httpServletRequest, string);
        }
        return string2;
    }

    public String getValueFromQueryString(HttpServletRequest httpServletRequest, String string) {
        String string2 = null;
        Hashtable hashtable = this.queryStringAsHashtable(httpServletRequest);
        string2 = (String)hashtable.get(string);
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private boolean hasMadeCall() {
        return this._hasMadeCall;
    }

    private VGJUIRecordBean instantiateBean(String string) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, GatewayException {
        String string2 = GatewayRequestHandler.mangleName(string);
        this.trace("Instaniate bean, " + string2);
        String string3 = this.getBeanNameFor(string2);
        this.trace("Instaniate bean, " + string2 + ", class, " + string3);
        Class<?> clazz = Class.forName(string3);
        clazz.getConstructors();
        Class[] classArray = this.getBeanParmClasses();
        Constructor<?> constructor = clazz.getConstructor(classArray);
        Object[] objectArray = new Object[]{this._currentBean, string, new Integer(1)};
        VGJUIRecordBean vGJUIRecordBean = (VGJUIRecordBean)constructor.newInstance(objectArray);
        return vGJUIRecordBean;
    }

    public void invokeServerAndProcessResults(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws GatewayException, RequestTermination {
        ServerRequest serverRequest = this.getServerRequest();
        VGJUIRecordBean vGJUIRecordBean = this.getCurrentBean();
        this.setupInputData(vGJUIRecordBean, serverRequest);
        if (vGJUIRecordBean != null) {
            serverRequest.setEZEAID(new Character(vGJUIRecordBean.getEZEAID()).toString());
            serverRequest.setBypassEdit(vGJUIRecordBean.isBypassEdits() ? (byte)1 : 0);
            serverRequest.setInterfaceHashcode(vGJUIRecordBean.getHashCode());
            serverRequest.setBeanName(vGJUIRecordBean.getName());
            vGJUIRecordBean.resetIndicators();
        }
        this.setHasMadeCall(true);
        try {
            this.trace("--> server, \"" + serverRequest.getLinkage().getAppName() + "\", Bean, \"" + serverRequest.getBeanName() + "\"");
            this.getSessionData().getServer().invokeServer(serverRequest);
            this.trace("<-- server, \"" + serverRequest.getLinkage().getAppName() + "\", Bean, \"" + serverRequest.getBeanName() + "\"");
        }
        catch (CSOException cSOException) {
            Object[] objectArray = new Object[]{serverRequest.getLinkage().getAppName(), new String(), new String()};
            throw new GatewayException(cSOException);
        }
        String string = serverRequest.getBeanName();
        string = string == null ? new String() : string.trim();
        if (serverRequest.isTerminating()) {
            this.trace("App is terminating, beanName = \"" + string + "\"");
        } else {
            this.trace("App is not terminating, beanName = \"" + string + "\"");
        }
        if (serverRequest.isTerminating() && string.length() == 0) {
            throw new RequestTermination(this);
        }
        this.setProgramName(serverRequest.getLinkage().getAppName().trim());
        if (string.length() != 0) {
            if (vGJUIRecordBean == null || !string.equals(vGJUIRecordBean.getName())) {
                vGJUIRecordBean = this.getNewBean(string);
                vGJUIRecordBean.setLanguage(httpServletRequest.getHeader("Accept-Language"));
                this.setCurrentLanguage(httpServletRequest.getHeader("Accept-Language"));
            }
            if (serverRequest.getInterfaceHashcode() != vGJUIRecordBean.getHashCode()) {
                this.trace("Server hashCode = " + serverRequest.getInterfaceHashcode());
                this.trace("Bean   hashCode = " + vGJUIRecordBean.getHashCode());
                Object[] objectArray = new Object[]{serverRequest.getLinkage().getAppName(), this.getBeanNameFor(string)};
                throw new GatewayException("VGJ0607E", objectArray);
            }
        } else {
            throw new GatewayException("Danger! Danger! Danger, Will Robinson! Server did not return a bean name");
        }
        try {
            this.setupOutputData(vGJUIRecordBean);
        }
        catch (VGJException vGJException) {
            Object[] objectArray = new Object[]{string, vGJException.toString(), vGJException.getMessage()};
            throw new GatewayException("VGJ0608E", objectArray);
        }
        this.servePage(this.getJSPName(vGJUIRecordBean.getTemplateName()), httpServletRequest, httpServletResponse);
        if (serverRequest.isTerminating()) {
            this.getSessionData().removeHandler(this);
        }
    }

    private boolean isNumber(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) < '0' || string.charAt(n) > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String mangleName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (Character.isLetterOrDigit(cArray[n]) || cArray[n] == '_') {
                stringBuffer.append(cArray[n]);
            } else {
                String string2 = Integer.toHexString(cArray[n]).toUpperCase();
                stringBuffer.append('x');
                stringBuffer.append(string2.length() <= 4 ? String.valueOf("0000".substring(string2.length())) + string2 : string2.substring(4));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties parseParms(String string) {
        Properties properties = new Properties();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(38, 38);
        streamTokenizer.whitespaceChars(61, 61);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.quoteChar(39);
        streamTokenizer.quoteChar(34);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(43, 43);
        streamTokenizer.wordChars(60, 60);
        streamTokenizer.wordChars(62, 62);
        streamTokenizer.wordChars(37, 37);
        streamTokenizer.wordChars(42, 42);
        streamTokenizer.wordChars(40, 40);
        streamTokenizer.wordChars(41, 41);
        streamTokenizer.wordChars(44, 44);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(47, 47);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(59, 59);
        streamTokenizer.wordChars(63, 63);
        streamTokenizer.wordChars(33, 33);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(35, 35);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(94, 94);
        streamTokenizer.wordChars(92, 92);
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            block8: while (true) {
                int n = streamTokenizer.nextToken();
                switch (n) {
                    case -1: {
                        return properties;
                    }
                    case 10: {
                        continue block8;
                    }
                    case -2: {
                        if (!bl2) {
                            bl = true;
                            return properties;
                        }
                        ((Hashtable)properties).put(string2, String.valueOf(streamTokenizer.nval));
                        bl2 = false;
                        continue block8;
                    }
                    case -3: 
                    case 34: {
                        if (bl2) {
                            ((Hashtable)properties).put(string2, streamTokenizer.sval);
                            bl2 = false;
                            continue block8;
                        }
                        string2 = streamTokenizer.sval;
                        bl2 = true;
                        continue block8;
                    }
                }
                break;
            }
            bl = true;
            return properties;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return properties;
    }

    public void performTask(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws GatewayException, RequestTermination {
        this.getGatewayModifier().setRequest(httpServletRequest);
        String string = this.getValue(httpServletRequest, "hptPageId");
        String string2 = null;
        if (string != null) {
            string2 = string;
        }
        if (this.getCurrentSum() != null && (string2 != null && !this.getCurrentSum().equals(string2) || this.reshow())) {
            this.trace("Checksum failed for page, \"" + this.getCurrentPage() + "\": page sum=" + string2 + ", currentSum=" + this.getCurrentSum());
            this.servePage(this.getCurrentPage(), httpServletRequest, httpServletResponse);
            return;
        }
        this.processInput(httpServletRequest, httpServletResponse);
    }

    public void processInput(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws GatewayException, RequestTermination {
        String string;
        VGJUIRecordBean vGJUIRecordBean = this.getCurrentBean();
        if (vGJUIRecordBean == null && (string = this.getValue(httpServletRequest, "hptRecord")) != null) {
            vGJUIRecordBean = this.getNewBean(string);
            vGJUIRecordBean.setLanguage(httpServletRequest.getHeader("Accept-Language"));
            this.setCurrentLanguage(httpServletRequest.getHeader("Accept-Language"));
            try {
                vGJUIRecordBean.setInitialValues();
            }
            catch (VGJException vGJException) {
                String string2 = this.getBeanNameFor(GatewayRequestHandler.mangleName(string));
                Object[] objectArray = new Object[]{string2, vGJException.toString(), vGJException.getMessage()};
                throw new GatewayException("VGJ0604E", objectArray);
            }
            this.setCurrentPage(vGJUIRecordBean.getTemplateName());
            vGJUIRecordBean.setFirstBean(true);
        }
        if (vGJUIRecordBean != null) {
            try {
                vGJUIRecordBean.setInputFieldData(this.requestDataFrom(httpServletRequest));
            }
            catch (VGJException vGJException) {
                throw new GatewayException(vGJException);
            }
            if (vGJUIRecordBean.processInput()) {
                this.invokeServerAndProcessResults(httpServletRequest, httpServletResponse);
            } else {
                this.servePage(this.getCurrentPage(), httpServletRequest, httpServletResponse);
            }
        } else {
            this.invokeServerAndProcessResults(httpServletRequest, httpServletResponse);
        }
    }

    public Hashtable queryStringAsHashtable(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getQueryString();
        if (string == null) {
            return new Hashtable();
        }
        return this.parseParms(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.println("--> GatewayRequestHandler.readObject");
        objectInputStream.defaultReadObject();
        System.out.println("GatewayRequestHandler.readObject - initialize transients");
        this._linkage = null;
        this._sessionData = null;
        this._servletContext = null;
        this._servletSupport = null;
        this._gatewayModifier = null;
        this._parmClasses = null;
        this._currentBean = null;
        this._generator = new Random();
        System.out.println("<-- GatewayRequestHandler.readObject");
    }

    Hashtable requestDataFrom(HttpServletRequest httpServletRequest) throws GatewayException {
        Object object;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        Hashtable hashtable = new Hashtable();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.addParameterValue(hashtable, (String)object, httpServletRequest.getParameterValues((String)object));
        }
        object = this.queryStringAsHashtable(httpServletRequest);
        Enumeration enumeration2 = ((Hashtable)object).keys();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            if (hashtable.containsKey(string)) continue;
            String[] stringArray = new String[]{(String)((Hashtable)object).get(string)};
            this.addParameterValue(hashtable, string, stringArray);
        }
        return hashtable;
    }

    private boolean reshow() {
        return this._reshow;
    }

    public void servePage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws GatewayException {
        this.setReshow(false);
        String string2 = new Long(this._generator.nextLong()).toString();
        this.setCurrentSum(string2);
        if (this.getCurrentBean() != null) {
            if (!this.hasMadeCall() && this.getCurrentBean().hasInputError() && this.getValue(httpServletRequest, "hptExec") != null) {
                this.setCurrentSum(null);
            }
            this.getCurrentBean().setPageID(string2);
            this.getCurrentBean().setGatewayURL(this.getServletSupport().encodeURL(httpServletResponse, HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString()));
            this.getCurrentBean().setAppID(this.getProgramName());
            this.getCurrentBean().setSessionID(this.getSessionID());
        }
        if (!this.getServerRequest().isTerminating() && this.expirePage()) {
            httpServletResponse.setHeader("Expires", "Tues, 01 Jan 1980 00:00:00 GMT");
        }
        this.setCurrentPage(string);
        if (this.getCurrentBean() != null) {
            this.setAttribute(httpServletRequest, GatewayRequestHandler.mangleName(this.getCurrentBean().getName()), this.getCurrentBean());
        }
        this.callPage(string, httpServletRequest, httpServletResponse);
    }

    private void setAttribute(HttpServletRequest httpServletRequest, String string, Object object) {
        this.getServletSupport().setAttribute(httpServletRequest, string, object);
    }

    public void setCurrentBean(VGJUIRecordBean vGJUIRecordBean) {
        this._currentBean = vGJUIRecordBean;
    }

    public void setCurrentBeanName(String string) {
        this._currentBeanName = string;
    }

    public void setCurrentLanguage(String string) {
        this._language = string;
    }

    public void setCurrentPage(String string) {
        this._currentPage = string;
    }

    public void setCurrentSum(String string) {
        this._currentSum = string;
    }

    void setDontExpire(boolean bl) {
        this._dontExpirePage = bl;
    }

    private void setHasMadeCall(boolean bl) {
        this._hasMadeCall = bl;
    }

    public void setInitialProgramName(String string) {
        this._initialPgmName = string;
    }

    public void setLinkage(ApplicationLinkage applicationLinkage) {
        this._linkage = applicationLinkage;
    }

    public void setLinkageName(String string) {
        this._linkageName = string;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public void setProgramName(String string) {
        if (this.getInitialProgramName() == null) {
            this.setInitialProgramName(string);
        }
        this._pgmName = string;
    }

    void setReshow(boolean bl) {
        this._reshow = bl;
    }

    public void setSessionData(GatewaySessionData gatewaySessionData) {
        this._sessionData = gatewaySessionData;
    }

    public void setSessionID(String string) {
        this._sessionID = string;
    }

    void setupInputData(VGJUIRecordBean vGJUIRecordBean, ServerRequest serverRequest) {
        ApplicationLinkage applicationLinkage = serverRequest.getLinkage();
        int n = 0;
        byte[] byArray = null;
        if (vGJUIRecordBean != null) {
            UIRecordSegment[] uIRecordSegmentArray = vGJUIRecordBean.getInputData(applicationLinkage.getByteOrder(), applicationLinkage.getCodePage());
            n = 28;
            int n2 = 0;
            while (n2 < uIRecordSegmentArray.length) {
                n += 8 + uIRecordSegmentArray[n2].getLength();
                ++n2;
            }
            if (n + 128 > 32500) {
                this.trace("***WARNING: Field segment lengths," + (n + 128) + ", exceeded max buffer size of " + 32500 + ". The gateway will attempt to send whole record");
                uIRecordSegmentArray = vGJUIRecordBean.getInputDataAsSingle(applicationLinkage.getByteOrder(), applicationLinkage.getCodePage());
                n = 28;
                n2 = 0;
                while (n2 < uIRecordSegmentArray.length) {
                    n += 8 + uIRecordSegmentArray[n2].getLength();
                    ++n2;
                }
            }
            if (n + 128 > 32500) {
                this.trace("***WARNING: record data is greater than allowable length of 32500");
            }
            byArray = new byte[n + 128];
            n2 = 128;
            while (n2 < 132) {
                byArray[n2] = -86;
                ++n2;
            }
            String string = new String(String.valueOf(vGJUIRecordBean.getName()) + "                  ").substring(0, 18);
            System.arraycopy(CSOStrConverter.toBytes((String)string, (String)CSOStrConverter.getRemoteCodePage((String)applicationLinkage.getCodePage())), 0, byArray, n2, 18);
            n2 += 18;
            System.arraycopy(CSOIntConverter.get4Bytes((int)uIRecordSegmentArray.length, (int)applicationLinkage.getByteOrder()), 0, byArray, n2 += 2, 4);
            n2 += 4;
            int n3 = 0;
            while (n3 < uIRecordSegmentArray.length) {
                byte[] byArray2 = uIRecordSegmentArray[n3].toBytes(applicationLinkage.getByteOrder());
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
                ++n3;
            }
        } else {
            byArray = new byte[128];
        }
        serverRequest.setInputData(byArray);
        serverRequest.setDataLength(n);
    }

    void setupOutputData(VGJUIRecordBean vGJUIRecordBean) throws VGJException, GatewayException {
        ServerRequest serverRequest = this.getServerRequest();
        ApplicationLinkage applicationLinkage = serverRequest.getLinkage();
        byte[] byArray = serverRequest.getBeanData();
        int n = serverRequest.getDataLength();
        if (byArray != null && n > 0) {
            int n2 = 128;
            while (n2 - 128 < n) {
                int n3;
                int n4 = CSOIntConverter.intFrom4Bytes((byte[])byArray, (int)n2, (int)applicationLinkage.getByteOrder());
                CSOStrConverter.toString((byte[])byArray, (int)(n2 += 4), (int)18, (String)CSOStrConverter.getRemoteCodePage((String)applicationLinkage.getCodePage())).trim();
                n2 += 18;
                n2 += 2;
                if (n4 == -1431655766) {
                    n3 = CSOIntConverter.intFrom4Bytes((byte[])byArray, (int)n2, (int)applicationLinkage.getByteOrder());
                    n2 += 4;
                    UIRecordSegment[] uIRecordSegmentArray = new UIRecordSegment[n3];
                    int n5 = 0;
                    while (n5 < uIRecordSegmentArray.length) {
                        uIRecordSegmentArray[n5] = new UIRecordSegment(byArray, n2, applicationLinkage.getByteOrder());
                        n2 += uIRecordSegmentArray[n5].getLength() + 8;
                        ++n5;
                    }
                    if (vGJUIRecordBean == null) continue;
                    vGJUIRecordBean.setOutputData(uIRecordSegmentArray, applicationLinkage.getByteOrder(), applicationLinkage.getCodePage());
                    continue;
                }
                if (n4 != -1145324613) continue;
                n3 = CSOIntConverter.intFrom4Bytes((byte[])byArray, (int)n2, (int)applicationLinkage.getByteOrder());
                int n6 = CSOIntConverter.intFrom4Bytes((byte[])byArray, (int)(n2 += 4), (int)applicationLinkage.getByteOrder());
                String string = CSOStrConverter.toString((byte[])byArray, (int)(n2 += 4), (int)n6, (String)applicationLinkage.getCodePage());
                n2 += n6;
                Vector<String> vector = new Vector<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
                String string2 = null;
                if (string.charAt(0) != '\u0000' && stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().trim();
                }
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                }
                Object[] objectArray = new String[vector.size() + 1];
                objectArray[0] = new String();
                int n7 = 0;
                while (n7 < vector.size()) {
                    objectArray[n7 + 1] = (String)vector.elementAt(n7);
                    ++n7;
                }
                VGJUiRecordItem vGJUiRecordItem = vGJUIRecordBean.itemFromOffset(n3);
                if (vGJUiRecordItem != null) {
                    vGJUIRecordBean.EZEUIERR(vGJUiRecordItem, vGJUIRecordBean.indexFromOffset(n3), string2, objectArray);
                    continue;
                }
                this.trace("Offset, " + n3 + ", for message Key, " + string2 + ", does not match a record item.");
            }
        }
    }

    public void setURL(String string) {
        this._initialURL = string;
    }

    public void setUserid(String string) {
        this._userid = string;
    }

    public void trace(String string) {
        if (this.getSessionData() == null) {
            System.out.println(string);
        } else {
            this.getSessionData().trace(string);
        }
    }

    public void trace(Throwable throwable) {
        if (this.getSessionData() == null) {
            System.out.println(throwable.getMessage());
            throwable.printStackTrace();
        } else {
            this.getSessionData().trace(throwable);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.println("--> GatewayRequestHandler.writeObject");
        System.out.println("GatewayRequestHandler.writeObject - preparing for writing");
        this._linkageName = this._linkage.getAppName();
        this._serverid = this._linkage.getServerid();
        try {
            this._byteOrder = this.getLinkage().getByteOrder();
        }
        catch (GatewayException gatewayException) {
            this.trace((Throwable)((Object)gatewayException));
            this._byteOrder = 0;
        }
        try {
            this._beanData = this.getCurrentBean().getBytes(this._byteOrder);
        }
        catch (GatewayException gatewayException) {
            this.trace((Throwable)((Object)gatewayException));
            this._beanData = null;
        }
        objectOutputStream.defaultWriteObject();
        System.out.println("<-- GatewayRequestHandler.writeObject");
    }
}

