/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hpt.gateway;

import com.ibm.hpt.gateway.ApplicationLinkage;
import com.ibm.hpt.gateway.CsoAS400;
import com.ibm.hpt.gateway.CsoEci;
import com.ibm.hpt.gateway.CsoJavaDirect;
import com.ibm.hpt.gateway.CsoJavaTcpip;
import com.ibm.hpt.gateway.CsoTcpIMS;
import com.ibm.hpt.gateway.CsoTcpip;
import com.ibm.hpt.gateway.GatewaySessionData;
import com.ibm.hpt.gateway.ServerRequest;
import com.ibm.vgj.cso.CSOException;
import com.ibm.vgj.cso.CSOIntConverter;
import com.ibm.vgj.cso.CSOStrConverter;
import java.util.Hashtable;

public class CSOServerCommunications {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private GatewaySessionData sessionDataObject = null;
    private Hashtable CsoEciObjects = null;
    public static final int MAXCOMMAREA = 32500;

    public CSOServerCommunications(GatewaySessionData gatewaySessionData) {
        this.sessionDataObject = gatewaySessionData;
        this.CsoEciObjects = new Hashtable();
        System.out.println("CSOServerCommunications(GatewaySessionData)");
    }

    public CsoEci getCsoEciObjects(String string) {
        System.out.println("getCsoEciObjects(String): passed ctgKey is: " + string);
        System.out.println("(CsoEci) CsoEciObjects.get(ctgKey)" + (CsoEci)this.CsoEciObjects.get(string));
        return (CsoEci)this.CsoEciObjects.get(string);
    }

    public GatewaySessionData getSessionDataObject() {
        return this.sessionDataObject;
    }

    public int invokeServer(ServerRequest serverRequest) throws CSOException {
        CsoEci csoEci = null;
        String string = null;
        Object[] objectArray = new Object[]{" ", " ", " ", " ", ","};
        ApplicationLinkage applicationLinkage = serverRequest.getLinkage();
        String string2 = CSOStrConverter.getRemoteCodePage((String)applicationLinkage.getCodePage());
        int n = applicationLinkage.getByteOrder();
        byte[] byArray = serverRequest.getInputData();
        byte[] byArray2 = serverRequest.getBeanData();
        if (byArray2 == null) {
            byArray2 = new byte[32500];
        }
        boolean bl = applicationLinkage.getTrace();
        GatewaySessionData gatewaySessionData = this.getSessionDataObject();
        if (bl) {
            gatewaySessionData.trace("==> CSOServerCommunications VZ-6.0");
            gatewaySessionData.trace(applicationLinkage.toString());
        }
        if (applicationLinkage.getGatewayHostname() == null) {
            System.arraycopy(CSOIntConverter.get4Bytes((int)128, (int)n), 0, byArray, 0, 4);
            String string3 = "CSOGWS01        ".substring(0, 8);
            System.arraycopy(CSOStrConverter.toBytes((String)string3, (String)string2), 0, byArray, 4, 8);
            System.arraycopy(CSOIntConverter.get4Bytes((int)serverRequest.getDataLength(), (int)n), 0, byArray, 12, 4);
            System.arraycopy(CSOIntConverter.get4Bytes((int)32500, (int)n), 0, byArray, 16, 4);
            byArray[20] = serverRequest.getSsm();
            byArray[21] = 0;
            string3 = (String.valueOf(serverRequest.getSessionId()) + "        ").substring(0, 8);
            System.arraycopy(CSOStrConverter.toBytes((String)string3, (String)string2), 0, byArray, 22, 8);
            string3 = (String.valueOf(applicationLinkage.getServerid()) + "        ").substring(0, 8);
            System.arraycopy(CSOStrConverter.toBytes((String)string3, (String)string2), 0, byArray, 30, 8);
            string3 = (String.valueOf(applicationLinkage.getAppName()) + "        ").substring(0, 8);
            System.arraycopy(CSOStrConverter.toBytes((String)string3, (String)string2), 0, byArray, 38, 8);
            string3 = (String.valueOf(serverRequest.getBeanName()) + "                  ").substring(0, 18);
            System.arraycopy(CSOStrConverter.toBytes((String)string3, (String)string2), 0, byArray, 46, 18);
            System.arraycopy(CSOIntConverter.get4Bytes((int)serverRequest.getInterfaceHashcode(), (int)n), 0, byArray, 64, 4);
            int n2 = 68;
            while (n2 < 76) {
                byArray[n2] = 0;
                ++n2;
            }
            byArray[76] = 0;
            byArray[77] = 0;
            byArray[78] = 0;
            byArray[79] = 0;
            byArray[80] = 0;
            byArray[81] = 0;
            string3 = (String.valueOf(serverRequest.getEZEAID()) + " ").substring(0, 1);
            System.arraycopy(CSOStrConverter.toBytes((String)string3, (String)string2), 0, byArray, 82, 1);
            byArray[83] = serverRequest.getBypassEdit();
            string3 = (String.valueOf(serverRequest.getEzeusr()) + "        ").substring(0, 8);
            System.arraycopy(CSOStrConverter.toBytes((String)string3, (String)string2), 0, byArray, 84, 8);
            n2 = 92;
            while (n2 < 128) {
                byArray[n2] = 0;
                ++n2;
            }
            String string4 = applicationLinkage.getCommType();
            if (string4.equalsIgnoreCase("as400")) {
                byte[] byArray3 = new byte[32500];
                if (bl) {
                    gatewaySessionData.trace("==> CSO AS400");
                    gatewaySessionData.trace("Copying " + (128 + serverRequest.getDataLength()) + " bytes");
                    gatewaySessionData.trace("header length = " + byArray.length);
                    gatewaySessionData.trace("commarea length = " + byArray3.length);
                }
                System.arraycopy(byArray, 0, byArray3, 0, 128 + serverRequest.getDataLength());
                int n3 = 128 + serverRequest.getDataLength();
                while (n3 < 32500) {
                    byArray3[n3] = 0;
                    ++n3;
                }
                CsoAS400 csoAS400 = new CsoAS400();
                csoAS400.callServer(applicationLinkage.getAppName(), applicationLinkage.getLocation(), applicationLinkage.getServerid(), serverRequest.getUserid(), serverRequest.getPassword(), 32500, byArray3, applicationLinkage, this.getSessionDataObject());
                System.arraycopy(byArray3, 0, byArray2, 0, 32500);
                serverRequest.setDataLength(CSOIntConverter.intFrom4Bytes((byte[])byArray2, (int)12, (int)n));
                serverRequest.setBeanName(CSOStrConverter.toString((byte[])byArray2, (int)46, (int)18, (String)string2));
                serverRequest.setSsm(byArray2[20]);
                string3 = CSOStrConverter.toString((byte[])byArray2, (int)38, (int)8, (String)string2);
                if (string3 != null) {
                    applicationLinkage.setAppName(string3);
                }
                if ((string3 = CSOStrConverter.toString((byte[])byArray2, (int)30, (int)8, (String)string2)) != null && !string3.equals("        ")) {
                    applicationLinkage.setServerid(string3);
                } else {
                    applicationLinkage = applicationLinkage.getAppLinkageManger().getLinkage(applicationLinkage.getAppName());
                }
                serverRequest.setInterfaceHashcode(CSOIntConverter.intFrom4Bytes((byte[])byArray2, (int)64, (int)n));
                serverRequest.setBeanData(byArray2);
                csoAS400 = null;
            } else if (string4.equalsIgnoreCase("cicseci")) {
                byte[] byArray4 = new byte[32500];
                if (bl) {
                    gatewaySessionData.trace("Data length: 128" + serverRequest.getDataLength());
                }
                System.arraycopy(byArray, 0, byArray4, 0, 128 + serverRequest.getDataLength());
                int n4 = 128 + serverRequest.getDataLength();
                while (n4 < 32500) {
                    byArray4[n4] = 0;
                    ++n4;
                }
                String string5 = applicationLinkage.getCtgLocation();
                String string6 = applicationLinkage.getCtgPort();
                string = String.valueOf(string5) + "CSO" + string6;
                if (string5 == null && string6 != null) {
                    System.err.println("Error getting ctgLocation");
                    if (bl) {
                        gatewaySessionData.trace("getCtgLocation(): Error getting ctgLocation - no entry");
                    }
                    objectArray[0] = string5;
                    objectArray[1] = string6;
                    objectArray[2] = "Error getting ctgLocation";
                    objectArray[3] = serverRequest.getUserid();
                    throw new CSOException("CSO7816E", objectArray);
                }
                if (string5 != null && string6 == null) {
                    System.err.println("Error getting ctgPort");
                    if (bl) {
                        gatewaySessionData.trace("getCtgPort(): Error getting ctgPort - no entry");
                    }
                    objectArray[0] = string5;
                    objectArray[1] = string6;
                    objectArray[2] = "Error getting ctgPort";
                    objectArray[3] = serverRequest.getUserid();
                    throw new CSOException("CSO7816E", objectArray);
                }
                Hashtable hashtable = this.CsoEciObjects;
                synchronized (hashtable) {
                    csoEci = this.getCsoEciObjects(string);
                    if (csoEci == null) {
                        if (this.CsoEciObjects.containsKey(string)) {
                            csoEci = this.getCsoEciObjects(string);
                        } else {
                            if (string5 == null) {
                                if (bl) {
                                    gatewaySessionData.trace("ctgLocation and ctgPort parameters were not set");
                                }
                                csoEci = new CsoEci();
                            } else {
                                if (bl) {
                                    gatewaySessionData.trace("ctgLocation and ctgPort parameters were set");
                                    gatewaySessionData.trace("ctgLocation is:" + string5);
                                    gatewaySessionData.trace("ctgPort is:" + string6);
                                }
                                Integer n5 = new Integer(Integer.parseInt(string6));
                                csoEci = new CsoEci(string5, n5);
                            }
                            this.setCsoEciObjects(string, csoEci);
                        }
                    }
                }
                csoEci.callServer(applicationLinkage.getAppName(), applicationLinkage.getLocation(), applicationLinkage.getServerid(), serverRequest.getUserid(), serverRequest.getPassword(), 32500, byArray4, applicationLinkage, this.getSessionDataObject());
                System.arraycopy(byArray4, 0, byArray2, 0, 32500);
                serverRequest.setDataLength(CSOIntConverter.intFrom4Bytes((byte[])byArray2, (int)12, (int)n));
                serverRequest.setBeanName(CSOStrConverter.toString((byte[])byArray2, (int)46, (int)18, (String)string2));
                serverRequest.setSsm(byArray2[20]);
                string3 = CSOStrConverter.toString((byte[])byArray2, (int)38, (int)8, (String)string2);
                if (string3 != null) {
                    applicationLinkage.setAppName(string3);
                }
                if ((string3 = CSOStrConverter.toString((byte[])byArray2, (int)30, (int)8, (String)string2)) != null && !string3.equals("        ")) {
                    applicationLinkage.setServerid(string3);
                } else {
                    applicationLinkage = applicationLinkage.getAppLinkageManger().getLinkage(applicationLinkage.getAppName());
                }
                serverRequest.setInterfaceHashcode(CSOIntConverter.intFrom4Bytes((byte[])byArray2, (int)64, (int)n));
                serverRequest.setBeanData(byArray2);
            } else if (string4.equalsIgnoreCase("tcpip")) {
                if (applicationLinkage.getAppType() == 0L) {
                    CsoTcpip csoTcpip = new CsoTcpip();
                    csoTcpip.callServer(serverRequest, byArray, applicationLinkage, byArray2, 32500, this.getSessionDataObject());
                } else if (applicationLinkage.getAppType() == 3L) {
                    CsoJavaTcpip csoJavaTcpip = new CsoJavaTcpip();
                    csoJavaTcpip.callServer(serverRequest, byArray, applicationLinkage, byArray2, 32500, this.getSessionDataObject());
                }
            } else if (string4.equalsIgnoreCase("tcpims")) {
                byte[] byArray5 = new byte[32500];
                System.arraycopy(byArray, 0, byArray5, 0, 128 + serverRequest.getDataLength());
                int n6 = 128 + serverRequest.getDataLength();
                while (n6 < 32500) {
                    byArray5[n6] = 0;
                    ++n6;
                }
                CsoTcpIMS csoTcpIMS = new CsoTcpIMS();
                csoTcpIMS.callServerIMS(applicationLinkage.getLocation(), applicationLinkage.getTcpPort(), applicationLinkage.getIMSDestId(), serverRequest.getUserid(), applicationLinkage.getIMSGroupId(), serverRequest.getPassword(), byArray5, applicationLinkage, this.getSessionDataObject());
                System.arraycopy(byArray5, 0, byArray2, 0, 32500);
                serverRequest.setDataLength(CSOIntConverter.intFrom4Bytes((byte[])byArray2, (int)12, (int)n));
                serverRequest.setBeanName(CSOStrConverter.toString((byte[])byArray2, (int)46, (int)18, (String)string2));
                serverRequest.setSsm(byArray2[20]);
                string3 = CSOStrConverter.toString((byte[])byArray2, (int)38, (int)8, (String)string2);
                if (string3 != null) {
                    applicationLinkage.setAppName(string3);
                }
                if ((string3 = CSOStrConverter.toString((byte[])byArray2, (int)30, (int)8, (String)string2)) != null) {
                    applicationLinkage.setServerid(string3);
                }
                serverRequest.setInterfaceHashcode(CSOIntConverter.intFrom4Bytes((byte[])byArray2, (int)64, (int)n));
                serverRequest.setBeanData(byArray2);
            } else if (string4.equalsIgnoreCase("direct")) {
                CsoJavaDirect csoJavaDirect = new CsoJavaDirect();
                csoJavaDirect.callServer(serverRequest, byArray, applicationLinkage, byArray2, 32500, this.getSessionDataObject());
            } else {
                objectArray[0] = string4;
                throw new CSOException("CSO7080E", objectArray);
            }
        }
        return 0;
    }

    public void setCsoEciObjects(String string, CsoEci csoEci) {
        this.CsoEciObjects.put(string, csoEci);
    }

    public void setSessionDataObject(GatewaySessionData gatewaySessionData) {
        this.sessionDataObject = gatewaySessionData;
    }

    public boolean validateUser(ServerRequest serverRequest) {
        return true;
    }
}

